/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import java.io.Serializable;
import java.util.Iterator;
import org.cpsolver.ifs.util.ToolBox;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.base.BasePosMajor;
import org.unitime.timetable.model.base.BasePosMinor;
import org.unitime.timetable.model.dao.AcademicAreaDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=area]")
public class AcademicAreas
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageAcademicArea(), MESSAGES.pageAcademicAreas());
    }

    @PreAuthorize(value="checkPermission('AcademicAreas')")
    public SimpleEditInterface load(SessionContext context, org.hibernate.Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldExternalId(), SimpleEditInterface.FieldType.text, 120, 40, SimpleEditInterface.Flag.READ_ONLY), new SimpleEditInterface.Field(MESSAGES.fieldAbbreviation(), SimpleEditInterface.FieldType.text, 80, 10, SimpleEditInterface.Flag.UNIQUE), new SimpleEditInterface.Field(MESSAGES.fieldTitle(), SimpleEditInterface.FieldType.text, 500, 100, SimpleEditInterface.Flag.NOT_EMPTY));
        data.setSortBy(1, 2, 3);
        for (AcademicArea area : AcademicAreaDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.addRecord(area.getUniqueId());
            r.setField(0, area.getExternalUniqueId());
            r.setField(1, area.getAcademicAreaAbbreviation());
            r.setField(2, area.getTitle());
            r.setDeletable(area.getExternalUniqueId() == null && !area.isUsed(hibSession));
        }
        data.setEditable(context.hasPermission(Right.AcademicAreaEdit));
        return data;
    }

    @PreAuthorize(value="checkPermission('AcademicAreaEdit')")
    public void save(SimpleEditInterface data, SessionContext context, org.hibernate.Session hibSession) {
        for (AcademicArea area : AcademicAreaDAO.getInstance().findBySession(hibSession, context.getUser().getCurrentAcademicSessionId())) {
            SimpleEditInterface.Record r = data.getRecord(area.getUniqueId());
            if (r == null) {
                this.delete(area, context, hibSession);
                continue;
            }
            this.update(area, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @PreAuthorize(value="checkPermission('AcademicAreaEdit')")
    public void save(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        AcademicArea area = new AcademicArea();
        area.setExternalUniqueId(record.getField(0));
        area.setAcademicAreaAbbreviation(record.getField(1));
        area.setTitle(record.getField(2));
        area.setSession((Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId(), hibSession));
        record.setUniqueId((Long)hibSession.save((Object)area));
        ChangeLog.addChange(hibSession, context, area, area.getAcademicAreaAbbreviation() + " " + area.getTitle(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(AcademicArea area, SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        if (area == null) {
            return;
        }
        if (ToolBox.equals((Object)area.getExternalUniqueId(), (Object)record.getField(0)) && ToolBox.equals((Object)area.getAcademicAreaAbbreviation(), (Object)record.getField(1)) && ToolBox.equals((Object)area.getTitle(), (Object)record.getField(2))) {
            return;
        }
        area.setExternalUniqueId(record.getField(0));
        area.setAcademicAreaAbbreviation(record.getField(1));
        area.setTitle(record.getField(2));
        hibSession.saveOrUpdate((Object)area);
        ChangeLog.addChange(hibSession, context, area, area.getAcademicAreaAbbreviation() + " " + area.getTitle(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @PreAuthorize(value="checkPermission('AcademicAreaEdit')")
    public void update(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.update((AcademicArea)AcademicAreaDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(AcademicArea area, SessionContext context, org.hibernate.Session hibSession) {
        Serializable m;
        if (area == null) {
            return;
        }
        ChangeLog.addChange(hibSession, context, area, area.getAcademicAreaAbbreviation() + " " + area.getTitle(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        Iterator<Serializable> i = area.getPosMajors().iterator();
        while (i.hasNext()) {
            m = i.next();
            i.remove();
            ((BasePosMajor)m).getAcademicAreas().remove(area);
            if (((BasePosMajor)m).getAcademicAreas().isEmpty()) {
                hibSession.delete((Object)m);
                continue;
            }
            hibSession.update((Object)m);
        }
        i = area.getPosMinors().iterator();
        while (i.hasNext()) {
            m = (PosMinor)i.next();
            i.remove();
            ((BasePosMinor)m).getAcademicAreas().remove(area);
            if (((BasePosMinor)m).getAcademicAreas().isEmpty()) {
                hibSession.delete((Object)m);
                continue;
            }
            hibSession.update((Object)m);
        }
        hibSession.delete((Object)area);
    }

    @PreAuthorize(value="checkPermission('AcademicAreaEdit')")
    public void delete(SimpleEditInterface.Record record, SessionContext context, org.hibernate.Session hibSession) {
        this.delete((AcademicArea)AcademicAreaDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

