/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Date;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.util.DateUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcademicSessionInfo
implements Comparable<AcademicSessionInfo>,
Serializable,
Qualifiable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iYear;
    private String iTerm;
    private String iCampus;
    private Long iDatePatternId = null;
    private BitSet iWeekPattern = null;
    private BitSet iFreeTimePattern = null;
    private Date iSessionBegin = null;
    private Date iDatePatternFirstDate = null;
    private boolean iSectioningEnabled = false;
    private int iWkEnroll = 1;
    private int iWkChange = 1;
    private int iWkDrop = 4;
    private String iDefaultStatus = null;

    public AcademicSessionInfo(Session session) {
        this.update(session);
    }

    public void update(Session session) {
        this.iUniqueId = session.getUniqueId();
        this.iYear = session.getAcademicYear();
        this.iTerm = session.getAcademicTerm();
        this.iCampus = session.getAcademicInitiative();
        if (session.getDefaultDatePattern() != null) {
            this.iDatePatternId = session.getDefaultDatePattern().getUniqueId();
            this.iWeekPattern = session.getDefaultDatePattern().getPatternBitSet();
        }
        this.iFreeTimePattern = AcademicSessionInfo.getFreeTimeBitSet(session);
        this.iSessionBegin = session.getSessionBeginDateTime();
        this.iDatePatternFirstDate = AcademicSessionInfo.getDatePatternFirstDay(session);
        this.iSectioningEnabled = session.getStatusType().canOnlineSectionStudents();
        this.iWkEnroll = session.getLastWeekToEnroll();
        this.iWkChange = session.getLastWeekToChange();
        this.iWkDrop = session.getLastWeekToDrop();
        this.iDefaultStatus = session.getDefaultSectioningStatus() == null ? null : session.getDefaultSectioningStatus().getReference();
    }

    public AcademicSessionInfo(Long uniqueId, String year, String term, String campus) {
        this.iUniqueId = uniqueId;
        this.iYear = year;
        this.iTerm = term;
        this.iCampus = campus;
    }

    public static Date getDatePatternFirstDay(Session s) {
        return DateUtils.getDate(1, s.getPatternStartMonth(), s.getSessionStartYear());
    }

    public static BitSet getFreeTimeBitSet(Session session) {
        int startMonth = session.getPatternStartMonth();
        int endMonth = session.getPatternEndMonth();
        int size = DateUtils.getDayOfYear(0, endMonth + 1, session.getSessionStartYear()) - DateUtils.getDayOfYear(1, startMonth, session.getSessionStartYear());
        BitSet ret = new BitSet(size);
        for (int i = 0; i < size; ++i) {
            ret.set(i);
        }
        return ret;
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public String getTerm() {
        return this.iTerm;
    }

    public String getCampus() {
        return this.iCampus;
    }

    public String getYear() {
        return this.iYear;
    }

    public Long getDefaultDatePatternId() {
        return this.iDatePatternId;
    }

    public BitSet getDefaultWeekPattern() {
        return this.iWeekPattern;
    }

    public BitSet getFreeTimePattern() {
        return this.iFreeTimePattern;
    }

    public Date getDatePatternFirstDate() {
        return this.iDatePatternFirstDate;
    }

    public Date getSessionBeginDate() {
        return this.iSessionBegin;
    }

    @Override
    public int compareTo(AcademicSessionInfo a) {
        int cmp = this.iSessionBegin.compareTo(a.iSessionBegin);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getYear().compareToIgnoreCase(a.getYear());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getTerm().compareToIgnoreCase(a.getTerm());
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.getCampus().compareToIgnoreCase(a.getCampus());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(a.getUniqueId() == null ? -1L : a.getUniqueId());
    }

    public String toString() {
        return this.getYear() + " " + this.getTerm() + " (" + this.getCampus() + ")";
    }

    public String toCompactString() {
        return this.getTerm() + this.getYear() + this.getCampus();
    }

    public boolean isSectioningEnabled() {
        return this.iSectioningEnabled;
    }

    public void setSectioningEnabled(boolean enable) {
        this.iSectioningEnabled = enable;
    }

    public int getLastWeekToEnroll() {
        return this.iWkEnroll;
    }

    public int getLastWeekToChange() {
        return this.iWkChange;
    }

    public int getLastWeekToDrop() {
        return this.iWkDrop;
    }

    public String getDefaultSectioningStatus() {
        return this.iDefaultStatus;
    }

    @Override
    public Serializable getQualifierId() {
        return this.getUniqueId();
    }

    @Override
    public String getQualifierType() {
        return Session.class.getSimpleName();
    }

    @Override
    public String getQualifierReference() {
        return this.toCompactString();
    }

    @Override
    public String getQualifierLabel() {
        return this.toString();
    }
}

