/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.ManagerSettings;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseTimetableManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iFirstName;
    private String iMiddleName;
    private String iLastName;
    private String iAcademicTitle;
    private String iEmailAddress;
    private Set<ManagerSettings> iSettings;
    private Set<Department> iDepartments;
    private Set<ManagerRole> iManagerRoles;
    private Set<SolverGroup> iSolverGroups;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_EXTERNAL_UID = "externalUniqueId";
    public static String PROP_FIRST_NAME = "firstName";
    public static String PROP_MIDDLE_NAME = "middleName";
    public static String PROP_LAST_NAME = "lastName";
    public static String PROP_ACAD_TITLE = "academicTitle";
    public static String PROP_EMAIL_ADDRESS = "emailAddress";

    public BaseTimetableManager() {
        this.initialize();
    }

    public BaseTimetableManager(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    public String getFirstName() {
        return this.iFirstName;
    }

    public void setFirstName(String firstName) {
        this.iFirstName = firstName;
    }

    public String getMiddleName() {
        return this.iMiddleName;
    }

    public void setMiddleName(String middleName) {
        this.iMiddleName = middleName;
    }

    public String getLastName() {
        return this.iLastName;
    }

    public void setLastName(String lastName) {
        this.iLastName = lastName;
    }

    public String getAcademicTitle() {
        return this.iAcademicTitle;
    }

    public void setAcademicTitle(String academicTitle) {
        this.iAcademicTitle = academicTitle;
    }

    public String getEmailAddress() {
        return this.iEmailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.iEmailAddress = emailAddress;
    }

    public Set<ManagerSettings> getSettings() {
        return this.iSettings;
    }

    public void setSettings(Set<ManagerSettings> settings) {
        this.iSettings = settings;
    }

    public void addTosettings(ManagerSettings managerSettings) {
        if (this.iSettings == null) {
            this.iSettings = new HashSet<ManagerSettings>();
        }
        this.iSettings.add(managerSettings);
    }

    public Set<Department> getDepartments() {
        return this.iDepartments;
    }

    public void setDepartments(Set<Department> departments) {
        this.iDepartments = departments;
    }

    public void addTodepartments(Department department) {
        if (this.iDepartments == null) {
            this.iDepartments = new HashSet<Department>();
        }
        this.iDepartments.add(department);
    }

    public Set<ManagerRole> getManagerRoles() {
        return this.iManagerRoles;
    }

    public void setManagerRoles(Set<ManagerRole> managerRoles) {
        this.iManagerRoles = managerRoles;
    }

    public void addTomanagerRoles(ManagerRole managerRole) {
        if (this.iManagerRoles == null) {
            this.iManagerRoles = new HashSet<ManagerRole>();
        }
        this.iManagerRoles.add(managerRole);
    }

    public Set<SolverGroup> getSolverGroups() {
        return this.iSolverGroups;
    }

    public void setSolverGroups(Set<SolverGroup> solverGroups) {
        this.iSolverGroups = solverGroups;
    }

    public void addTosolverGroups(SolverGroup solverGroup) {
        if (this.iSolverGroups == null) {
            this.iSolverGroups = new HashSet<SolverGroup>();
        }
        this.iSolverGroups.add(solverGroup);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof TimetableManager)) {
            return false;
        }
        if (this.getUniqueId() == null || ((TimetableManager)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((TimetableManager)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "TimetableManager[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "TimetableManager[\n\tAcademicTitle: " + this.getAcademicTitle() + "\n\tEmailAddress: " + this.getEmailAddress() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFirstName: " + this.getFirstName() + "\n\tLastName: " + this.getLastName() + "\n\tMiddleName: " + this.getMiddleName() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

