/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.unitime.timetable.model.CourseCatalog;
import org.unitime.timetable.model.CourseSubpartCredit;
import org.unitime.timetable.model.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCourseCatalog
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private String iExternalUniqueId;
    private String iSubject;
    private String iCourseNumber;
    private String iTitle;
    private String iPermanentId;
    private String iApprovalType;
    private String iPreviousSubject;
    private String iPreviousCourseNumber;
    private String iCreditType;
    private String iCreditUnitType;
    private String iCreditFormat;
    private Float iFixedMinimumCredit;
    private Float iMaximumCredit;
    private Boolean iFractionalCreditAllowed;
    private Session iSession;
    private Set<CourseSubpartCredit> iSubparts;
    public static String PROP_UNIQUEID = "uniqueId";
    public static String PROP_EXTERNAL_UID = "externalUniqueId";
    public static String PROP_SUBJECT = "subject";
    public static String PROP_COURSE_NBR = "courseNumber";
    public static String PROP_TITLE = "title";
    public static String PROP_PERM_ID = "permanentId";
    public static String PROP_APPROVAL_TYPE = "approvalType";
    public static String PROP_PREV_SUBJECT = "previousSubject";
    public static String PROP_PREV_CRS_NBR = "previousCourseNumber";
    public static String PROP_CREDIT_TYPE = "creditType";
    public static String PROP_CREDIT_UNIT_TYPE = "creditUnitType";
    public static String PROP_CREDIT_FORMAT = "creditFormat";
    public static String PROP_FIXED_MIN_CREDIT = "fixedMinimumCredit";
    public static String PROP_MAX_CREDIT = "maximumCredit";
    public static String PROP_FRAC_CREDIT_ALLOWED = "fractionalCreditAllowed";

    public BaseCourseCatalog() {
        this.initialize();
    }

    public BaseCourseCatalog(Long uniqueId) {
        this.setUniqueId(uniqueId);
        this.initialize();
    }

    protected void initialize() {
    }

    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    public String getExternalUniqueId() {
        return this.iExternalUniqueId;
    }

    public void setExternalUniqueId(String externalUniqueId) {
        this.iExternalUniqueId = externalUniqueId;
    }

    public String getSubject() {
        return this.iSubject;
    }

    public void setSubject(String subject) {
        this.iSubject = subject;
    }

    public String getCourseNumber() {
        return this.iCourseNumber;
    }

    public void setCourseNumber(String courseNumber) {
        this.iCourseNumber = courseNumber;
    }

    public String getTitle() {
        return this.iTitle;
    }

    public void setTitle(String title) {
        this.iTitle = title;
    }

    public String getPermanentId() {
        return this.iPermanentId;
    }

    public void setPermanentId(String permanentId) {
        this.iPermanentId = permanentId;
    }

    public String getApprovalType() {
        return this.iApprovalType;
    }

    public void setApprovalType(String approvalType) {
        this.iApprovalType = approvalType;
    }

    public String getPreviousSubject() {
        return this.iPreviousSubject;
    }

    public void setPreviousSubject(String previousSubject) {
        this.iPreviousSubject = previousSubject;
    }

    public String getPreviousCourseNumber() {
        return this.iPreviousCourseNumber;
    }

    public void setPreviousCourseNumber(String previousCourseNumber) {
        this.iPreviousCourseNumber = previousCourseNumber;
    }

    public String getCreditType() {
        return this.iCreditType;
    }

    public void setCreditType(String creditType) {
        this.iCreditType = creditType;
    }

    public String getCreditUnitType() {
        return this.iCreditUnitType;
    }

    public void setCreditUnitType(String creditUnitType) {
        this.iCreditUnitType = creditUnitType;
    }

    public String getCreditFormat() {
        return this.iCreditFormat;
    }

    public void setCreditFormat(String creditFormat) {
        this.iCreditFormat = creditFormat;
    }

    public Float getFixedMinimumCredit() {
        return this.iFixedMinimumCredit;
    }

    public void setFixedMinimumCredit(Float fixedMinimumCredit) {
        this.iFixedMinimumCredit = fixedMinimumCredit;
    }

    public Float getMaximumCredit() {
        return this.iMaximumCredit;
    }

    public void setMaximumCredit(Float maximumCredit) {
        this.iMaximumCredit = maximumCredit;
    }

    public Boolean isFractionalCreditAllowed() {
        return this.iFractionalCreditAllowed;
    }

    public Boolean getFractionalCreditAllowed() {
        return this.iFractionalCreditAllowed;
    }

    public void setFractionalCreditAllowed(Boolean fractionalCreditAllowed) {
        this.iFractionalCreditAllowed = fractionalCreditAllowed;
    }

    public Session getSession() {
        return this.iSession;
    }

    public void setSession(Session session) {
        this.iSession = session;
    }

    public Set<CourseSubpartCredit> getSubparts() {
        return this.iSubparts;
    }

    public void setSubparts(Set<CourseSubpartCredit> subparts) {
        this.iSubparts = subparts;
    }

    public void addTosubparts(CourseSubpartCredit courseSubpartCredit) {
        if (this.iSubparts == null) {
            this.iSubparts = new HashSet<CourseSubpartCredit>();
        }
        this.iSubparts.add(courseSubpartCredit);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof CourseCatalog)) {
            return false;
        }
        if (this.getUniqueId() == null || ((CourseCatalog)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((CourseCatalog)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "CourseCatalog[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "CourseCatalog[\n\tApprovalType: " + this.getApprovalType() + "\n\tCourseNumber: " + this.getCourseNumber() + "\n\tCreditFormat: " + this.getCreditFormat() + "\n\tCreditType: " + this.getCreditType() + "\n\tCreditUnitType: " + this.getCreditUnitType() + "\n\tExternalUniqueId: " + this.getExternalUniqueId() + "\n\tFixedMinimumCredit: " + this.getFixedMinimumCredit() + "\n\tFractionalCreditAllowed: " + this.getFractionalCreditAllowed() + "\n\tMaximumCredit: " + this.getMaximumCredit() + "\n\tPermanentId: " + this.getPermanentId() + "\n\tPreviousCourseNumber: " + this.getPreviousCourseNumber() + "\n\tPreviousSubject: " + this.getPreviousSubject() + "\n\tSession: " + this.getSession() + "\n\tSubject: " + this.getSubject() + "\n\tTitle: " + this.getTitle() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

