/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Collection;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.base.BaseEventNote;
import org.unitime.timetable.util.Formats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventNote
extends BaseEventNote
implements Comparable<EventNote> {
    private static final long serialVersionUID = 1L;
    public static final int sEventNoteTypeCreateEvent = 0;
    public static final int sEventNoteTypeAddMeetings = 1;
    public static final int sEventNoteTypeApproval = 2;
    public static final int sEventNoteTypeRejection = 3;
    public static final int sEventNoteTypeDeletion = 4;
    public static final int sEventNoteTypeEditEvent = 5;
    public static final int sEventNoteTypeInquire = 6;
    public static final int sEventNoteTypeCancel = 7;
    public static final int sEventNoteTypeEmail = 8;
    public static final String[] sEventNoteTypeBgColor = new String[]{"transparent", "transparent", "#D7FFD7", "#FFD7D7", "transparent", "transparent", "#FFFFD7", "transparent"};
    public static final String[] sEventNoteTypeName = new String[]{"Create", "Update", "Approve", "Reject", "Delete", "Edit", "Inquire", "Cancel", "Email"};

    public EventNote() {
    }

    public EventNote(Long uniqueId) {
        super(uniqueId);
    }

    @Override
    public int compareTo(EventNote n) {
        int cmp = this.getTimeStamp().compareTo(n.getTimeStamp());
        if (cmp != 0) {
            return cmp;
        }
        return (this.getUniqueId() == null ? new Long(-1L) : this.getUniqueId()).compareTo(n.getUniqueId() == null ? -1L : n.getUniqueId());
    }

    public void setMeetingCollection(Collection meetings) {
        String meetingStr = "";
        for (Event.MultiMeeting m : Event.getMultiMeetings(meetings)) {
            if (meetingStr.length() > 0) {
                meetingStr = meetingStr + "\n";
            }
            meetingStr = meetingStr + m.toShortString();
        }
        this.setMeetings(meetingStr);
    }

    public String getMeetingsHtml() {
        if (this.getMeetings() == null || this.getMeetings().length() == 0) {
            return "<i>N/A</i>";
        }
        return this.getMeetings().replaceAll("\n", "<br>");
    }

    public String toHtmlString(boolean includeUser) {
        return "<tr style=\"background-color:" + sEventNoteTypeBgColor[this.getNoteType()] + ";\" valign='top' " + "onMouseOver=\"this.style.backgroundColor='rgb(223,231,242)';\" " + "onMouseOut=\"this.style.backgroundColor='" + sEventNoteTypeBgColor[this.getNoteType()] + "';\">" + "<td>" + Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP).format(this.getTimeStamp()) + "</td>" + (includeUser ? "<td>" + (this.getUser() == null || this.getUser().length() == 0 ? "<i>N/A</i>" : this.getUser()) + "</td>" : "") + "<td>" + sEventNoteTypeName[this.getNoteType()] + "</td>" + "<td>" + this.getMeetingsHtml() + "</td>" + "<td>" + (this.getTextNote() == null ? "" : this.getTextNote().replaceAll("\n", "<br>")) + "</td>" + "</tr>";
    }
}

