/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.base.BaseApplicationConfig;
import org.unitime.timetable.model.dao.ApplicationConfigDAO;
import org.unitime.timetable.model.dao._RootDAO;

public class ApplicationConfig
extends BaseApplicationConfig {
    private static final long serialVersionUID = 1L;
    public static final String APP_CFG_ATTR_NAME = "appConfig";

    public ApplicationConfig() {
    }

    public ApplicationConfig(String key) {
        super(key);
    }

    public static ApplicationConfig getConfig(String key) {
        try {
            return (ApplicationConfig)new ApplicationConfigDAO().getSession().createCriteria(ApplicationConfig.class).add((Criterion)Restrictions.eq((String)"key", (Object)key)).setCacheable(true).uniqueResult();
        }
        catch (Exception e) {
            Debug.error(e);
            return null;
        }
    }

    public static String getConfigValue(String key, String defaultValue) {
        if (!_RootDAO.isConfigured()) {
            return defaultValue;
        }
        String value = (String)new ApplicationConfigDAO().getSession().createQuery("select c.value from ApplicationConfig c where c.key=:key").setString("key", key).setCacheable(true).uniqueResult();
        return value == null ? defaultValue : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties toProperties() {
        Properties properties = new Properties();
        if (!_RootDAO.isConfigured()) {
            return properties;
        }
        Session hibSession = ApplicationConfigDAO.getInstance().createNewSession();
        try {
            for (ApplicationConfig appcfg : ApplicationConfigDAO.getInstance().findAll(hibSession)) {
                properties.setProperty(appcfg.getKey(), appcfg.getValue() == null ? "" : appcfg.getValue());
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean configureLogging() {
        if (!_RootDAO.isConfigured()) {
            return false;
        }
        Session hibSession = ApplicationConfigDAO.getInstance().createNewSession();
        try {
            for (ApplicationConfig config : hibSession.createQuery("from ApplicationConfig where key like 'log4j.logger.%'").list()) {
                Level level = Level.toLevel((String)config.getValue());
                boolean root = "log4j.logger.root".equals(config.getKey());
                Logger logger = root ? Logger.getRootLogger() : Logger.getLogger((String)config.getKey().substring("log4j.logger.".length()));
                logger.setLevel(level);
                Debug.info("Logging level for " + logger.getName() + " set to " + level);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            hibSession.close();
            throw throwable;
        }
        hibSession.close();
        return true;
    }
}

