/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseRequestInterface
implements IsSerializable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long iSessionId;
    private Long iStudentId;
    private ArrayList<Request> iCourses = new ArrayList();
    private ArrayList<Request> iAlternatives = new ArrayList();
    private boolean iSaved = false;
    private boolean iNoChange = false;
    private Boolean iUpdateLastRequest = null;
    private String iLastCourse = null;

    public Long getAcademicSessionId() {
        return this.iSessionId;
    }

    public void setAcademicSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public Long getStudentId() {
        return this.iStudentId;
    }

    public void setStudentId(Long studentId) {
        this.iStudentId = studentId;
    }

    public ArrayList<Request> getCourses() {
        return this.iCourses;
    }

    public ArrayList<Request> getAlternatives() {
        return this.iAlternatives;
    }

    public boolean isSaved() {
        return this.iSaved;
    }

    public void setSaved(boolean saved) {
        this.iSaved = saved;
    }

    public boolean isNoChange() {
        return this.iNoChange;
    }

    public void setNoChange(boolean noChange) {
        this.iNoChange = noChange;
    }

    public boolean isUpdateLastRequest() {
        return this.iUpdateLastRequest == null || this.iUpdateLastRequest != false;
    }

    public void setUpdateLastRequest(boolean updateLastRequest) {
        this.iUpdateLastRequest = updateLastRequest;
    }

    public boolean addCourse(String course) {
        this.iLastCourse = course;
        if (this.getRequestPriority(course) != null) {
            return false;
        }
        for (Request r : this.getCourses()) {
            if (r.hasRequestedFreeTime() || r.hasRequestedCourse()) continue;
            r.setRequestedCourse(course);
            return true;
        }
        Request r = new Request();
        r.setRequestedCourse(course);
        this.getCourses().add(r);
        return true;
    }

    public boolean hasLastCourse() {
        return this.iLastCourse != null;
    }

    public String getLastCourse() {
        return this.iLastCourse;
    }

    public RequestPriority getRequestPriority(String course) {
        if (course == null || course.isEmpty()) {
            return null;
        }
        int priority = 1;
        for (Request r : this.getCourses()) {
            if (course.equalsIgnoreCase(r.getRequestedCourse())) {
                return new RequestPriority(false, priority, 0, r);
            }
            if (course.equalsIgnoreCase(r.getFirstAlternative())) {
                return new RequestPriority(false, priority, 1, r);
            }
            if (course.equalsIgnoreCase(r.getSecondAlternative())) {
                return new RequestPriority(false, priority, 2, r);
            }
            ++priority;
        }
        priority = 1;
        for (Request r : this.getAlternatives()) {
            if (course.equalsIgnoreCase(r.getRequestedCourse())) {
                return new RequestPriority(true, priority, 0, r);
            }
            if (course.equalsIgnoreCase(r.getFirstAlternative())) {
                return new RequestPriority(true, priority, 1, r);
            }
            if (course.equalsIgnoreCase(r.getSecondAlternative())) {
                return new RequestPriority(true, priority, 2, r);
            }
            ++priority;
        }
        return null;
    }

    public String toString() {
        String ret = "CourseRequests(student = " + this.iStudentId + ", session = " + this.iSessionId + ", requests = {";
        int idx = 1;
        for (Request r : this.iCourses) {
            ret = ret + "\n   " + idx++ + ". " + r;
        }
        idx = 1;
        for (Request r : this.iAlternatives) {
            ret = ret + "\n  A" + idx++ + ". " + r;
        }
        return ret + "\n})";
    }

    public static class RequestPriority
    implements IsSerializable {
        private boolean iAlternative = false;
        private int iPriority = 0;
        private int iChoice = 0;
        private Request iRequest;

        RequestPriority(boolean alternative, int priority, int choice, Request request) {
            this.iAlternative = alternative;
            this.iPriority = priority;
            this.iChoice = choice;
            this.iRequest = request;
        }

        public boolean isAlternative() {
            return this.iAlternative;
        }

        public int getPriority() {
            return this.iPriority;
        }

        public int getChoice() {
            return this.iChoice;
        }

        public Request getRequest() {
            return this.iRequest;
        }

        public String toString() {
            if (this.iAlternative) {
                switch (this.iChoice) {
                    case 0: {
                        return "Alt " + this.iPriority + ".";
                    }
                    case 1: {
                        return "Alt " + this.iPriority + "A.";
                    }
                }
                return "Alt " + this.iPriority + "B.";
            }
            switch (this.iChoice) {
                case 0: {
                    return this.iPriority + ".";
                }
                case 1: {
                    return this.iPriority + "A.";
                }
            }
            return this.iPriority + "B.";
        }

        public String toString(StudentSectioningMessages MESSAGES) {
            if (this.iAlternative) {
                switch (this.iChoice) {
                    case 0: {
                        return MESSAGES.degreeRequestedAlternative(this.iPriority);
                    }
                    case 1: {
                        return MESSAGES.degreeRequestedAlternativeFirstAlt(this.iPriority);
                    }
                }
                return MESSAGES.degreeRequestedAlternativeSecondAlt(this.iPriority);
            }
            switch (this.iChoice) {
                case 0: {
                    return MESSAGES.degreeRequestedCourse(this.iPriority);
                }
                case 1: {
                    return MESSAGES.degreeRequestedCourseFirstAlt(this.iPriority);
                }
            }
            return MESSAGES.degreeRequestedCourseSecondAlt(this.iPriority);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Request
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ArrayList<FreeTime> iRequestedFreeTime = null;
        private String iRequestedCourse = null;
        private String iFirstAlternative = null;
        private String iSecondAlternative = null;
        private Boolean iWaitList = false;
        private Integer iReadOnly = null;

        public String getRequestedCourse() {
            return this.iRequestedCourse;
        }

        public void setRequestedCourse(String requestedCourse) {
            this.iRequestedCourse = requestedCourse;
        }

        public boolean hasRequestedCourse() {
            return this.iRequestedCourse != null && !this.iRequestedCourse.isEmpty();
        }

        public ArrayList<FreeTime> getRequestedFreeTime() {
            return this.iRequestedFreeTime;
        }

        public void addRequestedFreeTime(FreeTime ft) {
            if (this.iRequestedFreeTime == null) {
                this.iRequestedFreeTime = new ArrayList();
            }
            this.iRequestedFreeTime.add(ft);
        }

        public boolean hasRequestedFreeTime() {
            return this.iRequestedFreeTime != null && !this.iRequestedFreeTime.isEmpty();
        }

        public String getFirstAlternative() {
            return this.iFirstAlternative;
        }

        public void setFirstAlternative(String firstAlternative) {
            this.iFirstAlternative = firstAlternative;
        }

        public boolean hasFirstAlternative() {
            return this.iFirstAlternative != null && !this.iFirstAlternative.isEmpty();
        }

        public String getSecondAlternative() {
            return this.iSecondAlternative;
        }

        public void setSecondAlternative(String secondAlternative) {
            this.iSecondAlternative = secondAlternative;
        }

        public boolean hasSecondAlternative() {
            return this.iSecondAlternative != null && !this.iSecondAlternative.isEmpty();
        }

        public boolean hasWaitList() {
            return this.iWaitList != null;
        }

        public boolean isWaitList() {
            return this.iWaitList != null && this.iWaitList != false;
        }

        public void setWaitList(Boolean waitList) {
            this.iWaitList = waitList;
        }

        public boolean isReadOnly() {
            return this.iReadOnly != null && this.iReadOnly >= 0;
        }

        public boolean isRequestedCourseReadOnly() {
            return this.iReadOnly != null && this.iReadOnly == 0;
        }

        public boolean isFirstAlternativeReadOnly() {
            return this.iReadOnly != null && this.iReadOnly == 1;
        }

        public boolean isSecondAlternativeReadOnly() {
            return this.iReadOnly != null && this.iReadOnly == 2;
        }

        public void setReadOnly(Integer readOnly) {
            this.iReadOnly = readOnly;
        }

        public String toString() {
            return (this.hasRequestedFreeTime() ? this.iRequestedFreeTime.toString() : (this.hasRequestedCourse() ? this.iRequestedCourse : "-")) + (this.hasFirstAlternative() ? ", " + this.iFirstAlternative : "") + (this.hasSecondAlternative() ? ", " + this.iSecondAlternative : "") + (this.isWaitList() ? " (w)" : "");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FreeTime
    implements IsSerializable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private ArrayList<Integer> iDays = new ArrayList();
        private int iStart;
        private int iLength;

        public void addDay(int day) {
            this.iDays.add(day);
        }

        public ArrayList<Integer> getDays() {
            return this.iDays;
        }

        public String getDaysString(String[] shortDays, String separator) {
            if (this.iDays == null) {
                return "";
            }
            String ret = "";
            for (int day : this.iDays) {
                ret = ret + (ret.isEmpty() ? "" : separator) + shortDays[day];
            }
            return ret;
        }

        public int getStart() {
            return this.iStart;
        }

        public void setStart(int startSlot) {
            this.iStart = startSlot;
        }

        public String getStartString(boolean useAmPm) {
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public int getLength() {
            return this.iLength;
        }

        public void setLength(int length) {
            this.iLength = length;
        }

        public String getEndString(boolean useAmPm) {
            int h = (this.iStart + this.iLength) / 12;
            int m = 5 * ((this.iStart + this.iLength) % 12);
            if (useAmPm) {
                return (h > 12 ? h - 12 : h) + ":" + (m < 10 ? "0" : "") + m + (h == 24 ? "a" : (h >= 12 ? "p" : "a"));
            }
            return h + ":" + (m < 10 ? "0" : "") + m;
        }

        public String toString(String[] shortDays, boolean useAmPm) {
            return this.getDaysString(shortDays, "") + " " + this.getStartString(useAmPm) + " - " + this.getEndString(useAmPm);
        }

        public String toString() {
            return "Free " + this.toString(new String[]{"M", "T", "W", "R", "F", "S", "U"}, true);
        }

        public String toAriaString(String[] longDays, boolean useAmPm) {
            int h = this.iStart / 12;
            int m = 5 * (this.iStart % 12);
            String ret = this.getDaysString(longDays, " ") + " from ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            h = (this.iStart + this.iLength) / 12;
            m = 5 * ((this.iStart + this.iLength) % 12);
            ret = ret + " to ";
            ret = useAmPm ? ret + (h > 12 ? h - 12 : h) + (m == 0 ? "" : (m < 10 ? " 0" : " ") + m) + (h == 24 ? " AM" : (h >= 12 ? " PM" : " AM")) : ret + h + " " + (m < 10 ? "0" : "") + m;
            return ret;
        }
    }
}

