/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.EnrollmentTable;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.SimpleForm;
import org.unitime.timetable.gwt.client.widgets.UniTimeHeaderPanel;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.client.widgets.UniTimeWidget;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.EventInterface;

public class SectioningReports
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final StudentSectioningMessages SCT_MSG = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    private static final GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private static NumberFormat PF = NumberFormat.getFormat((String)"0.0%");
    private static NumberFormat DF = NumberFormat.getFormat((String)"0.00");
    private SimpleForm iForm = null;
    private UniTimeHeaderPanel iHeader = null;
    private UniTimeHeaderPanel iTableHeader = null;
    private UniTimeWidget<ListBox> iReportSelector = null;
    private RowData iHead = null;
    private List<RowData> iData = new ArrayList<RowData>();
    private UniTimeTable<RowData> iTable = new UniTimeTable();
    private int iFirstLine = 0;
    private int iLastSort = 0;
    private String iLastHistory = null;
    private boolean iOnline = false;

    public SectioningReports(boolean online) {
        this.iOnline = online;
        this.iForm = new SimpleForm(2);
        this.iForm.removeStyleName("unitime-NotPrintableBottomLine");
        this.iHeader = new UniTimeHeaderPanel(MESSAGES.sectFilter());
        this.iHeader.addButton("execute", MESSAGES.buttonExecute(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                SectioningReports.this.iFirstLine = 0;
                SectioningReports.this.iLastSort = 0;
                SectioningReports.this.execute();
            }
        });
        this.iHeader.addButton("print", MESSAGES.buttonPrint(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                final UniTimeTable table = new UniTimeTable();
                ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
                for (int i = 0; i < SectioningReports.this.iHead.getLength(); ++i) {
                    String x = SectioningReports.this.iHead.getCell(i);
                    String name = x.replace('_', ' ').trim();
                    UniTimeTableHeader h = new UniTimeTableHeader(name.replaceAll("\\n", "<br>"), 1);
                    if (i + 1 == SectioningReports.this.iLastSort) {
                        h.setOrder(true);
                    } else if (-1 - i == SectioningReports.this.iLastSort) {
                        h.setOrder(false);
                    }
                    header.add(h);
                }
                table.addRow(null, header);
                RowData prev = null;
                for (int i = 0; i < SectioningReports.this.iData.size(); ++i) {
                    RowData row = (RowData)SectioningReports.this.iData.get(i);
                    ArrayList<NumberCell> line = new ArrayList<NumberCell>();
                    boolean prevHide = true;
                    for (int x = 0; x < table.getCellCount(0); ++x) {
                        boolean hide = true;
                        if (prev == null || !prevHide || !prev.getCell(x).equals(row.getCell(x))) {
                            hide = false;
                        }
                        String text = row.getCell(x).replaceAll("\\n", "<br>");
                        boolean number = false;
                        try {
                            Double.parseDouble(text);
                            number = true;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (SectioningReports.this.iHead.getCell(x).contains("%") && number) {
                            text = PF.format(Double.parseDouble(text));
                        } else if (text.matches("[\\-]?[0-9]+\\.[0-9]+") && number) {
                            text = DF.format(Double.parseDouble(text));
                        }
                        line.add(number ? new NumberCell(hide ? "" : text) : new HTML(hide ? "" : text));
                        prevHide = hide;
                    }
                    int last = table.addRow(row, line);
                    if (prev != null && !prev.getCell(0).equals(row.getCell(0))) {
                        for (int c = 0; c < table.getCellCount(last); ++c) {
                            table.getCellFormatter().addStyleName(last, c, "unitime-TopLineDash");
                        }
                    }
                    prev = row;
                }
                if (SectioningReports.this.iHead.getCell(0).startsWith("__")) {
                    table.setColumnVisible(0, false);
                }
                table.getElement().getStyle().setWidth(1040.0, Style.Unit.PX);
                com.google.gwt.user.client.Element headerRow = table.getRowFormatter().getElement(0);
                com.google.gwt.user.client.Element tableElement = table.getElement();
                com.google.gwt.user.client.Element thead = DOM.createTHead();
                tableElement.insertFirst((Node)thead);
                headerRow.getParentElement().removeChild((Node)headerRow);
                thead.appendChild((Node)headerRow);
                final String name = ((ListBox)SectioningReports.this.iReportSelector.getWidget()).getItemText(((ListBox)SectioningReports.this.iReportSelector.getWidget()).getSelectedIndex());
                ToolBox.print(new ToolBox.Page(){

                    public String getName() {
                        return name;
                    }

                    public String getUser() {
                        return "";
                    }

                    public String getSession() {
                        return "";
                    }

                    public Element getBody() {
                        return table.getElement();
                    }
                });
            }
        });
        this.iHeader.addButton("export", MESSAGES.buttonExportCSV(), 85, new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (((ListBox)SectioningReports.this.iReportSelector.getWidget()).getSelectedIndex() <= 0) {
                    SectioningReports.this.iHeader.setErrorMessage(MESSAGES.errorNoReportSelected());
                    return;
                }
                ReportType type = ReportType.valueOf(((ListBox)SectioningReports.this.iReportSelector.getWidget()).getValue(((ListBox)SectioningReports.this.iReportSelector.getWidget()).getSelectedIndex()));
                String query = "output=sct-report.csv&name=" + type.name() + "&report=" + type.getImplementation() + "&online=" + (SectioningReports.this.iOnline ? "true" : "false") + "&sort=" + SectioningReports.this.iLastSort;
                int i = 0;
                while (i + 1 < type.getParameters().length) {
                    query = query + "&" + type.getParameters()[i] + "=" + type.getParameters()[i + 1];
                    i += 2;
                }
                RPC.execute(EventInterface.EncodeQueryRpcRequest.encode(query), new AsyncCallback<EventInterface.EncodeQueryRpcResponse>(){

                    public void onFailure(Throwable caught) {
                    }

                    public void onSuccess(EventInterface.EncodeQueryRpcResponse result) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "export?q=" + result.getQuery());
                    }
                });
            }
        });
        this.iForm.addHeaderRow((Widget)this.iHeader);
        this.iHeader.setEnabled("execute", false);
        this.iHeader.setEnabled("print", false);
        this.iHeader.setEnabled("export", false);
        this.iForm.getColumnFormatter().setWidth(0, "120px");
        this.iForm.getColumnFormatter().setWidth(1, "100%");
        this.iReportSelector = new UniTimeWidget<ListBox>(new ListBox());
        this.iReportSelector.getWidget().addItem(MESSAGES.itemSelect(), "");
        for (ReportType type : ReportType.values()) {
            this.iReportSelector.getWidget().addItem(type.getName(), type.name());
        }
        this.iForm.addRow(MESSAGES.propReport(), (Widget)this.iReportSelector);
        this.iReportSelector.getWidget().addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                SectioningReports.this.iReportSelector.clearHint();
                SectioningReports.this.iReportSelector.setPrintText(((ListBox)SectioningReports.this.iReportSelector.getWidget()).getItemText(((ListBox)SectioningReports.this.iReportSelector.getWidget()).getSelectedIndex()));
                SectioningReports.this.queryChanged();
            }
        });
        this.iTableHeader = new UniTimeHeaderPanel(MESSAGES.sectResults());
        this.iTableHeader.addButton("previous", MESSAGES.buttonPrevious(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                SectioningReports.this.iFirstLine = SectioningReports.this.iFirstLine - 100;
                SectioningReports.this.populate(false);
                History.newItem((String)(SectioningReports.this.iLastHistory + ":" + SectioningReports.this.iFirstLine + ":" + SectioningReports.this.iLastSort), (boolean)false);
            }
        });
        this.iTableHeader.addButton("next", MESSAGES.buttonNext(), 75, new ClickHandler(){

            public void onClick(ClickEvent event) {
                SectioningReports.this.iFirstLine = SectioningReports.this.iFirstLine + 100;
                SectioningReports.this.populate(false);
                History.newItem((String)(SectioningReports.this.iLastHistory + ":" + SectioningReports.this.iFirstLine + ":" + SectioningReports.this.iLastSort), (boolean)false);
            }
        });
        this.iTableHeader.setEnabled("previous", false);
        this.iTableHeader.setEnabled("next", false);
        this.iForm.addHeaderRow((Widget)this.iTableHeader);
        this.iForm.addRow((Widget)this.iTable);
        this.iForm.addBottomRow((Widget)this.iHeader.clonePanel(""));
        this.initWidget((Widget)this.iForm);
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                SectioningReports.this.reload((String)event.getValue());
            }
        });
        this.iTable.addMouseClickListener(new UniTimeTable.MouseClickListener<RowData>(){

            @Override
            public void onMouseClick(UniTimeTable.TableEvent<RowData> event) {
                if (event.getRow() > 0 && event.getData() != null) {
                    if ("__Class".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "classDetail.do?cid=" + event.getData().getCell(0));
                    } else if ("__Offering".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "instructionalOfferingDetail.do?op=view&io=" + event.getData().getCell(0));
                    } else if ("__Subpart".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "schedulingSubpartDetail.do?ssuid=" + event.getData().getCell(0));
                    } else if ("__Room".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "gwt.jsp?page=rooms&back=1&id=" + event.getData().getCell(0));
                    } else if ("__Instructor".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "instructorDetail.do?instructorId=" + event.getData().getCell(0));
                    } else if ("__Exam".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "examDetail.do?examId=" + event.getData().getCell(0));
                    } else if ("__Event".equals(SectioningReports.this.iHead.getCell(0))) {
                        ToolBox.open(GWT.getHostPageBaseURL() + "gwt.jsp?page=events#event=" + event.getData().getCell(0));
                    } else if ("__Student".equals(SectioningReports.this.iHead.getCell(0))) {
                        ClassAssignmentInterface.Student student = new ClassAssignmentInterface.Student();
                        student.setId(Long.valueOf(event.getData().getCell(0)));
                        for (int i = 0; i < SectioningReports.this.iHead.getLength(); ++i) {
                            if (SCT_MSG.reportStudentId().equals(SectioningReports.this.iHead.getCell(i))) {
                                student.setExternalId(event.getData().getCell(i));
                                continue;
                            }
                            if (!SCT_MSG.reportStudentName().equals(SectioningReports.this.iHead.getCell(i))) continue;
                            student.setName(event.getData().getCell(i));
                        }
                        LoadingWidget.getInstance().show(MESSAGES.waitPlease());
                        new EnrollmentTable(false, SectioningReports.this.iOnline).showStudentSchedule(student, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                LoadingWidget.getInstance().hide();
                                UniTimeNotifications.error(caught.getMessage());
                            }

                            public void onSuccess(Boolean result) {
                                LoadingWidget.getInstance().hide();
                            }
                        });
                    }
                }
            }
        });
        this.reload(History.getToken());
    }

    private void queryChanged() {
        this.iHeader.clearMessage();
        if (this.iReportSelector.getWidget().getSelectedIndex() <= 0) {
            this.iHeader.setEnabled("execute", false);
            this.iHeader.setEnabled("export", false);
        } else {
            this.iHeader.setEnabled("execute", true);
            this.iHeader.setEnabled("export", true);
        }
    }

    public void populate(boolean sort) {
        if (this.iData == null || this.iData.isEmpty() || this.iHead == null) {
            this.iTableHeader.setMessage(MESSAGES.errorNoResults());
        } else {
            if (this.iLastSort != 0 && sort) {
                final boolean asc = this.iLastSort > 0;
                final int col = Math.abs(this.iLastSort) - 1;
                Collections.sort(this.iData, new Comparator<RowData>(){

                    @Override
                    public int compare(RowData o1, RowData o2) {
                        return asc ? o1.compareTo(o2, col) : o2.compareTo(o1, col);
                    }
                });
            }
            ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
            this.iTable.clearTable();
            for (int i = 0; i < this.iHead.getLength(); ++i) {
                String x = this.iHead.getCell(i);
                final String name = x.replace('_', ' ').trim();
                final UniTimeTableHeader h = new UniTimeTableHeader(name.replaceAll("\\n", "<br>"), 1);
                final int col = header.size();
                h.addOperation(new UniTimeTableHeader.Operation(){

                    public void execute() {
                        boolean asc = h.getOrder() == null ? true : h.getOrder() == false;
                        SectioningReports.this.iLastSort = asc ? 1 + col : -1 - col;
                        SectioningReports.this.populate(true);
                        History.newItem((String)(SectioningReports.this.iLastHistory + ":" + SectioningReports.this.iFirstLine + ":" + SectioningReports.this.iLastSort), (boolean)false);
                    }

                    public boolean isApplicable() {
                        return true;
                    }

                    public boolean hasSeparator() {
                        return false;
                    }

                    public String getName() {
                        return MESSAGES.opSortBy(name);
                    }
                });
                if (i + 1 == this.iLastSort) {
                    h.setOrder(true);
                } else if (-1 - i == this.iLastSort) {
                    h.setOrder(false);
                }
                header.add(h);
            }
            this.iTable.addRow(null, header);
            RowData prev = null;
            for (int i = this.iFirstLine; i < Math.min(this.iFirstLine + 100, this.iData.size()); ++i) {
                RowData row = this.iData.get(i);
                ArrayList<NumberCell> line = new ArrayList<NumberCell>();
                boolean prevHide = true;
                for (int x = 0; x < this.iTable.getCellCount(0); ++x) {
                    boolean hide = true;
                    if (prev == null || !prevHide || !prev.getCell(x).equals(row.getCell(x))) {
                        hide = false;
                    }
                    String text = row.getCell(x).replaceAll("\\n", "<br>");
                    boolean number = false;
                    try {
                        Double.parseDouble(text);
                        number = true;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (this.iHead.getCell(x).contains("%") && number) {
                        text = PF.format(Double.parseDouble(text));
                    } else if (text.matches("[\\-]?[0-9]+\\.[0-9]+") && number) {
                        text = DF.format(Double.parseDouble(text));
                    }
                    line.add(number ? new NumberCell(hide ? "" : text) : new HTML(hide ? "" : text));
                    prevHide = hide;
                }
                int last = this.iTable.addRow(row, line);
                if (prev != null && !prev.getCell(0).equals(row.getCell(0))) {
                    for (int c = 0; c < this.iTable.getCellCount(last); ++c) {
                        this.iTable.getCellFormatter().addStyleName(last, c, "unitime-TopLineDash");
                    }
                }
                prev = row;
            }
            this.iTable.setColumnVisible(0, !this.iHead.getCell(0).startsWith("__"));
            this.iHeader.setEnabled("print", true);
            this.iHeader.setEnabled("export", true);
            if (this.iData.size() <= 100 && this.iFirstLine == 0) {
                this.iTableHeader.setMessage(MESSAGES.infoShowingAllLines(this.iData.size()));
            } else {
                this.iTableHeader.setMessage(MESSAGES.infoShowingLines(this.iFirstLine + 1, Math.min(this.iFirstLine + 100, this.iData.size())));
            }
            this.iTableHeader.setEnabled("next", this.iFirstLine + 100 < this.iData.size());
            this.iTableHeader.setEnabled("previous", this.iFirstLine > 0);
        }
    }

    public void reload(String history) {
        if (history == null) {
            return;
        }
        if (history.indexOf(38) >= 0) {
            history = history.substring(0, history.indexOf(38));
        }
        if (history.isEmpty()) {
            return;
        }
        String[] params = history.split(":");
        ReportType type = ReportType.valueOf(params[0]);
        if (type == null) {
            return;
        }
        this.iReportSelector.getWidget().setSelectedIndex(1 + type.ordinal());
        this.queryChanged();
        this.iFirstLine = Integer.parseInt(params[1]);
        this.iLastSort = Integer.parseInt(params[2]);
        this.execute();
    }

    private void execute() {
        this.iHeader.setEnabled("print", false);
        if (this.iReportSelector.getWidget().getSelectedIndex() <= 0) {
            this.iHeader.setErrorMessage(MESSAGES.errorNoReportSelected());
            return;
        }
        ReportType type = ReportType.valueOf(this.iReportSelector.getWidget().getValue(this.iReportSelector.getWidget().getSelectedIndex()));
        this.iLastHistory = type.name();
        this.iTable.clearTable();
        this.iTableHeader.clearMessage();
        this.iHeader.clearMessage();
        LoadingWidget.getInstance().show(MESSAGES.waitExecuting(type.getName()));
        History.newItem((String)(this.iLastHistory + ":" + this.iFirstLine + ":" + this.iLastSort), (boolean)false);
        SectioningReportRpcRequest request = new SectioningReportRpcRequest();
        request.setParameter("report", type.getImplementation());
        request.setParameter("online", this.iOnline ? "true" : "false");
        int i = 0;
        while (i + 1 < type.getParameters().length) {
            request.setParameter(type.getParameters()[i], type.getParameters()[i + 1]);
            i += 2;
        }
        RPC.execute(request, new AsyncCallback<SectioningReportRpcResponse>(){

            public void onFailure(Throwable caught) {
                SectioningReports.this.iTableHeader.setErrorMessage(caught.getMessage(), true);
                LoadingWidget.getInstance().hide();
            }

            public void onSuccess(SectioningReportRpcResponse result) {
                SectioningReports.this.iData.clear();
                RowData prev = null;
                for (int i = 0; i < result.getReport().size(); ++i) {
                    String[] row = result.getReport().get(i);
                    if (row.length == 0) continue;
                    RowData data = new RowData(row);
                    while (prev != null && data.getNrBlanks() <= prev.getNrBlanks()) {
                        prev = prev.getParent();
                    }
                    if (prev != null) {
                        data.setParent(prev);
                    }
                    if (i == 0) {
                        SectioningReports.this.iHead = data;
                        continue;
                    }
                    SectioningReports.this.iData.add(data);
                    prev = data;
                }
                SectioningReports.this.populate(true);
                LoadingWidget.getInstance().hide();
            }
        });
    }

    public static class RowData {
        String[] iRow;
        RowData iParent;

        public RowData(String[] row) {
            this.iRow = row;
        }

        public String[] getRow() {
            return this.iRow;
        }

        public RowData getParent() {
            return this.iParent;
        }

        public void setParent(RowData parent) {
            this.iParent = parent;
        }

        public boolean isBlank(int col) {
            return this.getRow().length <= col || this.getRow()[col] == null || this.getRow()[col].isEmpty();
        }

        public String getCell(int col) {
            if (this.isBlank(col)) {
                if (this.getParent() != null) {
                    return this.getParent().getCell(col);
                }
                return "";
            }
            return this.getRow()[col];
        }

        public int getLevel() {
            return this.getParent() == null ? 0 : this.getParent().getLevel() + 1;
        }

        public int getLength() {
            return this.getParent() == null ? this.getRow().length : this.getParent().getLength();
        }

        public int getNrBlanks() {
            for (int i = 0; i < this.getLength(); ++i) {
                if (this.isBlank(i)) continue;
                return i;
            }
            return this.getLength();
        }

        public boolean isAllBlank() {
            return this.getNrBlanks() == this.getLength();
        }

        public int compareTo(RowData b, int col) {
            block5: {
                RowData a = this;
                while (a.getLevel() > b.getLevel()) {
                    a = a.getParent();
                }
                while (b.getLevel() > a.getLevel()) {
                    b = b.getParent();
                }
                try {
                    int cmp = Double.valueOf(a.getCell(col) == null ? "0" : a.getCell(col)).compareTo(Double.valueOf(b.getCell(col) == null ? "0" : b.getCell(col)));
                    if (cmp != 0) {
                        return cmp;
                    }
                }
                catch (NumberFormatException e) {
                    int cmp = (a.getCell(col) == null ? "" : a.getCell(col)).compareTo(b.getCell(col) == null ? "" : b.getCell(col));
                    if (cmp == 0) break block5;
                    return cmp;
                }
            }
            return 0;
        }
    }

    public static class NumberCell
    extends HTML
    implements UniTimeTable.HasCellAlignment {
        public NumberCell(String text) {
            super(text, false);
        }

        public NumberCell(int text) {
            super(String.valueOf(text), false);
        }

        public HasHorizontalAlignment.HorizontalAlignmentConstant getCellAlignment() {
            return HasHorizontalAlignment.ALIGN_RIGHT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SectioningReportRpcResponse
    implements GwtRpcResponse {
        private List<String[]> iReport = new ArrayList<String[]>();

        public void addLine(String[] line) {
            this.iReport.add(line);
        }

        public List<String[]> getReport() {
            return this.iReport;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SectioningReportRpcRequest
    implements GwtRpcRequest<SectioningReportRpcResponse> {
        Map<String, String> iParameters = new HashMap<String, String>();

        public void setParameter(String name, String value) {
            this.iParameters.put(name, value);
        }

        public Map<String, String> getParameters() {
            return this.iParameters;
        }

        @Override
        public String toString() {
            return this.getParameters().toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReportType {
        TIME_CONFLICTS("Time Conflicts", "org.cpsolver.studentsct.report.SectionConflictTable", "type", "OVERLAPS", "overlapsIncludeAll", "true"),
        AVAILABLE_CONFLICTS("Availability Conflicts", "org.cpsolver.studentsct.report.SectionConflictTable", "type", "UNAVAILABILITIES", "overlapsIncludeAll", "true"),
        SECTION_CONFLICTS("Time & Availability Conflicts", "org.cpsolver.studentsct.report.SectionConflictTable", "type", "OVERLAPS_AND_UNAVAILABILITIES", "overlapsIncludeAll", "true"),
        UNBALANCED_SECTIONS("Unbalanced Classes", "org.cpsolver.studentsct.report.UnbalancedSectionsTable", new String[0]),
        DISTANCE_CONFLICTS("Distance Conflicts", "org.cpsolver.studentsct.report.DistanceConflictTable", new String[0]),
        TIME_OVERLAPS("Time Overlaps", "org.cpsolver.studentsct.report.TimeOverlapConflictTable", new String[0]),
        REQUEST_GROUPS("Request Groups", "org.cpsolver.studentsct.report.RequestGroupTable", new String[0]),
        INDIVIDUAL_TIME_OVERLAPS("Individual Student Time Overlaps", "org.unitime.timetable.reports.studentsct.IndividualStudentTimeOverlaps", new String[0]),
        NOT_ALLOWED_TIME_OVERLAPS("Not Allowed Time Overlaps", "org.unitime.timetable.reports.studentsct.IndividualStudentTimeOverlaps", "includeAllowedOverlaps", "false"),
        INDIVIDUAL_TIME_OVERLAPS_BT("Individual Student Time Overlaps (Exclude Break Times)", "org.unitime.timetable.reports.studentsct.IndividualStudentTimeOverlaps", "ignoreBreakTimeConflicts", "true"),
        NOT_ALLOWED_TIME_OVERLAPS_BT("Not Allowed Time Overlaps (Exclude Break Times)", "org.unitime.timetable.reports.studentsct.IndividualStudentTimeOverlaps", "ignoreBreakTimeConflicts", "true", "includeAllowedOverlaps", "false"),
        NOT_ASSIGNED_COURSE_REQUESTS(SCT_MSG.reportUnassignedCourseRequests(), "org.unitime.timetable.reports.studentsct.UnasignedCourseRequests", new String[0]);

        String iName;
        String iImplementation;
        String[] iParameters;

        private ReportType(String name, String implementation, String ... params) {
            this.iName = name;
            this.iImplementation = implementation;
            this.iParameters = params;
        }

        public String getName() {
            return this.iName;
        }

        public String getImplementation() {
            return this.iImplementation;
        }

        public String[] getParameters() {
            return this.iParameters;
        }
    }
}

