/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.sectioning;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.aria.AriaCheckBox;
import org.unitime.timetable.gwt.client.aria.ImageButton;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.sectioning.CourseSelectionBox;
import org.unitime.timetable.gwt.client.widgets.CourseSelection;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionEvent;
import org.unitime.timetable.gwt.client.widgets.CourseSelectionHandler;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.Validator;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningResources;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.services.SectioningServiceAsync;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.CourseRequestInterface;
import org.unitime.timetable.gwt.shared.SectioningException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseRequestsTable
extends Composite
implements HasValue<CourseRequestInterface> {
    public static final StudentSectioningResources RESOURCES = (StudentSectioningResources)GWT.create(StudentSectioningResources.class);
    public static final StudentSectioningMessages MESSAGES = (StudentSectioningMessages)GWT.create(StudentSectioningMessages.class);
    public static final StudentSectioningConstants CONSTANTS = (StudentSectioningConstants)GWT.create(StudentSectioningConstants.class);
    public static final GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private final SectioningServiceAsync iSectioningService = (SectioningServiceAsync)GWT.create(SectioningService.class);
    private FlexTable iGrid;
    private AcademicSessionProvider iSessionProvider;
    private ArrayList<CourseSelectionBox[]> iCourses;
    private ArrayList<CourseSelectionBox[]> iAlternatives;
    private Label iTip;
    private boolean iOnline;
    Validator<CourseSelection> iCheckForDuplicities;
    private boolean iCanWaitList = true;
    private boolean iArrowsVisible = true;

    public CourseRequestsTable(AcademicSessionProvider sessionProvider, boolean online) {
        CourseSelectionBox[] c;
        int i;
        this.iOnline = online;
        this.iSessionProvider = sessionProvider;
        this.iGrid = new FlexTable();
        this.iGrid.setStylePrimaryName("unitime-MainTable");
        this.iGrid.addStyleName("unitime-BottomLine");
        this.iGrid.setCellPadding(2);
        this.iGrid.setCellSpacing(0);
        int idx = 0;
        this.iGrid.getFlexCellFormatter().setColSpan(idx, 0, 4);
        this.iGrid.getFlexCellFormatter().setStyleName(idx, 0, "unitime-MainTableHeader");
        this.iGrid.getRowFormatter().setStyleName(idx, "unitime-MainTableHeaderRow");
        this.iGrid.setText(idx, 0, MESSAGES.courseRequestsCourses());
        this.iGrid.getFlexCellFormatter().setColSpan(idx, 1, 4);
        this.iGrid.getFlexCellFormatter().setStyleName(idx, 1, "unitime-MainTableHeaderNote");
        this.iGrid.setHTML(idx, 1, MESSAGES.courseRequestsWaitList());
        this.iGrid.getFlexCellFormatter().getElement(idx, 1).getStyle().setVerticalAlign(Style.VerticalAlign.BOTTOM);
        ++idx;
        this.iCourses = new ArrayList();
        this.iAlternatives = new ArrayList();
        this.iCheckForDuplicities = new Validator<CourseSelection>(){

            @Override
            public String validate(CourseSelection source) {
                int i;
                if (((String)source.getValue()).isEmpty() || source.isFreeTime()) {
                    return null;
                }
                String course = (String)source.getValue();
                for (CourseSelectionBox[] c : CourseRequestsTable.this.iCourses) {
                    for (i = 0; i < c.length; ++i) {
                        if (c[i] == source || !c[i].getValue().equals(course)) continue;
                        return MESSAGES.validationMultiple(course);
                    }
                }
                for (CourseSelectionBox[] c : CourseRequestsTable.this.iAlternatives) {
                    for (i = 0; i < c.length; ++i) {
                        if (c[i] == source || !c[i].getValue().equals(course)) continue;
                        return MESSAGES.validationMultiple(course);
                    }
                }
                return null;
            }
        };
        for (i = 0; i < CONSTANTS.numberOfCourses(); ++i) {
            this.iGrid.setText(idx, 0, MESSAGES.courseRequestsPriority(i + 1));
            this.iGrid.getCellFormatter().setHorizontalAlignment(idx, 0, HasHorizontalAlignment.ALIGN_RIGHT);
            c = new CourseSelectionBox[]{new CourseSelectionBox(this.iSessionProvider, true, true), new CourseSelectionBox(this.iSessionProvider, false, false), new CourseSelectionBox(this.iSessionProvider, false, false)};
            c[0].setLabel(ARIA.titleRequestedCourse(1 + i), ARIA.altRequestedCourseFinder(1 + i));
            c[1].setLabel(ARIA.titleRequestedCourseFirstAlternative(1 + i), ARIA.altRequestedCourseFirstAlternativeFinder(1 + i));
            c[2].setLabel(ARIA.titleRequestedCourseSecondAlternative(1 + i), ARIA.altRequestedCourseSecondAlternativeFinder(1 + i));
            if (i < 9) {
                c[0].setAccessKey((char)(49 + i));
            } else if (i == 9) {
                c[0].setAccessKey('0');
            }
            AriaCheckBox ch = new AriaCheckBox();
            ch.setAriaLabel(ARIA.titleRequestedWaitList(1 + i));
            if (i > 0) {
                CourseSelectionBox[] x = this.iCourses.get(i - 1);
                for (int j = 0; j < 3; ++j) {
                    c[j].setPrev(x[j]);
                    x[j].setNext(c[j]);
                }
                ImageButton up = new ImageButton(RESOURCES.up(), RESOURCES.up_Down(), RESOURCES.up_Over());
                up.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        c[0].swapUp();
                    }
                });
                this.iGrid.setWidget(idx, 5, (Widget)up);
                up.setAltText(ARIA.altSwapCourseRequest(i + 1, i));
            }
            if (i <= CONSTANTS.numberOfCourses()) {
                ImageButton down = new ImageButton(RESOURCES.down(), RESOURCES.down_Down(), RESOURCES.down_Over());
                down.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        c[0].swapDown();
                    }
                });
                this.iGrid.setWidget(idx, 6, (Widget)down);
                down.setAltText(i + 1 == CONSTANTS.numberOfCourses() ? ARIA.altSwapCourseAlternateRequest(i + 1, 1) : ARIA.altSwapCourseRequest(i + 1, i + 2));
            }
            ImageButton delete = new ImageButton(RESOURCES.delete(), RESOURCES.delete_Down(), RESOURCES.delete_Over());
            delete.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    c[0].remove();
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
                }
            });
            this.iGrid.setWidget(idx, 7, (Widget)delete);
            delete.setAltText(ARIA.altDeleteRequest(i + 1));
            c[0].setWidth("260px");
            c[1].setWidth("155px");
            c[2].setWidth("155px");
            this.iGrid.setWidget(idx, 1, (Widget)c[0]);
            this.iGrid.setWidget(idx, 2, (Widget)c[1]);
            this.iGrid.setWidget(idx, 3, (Widget)c[2]);
            this.iGrid.setWidget(idx, 4, (Widget)ch);
            this.iGrid.getRowFormatter().setVerticalAlign(idx, HasVerticalAlignment.ALIGN_TOP);
            this.iCourses.add(c);
            c[0].setWaitList(ch);
            ++idx;
        }
        this.iCourses.get(1)[0].setHint(MESSAGES.courseRequestsHint1());
        this.iCourses.get(3)[0].setHint(MESSAGES.courseRequestsHint3());
        this.iCourses.get(4)[0].setHint(MESSAGES.courseRequestsHint4());
        this.iCourses.get(CONSTANTS.numberOfCourses() - 1)[0].setHint(MESSAGES.courseRequestsHint8());
        this.iTip = new Label(CONSTANTS.tips()[(int)(Math.random() * (double)CONSTANTS.tips().length)]);
        ToolBox.disableTextSelectInternal((Element)this.iTip.getElement());
        this.iTip.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                String oldText = CourseRequestsTable.this.iTip.getText();
                do {
                    CourseRequestsTable.this.iTip.setText(CONSTANTS.tips()[(int)(Math.random() * (double)CONSTANTS.tips().length)]);
                } while (oldText.equals(CourseRequestsTable.this.iTip.getText()));
            }
        });
        this.iGrid.getFlexCellFormatter().setColSpan(idx, 0, 8);
        this.iGrid.getFlexCellFormatter().setStyleName(idx, 0, "unitime-Hint");
        this.iGrid.setWidget(idx++, 0, (Widget)this.iTip);
        this.iGrid.getFlexCellFormatter().setColSpan(idx, 0, 2);
        this.iGrid.getFlexCellFormatter().setStyleName(idx, 0, "unitime-MainTableHeader");
        this.iGrid.setText(idx, 0, MESSAGES.courseRequestsAlternatives());
        this.iGrid.getFlexCellFormatter().setColSpan(idx, 1, 6);
        this.iGrid.getFlexCellFormatter().setStyleName(idx, 1, "unitime-MainTableHeaderNote");
        this.iGrid.setHTML(idx, 1, MESSAGES.courseRequestsAlternativesNote());
        this.iGrid.getFlexCellFormatter().getElement(idx, 1).getStyle().setVerticalAlign(Style.VerticalAlign.BOTTOM);
        ++idx;
        for (i = 0; i < CONSTANTS.numberOfAlternatives(); ++i) {
            this.iGrid.setText(idx, 0, MESSAGES.courseRequestsAlternative(i + 1));
            this.iGrid.getCellFormatter().setHorizontalAlignment(idx, 0, HasHorizontalAlignment.ALIGN_RIGHT);
            c = new CourseSelectionBox[]{new CourseSelectionBox(this.iSessionProvider, true, false), new CourseSelectionBox(this.iSessionProvider, false, false), new CourseSelectionBox(this.iSessionProvider, false, false)};
            c[0].setLabel(ARIA.titleRequestedAlternate(1 + i, String.valueOf((char)(97 + i))), ARIA.altRequestedAlternateFinder(1 + i));
            c[1].setLabel(ARIA.titleRequestedAlternateFirstAlternative(1 + i), ARIA.altRequestedAlternateFirstFinder(1 + i));
            c[2].setLabel(ARIA.titleRequestedAlternateSecondAlternative(1 + i), ARIA.altRequestedAlternateSecondFinder(1 + i));
            c[0].setAccessKey((char)(97 + i));
            if (i >= 0) {
                CourseSelectionBox[] x = i == 0 ? this.iCourses.get(CONSTANTS.numberOfCourses() - 1) : this.iAlternatives.get(i - 1);
                for (int j = 0; j < 3; ++j) {
                    c[j].setPrev(x[j]);
                    x[j].setNext(c[j]);
                }
                ImageButton up = new ImageButton(RESOURCES.up(), RESOURCES.up_Down(), RESOURCES.up_Over());
                up.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        c[0].swapUp();
                    }
                });
                this.iGrid.setWidget(idx, 4, (Widget)up);
                up.setAltText(i == 0 ? ARIA.altSwapCourseAlternateRequest(CONSTANTS.numberOfCourses(), 1) : ARIA.altSwapAlternateRequest(i + 1, i));
            }
            if (i < CONSTANTS.numberOfAlternatives() - 1) {
                ImageButton down = new ImageButton(RESOURCES.down(), RESOURCES.down_Down(), RESOURCES.down_Over());
                down.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        c[0].swapDown();
                    }
                });
                this.iGrid.setWidget(idx, 5, (Widget)down);
                down.setAltText(ARIA.altSwapAlternateRequest(i + 1, i + 2));
            }
            ImageButton delete = new ImageButton(RESOURCES.delete(), RESOURCES.delete_Down(), RESOURCES.delete_Over());
            delete.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    c[0].remove();
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
                }
            });
            this.iGrid.setWidget(idx, 6, (Widget)delete);
            delete.setAltText(ARIA.altDeleteAlternateRequest(i + 1));
            c[0].setWidth("260px");
            c[1].setWidth("155px");
            c[2].setWidth("155px");
            this.iGrid.setWidget(idx, 1, (Widget)c[0]);
            this.iGrid.setWidget(idx, 2, (Widget)c[1]);
            this.iGrid.setWidget(idx, 3, (Widget)c[2]);
            this.iGrid.getRowFormatter().setVerticalAlign(idx, HasVerticalAlignment.ALIGN_TOP);
            this.iAlternatives.add(c);
            ++idx;
        }
        this.iAlternatives.get(0)[0].setHint(MESSAGES.courseRequestsHintA0());
        this.initWidget((Widget)this.iGrid);
        this.initAsync();
    }

    private void initAsync() {
        GWT.runAsync((RunAsyncCallback)new RunAsyncCallback(){

            public void onSuccess() {
                CourseRequestsTable.this.init();
            }

            public void onFailure(Throwable reason) {
                UniTimeNotifications.error(reason);
            }
        });
    }

    private void addCourseLine() {
        int i = this.iCourses.size();
        int idx = 1 + i;
        this.iGrid.insertRow(idx);
        this.iGrid.setText(idx, 0, MESSAGES.courseRequestsPriority(i + 1));
        this.iGrid.getCellFormatter().setHorizontalAlignment(idx, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        final CourseSelectionBox[] c = new CourseSelectionBox[]{new CourseSelectionBox(this.iSessionProvider, true, true), new CourseSelectionBox(this.iSessionProvider, false, false), new CourseSelectionBox(this.iSessionProvider, false, false)};
        c[0].setHint(MESSAGES.courseRequestsHint8());
        c[0].setLabel(ARIA.titleRequestedCourse(1 + i), ARIA.altRequestedCourseFinder(1 + i));
        c[1].setLabel(ARIA.titleRequestedCourseFirstAlternative(1 + i), ARIA.altRequestedCourseFirstAlternativeFinder(1 + i));
        c[2].setLabel(ARIA.titleRequestedCourseSecondAlternative(1 + i), ARIA.altRequestedCourseSecondAlternativeFinder(1 + i));
        if (i < 9) {
            c[0].setAccessKey((char)(49 + i));
        } else if (i == 9) {
            c[0].setAccessKey('0');
        }
        AriaCheckBox ch = new AriaCheckBox();
        ch.setAriaLabel(ARIA.titleRequestedWaitList(1 + i));
        CourseSelectionBox[] x = this.iCourses.get(i - 1);
        x[0].setHint("");
        for (int j = 0; j < 3; ++j) {
            c[j].setPrev(x[j]);
            x[j].setNext(c[j]);
        }
        CourseSelectionBox[] y = this.iAlternatives.get(0);
        for (int j = 0; j < 3; ++j) {
            c[j].setNext(y[j]);
            y[j].setPrev(c[j]);
        }
        if (i > 0) {
            ImageButton up = new ImageButton(RESOURCES.up(), RESOURCES.up_Down(), RESOURCES.up_Over());
            up.setVisible(this.iArrowsVisible);
            up.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    c[0].swapUp();
                }
            });
            this.iGrid.setWidget(idx, 5, (Widget)up);
            up.setAltText(ARIA.altSwapCourseRequest(i + 1, i));
            ImageButton down = new ImageButton(RESOURCES.down(), RESOURCES.down_Down(), RESOURCES.down_Over());
            down.setVisible(this.iArrowsVisible);
            down.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    c[0].swapDown();
                }
            });
            this.iGrid.setWidget(idx, 6, (Widget)down);
            down.setAltText(ARIA.altSwapCourseAlternateRequest(i + 1, 1));
            ((ImageButton)this.iGrid.getWidget(idx - 1, 6)).setAltText(ARIA.altSwapCourseRequest(i, i + 1));
            ((ImageButton)this.iGrid.getWidget(idx + 3, 4)).setAltText(ARIA.altSwapCourseAlternateRequest(this.iCourses.size(), 1));
            ImageButton delete = new ImageButton(RESOURCES.delete(), RESOURCES.delete_Down(), RESOURCES.delete_Over());
            delete.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    c[0].remove();
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
                }
            });
            this.iGrid.setWidget(idx, 7, (Widget)delete);
            delete.setAltText(ARIA.altDeleteRequest(i + 1));
        }
        c[0].setWidth(this.iArrowsVisible ? "260px" : "300px");
        c[1].setWidth("155px");
        c[2].setWidth("155px");
        c[1].setEnabled(false);
        c[2].setEnabled(false);
        this.iGrid.setWidget(idx, 1, (Widget)c[0]);
        this.iGrid.setWidget(idx, 2, (Widget)c[1]);
        this.iGrid.setWidget(idx, 3, (Widget)c[2]);
        this.iGrid.setWidget(idx, 4, (Widget)ch);
        this.iGrid.getCellFormatter().setVisible(idx, 4, this.iCanWaitList);
        this.iGrid.getRowFormatter().setVerticalAlign(idx, HasVerticalAlignment.ALIGN_TOP);
        this.iCourses.add(c);
        c[0].setWaitList(ch);
        c[0].addCourseSelectionHandler(new CourseSelectionHandler(){

            public void onCourseSelection(CourseSelectionEvent event) {
                if (event.isValid()) {
                    c[0].setError("");
                }
                if (!c[0].isFreeTime()) {
                    c[1].setEnabled(event.isValid() || !c[1].getValue().isEmpty() || !c[2].getValue().isEmpty());
                    if (event.isValid() && !c[0].getValue().isEmpty()) {
                        c[1].setHint(MESSAGES.courseRequestsHintAlt(c[0].getValue()));
                    } else {
                        c[1].setHint("");
                    }
                } else {
                    c[1].setHint("");
                }
                if (event.isValid() && c == CourseRequestsTable.this.iCourses.get(CourseRequestsTable.this.iCourses.size() - 1)) {
                    CourseRequestsTable.this.addCourseLine();
                }
                ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
            }
        });
        c[1].addCourseSelectionHandler(new CourseSelectionHandler(){

            public void onCourseSelection(CourseSelectionEvent event) {
                if (event.isValid()) {
                    c[1].setError("");
                }
                c[2].setEnabled(event.isValid() || !c[2].getValue().isEmpty());
                if (event.isValid() && !c[0].getValue().isEmpty() && !c[1].getValue().isEmpty()) {
                    c[2].setHint(MESSAGES.courseRequestsHintAlt2(c[0].getValue(), c[1].getValue()));
                } else {
                    c[2].setHint("");
                }
                ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
            }
        });
        c[2].addCourseSelectionHandler(new CourseSelectionHandler(){

            public void onCourseSelection(CourseSelectionEvent event) {
                if (event.isValid()) {
                    c[2].setError("");
                }
                ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
            }
        });
        c[1].addValidator(new Validator<CourseSelection>(){

            @Override
            public String validate(CourseSelection source) {
                if (!c[1].getValue().isEmpty() && c[0].getValue().isEmpty()) {
                    return MESSAGES.validationNoCourse();
                }
                if (!c[1].getValue().isEmpty() && c[0].isFreeTime()) {
                    return MESSAGES.validationFreeTimeWithAlt();
                }
                if (c[1].isFreeTime()) {
                    return MESSAGES.validationAltFreeTime();
                }
                return null;
            }
        });
        c[2].addValidator(new Validator<CourseSelection>(){

            @Override
            public String validate(CourseSelection source) {
                if (!c[2].getValue().isEmpty() && c[1].getValue().isEmpty()) {
                    return MESSAGES.validationSecondAltWithoutFirst();
                }
                if (!c[2].getValue().isEmpty() && c[0].isFreeTime()) {
                    return MESSAGES.validationFreeTimeWithAlt();
                }
                if (c[2].isFreeTime()) {
                    return MESSAGES.validationAltFreeTime();
                }
                return null;
            }
        });
        c[0].setAlternative(c[1]);
        c[1].setAlternative(c[2]);
        c[1].setPrimary(c[0]);
        c[2].setPrimary(c[1]);
        c[0].addValidator(this.iCheckForDuplicities);
        c[1].addValidator(this.iCheckForDuplicities);
        c[2].addValidator(this.iCheckForDuplicities);
    }

    private void addAlternativeLine() {
        int i = this.iAlternatives.size();
        int idx = 3 + this.iCourses.size() + i;
        this.iGrid.insertRow(idx);
        this.iGrid.setText(idx, 0, MESSAGES.courseRequestsAlternative(i + 1));
        this.iGrid.getCellFormatter().setHorizontalAlignment(idx, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        final CourseSelectionBox[] c = new CourseSelectionBox[]{new CourseSelectionBox(this.iSessionProvider, true, false), new CourseSelectionBox(this.iSessionProvider, false, false), new CourseSelectionBox(this.iSessionProvider, false, false)};
        c[0].setLabel(ARIA.titleRequestedAlternate(1 + i, String.valueOf((char)(97 + i))), ARIA.altRequestedAlternateFinder(1 + i));
        c[1].setLabel(ARIA.titleRequestedAlternateFirstAlternative(1 + i), ARIA.altRequestedAlternateFirstFinder(1 + i));
        c[2].setLabel(ARIA.titleRequestedAlternateSecondAlternative(1 + i), ARIA.altRequestedAlternateSecondFinder(1 + i));
        c[0].setAccessKey((char)(97 + i));
        if (i >= 0) {
            final CourseSelectionBox[] x = this.iAlternatives.get(i - 1);
            for (int j = 0; j < 3; ++j) {
                c[j].setPrev(x[j]);
                x[j].setNext(c[j]);
            }
            ImageButton up = new ImageButton(RESOURCES.up(), RESOURCES.up_Down(), RESOURCES.up_Over());
            up.setVisible(this.iArrowsVisible);
            up.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    c[0].swapUp();
                }
            });
            this.iGrid.setWidget(idx, 4, (Widget)up);
            up.setAltText(i == 0 ? ARIA.altSwapCourseAlternateRequest(CONSTANTS.numberOfCourses(), 1) : ARIA.altSwapAlternateRequest(i + 1, i));
            ImageButton down = new ImageButton(RESOURCES.down(), RESOURCES.down_Down(), RESOURCES.down_Over());
            down.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    x[0].swapDown();
                }
            });
            this.iGrid.setWidget(idx - 1, 5, (Widget)down);
            down.setAltText(ARIA.altSwapAlternateRequest(i, i + 1));
            down.setVisible(this.iArrowsVisible);
            ImageButton delete = new ImageButton(RESOURCES.delete(), RESOURCES.delete_Down(), RESOURCES.delete_Over());
            delete.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    c[0].remove();
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
                }
            });
            this.iGrid.setWidget(idx, 6, (Widget)delete);
            delete.setAltText(ARIA.altDeleteAlternateRequest(i + 1));
        }
        c[0].setWidth(this.iArrowsVisible ? "260px" : "300px");
        c[1].setWidth("155px");
        c[2].setWidth("155px");
        c[1].setEnabled(false);
        c[2].setEnabled(false);
        this.iGrid.setWidget(idx, 1, (Widget)c[0]);
        this.iGrid.setWidget(idx, 2, (Widget)c[1]);
        this.iGrid.setWidget(idx, 3, (Widget)c[2]);
        this.iGrid.getRowFormatter().setVerticalAlign(idx, HasVerticalAlignment.ALIGN_TOP);
        this.iAlternatives.add(c);
        c[0].addCourseSelectionHandler(new CourseSelectionHandler(){

            public void onCourseSelection(CourseSelectionEvent event) {
                if (event.isValid()) {
                    c[0].setError("");
                }
                if (!c[0].isFreeTime()) {
                    c[1].setEnabled(event.isValid() || !c[1].getValue().isEmpty() || !c[2].getValue().isEmpty());
                    if (event.isValid() && !c[0].getValue().isEmpty()) {
                        c[1].setHint(MESSAGES.courseRequestsHintAlt(c[0].getValue()));
                    } else {
                        c[1].setHint("");
                    }
                } else {
                    c[1].setHint("");
                }
                if (event.isValid() && c == CourseRequestsTable.this.iAlternatives.get(CourseRequestsTable.this.iAlternatives.size() - 1)) {
                    CourseRequestsTable.this.addAlternativeLine();
                }
                ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
            }
        });
        c[1].addCourseSelectionHandler(new CourseSelectionHandler(){

            public void onCourseSelection(CourseSelectionEvent event) {
                if (event.isValid()) {
                    c[1].setError("");
                }
                c[2].setEnabled(event.isValid() || !c[2].getValue().isEmpty());
                if (event.isValid() && !c[0].getValue().isEmpty() && !c[1].getValue().isEmpty()) {
                    c[2].setHint(MESSAGES.courseRequestsHintAlt2(c[0].getValue(), c[1].getValue()));
                } else {
                    c[2].setHint("");
                }
                ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
            }
        });
        c[2].addCourseSelectionHandler(new CourseSelectionHandler(){

            public void onCourseSelection(CourseSelectionEvent event) {
                if (event.isValid()) {
                    c[2].setError("");
                }
                ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
            }
        });
        c[0].addValidator(new Validator<CourseSelection>(){

            @Override
            public String validate(CourseSelection source) {
                if (c[0].isFreeTime()) {
                    return MESSAGES.validationAltFreeTime();
                }
                return null;
            }
        });
        c[1].addValidator(new Validator<CourseSelection>(){

            @Override
            public String validate(CourseSelection source) {
                if (!c[1].getValue().isEmpty() && c[0].getValue().isEmpty()) {
                    return MESSAGES.validationNoCourse();
                }
                if (!c[1].getValue().isEmpty() && c[0].isFreeTime()) {
                    return MESSAGES.validationFreeTimeWithAlt();
                }
                if (c[1].isFreeTime()) {
                    return MESSAGES.validationAltFreeTime();
                }
                return null;
            }
        });
        c[2].addValidator(new Validator<CourseSelection>(){

            @Override
            public String validate(CourseSelection source) {
                if (!c[2].getValue().isEmpty() && c[1].getValue().isEmpty()) {
                    return MESSAGES.validationSecondAltWithoutFirst();
                }
                if (!c[2].getValue().isEmpty() && c[0].isFreeTime()) {
                    return MESSAGES.validationFreeTimeWithAlt();
                }
                if (c[2].isFreeTime()) {
                    return MESSAGES.validationAltFreeTime();
                }
                return null;
            }
        });
        c[0].setAlternative(c[1]);
        c[1].setAlternative(c[2]);
        c[1].setPrimary(c[0]);
        c[2].setPrimary(c[1]);
        c[0].addValidator(this.iCheckForDuplicities);
        c[1].addValidator(this.iCheckForDuplicities);
        c[2].addValidator(this.iCheckForDuplicities);
    }

    private void init() {
        for (final CourseSelectionBox[] c : this.iCourses) {
            c[0].addCourseSelectionHandler(new CourseSelectionHandler(){

                public void onCourseSelection(CourseSelectionEvent event) {
                    if (event.isValid()) {
                        c[0].setError("");
                    }
                    if (!c[0].isFreeTime()) {
                        c[1].setEnabled(event.isValid() || !c[1].getValue().isEmpty() || !c[2].getValue().isEmpty());
                        if (event.isValid() && !c[0].getValue().isEmpty()) {
                            c[1].setHint(MESSAGES.courseRequestsHintAlt(c[0].getValue()));
                        } else {
                            c[1].setHint("");
                        }
                    } else {
                        c[1].setHint("");
                    }
                    if (event.isValid() && c == CourseRequestsTable.this.iCourses.get(CourseRequestsTable.this.iCourses.size() - 1)) {
                        CourseRequestsTable.this.addCourseLine();
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
                }
            });
            c[1].addCourseSelectionHandler(new CourseSelectionHandler(){

                public void onCourseSelection(CourseSelectionEvent event) {
                    if (event.isValid()) {
                        c[1].setError("");
                    }
                    c[2].setEnabled(event.isValid() || !c[2].getValue().isEmpty());
                    if (event.isValid() && !c[0].getValue().isEmpty() && !c[1].getValue().isEmpty()) {
                        c[2].setHint(MESSAGES.courseRequestsHintAlt2(c[0].getValue(), c[1].getValue()));
                    } else {
                        c[2].setHint("");
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
                }
            });
            c[2].addCourseSelectionHandler(new CourseSelectionHandler(){

                public void onCourseSelection(CourseSelectionEvent event) {
                    if (event.isValid()) {
                        c[2].setError("");
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
                }
            });
            c[1].addValidator(new Validator<CourseSelection>(){

                @Override
                public String validate(CourseSelection source) {
                    if (!c[1].getValue().isEmpty() && c[0].getValue().isEmpty()) {
                        return MESSAGES.validationNoCourse();
                    }
                    if (!c[1].getValue().isEmpty() && c[0].isFreeTime()) {
                        return MESSAGES.validationFreeTimeWithAlt();
                    }
                    if (c[1].isFreeTime()) {
                        return MESSAGES.validationAltFreeTime();
                    }
                    return null;
                }
            });
            c[2].addValidator(new Validator<CourseSelection>(){

                @Override
                public String validate(CourseSelection source) {
                    if (!c[2].getValue().isEmpty() && c[1].getValue().isEmpty()) {
                        return MESSAGES.validationSecondAltWithoutFirst();
                    }
                    if (!c[2].getValue().isEmpty() && c[0].isFreeTime()) {
                        return MESSAGES.validationFreeTimeWithAlt();
                    }
                    if (c[2].isFreeTime()) {
                        return MESSAGES.validationAltFreeTime();
                    }
                    return null;
                }
            });
            c[0].setAlternative(c[1]);
            c[1].setAlternative(c[2]);
            c[1].setPrimary(c[0]);
            c[2].setPrimary(c[1]);
            c[0].addValidator(this.iCheckForDuplicities);
            c[1].addValidator(this.iCheckForDuplicities);
            c[2].addValidator(this.iCheckForDuplicities);
        }
        for (final CourseSelectionBox[] c : this.iAlternatives) {
            c[0].addCourseSelectionHandler(new CourseSelectionHandler(){

                public void onCourseSelection(CourseSelectionEvent event) {
                    if (event.isValid()) {
                        c[0].setError("");
                    }
                    if (!c[0].isFreeTime()) {
                        c[1].setEnabled(event.isValid() || !c[1].getValue().isEmpty() || !c[2].getValue().isEmpty());
                        if (event.isValid() && !c[0].getValue().isEmpty()) {
                            c[1].setHint(MESSAGES.courseRequestsHintAlt(c[0].getValue()));
                        } else {
                            c[1].setHint("");
                        }
                    } else {
                        c[1].setHint("");
                    }
                    if (event.isValid() && c == CourseRequestsTable.this.iAlternatives.get(CourseRequestsTable.this.iAlternatives.size() - 1)) {
                        CourseRequestsTable.this.addAlternativeLine();
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
                }
            });
            c[1].addCourseSelectionHandler(new CourseSelectionHandler(){

                public void onCourseSelection(CourseSelectionEvent event) {
                    if (event.isValid()) {
                        c[1].setError("");
                    }
                    c[2].setEnabled(event.isValid() || !c[2].getValue().isEmpty());
                    if (event.isValid() && !c[0].getValue().isEmpty() && !c[1].getValue().isEmpty()) {
                        c[2].setHint(MESSAGES.courseRequestsHintAlt2(c[0].getValue(), c[1].getValue()));
                    } else {
                        c[2].setHint("");
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
                }
            });
            c[2].addCourseSelectionHandler(new CourseSelectionHandler(){

                public void onCourseSelection(CourseSelectionEvent event) {
                    if (event.isValid()) {
                        c[2].setError("");
                    }
                    ValueChangeEvent.fire((HasValueChangeHandlers)CourseRequestsTable.this, (Object)CourseRequestsTable.this.getRequest());
                }
            });
            c[0].addValidator(new Validator<CourseSelection>(){

                @Override
                public String validate(CourseSelection source) {
                    if (c[0].isFreeTime()) {
                        return MESSAGES.validationAltFreeTime();
                    }
                    return null;
                }
            });
            c[1].addValidator(new Validator<CourseSelection>(){

                @Override
                public String validate(CourseSelection source) {
                    if (!c[1].getValue().isEmpty() && c[0].getValue().isEmpty()) {
                        return MESSAGES.validationNoCourse();
                    }
                    if (!c[1].getValue().isEmpty() && c[0].isFreeTime()) {
                        return MESSAGES.validationFreeTimeWithAlt();
                    }
                    if (c[1].isFreeTime()) {
                        return MESSAGES.validationAltFreeTime();
                    }
                    return null;
                }
            });
            c[2].addValidator(new Validator<CourseSelection>(){

                @Override
                public String validate(CourseSelection source) {
                    if (!c[2].getValue().isEmpty() && c[1].getValue().isEmpty()) {
                        return MESSAGES.validationSecondAltWithoutFirst();
                    }
                    if (!c[2].getValue().isEmpty() && c[0].isFreeTime()) {
                        return MESSAGES.validationFreeTimeWithAlt();
                    }
                    if (c[2].isFreeTime()) {
                        return MESSAGES.validationAltFreeTime();
                    }
                    return null;
                }
            });
            c[0].setAlternative(c[1]);
            c[1].setAlternative(c[2]);
            c[1].setPrimary(c[0]);
            c[2].setPrimary(c[1]);
            c[0].addValidator(this.iCheckForDuplicities);
            c[1].addValidator(this.iCheckForDuplicities);
            c[2].addValidator(this.iCheckForDuplicities);
        }
    }

    public void setCanWaitList(boolean canWaitList) {
        this.iCanWaitList = canWaitList;
        this.iGrid.setHTML(0, 1, this.iCanWaitList ? (this.iArrowsVisible ? MESSAGES.courseRequestsWaitList() : MESSAGES.courseRequestsWaitListNoArrows()) : "");
        for (int i = 0; i < this.iCourses.size(); ++i) {
            this.iGrid.getCellFormatter().setVisible(1 + i, 4, this.iCanWaitList);
        }
    }

    public void setArrowsVisible(boolean arrowsVisible) {
        int i;
        this.iArrowsVisible = arrowsVisible;
        for (i = 0; i < this.iCourses.size(); ++i) {
            this.iCourses.get(i)[0].setWidth(this.iArrowsVisible ? "260px" : "300px");
            this.iGrid.getCellFormatter().setVisible(1 + i, 5, this.iArrowsVisible);
            this.iGrid.getCellFormatter().setVisible(1 + i, 6, this.iArrowsVisible);
        }
        for (i = 0; i < this.iAlternatives.size(); ++i) {
            this.iAlternatives.get(i)[0].setWidth(this.iArrowsVisible ? "260px" : "300px");
            this.iGrid.getCellFormatter().setVisible(3 + this.iCourses.size() + i, 4, this.iArrowsVisible);
            this.iGrid.getCellFormatter().setVisible(3 + this.iCourses.size() + i, 5, this.iArrowsVisible);
        }
        if (this.iArrowsVisible) {
            this.iGrid.getFlexCellFormatter().setColSpan(0, 0, 4);
            this.iGrid.getFlexCellFormatter().setColSpan(0, 1, 4);
            this.iGrid.getFlexCellFormatter().getElement(0, 1).getStyle().clearTextAlign();
            this.iGrid.setHTML(0, 1, this.iCanWaitList ? MESSAGES.courseRequestsWaitList() : "");
            this.iGrid.getFlexCellFormatter().getElement(0, 1).getStyle().clearPaddingRight();
        } else {
            this.iGrid.getFlexCellFormatter().setColSpan(0, 0, 3);
            this.iGrid.getFlexCellFormatter().setColSpan(0, 1, 5);
            this.iGrid.getFlexCellFormatter().getElement(0, 1).getStyle().setTextAlign(Style.TextAlign.RIGHT);
            this.iGrid.setHTML(0, 1, this.iCanWaitList ? MESSAGES.courseRequestsWaitListNoArrows() : "");
            this.iGrid.getFlexCellFormatter().getElement(0, 1).getStyle().setPaddingRight(30.0, Style.Unit.PX);
        }
    }

    public void validate(AsyncCallback<Boolean> callback) {
        this.validate(null, callback);
    }

    public void validate(Boolean updateLastRequest, final AsyncCallback<Boolean> callback) {
        try {
            String failed = null;
            LoadingWidget.getInstance().show(MESSAGES.courseRequestsValidating());
            for (CourseSelectionBox[] c : this.iCourses) {
                for (CourseSelectionBox x : c) {
                    String message = x.validate();
                    if (message == null) continue;
                    failed = message;
                }
            }
            CourseRequestInterface cr = new CourseRequestInterface();
            cr.setAcademicSessionId(this.iSessionProvider.getAcademicSessionId());
            if (cr.getAcademicSessionId() == null) {
                throw new SectioningException(MESSAGES.sessionSelectorNoSession());
            }
            this.fillInCourses(cr);
            this.fillInAlternatives(cr);
            if (updateLastRequest != null) {
                cr.setUpdateLastRequest(updateLastRequest);
            }
            final boolean success = failed == null;
            this.iSectioningService.checkCourses(this.iOnline, cr, new AsyncCallback<Collection<String>>(){

                public void onSuccess(Collection<String> result) {
                    for (String course : result) {
                        CourseRequestsTable.this.setError(course, MESSAGES.validationCourseNotExists(course));
                    }
                    LoadingWidget.getInstance().hide();
                    callback.onSuccess((Object)(success && result.isEmpty() ? 1 : 0));
                }

                public void onFailure(Throwable caught) {
                    LoadingWidget.getInstance().hide();
                    callback.onFailure(caught);
                }
            });
        }
        catch (Exception e) {
            callback.onFailure((Throwable)e);
        }
    }

    public void setError(String course, String error) {
        int i;
        GWT.log((String)error);
        for (CourseSelectionBox[] c : this.iCourses) {
            for (i = 0; i < c.length; ++i) {
                if (!course.equals(c[i].getValue()) || c[i].getError() != null) continue;
                c[i].setError(error);
            }
        }
        for (CourseSelectionBox[] c : this.iAlternatives) {
            for (i = 0; i < c.length; ++i) {
                if (!course.equals(c[i].getValue()) || c[i].getError() != null) continue;
                c[i].setError(error);
            }
        }
    }

    public void changeTip() {
        this.iTip.setText(CONSTANTS.tips()[(int)(Math.random() * (double)CONSTANTS.tips().length)]);
    }

    public void fillInCourses(CourseRequestInterface cr) {
        for (CourseSelectionBox[] course : this.iCourses) {
            CourseRequestInterface.Request req = new CourseRequestInterface.Request();
            course[0].fillInFreeTime(req);
            req.setRequestedCourse(course[0].getValue());
            req.setFirstAlternative(course[1].getValue());
            req.setSecondAlternative(course[2].getValue());
            req.setWaitList(course[0].getWaitList());
            if (!course[0].isEnabled()) {
                req.setReadOnly(course[2].isSaved() ? 2 : (course[1].isSaved() ? 1 : 0));
            }
            cr.getCourses().add(req);
        }
    }

    public void fillInAlternatives(CourseRequestInterface cr) {
        for (CourseSelectionBox[] course : this.iAlternatives) {
            CourseRequestInterface.Request req = new CourseRequestInterface.Request();
            req.setRequestedCourse(course[0].getValue());
            req.setFirstAlternative(course[1].getValue());
            req.setSecondAlternative(course[2].getValue());
            if (!course[0].isEnabled()) {
                req.setReadOnly(course[2].isSaved() ? 2 : (course[1].isSaved() ? 1 : 0));
            }
            cr.getAlternatives().add(req);
        }
    }

    public CourseRequestInterface getRequest() {
        CourseRequestInterface cr = new CourseRequestInterface();
        cr.setAcademicSessionId(this.iSessionProvider.getAcademicSessionId());
        this.fillInCourses(cr);
        this.fillInAlternatives(cr);
        return cr;
    }

    public void setRequest(CourseRequestInterface request) {
        int idx;
        this.clear();
        while (this.iCourses.size() < request.getCourses().size()) {
            this.addCourseLine();
        }
        for (idx = 0; idx < request.getCourses().size(); ++idx) {
            this.iCourses.get(idx)[0].setValue(request.getCourses().get(idx).getRequestedCourse(), true);
            this.iCourses.get(idx)[1].setValue(request.getCourses().get(idx).getFirstAlternative(), true);
            this.iCourses.get(idx)[2].setValue(request.getCourses().get(idx).getSecondAlternative(), true);
            this.iCourses.get(idx)[0].setWaitList(request.getCourses().get(idx).isWaitList());
            if (request.getCourses().get(idx).isReadOnly()) {
                this.iCourses.get(idx)[0].setSaved(request.getCourses().get(idx).isRequestedCourseReadOnly());
                this.iCourses.get(idx)[1].setSaved(request.getCourses().get(idx).isFirstAlternativeReadOnly());
                this.iCourses.get(idx)[2].setSaved(request.getCourses().get(idx).isSecondAlternativeReadOnly());
                this.iCourses.get(idx)[0].setEnabled(false);
                this.iCourses.get(idx)[1].setEnabled(false);
                this.iCourses.get(idx)[1].setHint("");
                this.iCourses.get(idx)[2].setEnabled(false);
                this.iCourses.get(idx)[2].setHint("");
                this.iCourses.get(idx)[0].setWaitListEnabled(false);
                continue;
            }
            this.iCourses.get(idx)[0].setSaved(false);
            this.iCourses.get(idx)[1].setSaved(false);
            this.iCourses.get(idx)[2].setSaved(false);
        }
        while (this.iAlternatives.size() < request.getAlternatives().size()) {
            this.addAlternativeLine();
        }
        for (idx = 0; idx < request.getAlternatives().size(); ++idx) {
            this.iAlternatives.get(idx)[0].setValue(request.getAlternatives().get(idx).getRequestedCourse(), true);
            this.iAlternatives.get(idx)[1].setValue(request.getAlternatives().get(idx).getFirstAlternative(), true);
            this.iAlternatives.get(idx)[2].setValue(request.getAlternatives().get(idx).getSecondAlternative(), true);
            if (request.getAlternatives().get(idx).isReadOnly()) {
                this.iAlternatives.get(idx)[0].setSaved(request.getAlternatives().get(idx).isRequestedCourseReadOnly());
                this.iAlternatives.get(idx)[1].setSaved(request.getAlternatives().get(idx).isFirstAlternativeReadOnly());
                this.iAlternatives.get(idx)[2].setSaved(request.getAlternatives().get(idx).isSecondAlternativeReadOnly());
                this.iAlternatives.get(idx)[0].setEnabled(false);
                this.iAlternatives.get(idx)[1].setEnabled(false);
                this.iAlternatives.get(idx)[1].setHint("");
                this.iAlternatives.get(idx)[2].setEnabled(false);
                this.iAlternatives.get(idx)[2].setHint("");
                continue;
            }
            this.iAlternatives.get(idx)[0].setSaved(false);
            this.iAlternatives.get(idx)[1].setSaved(false);
            this.iAlternatives.get(idx)[2].setSaved(false);
        }
    }

    public Boolean getWaitList(String course) {
        if (this.iCanWaitList) {
            for (CourseSelectionBox[] line : this.iCourses) {
                if (!course.equals(line[0].getValue()) && !course.equals(line[1].getValue()) && !course.equals(line[2].getValue())) continue;
                return line[0].getWaitList();
            }
        }
        return null;
    }

    public void setWaitList(String course, boolean waitList) {
        for (CourseSelectionBox[] line : this.iCourses) {
            if (!course.equals(line[0].getValue()) && !course.equals(line[1].getValue()) && !course.equals(line[2].getValue())) continue;
            line[0].setWaitList(waitList);
        }
    }

    public void clear() {
        int i;
        this.iTip.setText(CONSTANTS.tips()[(int)(Math.random() * (double)CONSTANTS.tips().length)]);
        for (CourseSelectionBox[] c : this.iCourses) {
            for (i = 0; i < 3; ++i) {
                c[i].setValue("");
                c[i].setSaved(false);
                if (i > 0) {
                    c[i].setEnabled(false);
                    c[i].setHint("");
                    continue;
                }
                c[i].setEnabled(true);
            }
            c[0].setWaitList(false);
            c[0].setWaitListEnabled(true);
        }
        for (CourseSelectionBox[] c : this.iAlternatives) {
            for (i = 0; i < 3; ++i) {
                c[i].setValue("");
                c[i].setSaved(false);
                if (i > 0) {
                    c[i].setEnabled(false);
                    c[i].setHint("");
                    continue;
                }
                c[i].setEnabled(true);
            }
        }
    }

    public String getFirstError() {
        int i;
        for (CourseSelectionBox[] c : this.iCourses) {
            for (i = 0; i < 3; ++i) {
                if (c[i].getError() == null) continue;
                return c[i].getError();
            }
        }
        for (CourseSelectionBox[] c : this.iAlternatives) {
            for (i = 0; i < 3; ++i) {
                if (c[i].getError() == null) continue;
                return c[i].getError();
            }
        }
        return null;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<CourseRequestInterface> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public CourseRequestInterface getValue() {
        return this.getRequest();
    }

    public void setValue(CourseRequestInterface value) {
        this.setValue(value, false);
    }

    public void setValue(CourseRequestInterface value, boolean fireEvents) {
        this.setRequest(value);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)value);
        }
    }

    protected void clear(CourseSelectionBox[] c) {
        for (int i = 0; i < 3; ++i) {
            c[i].setValue("");
            c[i].setSaved(false);
            if (i > 0) {
                c[i].setEnabled(false);
                c[i].setHint("");
                continue;
            }
            c[i].setEnabled(true);
        }
        c[0].setWaitList(false);
        c[0].setWaitListEnabled(true);
    }

    protected void clearErrors() {
        int i;
        for (CourseSelectionBox[] c : this.iCourses) {
            for (i = 0; i < 3; ++i) {
                c[i].setError(null);
            }
        }
        for (CourseSelectionBox[] c : this.iAlternatives) {
            for (i = 0; i < 3; ++i) {
                c[i].setError(null);
            }
        }
    }

    public Command addCourse(String text) {
        for (final CourseSelectionBox[] course : this.iCourses) {
            if (!course[0].getValue().isEmpty()) continue;
            this.clear(course);
            course[0].setValue(text, true);
            return new Command(){

                public void execute() {
                    course[0].setValue(null, true);
                    CourseRequestsTable.this.clearErrors();
                }
            };
        }
        this.addCourseLine();
        final CourseSelectionBox[] course = this.iCourses.get(this.iCourses.size() - 1);
        course[0].setValue(text, true);
        return new Command(){

            public void execute() {
                course[0].setValue(null, true);
                CourseRequestsTable.this.clearErrors();
            }
        };
    }

    public boolean hasCourse(String text) {
        for (CourseSelectionBox[] course : this.iCourses) {
            if (!text.equalsIgnoreCase(course[0].getValue()) && !text.equalsIgnoreCase(course[1].getValue()) && !text.equalsIgnoreCase(course[2].getValue())) continue;
            return true;
        }
        for (CourseSelectionBox[] course : this.iAlternatives) {
            if (!text.equalsIgnoreCase(course[0].getValue()) && !text.equalsIgnoreCase(course[1].getValue()) && !text.equalsIgnoreCase(course[2].getValue())) continue;
            return true;
        }
        return false;
    }

    public void dropCourse(String text) {
        for (CourseSelectionBox[] course : this.iCourses) {
            if (!text.equalsIgnoreCase(course[0].getValue()) && !text.equalsIgnoreCase(course[1].getValue()) && !text.equalsIgnoreCase(course[2].getValue())) continue;
            course[0].remove();
            return;
        }
        for (CourseSelectionBox[] course : this.iAlternatives) {
            if (!text.equalsIgnoreCase(course[0].getValue()) && !text.equalsIgnoreCase(course[1].getValue()) && !text.equalsIgnoreCase(course[2].getValue())) continue;
            course[0].remove();
            return;
        }
    }

    public void dropCourse(ClassAssignmentInterface.ClassAssignment assignment) {
        if (assignment.isFreeTime()) {
            String free = assignment.getTimeString(new String[]{"M", "T", "W", "R", "F", "S", "X"}, true, "");
            for (CourseSelectionBox[] course : this.iCourses) {
                try {
                    boolean changed = false;
                    String text = null;
                    if (course[0].getFreeTimes() != null) {
                        for (CourseRequestInterface.FreeTime ft : course[0].getFreeTimes().parseFreeTime(course[0].getValue())) {
                            if (free.equals(ft.toString(new String[]{"M", "T", "W", "R", "F", "S", "X"}, true))) {
                                changed = true;
                                continue;
                            }
                            if (text == null) {
                                text = CONSTANTS.freePrefix() + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                                continue;
                            }
                            text = text + ", " + ft.toString(CONSTANTS.shortDays(), CONSTANTS.useAmPm());
                        }
                    }
                    if (!changed) continue;
                    if (text == null) {
                        course[0].remove();
                    } else {
                        course[0].setValue(text, true);
                    }
                    return;
                }
                catch (Exception e) {
                }
            }
        } else {
            for (CourseSelectionBox[] course : this.iCourses) {
                if (!assignment.equalsIgnoreCase(course[0].getValue()) && !assignment.equalsIgnoreCase(course[1].getValue()) && !assignment.equalsIgnoreCase(course[2].getValue())) continue;
                course[0].remove();
                return;
            }
            for (CourseSelectionBox[] course : this.iAlternatives) {
                if (!assignment.equalsIgnoreCase(course[0].getValue()) && !assignment.equalsIgnoreCase(course[1].getValue()) && !assignment.equalsIgnoreCase(course[2].getValue())) continue;
                course[0].remove();
                return;
            }
        }
    }
}

