/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.reservations;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.unitime.timetable.gwt.client.Client;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.page.UniTimeNotifications;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.reservations.ReservationEdit;
import org.unitime.timetable.gwt.client.reservations.ReservationFilterBox;
import org.unitime.timetable.gwt.client.reservations.ReservationTable;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.GwtResources;
import org.unitime.timetable.gwt.services.ReservationService;
import org.unitime.timetable.gwt.services.ReservationServiceAsync;
import org.unitime.timetable.gwt.shared.ReservationInterface;

public class ReservationsPage
extends Composite {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static final GwtResources RESOURCES = (GwtResources)GWT.create(GwtResources.class);
    protected static final GwtConstants CONSTANTS = (GwtConstants)GWT.create(GwtConstants.class);
    private final ReservationServiceAsync iReservationService = (ReservationServiceAsync)GWT.create(ReservationService.class);
    private ReservationFilterBox iFilter = null;
    private Button iSearch = null;
    private Button iNew = null;
    private Button iPrint = null;
    private ReservationTable iReservationTable = null;
    private VerticalPanel iReservationPanel = null;
    private SimplePanel iPanel = new SimplePanel();
    private HorizontalPanel iFilterPanel = null;
    private ReservationEdit iReservationEdit = null;
    private Long iLastReservationId = null;

    public ReservationsPage() {
        this.iPanel.setWidth("100%");
        this.iReservationPanel = new VerticalPanel();
        this.iFilterPanel = new HorizontalPanel();
        this.iFilterPanel.setSpacing(3);
        Label filterLabel = new Label(MESSAGES.propFilter());
        this.iFilterPanel.add((Widget)filterLabel);
        this.iFilterPanel.setCellVerticalAlignment((Widget)filterLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        this.iFilter = new ReservationFilterBox();
        this.iFilterPanel.add((Widget)this.iFilter);
        this.iSearch = new Button(MESSAGES.buttonSearch());
        this.iSearch.setAccessKey('s');
        this.iSearch.addStyleName("unitime-NoPrint");
        this.iFilterPanel.add((Widget)this.iSearch);
        this.iPrint = new Button(MESSAGES.buttonPrint());
        this.iPrint.setAccessKey('p');
        this.iPrint.addStyleName("unitime-NoPrint");
        this.iFilterPanel.add((Widget)this.iPrint);
        this.iNew = new Button(MESSAGES.buttonAddNew());
        this.iNew.setAccessKey('a');
        this.iNew.setEnabled(false);
        this.iNew.addStyleName("unitime-NoPrint");
        this.iFilterPanel.add((Widget)this.iNew);
        this.iReservationService.canAddReservation(new AsyncCallback<Boolean>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Boolean result) {
                ReservationsPage.this.iNew.setEnabled(result.booleanValue());
            }
        });
        this.iReservationPanel.add((Widget)this.iFilterPanel);
        this.iReservationPanel.setCellHorizontalAlignment((Widget)this.iFilterPanel, HasHorizontalAlignment.ALIGN_CENTER);
        this.iReservationTable = new ReservationTable(true, false);
        this.iReservationTable.getElement().getStyle().setMarginTop(10.0, Style.Unit.PX);
        this.iReservationPanel.add((Widget)this.iReservationTable);
        this.iReservationPanel.setWidth("100%");
        this.iPanel.setWidget((Widget)this.iReservationPanel);
        this.iReservationEdit = new ReservationEdit(false);
        this.initWidget((Widget)this.iPanel);
        this.iSearch.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ReservationsPage.this.loadReservations();
            }
        });
        this.iPrint.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                Window.print();
            }
        });
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                ReservationsPage.this.iFilter.setFocus(true);
            }
        });
        if (Window.Location.getParameter((String)"q") != null) {
            this.iFilter.setValue(Window.Location.getParameter((String)"q"), true);
            this.loadReservations();
        } else {
            this.iReservationService.lastReservationFilter(new AsyncCallback<String>(){

                public void onSuccess(String result) {
                    if (ReservationsPage.this.iFilter.getValue().isEmpty()) {
                        ReservationsPage.this.iFilter.setValue(result, true);
                        if (CONSTANTS.searchWhenPageIsLoaded()) {
                            ReservationsPage.this.loadReservations();
                        }
                    }
                }

                public void onFailure(Throwable caught) {
                    ToolBox.checkAccess(caught);
                }
            });
        }
        History.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<String>(){

            public void onValueChange(ValueChangeEvent<String> event) {
                if (event.getValue() != null && !((String)event.getValue()).isEmpty()) {
                    ReservationsPage.this.iFilter.setValue(((String)event.getValue()).replace("%20", " "), true);
                    ReservationsPage.this.loadReservations();
                }
            }
        });
        this.iReservationTable.addReservationClickHandler(new ReservationTable.ReservationClickHandler(){

            public void onClick(ReservationTable.ReservationClickedEvent evt) {
                ReservationsPage.this.iReservationEdit.setReservation(evt.getReservation());
                ReservationsPage.this.iPanel.setWidget((Widget)ReservationsPage.this.iReservationEdit);
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                ReservationsPage.this.iLastReservationId = evt.getReservation().getId();
            }
        });
        this.iNew.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageAddReservation());
                ReservationsPage.this.iPanel.setWidget((Widget)ReservationsPage.this.iReservationEdit);
                ReservationsPage.this.iReservationEdit.setReservation(null);
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                ReservationsPage.this.iLastReservationId = null;
            }
        });
        this.iReservationEdit.addEditFinishedHandler(new ReservationEdit.EditFinishedHandler(){

            public void onSave(ReservationEdit.EditFinishedEvent evt) {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageReservations());
                ReservationsPage.this.iPanel.setWidget((Widget)ReservationsPage.this.iReservationPanel);
                ReservationsPage.this.loadReservations();
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                ReservationsPage.this.iLastReservationId = evt.getReservationId();
            }

            public void onDelete(ReservationEdit.EditFinishedEvent evt) {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageReservations());
                ReservationsPage.this.iPanel.setWidget((Widget)ReservationsPage.this.iReservationPanel);
                ReservationsPage.this.loadReservations();
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                ReservationsPage.this.iLastReservationId = evt.getReservationId();
            }

            public void onBack(ReservationEdit.EditFinishedEvent evt) {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageReservations());
                ReservationsPage.this.iPanel.setWidget((Widget)ReservationsPage.this.iReservationPanel);
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                ReservationsPage.this.iLastReservationId = evt.getReservationId();
                ReservationsPage.this.iReservationTable.select(ReservationsPage.this.iLastReservationId);
            }

            public void onFailure(Throwable caught) {
                UniTimePageLabel.getInstance().setPageName(MESSAGES.pageReservations());
                ReservationsPage.this.iPanel.setWidget((Widget)ReservationsPage.this.iReservationPanel);
                Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
            }

            public boolean hasNext(ReservationEdit.EditFinishedEvent evt) {
                return ReservationsPage.this.iReservationTable.getNext(evt.getReservationId()) != null;
            }

            public boolean hasPrevious(ReservationEdit.EditFinishedEvent evt) {
                return ReservationsPage.this.iReservationTable.getPrevious(evt.getReservationId()) != null;
            }

            public void onNext(ReservationEdit.EditFinishedEvent evt) {
                ReservationInterface reservation = ReservationsPage.this.iReservationTable.getNext(evt.getReservationId());
                if (reservation == null) {
                    this.onSave(evt);
                } else {
                    ReservationsPage.this.iReservationEdit.setReservation(reservation);
                    ReservationsPage.this.iPanel.setWidget((Widget)ReservationsPage.this.iReservationEdit);
                    Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                    ReservationsPage.this.iLastReservationId = reservation.getId();
                }
            }

            public void onPrevious(ReservationEdit.EditFinishedEvent evt) {
                ReservationInterface reservation = ReservationsPage.this.iReservationTable.getPrevious(evt.getReservationId());
                if (reservation == null) {
                    this.onSave(evt);
                } else {
                    ReservationsPage.this.iReservationEdit.setReservation(reservation);
                    ReservationsPage.this.iPanel.setWidget((Widget)ReservationsPage.this.iReservationEdit);
                    Client.fireGwtPageChanged(new Client.GwtPageChangeEvent());
                    ReservationsPage.this.iLastReservationId = reservation.getId();
                }
            }
        });
    }

    private void loadReservations() {
        if (!this.iSearch.isEnabled()) {
            return;
        }
        this.iSearch.setEnabled(false);
        this.iPrint.setEnabled(false);
        final boolean newEnabled = this.iNew.isEnabled();
        if (newEnabled) {
            this.iNew.setEnabled(false);
        }
        History.newItem((String)this.iFilter.getValue(), (boolean)false);
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingReservations());
        this.iReservationTable.query((ReservationInterface.ReservationFilterRpcRequest)this.iFilter.getElementsRequest(), new AsyncCallback<List<ReservationInterface>>(){

            public void onSuccess(List<ReservationInterface> result) {
                LoadingWidget.getInstance().hide();
                ReservationsPage.this.iSearch.setEnabled(true);
                ReservationsPage.this.iPrint.setEnabled(true);
                if (newEnabled) {
                    ReservationsPage.this.iNew.setEnabled(true);
                }
                if (ReservationsPage.this.iLastReservationId != null) {
                    ReservationsPage.this.iReservationTable.select(ReservationsPage.this.iLastReservationId);
                    ReservationsPage.this.iReservationTable.scrollIntoView(ReservationsPage.this.iLastReservationId);
                }
            }

            public void onFailure(Throwable caught) {
                LoadingWidget.getInstance().hide();
                ReservationsPage.this.iReservationTable.setErrorMessage(MESSAGES.failedToLoadReservations(caught.getMessage()));
                UniTimeNotifications.error(MESSAGES.failedToLoadReservations(caught.getMessage()), caught);
                ToolBox.checkAccess(caught);
            }
        });
    }
}

