/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.util.ComboBoxLookup;

public class ExamsForm
extends ActionForm {
    private static final long serialVersionUID = 8434268097497866325L;
    private String iOp = null;
    private Long iSession = null;
    private String iSubjectArea = null;
    private Collection iSubjectAreas = null;
    private Vector iSessions = null;
    private String iTable = null;
    private int iNrColumns;
    private int iNrRows;
    private Long iExamType;
    private String iMessage;
    private Boolean canRetrieveAllExamForAllSubjects;
    private String iUser;
    private String iPassword;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iOp = null;
        this.iTable = null;
        this.iNrColumns = 0;
        this.iNrRows = 0;
        this.iExamType = null;
        this.iSession = null;
        this.iUser = null;
        this.iPassword = null;
        this.iMessage = null;
        this.canRetrieveAllExamForAllSubjects = new Boolean(false);
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public String getSubjectArea() {
        return this.iSubjectArea;
    }

    public void setSubjectArea(String subjectArea) {
        this.iSubjectArea = subjectArea;
    }

    public Collection getSubjectAreas() {
        return this.iSubjectAreas;
    }

    public Long getSession() {
        return this.iSession;
    }

    public void setSession(Long session) {
        this.iSession = session;
    }

    public Collection getSessions() {
        return this.iSessions;
    }

    public Boolean canDisplayAllSubjectsAtOnce() {
        Boolean displayAll = new Boolean(false);
        if (this.iSession != null) {
            String queryStr = "select count(e) from Exam e where e.session.uniqueId = :sessionId";
            int count = ((Number)SessionDAO.getInstance().getQuery(queryStr).setLong("sessionId", this.iSession.longValue()).setCacheable(true).uniqueResult()).intValue();
            if (count <= 300) {
                displayAll = new Boolean(true);
            }
        }
        return displayAll;
    }

    public void load(HttpSession session) {
        this.setSubjectArea(session.getAttribute("Exams.subjectArea") == null ? null : (String)session.getAttribute("Exams.subjectArea"));
        this.iSessions = new Vector();
        this.setSession((Long)(session.getAttribute("Exams.session") == null ? (this.iSessions.isEmpty() ? null : Long.valueOf(((ComboBoxLookup)this.iSessions.lastElement()).getValue())) : (Long)session.getAttribute("Exams.session")));
        boolean hasSession = false;
        for (Session s : Session.getAllSessions()) {
            if (s.getStatusType() == null || !s.canNoRoleReportExamFinal() && !s.canNoRoleReportExamMidterm() || !Exam.hasTimetable(s.getUniqueId())) continue;
            if (s.getUniqueId().equals(this.getSession())) {
                hasSession = true;
            }
            this.iSessions.add(new ComboBoxLookup(s.getLabel(), s.getUniqueId().toString()));
        }
        if (!hasSession) {
            this.setSession(null);
            this.setSubjectArea(null);
        }
        if (this.getSession() == null && !this.iSessions.isEmpty()) {
            this.setSession(Long.valueOf(((ComboBoxLookup)this.iSessions.lastElement()).getValue()));
        }
        this.iSubjectAreas = new TreeSet(new SubjectAreaDAO().getSession().createQuery("select distinct sa.subjectAreaAbbreviation from SubjectArea sa").setCacheable(true).list());
        this.setExamType(session.getAttribute("Exams.examType") == null ? this.iExamType : (Long)session.getAttribute("Exams.examType"));
        this.setCanRetrieveAllExamForAllSubjects(this.canDisplayAllSubjectsAtOnce());
    }

    public void save(HttpSession session) {
        if (this.getSubjectArea() == null) {
            session.removeAttribute("Exams.subjectArea");
        } else {
            session.setAttribute("Exams.subjectArea", (Object)this.getSubjectArea());
        }
        session.setAttribute("Exams.examType", (Object)this.getExamType());
        if (this.getSession() == null) {
            session.removeAttribute("Exams.session");
        } else {
            session.setAttribute("Exams.session", (Object)this.getSession());
        }
    }

    public void setTable(String table, int cols, int rows) {
        this.iTable = table;
        this.iNrColumns = cols;
        this.iNrRows = rows;
    }

    public String getTable() {
        return this.iTable;
    }

    public int getNrRows() {
        return this.iNrRows;
    }

    public int getNrColumns() {
        return this.iNrColumns;
    }

    public Long getExamType() {
        return this.iExamType;
    }

    public void setExamType(Long type) {
        this.iExamType = type;
    }

    public String getUsername() {
        return this.iUser;
    }

    public void setUsername(String user) {
        this.iUser = user;
    }

    public String getPassword() {
        return this.iPassword;
    }

    public void setPassword(String password) {
        this.iPassword = password;
    }

    public String getMessage() {
        return this.iMessage;
    }

    public void setMessage(String message) {
        this.iMessage = message;
    }

    public String getExamTypeLabel() {
        ExamType type = this.iExamType == null ? null : (ExamType)ExamTypeDAO.getInstance().get(this.iExamType);
        return type == null ? "" : type.getLabel();
    }

    public boolean isFinals() {
        ExamType type = this.iExamType == null ? null : (ExamType)ExamTypeDAO.getInstance().get(this.iExamType);
        return type == null || type.getType() == 0;
    }

    public String getSessionLabel() {
        if (this.iSessions == null) {
            return "";
        }
        Enumeration e = this.iSessions.elements();
        while (e.hasMoreElements()) {
            ComboBoxLookup s = (ComboBoxLookup)e.nextElement();
            if (!Long.valueOf(s.getValue()).equals(this.getSession())) continue;
            return s.getLabel();
        }
        return "";
    }

    public Boolean getCanRetrieveAllExamForAllSubjects() {
        return this.canRetrieveAllExamForAllSubjects;
    }

    public void setCanRetrieveAllExamForAllSubjects(Boolean canRetrieveAllExamForAllSubjects) {
        this.canRetrieveAllExamForAllSubjects = canRetrieveAllExamForAllSubjects;
    }
}

