/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.commons.Debug;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.util.ReferenceList;

public class DepartmentEditForm
extends ActionForm {
    private static final long serialVersionUID = -6614766002463228171L;
    public Long iId = null;
    public Long iSessionId = null;
    public String iName = null;
    public String iDeptCode = null;
    public String iStatusType = null;
    public String iOp = null;
    public String iAbbv = null;
    public String iExternalId = null;
    public int iDistPrefPriority = 0;
    public boolean iIsExternal = false;
    public String iExtAbbv = null;
    public String iExtName = null;
    public boolean iAllowReqTime = false;
    public boolean iAllowReqRoom = false;
    public boolean iAllowReqDist = false;
    public boolean iAllowEvents = false;
    public boolean iInheritInstructorPreferences = false;
    public boolean iAllowStudentScheduling = false;

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.iName == null || this.iName.trim().equalsIgnoreCase("")) {
            errors.add("name", new ActionMessage("errors.required", (Object)"Name"));
        }
        if (this.iName != null && this.iName.trim().length() > 100) {
            errors.add("name", new ActionMessage("errors.maxlength", (Object)"Name", (Object)"100"));
        }
        if (this.iAbbv == null || this.iAbbv.trim().equalsIgnoreCase("")) {
            errors.add("abbv", new ActionMessage("errors.required", (Object)"Abbreviation"));
        }
        if (this.iAbbv != null && this.iAbbv.trim().length() > 20) {
            errors.add("abbv", new ActionMessage("errors.maxlength", (Object)"Abbreviation", (Object)"20"));
        }
        if (this.iDeptCode == null || this.iDeptCode.trim().equalsIgnoreCase("")) {
            errors.add("deptCode", new ActionMessage("errors.required", (Object)"Code"));
        }
        if (this.iDeptCode != null && this.iDeptCode.trim().length() > 50) {
            errors.add("deptCode", new ActionMessage("errors.maxlength", (Object)"Code", (Object)"50"));
        }
        if (this.iIsExternal && (this.iExtName == null || this.iExtName.trim().length() == 0)) {
            errors.add("extName", new ActionMessage("errors.required", (Object)"External Manager Name"));
        }
        if (!this.iIsExternal && this.iExtName != null && this.iExtName.trim().length() > 0) {
            errors.add("extName", new ActionMessage("errors.generic", (Object)"External Manager Name should only be used when the department is marked as 'External Manager'"));
        }
        if (this.iIsExternal && this.iExtName != null && this.iExtName.trim().length() > 30) {
            errors.add("extName", new ActionMessage("errors.maxlength", (Object)"External Manager Name", (Object)"30"));
        }
        if (this.iIsExternal && (this.iExtAbbv == null || this.iExtAbbv.trim().length() == 0)) {
            errors.add("extAbbv", new ActionMessage("errors.required", (Object)"External Manager Abbreviation"));
        }
        if (!this.iIsExternal && this.iExtAbbv != null && this.iExtAbbv.trim().length() > 0) {
            errors.add("extName", new ActionMessage("errors.generic", (Object)"External Manager Abbreviation should only be used when the department is marked as 'External Manager'"));
        }
        if (this.iIsExternal && this.iExtAbbv != null && this.iExtAbbv.trim().length() > 10) {
            errors.add("extAbbv", new ActionMessage("errors.maxlength", (Object)"External Manager Abbreviation", (Object)"10"));
        }
        try {
            Department dept = Department.findByDeptCode(this.iDeptCode, this.iSessionId);
            if (dept != null && !dept.getUniqueId().equals(this.iId)) {
                errors.add("deptCode", new ActionMessage("errors.exists", (Object)this.iDeptCode));
            }
        }
        catch (Exception e) {
            Debug.error(e);
            errors.add("deptCode", new ActionMessage("errors.generic", (Object)e.getMessage()));
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.iId = null;
        this.iSessionId = null;
        this.iName = null;
        this.iDeptCode = null;
        this.iStatusType = null;
        this.iAbbv = null;
        this.iDistPrefPriority = 0;
        this.iIsExternal = false;
        this.iExtName = null;
        this.iExtAbbv = null;
        this.iAllowReqTime = false;
        this.iAllowReqRoom = false;
        this.iAllowReqDist = false;
        this.iAllowEvents = false;
        this.iInheritInstructorPreferences = false;
        this.iAllowStudentScheduling = false;
    }

    public Long getId() {
        return this.iId;
    }

    public void setId(Long id) {
        this.iId = id;
    }

    public Long getSessionId() {
        return this.iSessionId;
    }

    public void setSessionId(Long sessionId) {
        this.iSessionId = sessionId;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public void setExternalId(String externalId) {
        this.iExternalId = externalId;
    }

    public String getName() {
        return this.iName;
    }

    public void setName(String name) {
        this.iName = name;
    }

    public String getAbbv() {
        return this.iAbbv;
    }

    public void setAbbv(String abbv) {
        this.iAbbv = abbv;
    }

    public int getDistPrefPriority() {
        return this.iDistPrefPriority;
    }

    public void setDistPrefPriority(int distPrefPriority) {
        this.iDistPrefPriority = distPrefPriority;
    }

    public String getDeptCode() {
        return this.iDeptCode;
    }

    public void setDeptCode(String deptCode) {
        this.iDeptCode = deptCode;
    }

    public String getStatusType() {
        return this.iStatusType;
    }

    public void setStatusType(String statusType) {
        this.iStatusType = statusType;
    }

    public String getOp() {
        return this.iOp;
    }

    public void setOp(String op) {
        this.iOp = op;
    }

    public boolean getIsExternal() {
        return this.iIsExternal;
    }

    public void setIsExternal(boolean isExternal) {
        this.iIsExternal = isExternal;
    }

    public boolean getAllowReqTime() {
        return this.iAllowReqTime;
    }

    public void setAllowReqTime(boolean allowReqTime) {
        this.iAllowReqTime = allowReqTime;
    }

    public boolean getAllowReqRoom() {
        return this.iAllowReqRoom;
    }

    public void setAllowReqRoom(boolean allowReqRoom) {
        this.iAllowReqRoom = allowReqRoom;
    }

    public boolean getAllowReqDist() {
        return this.iAllowReqDist;
    }

    public void setAllowReqDist(boolean allowReqDist) {
        this.iAllowReqDist = allowReqDist;
    }

    public boolean getAllowEvents() {
        return this.iAllowEvents;
    }

    public void setAllowEvents(boolean allowEvents) {
        this.iAllowEvents = allowEvents;
    }

    public boolean getInheritInstructorPreferences() {
        return this.iInheritInstructorPreferences;
    }

    public void setInheritInstructorPreferences(boolean inheritInstructorPreferences) {
        this.iInheritInstructorPreferences = inheritInstructorPreferences;
    }

    public String getExtAbbv() {
        return this.iExtAbbv;
    }

    public void setExtAbbv(String extAbbv) {
        this.iExtAbbv = extAbbv;
    }

    public String getExtName() {
        return this.iExtName;
    }

    public void setExtName(String extName) {
        this.iExtName = extName;
    }

    public boolean getAllowStudentScheduling() {
        return this.iAllowStudentScheduling;
    }

    public void setAllowStudentScheduling(boolean allowStudentScheduling) {
        this.iAllowStudentScheduling = allowStudentScheduling;
    }

    public ReferenceList getStatusOptions() {
        ReferenceList ref = new ReferenceList();
        ref.addAll(DepartmentStatusType.findAllForDepartment());
        return ref;
    }

    public void load(Department department) {
        this.setId(department.getUniqueId());
        this.setSessionId(department.getSessionId());
        this.setName(department.getName());
        this.setAbbv(department.getAbbreviation());
        this.setDistPrefPriority(department.getDistributionPrefPriority() == null ? 0 : department.getDistributionPrefPriority());
        this.setDeptCode(department.getDeptCode());
        this.setStatusType(department.getStatusType() == null ? null : department.getStatusType().getReference());
        this.setExternalId(department.getExternalUniqueId());
        this.setIsExternal(department.isExternalManager());
        this.setExtAbbv(department.getExternalMgrAbbv());
        this.setExtName(department.getExternalMgrLabel());
        this.setAllowReqRoom(department.isAllowReqRoom() != null && department.isAllowReqRoom() != false);
        this.setAllowReqTime(department.isAllowReqTime() != null && department.isAllowReqTime() != false);
        this.setAllowReqDist(department.isAllowReqDistribution() != null && department.isAllowReqDistribution() != false);
        this.setAllowEvents(department.isAllowEvents());
        this.setAllowStudentScheduling(department.isAllowStudentScheduling());
        this.setInheritInstructorPreferences(department.isInheritInstructorPreferences());
    }

    public void save(SessionContext context) throws Exception {
        Department department;
        DepartmentDAO dao = new DepartmentDAO();
        org.hibernate.Session session = dao.getSession();
        Session acadSession = null;
        if (this.getId().equals(new Long(0L))) {
            department = new Department();
            acadSession = (Session)SessionDAO.getInstance().get(context.getUser().getCurrentAcademicSessionId());
            department.setSession(acadSession);
            department.setDistributionPrefPriority(new Integer(0));
            acadSession.addTodepartments(department);
        } else {
            department = (Department)dao.get(this.getId(), session);
        }
        if (department != null) {
            department.setStatusType(this.getStatusType() == null || this.getStatusType().length() == 0 ? null : DepartmentStatusType.findByRef(this.getStatusType()));
            department.setName(this.getName());
            department.setDeptCode(this.getDeptCode());
            department.setAbbreviation(this.getAbbv());
            department.setExternalUniqueId(this.getExternalId());
            department.setDistributionPrefPriority(new Integer(this.getDistPrefPriority()));
            department.setExternalManager(new Boolean(this.getIsExternal()));
            department.setExternalMgrLabel(this.getExtName());
            department.setExternalMgrAbbv(this.getExtAbbv());
            department.setAllowReqRoom(new Boolean(this.getAllowReqRoom()));
            department.setAllowReqTime(new Boolean(this.getAllowReqTime()));
            department.setAllowReqDistribution(new Boolean(this.getAllowReqDist()));
            department.setAllowEvents(this.getAllowEvents());
            department.setAllowStudentScheduling(this.getAllowStudentScheduling());
            department.setInheritInstructorPreferences(this.getInheritInstructorPreferences());
            dao.saveOrUpdate(department);
            ChangeLog.addChange(session, context, department, ChangeLog.Source.DEPARTMENT_EDIT, this.getId().equals(new Long(0L)) ? ChangeLog.Operation.CREATE : ChangeLog.Operation.UPDATE, null, department);
            session.flush();
            if (acadSession != null) {
                session.refresh((Object)acadSession);
            }
        }
    }
}

