/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.form;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.util.DynamicList;
import org.unitime.timetable.util.DynamicListObjectFactory;

public class CourseOfferingEditForm
extends ActionForm {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    private static final long serialVersionUID = 5719027599139781262L;
    private String op;
    private boolean add = false;
    private Long subjectAreaId;
    private Long courseOfferingId;
    private Long instrOfferingId;
    private String courseName;
    private String courseNbr;
    private String title;
    private String scheduleBookNote;
    private Long demandCourseOfferingId;
    private boolean allowDemandCourseOfferings;
    private Long consent;
    private String creditFormat;
    private Long creditType;
    private Long creditUnitType;
    private Float units;
    private Float maxUnits;
    private Boolean fractionalIncrementsAllowed;
    private String creditText;
    private Boolean isControl;
    private Boolean ioNotOffered;
    private String catalogLinkLabel;
    private String catalogLinkLocation;
    private Boolean byReservationOnly;
    private List instructors;
    private String wkEnroll;
    private String wkChange;
    private String wkDrop;
    private Integer wkEnrollDefault;
    private Integer wkChangeDefault;
    private Integer wkDropDefault;
    private String weekStartDayOfWeek;
    private String courseTypeId;
    private String externalId;
    protected DynamicListObjectFactory factory = new DynamicListObjectFactory(){

        public Object create() {
            return new String("-");
        }
    };

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        if (this.getCourseNbr() != null && ApplicationProperty.CourseOfferingNumberUpperCase.isTrue()) {
            this.setCourseNbr(this.getCourseNbr().toUpperCase());
        }
        if (this.op.equals(MSG.actionUpdateCourseOffering()) || this.op.equals(MSG.actionSaveCourseOffering())) {
            if (this.subjectAreaId == null || this.subjectAreaId == 0L) {
                errors.add("subjectAreaId", new ActionMessage("errors.generic", (Object)MSG.errorSubjectRequired()));
            } else if (this.courseNbr == null || this.courseNbr.trim().length() == 0) {
                errors.add("courseNbr", new ActionMessage("errors.generic", (Object)MSG.errorCourseNumberRequired()));
            } else {
                String courseNbrRegex = ApplicationProperty.CourseOfferingNumberPattern.value();
                String courseNbrInfo = ApplicationProperty.CourseOfferingNumberPatternInfo.value();
                try {
                    Pattern pattern = Pattern.compile(courseNbrRegex);
                    Matcher matcher = pattern.matcher(this.courseNbr);
                    if (!matcher.find()) {
                        errors.add("courseNbr", new ActionMessage("errors.generic", (Object)courseNbrInfo));
                    }
                }
                catch (Exception e) {
                    errors.add("courseNbr", new ActionMessage("errors.generic", (Object)MSG.errorCourseNumberCannotBeMatched(courseNbrRegex, e.getMessage())));
                }
                if (ApplicationProperty.CourseOfferingNumberMustBeUnique.isTrue()) {
                    SubjectArea sa = (SubjectArea)new SubjectAreaDAO().get(this.subjectAreaId);
                    CourseOffering co = CourseOffering.findBySessionSubjAreaAbbvCourseNbr(sa.getSessionId(), sa.getSubjectAreaAbbreviation(), this.courseNbr);
                    if (this.add && co != null) {
                        errors.add("courseNbr", new ActionMessage("errors.generic", (Object)MSG.errorCourseCannotBeCreated()));
                    } else if (!this.add && co != null && !co.getUniqueId().equals(this.courseOfferingId)) {
                        errors.add("courseNbr", new ActionMessage("errors.generic", (Object)MSG.errorCourseCannotBeRenamed()));
                    }
                }
            }
        }
        return errors;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        this.op = "";
        this.subjectAreaId = null;
        this.courseOfferingId = null;
        this.instrOfferingId = null;
        this.courseName = "";
        this.title = "";
        this.scheduleBookNote = "";
        this.demandCourseOfferingId = null;
        this.consent = null;
        this.creditFormat = null;
        this.creditType = null;
        this.creditUnitType = null;
        this.units = null;
        this.maxUnits = null;
        this.fractionalIncrementsAllowed = new Boolean(false);
        this.creditText = "";
        this.courseNbr = "";
        this.ioNotOffered = null;
        this.catalogLinkLabel = null;
        this.catalogLinkLocation = null;
        this.instructors = DynamicList.getInstance(new ArrayList(), this.factory);
        this.byReservationOnly = false;
        this.wkEnroll = null;
        this.wkChange = null;
        this.wkDrop = null;
        this.wkEnrollDefault = null;
        this.wkChangeDefault = null;
        this.wkDropDefault = null;
        this.weekStartDayOfWeek = null;
        this.courseTypeId = null;
        this.add = false;
        this.externalId = null;
    }

    public boolean isAdd() {
        return this.add;
    }

    public void setAdd(boolean add) {
        this.add = add;
    }

    public Long getCourseOfferingId() {
        return this.courseOfferingId;
    }

    public void setCourseOfferingId(Long courseOfferingId) {
        this.courseOfferingId = courseOfferingId;
    }

    public String getScheduleBookNote() {
        return this.scheduleBookNote;
    }

    public void setScheduleBookNote(String scheduleBookNote) {
        this.scheduleBookNote = scheduleBookNote;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCourseName() {
        return this.courseName;
    }

    public void setCourseName(String courseName) {
        this.courseName = courseName;
    }

    public Long getInstrOfferingId() {
        return this.instrOfferingId;
    }

    public void setInstrOfferingId(Long instrOfferingId) {
        this.instrOfferingId = instrOfferingId;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public Long getSubjectAreaId() {
        return this.subjectAreaId;
    }

    public void setSubjectAreaId(Long subjectAreaId) {
        this.subjectAreaId = subjectAreaId;
    }

    public Long getDemandCourseOfferingId() {
        return this.demandCourseOfferingId;
    }

    public void setDemandCourseOfferingId(Long demandCourseOfferingId) {
        this.demandCourseOfferingId = demandCourseOfferingId;
    }

    public boolean getAllowDemandCourseOfferings() {
        return this.allowDemandCourseOfferings;
    }

    public void setAllowDemandCourseOfferings(boolean allowDemandCourseOfferings) {
        this.allowDemandCourseOfferings = allowDemandCourseOfferings;
    }

    public Long getConsent() {
        return this.consent;
    }

    public void setConsent(Long consent) {
        this.consent = consent;
    }

    public String getCreditFormat() {
        return this.creditFormat;
    }

    public void setCreditFormat(String creditFormat) {
        this.creditFormat = creditFormat;
    }

    public String getCreditText() {
        return this.creditText;
    }

    public void setCreditText(String creditText) {
        this.creditText = creditText;
    }

    public Long getCreditType() {
        return this.creditType;
    }

    public void setCreditType(Long creditType) {
        this.creditType = creditType;
    }

    public Long getCreditUnitType() {
        return this.creditUnitType;
    }

    public void setCreditUnitType(Long creditUnitType) {
        this.creditUnitType = creditUnitType;
    }

    public Boolean getFractionalIncrementsAllowed() {
        return this.fractionalIncrementsAllowed;
    }

    public void setFractionalIncrementsAllowed(Boolean fractionalIncrementsAllowed) {
        this.fractionalIncrementsAllowed = fractionalIncrementsAllowed;
    }

    public Float getMaxUnits() {
        return this.maxUnits;
    }

    public void setMaxUnits(Float maxUnits) {
        this.maxUnits = maxUnits;
    }

    public Float getUnits() {
        return this.units;
    }

    public void setUnits(Float units) {
        this.units = units;
    }

    public String getCourseNbr() {
        return this.courseNbr;
    }

    public void setCourseNbr(String courseNbr) {
        if (ApplicationProperty.CourseOfferingNumberUpperCase.isTrue()) {
            courseNbr = courseNbr.toUpperCase();
        }
        this.courseNbr = courseNbr;
    }

    public Boolean getIsControl() {
        return this.isControl;
    }

    public void setIsControl(Boolean isControl) {
        this.isControl = isControl;
    }

    public Boolean getIoNotOffered() {
        return this.ioNotOffered;
    }

    public void setIoNotOffered(Boolean ioNotOffered) {
        this.ioNotOffered = ioNotOffered;
    }

    public String getCatalogLinkLabel() {
        return this.catalogLinkLabel;
    }

    public void setCatalogLinkLabel(String catalogLinkLabel) {
        this.catalogLinkLabel = catalogLinkLabel;
    }

    public String getCatalogLinkLocation() {
        return this.catalogLinkLocation;
    }

    public void setCatalogLinkLocation(String catalogLinkLocation) {
        this.catalogLinkLocation = catalogLinkLocation;
    }

    public List getInstructors() {
        return this.instructors;
    }

    public String getInstructors(int key) {
        return this.instructors.get(key).toString();
    }

    public void setInstructors(int key, Object value) {
        this.instructors.set(key, value);
    }

    public void setInstructors(List instructors) {
        this.instructors = instructors;
    }

    public boolean isByReservationOnly() {
        return this.byReservationOnly;
    }

    public void setByReservationOnly(boolean byReservationOnly) {
        this.byReservationOnly = byReservationOnly;
    }

    public String getWkEnroll() {
        return this.wkEnroll;
    }

    public void setWkEnroll(String wkEnroll) {
        this.wkEnroll = wkEnroll;
    }

    public Integer getWkEnrollDefault() {
        return this.wkEnrollDefault;
    }

    public void setWkEnrollDefault(Integer wkEnrollDefault) {
        this.wkEnrollDefault = wkEnrollDefault;
    }

    public String getWkChange() {
        return this.wkChange;
    }

    public void setWkChange(String wkChange) {
        this.wkChange = wkChange;
    }

    public Integer getWkChangeDefault() {
        return this.wkChangeDefault;
    }

    public void setWkChangeDefault(Integer wkChangeDefault) {
        this.wkChangeDefault = wkChangeDefault;
    }

    public String getWkDrop() {
        return this.wkDrop;
    }

    public void setWkDrop(String wkDrop) {
        this.wkDrop = wkDrop;
    }

    public Integer getWkDropDefault() {
        return this.wkDropDefault;
    }

    public void setWkDropDefault(Integer wkDropDefault) {
        this.wkDropDefault = wkDropDefault;
    }

    public String getWeekStartDayOfWeek() {
        return this.weekStartDayOfWeek;
    }

    public void setWeekStartDayOfWeek(String weekStartDayOfWeek) {
        this.weekStartDayOfWeek = weekStartDayOfWeek;
    }

    public String getCourseTypeId() {
        return this.courseTypeId;
    }

    public void setCourseTypeId(String courseTypeId) {
        this.courseTypeId = courseTypeId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }
}

