/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.export.ExportServletHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.context.HttpSessionContext;

public class ExportServlet
extends HttpServlet {
    private static Log sLog = LogFactory.getLog(ExportServlet.class);
    private static final long serialVersionUID = 1L;

    protected SessionContext getSessionContext() {
        return HttpSessionContext.getSessionContext(this.getServletContext());
    }

    protected Exporter getExporter(String reference) {
        WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        return (Exporter)applicationContext.getBean("org.unitime.timetable.export.Exporter:" + reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ExportServletHelper helper;
        block16: {
            block17: {
                helper = null;
                String ref = null;
                try {
                    block15: {
                        try {
                            helper = new ExportServletHelper(request, response, this.getSessionContext());
                            ref = helper.getParameter("output");
                            if (ref == null) {
                                sLog.info((Object)"No exporter provided.");
                                response.sendError(400, "No exporter provided, please set the output parameter.");
                                Object var7_5 = null;
                                if (helper == null) return;
                                break block15;
                            }
                            this.getExporter(ref).export(helper);
                            break block16;
                        }
                        catch (NoSuchBeanDefinitionException e) {
                            sLog.info((Object)("Exporter " + ref + " not known."));
                            response.sendError(400, "Exporter " + ref + " not known, please check the output parameter.");
                            Object var7_7 = null;
                            if (helper == null) return;
                            if (helper.hasOutputStream()) {
                                helper.getOutputStream().flush();
                                helper.getOutputStream().close();
                            }
                            if (!helper.hasWriter()) return;
                            helper.getWriter().flush();
                            helper.getWriter().close();
                            return;
                        }
                        catch (IllegalArgumentException e) {
                            sLog.info((Object)e.getMessage());
                            response.sendError(400, e.getMessage());
                            Object var7_8 = null;
                            if (helper == null) return;
                            if (helper.hasOutputStream()) {
                                helper.getOutputStream().flush();
                                helper.getOutputStream().close();
                            }
                            if (!helper.hasWriter()) return;
                            helper.getWriter().flush();
                            helper.getWriter().close();
                            return;
                        }
                        catch (PageAccessException e) {
                            sLog.info((Object)e.getMessage());
                            response.sendError(403, e.getMessage());
                            Object var7_9 = null;
                            if (helper == null) return;
                            if (helper.hasOutputStream()) {
                                helper.getOutputStream().flush();
                                helper.getOutputStream().close();
                            }
                            if (!helper.hasWriter()) return;
                            helper.getWriter().flush();
                            helper.getWriter().close();
                            return;
                        }
                        catch (Exception e) {
                            sLog.warn((Object)e.getMessage(), (Throwable)e);
                            response.sendError(500, e.getMessage());
                            Object var7_10 = null;
                            if (helper == null) return;
                            if (helper.hasOutputStream()) {
                                helper.getOutputStream().flush();
                                helper.getOutputStream().close();
                            }
                            if (!helper.hasWriter()) return;
                            helper.getWriter().flush();
                            helper.getWriter().close();
                            return;
                        }
                    }
                    if (!helper.hasOutputStream()) break block17;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    if (helper == null) throw throwable;
                    if (helper.hasOutputStream()) {
                        helper.getOutputStream().flush();
                        helper.getOutputStream().close();
                    }
                    if (!helper.hasWriter()) throw throwable;
                    helper.getWriter().flush();
                    helper.getWriter().close();
                    throw throwable;
                }
                helper.getOutputStream().flush();
                helper.getOutputStream().close();
            }
            if (!helper.hasWriter()) return;
            helper.getWriter().flush();
            helper.getWriter().close();
            return;
        }
        Object var7_6 = null;
        if (helper == null) return;
        if (helper.hasOutputStream()) {
            helper.getOutputStream().flush();
            helper.getOutputStream().close();
        }
        if (!helper.hasWriter()) return;
        helper.getWriter().flush();
        helper.getWriter().close();
    }
}

