/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.EventLookupBackend;
import org.unitime.timetable.events.QueryEncoderBackend;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.model.EventNote;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RelatedCourseInfo;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SpecialEvent;
import org.unitime.timetable.model.base.BaseClassEvent;
import org.unitime.timetable.model.base.BaseCourseEvent;
import org.unitime.timetable.model.dao.ClassEventDAO;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseEventDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.ExamEventDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.CalendarUtils;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.NameFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtRpcImplements(value=EventInterface.EventDetailRpcRequest.class)
public class EventDetailBackend
extends EventAction<EventInterface.EventDetailRpcRequest, EventInterface> {
    protected static GwtConstants CONSTANTS = Localization.create(GwtConstants.class);

    @Override
    public EventInterface execute(EventInterface.EventDetailRpcRequest request, EventAction.EventContext context) {
        if (request.getEventId() != null && request.getEventId() < 0L) {
            Class_ clazz = (Class_)Class_DAO.getInstance().get(-request.getEventId().longValue());
            if (clazz == null) {
                throw new GwtRpcException("No class with id " + -request.getEventId().longValue() + " found.");
            }
            if (clazz.getEvent() != null) {
                context.checkPermission(clazz.getEvent(), Right.EventDetail);
                return EventDetailBackend.getEventDetail(clazz.getControllingDept().getSession(), clazz.getEvent(), context);
            }
            context.checkPermission(clazz, Right.EventDetailArrangeHourClass);
            return EventDetailBackend.getArrangeHoursClassDetail(clazz, context);
        }
        Event event = (Event)EventDAO.getInstance().get(request.getEventId());
        if (event == null) {
            throw new GwtRpcException("No event with id " + request.getEventId() + " found.");
        }
        context.checkPermission(event, Right.EventDetail);
        return EventDetailBackend.getEventDetail((Session)SessionDAO.getInstance().get(request.getSessionId()), event, context);
    }

    public static EventInterface getEventDetail(Session session, Event e, EventAction.EventContext context) throws GwtRpcException {
        Object location;
        Object time;
        Object assignment;
        EventInterface.ContactInterface instructor;
        Event ce;
        String nameFormat;
        org.hibernate.Session hibSession = EventDAO.getInstance().getSession();
        EventInterface event = new EventInterface();
        event.setId(e.getUniqueId());
        event.setName(e.getEventName());
        event.setType(EventInterface.EventType.values()[e.getEventType()]);
        event.setCanView(context != null && context.hasPermission(e, Right.EventDetail));
        event.setCanEdit(context != null && context.hasPermission(e, Right.EventEdit));
        event.setEmail(e.getEmail());
        event.setExpirationDate(e.getExpirationDate());
        event.setMaxCapacity(e.getMaxCapacity());
        String string = nameFormat = context != null ? context.getUser().getProperty(UserProperty.NameFormat) : NameFormat.LAST_FIRST_MIDDLE.reference();
        if (e.getMainContact() != null) {
            EventInterface.ContactInterface contact = new EventInterface.ContactInterface();
            contact.setFirstName(e.getMainContact().getFirstName());
            contact.setMiddleName(e.getMainContact().getMiddleName());
            contact.setLastName(e.getMainContact().getLastName());
            contact.setAcademicTitle(e.getMainContact().getAcademicTitle());
            contact.setExternalId(e.getMainContact().getExternalUniqueId());
            contact.setPhone(e.getMainContact().getPhone());
            contact.setEmail(e.getMainContact().getEmailAddress());
            contact.setFormattedName(e.getMainContact().getName(nameFormat));
            event.setContact(contact);
        }
        for (EventContact c : e.getAdditionalContacts()) {
            EventInterface.ContactInterface contact = new EventInterface.ContactInterface();
            contact.setFirstName(c.getFirstName());
            contact.setMiddleName(c.getMiddleName());
            contact.setLastName(c.getLastName());
            contact.setAcademicTitle(c.getAcademicTitle());
            contact.setExternalId(c.getExternalUniqueId());
            contact.setPhone(c.getPhone());
            contact.setEmail(c.getEmailAddress());
            contact.setFormattedName(c.getName(nameFormat));
            event.addAdditionalContact(contact);
        }
        if (e.getSponsoringOrganization() != null) {
            EventInterface.SponsoringOrganizationInterface sponsor = new EventInterface.SponsoringOrganizationInterface();
            sponsor.setEmail(e.getSponsoringOrganization().getEmail());
            sponsor.setName(e.getSponsoringOrganization().getName());
            sponsor.setUniqueId(e.getSponsoringOrganization().getUniqueId());
            event.setSponsor(sponsor);
        }
        if (0 == e.getEventType()) {
            ce = e instanceof ClassEvent ? (ClassEvent)e : (ClassEvent)ClassEventDAO.getInstance().get(e.getUniqueId(), hibSession);
            Class_ clazz = ((BaseClassEvent)ce).getClazz();
            event.setEnrollment(clazz.getEnrollment());
            event.setMaxCapacity(clazz.getClassLimit());
            HashSet addedInstructorIds = new HashSet();
            if (clazz.getDisplayInstructor().booleanValue()) {
                for (ClassInstructor i : clazz.getClassInstructors()) {
                    instructor = new EventInterface.ContactInterface();
                    instructor.setFirstName(i.getInstructor().getFirstName());
                    instructor.setMiddleName(i.getInstructor().getMiddleName());
                    instructor.setLastName(i.getInstructor().getLastName());
                    instructor.setAcademicTitle(i.getInstructor().getAcademicTitle());
                    instructor.setEmail(i.getInstructor().getEmail());
                    instructor.setFormattedName(i.getInstructor().getName(nameFormat));
                    event.addInstructor(instructor);
                    addedInstructorIds.add(i.getInstructor().getUniqueId());
                }
            }
            for (DepartmentalInstructor c : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCoordinators()) {
                if (!addedInstructorIds.add(c.getUniqueId())) continue;
                EventInterface.ContactInterface coordinator = new EventInterface.ContactInterface();
                coordinator.setFirstName(c.getFirstName());
                coordinator.setMiddleName(c.getMiddleName());
                coordinator.setLastName(c.getLastName());
                coordinator.setAcademicTitle(c.getAcademicTitle());
                coordinator.setEmail(c.getEmail());
                coordinator.setFormattedName(c.getName(nameFormat));
                event.addCoordinator(coordinator);
            }
            EventInterface.RelatedObjectInterface related = new EventInterface.RelatedObjectInterface();
            related.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Class);
            related.setUniqueId(clazz.getUniqueId());
            related.setName(clazz.getClassLabel(hibSession));
            String note = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getScheduleBookNote();
            if (clazz.getSchedulePrintNote() != null && !clazz.getSchedulePrintNote().isEmpty()) {
                note = (note == null || note.isEmpty() ? "" : note + "\n") + clazz.getSchedulePrintNote();
            }
            related.setNote(note);
            if (context != null && context.hasPermission(clazz, Right.ClassDetail)) {
                related.setDetailPage("classDetail.do?cid=" + clazz.getUniqueId());
            }
            CourseOffering courseOffering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
            related.addCourseName(courseOffering.getCourseName());
            related.addCourseTitle(courseOffering.getTitle() == null ? "" : courseOffering.getTitle());
            related.setSectionNumber(clazz.getSectionNumberString(hibSession));
            if (clazz.getClassSuffix() != null) {
                related.addExternalId(clazz.getClassSuffix());
            }
            related.setInstruction(clazz.getSchedulingSubpart().getItype().getDesc());
            if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
                related.setInstruction(related.getInstruction() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
            }
            related.setInstructionType(clazz.getSchedulingSubpart().getItype().getItype());
            for (CourseOffering co : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
                if (co.isIsControl().booleanValue()) continue;
                related.addCourseName(co.getCourseName());
                related.addCourseTitle(co.getTitle() == null ? "" : co.getTitle());
                if (clazz.getClassSuffix(co) == null) continue;
                related.addExternalId(clazz.getClassSuffix(co));
            }
            if (clazz.getDisplayInstructor().booleanValue()) {
                for (ClassInstructor i : clazz.getClassInstructors()) {
                    EventInterface.ContactInterface contactInterface = new EventInterface.ContactInterface();
                    contactInterface.setFirstName(i.getInstructor().getFirstName());
                    contactInterface.setMiddleName(i.getInstructor().getMiddleName());
                    contactInterface.setLastName(i.getInstructor().getLastName());
                    contactInterface.setAcademicTitle(i.getInstructor().getAcademicTitle());
                    contactInterface.setExternalId(i.getInstructor().getExternalUniqueId());
                    contactInterface.setEmail(i.getInstructor().getEmail());
                    contactInterface.setFormattedName(i.getInstructor().getName(nameFormat));
                    related.addInstructor(contactInterface);
                }
            }
            if ((assignment = clazz.getCommittedAssignment()) != null) {
                time = ((Assignment)assignment).getTimeLocation();
                if (time != null) {
                    related.setTime(time.getDayHeader() + " " + time.getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + time.getEndTimeHeader(CONSTANTS.useAmPm()));
                    related.setDate(time.getDatePatternName());
                }
                for (Location r : ((Assignment)assignment).getRooms()) {
                    location = new EventInterface.ResourceInterface();
                    ((EventInterface.ResourceInterface)location).setType(EventInterface.ResourceType.ROOM);
                    ((EventInterface.ResourceInterface)location).setId(r.getUniqueId());
                    ((EventInterface.ResourceInterface)location).setName(r.getLabel());
                    ((EventInterface.ResourceInterface)location).setSize(r.getCapacity());
                    ((EventInterface.ResourceInterface)location).setRoomType(r.getRoomTypeLabel());
                    ((EventInterface.ResourceInterface)location).setBreakTime(r.getEffectiveBreakTime());
                    ((EventInterface.ResourceInterface)location).setMessage(r.getEventMessage());
                    ((EventInterface.ResourceInterface)location).setIgnoreRoomCheck(r.isIgnoreRoomCheck());
                    related.addLocation((EventInterface.ResourceInterface)location);
                }
            }
            event.addRelatedObject(related);
            event.addCourseName(courseOffering.getCourseName());
            event.addCourseTitle(courseOffering.getTitle() == null ? "" : courseOffering.getTitle());
            event.setInstruction(clazz.getSchedulingSubpart().getItype().getDesc().length() <= 20 ? clazz.getSchedulingSubpart().getItype().getDesc() : clazz.getSchedulingSubpart().getItype().getAbbv());
            if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
                event.setInstruction(event.getInstruction() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
            }
            event.setInstructionType(clazz.getSchedulingSubpart().getItype().getItype());
            event.setSectionNumber(clazz.getSectionNumberString(hibSession));
            if (clazz.getClassSuffix(courseOffering) == null) {
                event.setName(clazz.getClassLabel(courseOffering));
            } else {
                event.addExternalId(clazz.getClassSuffix(courseOffering));
                event.setName(courseOffering.getCourseName() + " " + clazz.getClassSuffix(courseOffering));
            }
            for (CourseOffering courseOffering2 : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
                if (courseOffering2.isIsControl().booleanValue()) continue;
                event.addCourseName(courseOffering2.getCourseName());
                event.addCourseTitle(courseOffering2.getTitle() == null ? "" : courseOffering2.getTitle());
                if (clazz.getClassSuffix(courseOffering2) == null) continue;
                event.addExternalId(clazz.getClassSuffix(courseOffering2));
            }
        } else if (1 == e.getEventType() || 2 == e.getEventType()) {
            ExamEvent xe = e instanceof ExamEvent ? (ExamEvent)e : (ExamEvent)ExamEventDAO.getInstance().get(e.getUniqueId(), hibSession);
            event.setEnrollment(xe.getExam().countStudents());
            event.setMaxCapacity(xe.getExam().getSize());
            HashSet<Long> addedInstructorIds = new HashSet<Long>();
            for (DepartmentalInstructor i : xe.getExam().getInstructors()) {
                EventInterface.ContactInterface instructor3 = new EventInterface.ContactInterface();
                instructor3.setFirstName(i.getFirstName());
                instructor3.setMiddleName(i.getMiddleName());
                instructor3.setLastName(i.getLastName());
                instructor3.setAcademicTitle(i.getAcademicTitle());
                instructor3.setEmail(i.getEmail());
                instructor3.setFormattedName(i.getName(nameFormat));
                event.addInstructor(instructor3);
                addedInstructorIds.add(i.getUniqueId());
            }
            EventInterface.RelatedObjectInterface related = new EventInterface.RelatedObjectInterface();
            related.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Examination);
            related.setUniqueId(xe.getExam().getUniqueId());
            related.setName(xe.getExam().getName() == null ? xe.getExam().generateName() : xe.getExam().getName());
            related.addCourseName(related.getName());
            related.addCourseTitle("");
            related.setInstruction(e.getEventTypeAbbv());
            related.setInstructionType(xe.getExam().getExamType().getType());
            related.setSectionNumber(xe.getExam().getLength().toString());
            if (context != null && context.hasPermission(xe.getExam(), Right.ExaminationDetail)) {
                related.setDetailPage("examDetail.do?examId=" + xe.getExam().getUniqueId());
            }
            if (xe.getExam().getAssignedPeriod() != null) {
                Iterator<Comparable> period = xe.getExam().getAssignedPeriod();
                related.setDate(((ExamPeriod)((Object)period)).getStartDateLabel());
                int printOffset = xe.getExam().getPrintOffset() == null ? 0 : xe.getExam().getPrintOffset();
                related.setTime(((ExamPeriod)((Object)period)).getStartTimeLabel(printOffset) + " - " + ((ExamPeriod)((Object)period)).getEndTimeLabel(xe.getExam().getLength(), printOffset));
            }
            for (Location r : xe.getExam().getAssignedRooms()) {
                EventInterface.ResourceInterface location2 = new EventInterface.ResourceInterface();
                location2.setType(EventInterface.ResourceType.ROOM);
                location2.setId(r.getUniqueId());
                location2.setName(r.getLabel());
                location2.setSize(r.getCapacity());
                location2.setRoomType(r.getRoomTypeLabel());
                location2.setBreakTime(r.getEffectiveBreakTime());
                location2.setMessage(r.getEventMessage());
                location2.setIgnoreRoomCheck(r.isIgnoreRoomCheck());
                related.addLocation(location2);
            }
            for (DepartmentalInstructor i : xe.getExam().getInstructors()) {
                instructor = new EventInterface.ContactInterface();
                instructor.setFirstName(i.getFirstName());
                instructor.setMiddleName(i.getMiddleName());
                instructor.setLastName(i.getLastName());
                instructor.setAcademicTitle(i.getAcademicTitle());
                instructor.setExternalId(i.getExternalUniqueId());
                instructor.setEmail(i.getEmail());
                instructor.setFormattedName(i.getName(nameFormat));
                related.addInstructor(instructor);
            }
            event.addRelatedObject(related);
            for (ExamOwner owner : new TreeSet<ExamOwner>(xe.getExam().getOwners())) {
                related = new EventInterface.RelatedObjectInterface();
                related.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.values()[owner.getOwnerType()]);
                related.setUniqueId(owner.getOwnerId());
                related.setName(owner.getLabel());
                related.addCourseName(owner.getCourse().getCourseName());
                related.addCourseTitle(owner.getCourse().getTitle() == null ? "" : owner.getCourse().getTitle());
                if (owner.getOwnerType() != 3 && context != null && context.hasPermission(owner.getCourse().getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                    related.setDetailPage("instructionalOfferingDetail.do?io=" + owner.getCourse().getInstructionalOffering().getUniqueId());
                }
                if (owner.getOwnerType() == 3) {
                    Class_ clazz = (Class_)owner.getOwnerObject();
                    related.setSectionNumber(clazz.getSectionNumberString(hibSession));
                    if (clazz.getClassSuffix() != null) {
                        related.addExternalId(clazz.getClassSuffix());
                    }
                    related.setInstruction(clazz.getSchedulingSubpart().getItype().getDesc());
                    if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
                        related.setInstruction(related.getInstruction() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                    }
                    related.setInstructionType(clazz.getSchedulingSubpart().getItype().getItype());
                    for (CourseOffering course : owner.getCourse().getInstructionalOffering().getCourseOfferings()) {
                        if (course.isIsControl().booleanValue()) continue;
                        related.addCourseName(course.getCourseName());
                        related.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                        if (clazz.getClassSuffix(course) == null) continue;
                        related.addExternalId(clazz.getClassSuffix(course));
                    }
                    assignment = clazz.getCommittedAssignment();
                    if (assignment != null) {
                        time = ((Assignment)assignment).getTimeLocation();
                        if (time != null) {
                            related.setTime(time.getDayHeader() + " " + time.getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + time.getEndTimeHeader(CONSTANTS.useAmPm()));
                            related.setDate(time.getDatePatternName());
                        }
                        for (Location r : ((Assignment)assignment).getRooms()) {
                            location = new EventInterface.ResourceInterface();
                            ((EventInterface.ResourceInterface)location).setType(EventInterface.ResourceType.ROOM);
                            ((EventInterface.ResourceInterface)location).setId(r.getUniqueId());
                            ((EventInterface.ResourceInterface)location).setName(r.getLabel());
                            ((EventInterface.ResourceInterface)location).setSize(r.getCapacity());
                            ((EventInterface.ResourceInterface)location).setRoomType(r.getRoomTypeLabel());
                            ((EventInterface.ResourceInterface)location).setBreakTime(r.getEffectiveBreakTime());
                            ((EventInterface.ResourceInterface)location).setMessage(r.getEventMessage());
                            ((EventInterface.ResourceInterface)location).setIgnoreRoomCheck(r.isIgnoreRoomCheck());
                            related.addLocation((EventInterface.ResourceInterface)location);
                        }
                    }
                    if (context != null && context.hasPermission(clazz, Right.ClassDetail)) {
                        related.setDetailPage("classDetail.do?cid=" + clazz.getUniqueId());
                    }
                    if (clazz.getDisplayInstructor().booleanValue()) {
                        for (ClassInstructor classInstructor : clazz.getClassInstructors()) {
                            EventInterface.ContactInterface instructor4 = new EventInterface.ContactInterface();
                            instructor4.setFirstName(classInstructor.getInstructor().getFirstName());
                            instructor4.setMiddleName(classInstructor.getInstructor().getMiddleName());
                            instructor4.setLastName(classInstructor.getInstructor().getLastName());
                            instructor4.setAcademicTitle(classInstructor.getInstructor().getAcademicTitle());
                            instructor4.setExternalId(classInstructor.getInstructor().getExternalUniqueId());
                            instructor4.setEmail(classInstructor.getInstructor().getEmail());
                            instructor4.setFormattedName(classInstructor.getInstructor().getName(nameFormat));
                            related.addInstructor(instructor4);
                        }
                    }
                } else if (owner.getOwnerType() == 0) {
                    for (CourseOffering course : owner.getCourse().getInstructionalOffering().getCourseOfferings()) {
                        if (course.isIsControl().booleanValue()) continue;
                        related.addCourseName(course.getCourseName());
                        related.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                    }
                    related.setInstruction(MESSAGES.colOffering());
                } else if (owner.getOwnerType() == 2) {
                    InstrOfferingConfig config = (InstrOfferingConfig)owner.getOwnerObject();
                    related.setSectionNumber(config.getName());
                    related.setInstruction(MESSAGES.colConfig());
                    if (config.getInstructionalMethod() != null) {
                        related.setInstruction(related.getInstruction() + " (" + config.getInstructionalMethod().getLabel() + ")");
                    }
                } else {
                    related.setInstruction(MESSAGES.colCourse());
                }
                event.addRelatedObject(related);
                for (DepartmentalInstructor c : owner.getCourse().getInstructionalOffering().getCoordinators()) {
                    if (!addedInstructorIds.add(c.getUniqueId())) continue;
                    EventInterface.ContactInterface coordinator = new EventInterface.ContactInterface();
                    coordinator.setFirstName(c.getFirstName());
                    coordinator.setMiddleName(c.getMiddleName());
                    coordinator.setLastName(c.getLastName());
                    coordinator.setAcademicTitle(c.getAcademicTitle());
                    coordinator.setEmail(c.getEmail());
                    coordinator.setFormattedName(c.getName(nameFormat));
                    event.addCoordinator(coordinator);
                }
            }
        } else if (3 == e.getEventType()) {
            ce = e instanceof CourseEvent ? (CourseEvent)e : (CourseEvent)CourseEventDAO.getInstance().get(e.getUniqueId(), hibSession);
            event.setRequiredAttendance(((BaseCourseEvent)ce).isReqAttendance());
            int enrl = 0;
            int limit = 0;
            HashSet<Long> addedInstructorIds = new HashSet<Long>();
            for (RelatedCourseInfo owner : new TreeSet<RelatedCourseInfo>(((BaseCourseEvent)ce).getRelatedCourses())) {
                EventInterface.RelatedObjectInterface related = new EventInterface.RelatedObjectInterface();
                related.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.values()[owner.getOwnerType()]);
                related.setUniqueId(owner.getOwnerId());
                related.addCourseName(owner.getCourse().getCourseName());
                related.addCourseTitle(owner.getCourse().getTitle() == null ? "" : owner.getCourse().getTitle());
                related.setName(owner.getLabel());
                related.setSelection(new long[]{owner.getCourse().getSubjectArea().getUniqueId(), owner.getCourse().getUniqueId()});
                if (owner.getOwnerType() != 3 && context != null && context.hasPermission(owner.getCourse().getInstructionalOffering(), Right.InstructionalOfferingDetail)) {
                    related.setDetailPage("instructionalOfferingDetail.do?io=" + owner.getCourse().getInstructionalOffering().getUniqueId());
                }
                if (owner.getOwnerType() == 3) {
                    Class_ clazz = (Class_)owner.getOwnerObject();
                    related.setSelection(new long[]{owner.getCourse().getSubjectArea().getUniqueId(), owner.getCourse().getUniqueId(), clazz.getSchedulingSubpart().getUniqueId(), clazz.getUniqueId()});
                    related.setSectionNumber(clazz.getSectionNumberString(hibSession));
                    if (clazz.getClassSuffix() != null) {
                        related.addExternalId(clazz.getClassSuffix());
                    }
                    related.setInstruction(clazz.getSchedulingSubpart().getItype().getDesc());
                    if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
                        related.setInstruction(related.getInstruction() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                    }
                    related.setInstructionType(clazz.getSchedulingSubpart().getItype().getItype());
                    for (CourseOffering course : owner.getCourse().getInstructionalOffering().getCourseOfferings()) {
                        if (course.isIsControl().booleanValue()) continue;
                        related.addCourseName(course.getCourseName());
                        related.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                        if (clazz.getClassSuffix(course) == null) continue;
                        related.addExternalId(clazz.getClassSuffix(course));
                    }
                    Assignment assignment2 = clazz.getCommittedAssignment();
                    if (assignment2 != null) {
                        TimeLocation time2 = assignment2.getTimeLocation();
                        if (time2 != null) {
                            related.setTime(time2.getDayHeader() + " " + time2.getStartTimeHeader(CONSTANTS.useAmPm()) + " - " + time2.getEndTimeHeader(CONSTANTS.useAmPm()));
                            related.setDate(time2.getDatePatternName());
                        }
                        for (Location r : assignment2.getRooms()) {
                            EventInterface.ResourceInterface location3 = new EventInterface.ResourceInterface();
                            location3.setType(EventInterface.ResourceType.ROOM);
                            location3.setId(r.getUniqueId());
                            location3.setName(r.getLabel());
                            location3.setSize(r.getCapacity());
                            location3.setRoomType(r.getRoomTypeLabel());
                            location3.setBreakTime(r.getEffectiveBreakTime());
                            location3.setMessage(r.getEventMessage());
                            location3.setIgnoreRoomCheck(r.isIgnoreRoomCheck());
                            related.addLocation(location3);
                        }
                    }
                    if (context != null && context.hasPermission(clazz, Right.ClassDetail)) {
                        related.setDetailPage("classDetail.do?cid=" + clazz.getUniqueId());
                    }
                    if (clazz.getDisplayInstructor().booleanValue()) {
                        for (ClassInstructor i : clazz.getClassInstructors()) {
                            EventInterface.ContactInterface instructor5 = new EventInterface.ContactInterface();
                            instructor5.setFirstName(i.getInstructor().getFirstName());
                            instructor5.setMiddleName(i.getInstructor().getMiddleName());
                            instructor5.setLastName(i.getInstructor().getLastName());
                            instructor5.setAcademicTitle(i.getInstructor().getAcademicTitle());
                            instructor5.setExternalId(i.getInstructor().getExternalUniqueId());
                            instructor5.setEmail(i.getInstructor().getEmail());
                            instructor5.setFormattedName(i.getInstructor().getName(nameFormat));
                            related.addInstructor(instructor5);
                        }
                    }
                } else if (owner.getOwnerType() == 0) {
                    for (CourseOffering courseOffering : owner.getCourse().getInstructionalOffering().getCourseOfferings()) {
                        if (courseOffering.isIsControl().booleanValue()) continue;
                        related.addCourseName(courseOffering.getCourseName());
                        related.addCourseTitle(courseOffering.getTitle() == null ? "" : courseOffering.getTitle());
                    }
                    related.setInstruction(MESSAGES.colOffering());
                } else if (owner.getOwnerType() == 2) {
                    InstrOfferingConfig config = (InstrOfferingConfig)owner.getOwnerObject();
                    related.setSelection(new long[]{owner.getCourse().getSubjectArea().getUniqueId(), owner.getCourse().getUniqueId(), config.getUniqueId()});
                    related.setSectionNumber(config.getName());
                    related.setInstruction(MESSAGES.colConfig());
                    if (config.getInstructionalMethod() != null) {
                        related.setInstruction(related.getInstruction() + " (" + config.getInstructionalMethod().getLabel() + ")");
                    }
                } else {
                    related.setInstruction(MESSAGES.colCourse());
                }
                event.addRelatedObject(related);
                enrl += owner.countStudents();
                limit += owner.getLimit();
                for (DepartmentalInstructor departmentalInstructor : owner.getCourse().getInstructionalOffering().getCoordinators()) {
                    if (!addedInstructorIds.add(departmentalInstructor.getUniqueId())) continue;
                    EventInterface.ContactInterface coordinator = new EventInterface.ContactInterface();
                    coordinator.setFirstName(departmentalInstructor.getFirstName());
                    coordinator.setMiddleName(departmentalInstructor.getMiddleName());
                    coordinator.setLastName(departmentalInstructor.getLastName());
                    coordinator.setAcademicTitle(departmentalInstructor.getAcademicTitle());
                    coordinator.setEmail(departmentalInstructor.getEmail());
                    coordinator.setFormattedName(departmentalInstructor.getName(nameFormat));
                    event.addCoordinator(coordinator);
                }
            }
            event.setEnrollment(enrl);
            event.setMaxCapacity(limit);
        }
        HashMap<Long, TreeSet<Meeting>> overlaps = new HashMap<Long, TreeSet<Meeting>>();
        if (e.getUniqueId() != null) {
            for (Object[] o : EventDAO.getInstance().getSession().createQuery("select m.uniqueId, o from Event e inner join e.meetings m, Meeting o where e.uniqueId = :eventId and m.uniqueId != o.uniqueId and o.startPeriod < m.stopPeriod and o.stopPeriod > m.startPeriod and m.approvalStatus <= 1 and o.approvalStatus <= 1 and m.locationPermanentId = o.locationPermanentId and m.meetingDate = o.meetingDate").setLong("eventId", e.getUniqueId().longValue()).list()) {
                Long meetingId = (Long)o[0];
                Meeting overlap = (Meeting)o[1];
                TreeSet<Meeting> overlapsThisMeeting = (TreeSet<Meeting>)overlaps.get(meetingId);
                if (overlapsThisMeeting == null) {
                    overlapsThisMeeting = new TreeSet<Meeting>();
                    overlaps.put(meetingId, overlapsThisMeeting);
                }
                overlapsThisMeeting.add(overlap);
            }
        }
        Hashtable<Long, EventInterface> conflictingEvents = new Hashtable<Long, EventInterface>();
        HashSet<Location> unavailableLocations = new HashSet<Location>();
        for (Meeting m : e.getMeetings()) {
            Object overlapsThisMeeting;
            EventInterface.MeetingInterface meeting = new EventInterface.MeetingInterface();
            meeting.setId(m.getUniqueId());
            meeting.setMeetingDate(m.getMeetingDate());
            meeting.setDayOfWeek(Constants.getDayOfWeek(m.getMeetingDate()));
            meeting.setStartTime(m.getStartTime().getTime());
            meeting.setStopTime(m.getStopTime().getTime());
            meeting.setDayOfYear(CalendarUtils.date2dayOfYear(session.getSessionStartYear(), m.getMeetingDate()));
            meeting.setStartSlot(m.getStartPeriod());
            meeting.setEndSlot(m.getStopPeriod());
            meeting.setStartOffset(m.getStartOffset() == null ? 0 : m.getStartOffset());
            meeting.setEndOffset(m.getStopOffset() == null ? 0 : m.getStopOffset());
            meeting.setPast(context != null && context.isPastOrOutside(m.getStartTime()));
            meeting.setApprovalDate(m.getApprovalDate());
            meeting.setApprovalStatus(m.getApprovalStatus());
            meeting.setCanEdit(context != null && context.hasPermission(m, Right.EventMeetingEdit));
            meeting.setCanInquire(context != null && (context.hasPermission(m, Right.EventMeetingInquire) || m.getEvent().getEventType() == 0 && context.hasPermission(m, Right.EventMeetingInquireClass) || m.getEvent().getEventType() == 1 && context.hasPermission(m, Right.EventMeetingInquireExam) || m.getEvent().getEventType() == 2 && context.hasPermission(m, Right.EventMeetingInquireExam)));
            meeting.setCanApprove(context != null && context.hasPermission(m, Right.EventMeetingApprove));
            meeting.setCanDelete(context != null && context.hasPermission(m, Right.EventMeetingDelete));
            meeting.setCanCancel(context != null && (context.hasPermission(m, Right.EventMeetingCancel) || m.getEvent().getEventType() == 0 && context.hasPermission(m, Right.EventMeetingCancelClass) || m.getEvent().getEventType() == 1 && context.hasPermission(m, Right.EventMeetingCancelExam) || m.getEvent().getEventType() == 2 && context.hasPermission(m, Right.EventMeetingCancelExam)));
            if (m.getLocation() != null) {
                EventInterface.ResourceInterface location4 = new EventInterface.ResourceInterface();
                location4.setType(EventInterface.ResourceType.ROOM);
                location4.setId(m.getLocation().getUniqueId());
                location4.setName(m.getLocation().getLabel());
                location4.setSize(m.getLocation().getCapacity());
                location4.setRoomType(m.getLocation().getRoomTypeLabel());
                location4.setBreakTime(m.getLocation().getEffectiveBreakTime());
                location4.setMessage(m.getLocation().getEventMessage());
                location4.setIgnoreRoomCheck(m.getLocation().isIgnoreRoomCheck());
                meeting.setLocation(location4);
                if ((e instanceof SpecialEvent || e instanceof CourseEvent) && (meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Approved || meeting.getApprovalStatus() == EventInterface.ApprovalStatus.Pending)) {
                    if (m.getLocation().getEventDepartment() != null && m.getLocation().getEventDepartment().isAllowEvents().booleanValue()) {
                        String message = m.getLocation().getEventMessage();
                        if (message != null && !message.isEmpty()) {
                            EventInterface.MeetingConflictInterface meetingConflictInterface = new EventInterface.MeetingConflictInterface();
                            meetingConflictInterface.setName(message);
                            meetingConflictInterface.setType(EventInterface.EventType.Message);
                            meetingConflictInterface.setMeetingDate(meeting.getMeetingDate());
                            meetingConflictInterface.setDayOfYear(meeting.getDayOfYear());
                            meetingConflictInterface.setStartOffset(0);
                            meetingConflictInterface.setEndOffset(0);
                            meetingConflictInterface.setStartSlot(0);
                            meetingConflictInterface.setEndSlot(288);
                            meeting.addConflict(meetingConflictInterface);
                        }
                    } else {
                        EventInterface.MeetingConflictInterface conflict = new EventInterface.MeetingConflictInterface();
                        conflict.setName(MESSAGES.conflictNotEventRoom(location4.getName()));
                        conflict.setType(EventInterface.EventType.Message);
                        conflict.setMeetingDate(meeting.getMeetingDate());
                        conflict.setDayOfYear(meeting.getDayOfYear());
                        conflict.setStartOffset(0);
                        conflict.setEndOffset(0);
                        conflict.setStartSlot(0);
                        conflict.setEndSlot(288);
                        meeting.addConflict(conflict);
                    }
                }
            }
            if ((overlapsThisMeeting = (Set)overlaps.get(m.getUniqueId())) != null && m.getLocation() != null && !m.getLocation().isIgnoreRoomCheck().booleanValue()) {
                Iterator conflict = overlapsThisMeeting.iterator();
                while (conflict.hasNext()) {
                    Meeting meeting2 = (Meeting)conflict.next();
                    EventInterface.MeetingConflictInterface conflict2 = new EventInterface.MeetingConflictInterface();
                    conflict2.setEventId(meeting2.getEvent().getUniqueId());
                    conflict2.setName(meeting2.getEvent().getEventName());
                    conflict2.setType(EventInterface.EventType.values()[meeting2.getEvent().getEventType()]);
                    conflict2.setId(meeting2.getUniqueId());
                    conflict2.setMeetingDate(meeting2.getMeetingDate());
                    conflict2.setDayOfYear(meeting.getDayOfYear());
                    conflict2.setStartSlot(meeting2.getStartPeriod());
                    conflict2.setEndSlot(meeting2.getStopPeriod());
                    conflict2.setStartOffset(meeting2.getStartOffset() == null ? 0 : meeting2.getStartOffset());
                    conflict2.setEndOffset(meeting2.getStopOffset() == null ? 0 : meeting2.getStopOffset());
                    conflict2.setApprovalDate(meeting2.getApprovalDate());
                    conflict2.setApprovalStatus(meeting2.getApprovalStatus());
                    conflict2.setLocation(meeting.getLocation());
                    EventInterface confEvent = (EventInterface)conflictingEvents.get(meeting2.getEvent().getUniqueId());
                    if (confEvent == null) {
                        confEvent = new EventInterface();
                        confEvent.setId(meeting2.getEvent().getUniqueId());
                        confEvent.setName(meeting2.getEvent().getEventName());
                        confEvent.setType(EventInterface.EventType.values()[meeting2.getEvent().getEventType()]);
                        conflictingEvents.put(meeting2.getEvent().getUniqueId(), confEvent);
                        confEvent.setCanView(context != null && context.hasPermission(meeting2.getEvent(), Right.EventDetail));
                        confEvent.setMaxCapacity(meeting2.getEvent().getMaxCapacity());
                        if (meeting2.getEvent().getMainContact() != null) {
                            EventInterface.ContactInterface contact = new EventInterface.ContactInterface();
                            contact.setFirstName(meeting2.getEvent().getMainContact().getFirstName());
                            contact.setMiddleName(meeting2.getEvent().getMainContact().getMiddleName());
                            contact.setLastName(meeting2.getEvent().getMainContact().getLastName());
                            contact.setAcademicTitle(meeting2.getEvent().getMainContact().getAcademicTitle());
                            contact.setFormattedName(meeting2.getEvent().getMainContact().getName(nameFormat));
                            confEvent.setContact(contact);
                        }
                        if (meeting2.getEvent().getSponsoringOrganization() != null) {
                            EventInterface.SponsoringOrganizationInterface sponsor = new EventInterface.SponsoringOrganizationInterface();
                            sponsor.setEmail(meeting2.getEvent().getSponsoringOrganization().getEmail());
                            sponsor.setName(meeting2.getEvent().getSponsoringOrganization().getName());
                            sponsor.setUniqueId(meeting2.getEvent().getSponsoringOrganization().getUniqueId());
                            confEvent.setSponsor(sponsor);
                        }
                        if (0 == meeting2.getEvent().getEventType()) {
                            ClassEvent ce2 = (ClassEvent)ClassEventDAO.getInstance().get(meeting2.getEvent().getUniqueId(), hibSession);
                            Class_ clazz = ce2.getClazz();
                            confEvent.setEnrollment(clazz.getEnrollment());
                            confEvent.setMaxCapacity(clazz.getClassLimit());
                            if (clazz.getDisplayInstructor().booleanValue()) {
                                for (ClassInstructor i : clazz.getClassInstructors()) {
                                    EventInterface.ContactInterface instructor6 = new EventInterface.ContactInterface();
                                    instructor6.setFirstName(i.getInstructor().getFirstName());
                                    instructor6.setMiddleName(i.getInstructor().getMiddleName());
                                    instructor6.setLastName(i.getInstructor().getLastName());
                                    instructor6.setAcademicTitle(i.getInstructor().getAcademicTitle());
                                    instructor6.setEmail(i.getInstructor().getEmail());
                                    instructor6.setFormattedName(i.getInstructor().getName(nameFormat));
                                    confEvent.addInstructor(instructor6);
                                }
                            }
                            CourseOffering correctedOffering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
                            ArrayList<CourseOffering> courses = new ArrayList<CourseOffering>(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings());
                            confEvent.addCourseName(correctedOffering.getCourseName());
                            confEvent.addCourseTitle(correctedOffering.getTitle() == null ? "" : correctedOffering.getTitle());
                            confEvent.setInstruction(clazz.getSchedulingSubpart().getItype().getDesc().length() <= 20 ? clazz.getSchedulingSubpart().getItype().getDesc() : clazz.getSchedulingSubpart().getItype().getAbbv());
                            if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
                                event.setInstruction(event.getInstruction() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
                            }
                            confEvent.setInstructionType(clazz.getSchedulingSubpart().getItype().getItype());
                            confEvent.setSectionNumber(clazz.getSectionNumberString(hibSession));
                            if (clazz.getClassSuffix(correctedOffering) == null) {
                                confEvent.setName(clazz.getClassLabel(correctedOffering));
                            } else {
                                confEvent.addExternalId(clazz.getClassSuffix(correctedOffering));
                                confEvent.setName(correctedOffering.getCourseName() + " " + clazz.getClassSuffix(correctedOffering));
                            }
                            for (CourseOffering co : courses) {
                                confEvent.addCourseName(co.getCourseName());
                                confEvent.addCourseTitle(co.getTitle() == null ? "" : co.getTitle());
                                if (clazz.getClassSuffix(co) == null) continue;
                                confEvent.addExternalId(clazz.getClassSuffix(co));
                            }
                        } else if (1 == meeting2.getEvent().getEventType() || 2 == meeting2.getEvent().getEventType()) {
                            ExamEvent xe = (ExamEvent)ExamEventDAO.getInstance().get(meeting2.getEvent().getUniqueId(), hibSession);
                            confEvent.setEnrollment(xe.getExam().countStudents());
                            confEvent.setMaxCapacity(xe.getExam().getSize());
                            for (DepartmentalInstructor i : xe.getExam().getInstructors()) {
                                EventInterface.ContactInterface instructor7 = new EventInterface.ContactInterface();
                                instructor7.setFirstName(i.getFirstName());
                                instructor7.setMiddleName(i.getMiddleName());
                                instructor7.setLastName(i.getLastName());
                                instructor7.setAcademicTitle(i.getAcademicTitle());
                                instructor7.setEmail(i.getEmail());
                                instructor7.setFormattedName(i.getName(nameFormat));
                                confEvent.addInstructor(instructor7);
                            }
                            for (ExamOwner owner : new TreeSet<ExamOwner>(xe.getExam().getOwners())) {
                                for (CourseOffering course : owner.getCourse().getInstructionalOffering().getCourseOfferings()) {
                                    String courseName = owner.getCourse().getCourseName();
                                    String label = owner.getLabel();
                                    if (label.startsWith(courseName)) {
                                        label = label.substring(courseName.length());
                                    }
                                    confEvent.addCourseName(course.getCourseName());
                                    confEvent.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                                    confEvent.addExternalId(label.trim());
                                }
                            }
                        } else if (3 == meeting2.getEvent().getEventType()) {
                            CourseEvent ce2 = (CourseEvent)CourseEventDAO.getInstance().get(meeting2.getEvent().getUniqueId(), hibSession);
                            confEvent.setRequiredAttendance(ce2.isReqAttendance());
                            int enrl = 0;
                            int limit = 0;
                            for (RelatedCourseInfo owner : ce2.getRelatedCourses()) {
                                enrl += owner.countStudents();
                                limit += owner.getLimit();
                                for (CourseOffering course : owner.getCourse().getInstructionalOffering().getCourseOfferings()) {
                                    String courseName = owner.getCourse().getCourseName();
                                    String label = owner.getLabel();
                                    if (label.startsWith(courseName)) {
                                        label = label.substring(courseName.length());
                                    }
                                    confEvent.addCourseName(course.getCourseName());
                                    confEvent.addCourseTitle(course.getTitle() == null ? "" : course.getTitle());
                                    confEvent.addExternalId(label.trim());
                                }
                            }
                            confEvent.setEnrollment(enrl);
                            confEvent.setMaxCapacity(limit);
                        }
                    }
                    confEvent.addMeeting(conflict2);
                    meeting.addConflict(conflict2);
                }
            }
            if (m.getLocation() != null && m.getLocation().getEventAvailability() != null && m.getLocation().getEventAvailability().length() == 288 * Constants.DAY_CODES.length) {
                for (int slot = meeting.getStartSlot(); slot < meeting.getEndSlot(); ++slot) {
                    if (m.getLocation().getEventAvailability().charAt(meeting.getDayOfWeek() * 288 + slot) != '1') continue;
                    unavailableLocations.add(m.getLocation());
                    break;
                }
            }
            event.addMeeting(meeting);
        }
        for (EventInterface confEvent : conflictingEvents.values()) {
            event.addConflict(confEvent);
        }
        for (Location location5 : unavailableLocations) {
            TreeSet<EventInterface.MeetingInterface> unavailabilities = EventLookupBackend.generateUnavailabilityMeetings(location5, true);
            if (unavailabilities == null || unavailabilities.isEmpty()) continue;
            for (EventInterface.MeetingInterface meeting : event.getMeetings()) {
                for (EventInterface.MeetingInterface conf : unavailabilities) {
                    if (!meeting.inConflict(conf)) continue;
                    meeting.addConflict((EventInterface.MeetingConflictInterface)conf);
                }
            }
            EventInterface unavailability = new EventInterface();
            unavailability.setId(-location5.getUniqueId().longValue());
            unavailability.setName(MESSAGES.unavailableEventDefaultName());
            unavailability.setType(EventInterface.EventType.Unavailabile);
            for (EventInterface.MeetingInterface meetingInterface : unavailabilities) {
                if (!event.inConflict(meetingInterface)) continue;
                unavailability.addMeeting(meetingInterface);
            }
            event.addConflict(unavailability);
        }
        for (EventNote n : e.getNotes()) {
            EventInterface.NoteInterface note = new EventInterface.NoteInterface();
            note.setId(n.getUniqueId());
            note.setDate(n.getTimeStamp());
            note.setType(EventInterface.NoteInterface.NoteType.values()[n.getNoteType()]);
            note.setMeetings(n.getMeetingsHtml());
            note.setNote(n.getTextNote() == null ? null : n.getTextNote().replace("\n", "<br>"));
            note.setUser(n.getUser());
            note.setAttachment(n.getAttachedName());
            note.setLink(n.getAttachedName() == null ? null : QueryEncoderBackend.encode("event=" + e.getUniqueId() + "&note=" + n.getUniqueId()));
            event.addNote(note);
        }
        return event;
    }

    public static EventInterface getArrangeHoursClassDetail(Class_ clazz, EventAction.EventContext context) throws GwtRpcException {
        org.hibernate.Session hibSession = EventDAO.getInstance().getSession();
        EventInterface event = new EventInterface();
        event.setId(-clazz.getUniqueId().longValue());
        event.setName(clazz.getClassLabel(hibSession));
        event.setType(EventInterface.EventType.Class);
        event.setCanView(true);
        event.setMaxCapacity(clazz.getClassLimit());
        event.setEnrollment(clazz.getEnrollment());
        String nameFormat = context != null ? context.getUser().getProperty(UserProperty.NameFormat) : NameFormat.LAST_FIRST_MIDDLE.reference();
        HashSet<Long> addedInstructorIds = new HashSet<Long>();
        if (clazz.getDisplayInstructor().booleanValue()) {
            for (ClassInstructor i : clazz.getClassInstructors()) {
                EventInterface.ContactInterface instructor = new EventInterface.ContactInterface();
                instructor.setFirstName(i.getInstructor().getFirstName());
                instructor.setMiddleName(i.getInstructor().getMiddleName());
                instructor.setLastName(i.getInstructor().getLastName());
                instructor.setAcademicTitle(i.getInstructor().getAcademicTitle());
                instructor.setEmail(i.getInstructor().getEmail());
                instructor.setFormattedName(i.getInstructor().getName(nameFormat));
                event.addInstructor(instructor);
                addedInstructorIds.add(i.getInstructor().getUniqueId());
            }
        }
        for (DepartmentalInstructor c : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCoordinators()) {
            if (!addedInstructorIds.add(c.getUniqueId())) continue;
            EventInterface.ContactInterface coordinator = new EventInterface.ContactInterface();
            coordinator.setFirstName(c.getFirstName());
            coordinator.setMiddleName(c.getMiddleName());
            coordinator.setLastName(c.getLastName());
            coordinator.setAcademicTitle(c.getAcademicTitle());
            coordinator.setEmail(c.getEmail());
            coordinator.setFormattedName(c.getName(nameFormat));
            event.addCoordinator(coordinator);
        }
        CourseOffering correctedOffering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
        ArrayList<CourseOffering> courses = new ArrayList<CourseOffering>(clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings());
        event.addCourseName(correctedOffering.getCourseName());
        event.addCourseTitle(correctedOffering.getTitle() == null ? "" : correctedOffering.getTitle());
        event.setInstruction(clazz.getSchedulingSubpart().getItype().getDesc().length() <= 20 ? clazz.getSchedulingSubpart().getItype().getDesc() : clazz.getSchedulingSubpart().getItype().getAbbv());
        if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
            event.setInstruction(event.getInstruction() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
        }
        event.setInstructionType(clazz.getSchedulingSubpart().getItype().getItype());
        event.setSectionNumber(clazz.getSectionNumberString(hibSession));
        if (clazz.getClassSuffix(correctedOffering) == null) {
            event.setName(clazz.getClassLabel(correctedOffering));
        } else {
            event.addExternalId(clazz.getClassSuffix(correctedOffering));
            event.setName(correctedOffering.getCourseName() + " " + clazz.getClassSuffix(correctedOffering));
        }
        for (CourseOffering co : courses) {
            event.addCourseName(co.getCourseName());
            event.addCourseTitle(co.getTitle() == null ? "" : co.getTitle());
            if (clazz.getClassSuffix(co) == null) continue;
            event.addExternalId(clazz.getClassSuffix(co));
        }
        DatePattern pattern = clazz.effectiveDatePattern();
        if (pattern != null) {
            String datePatternFormat = ApplicationProperty.DatePatternFormatUseDates.value();
            if ("never".equals(datePatternFormat)) {
                event.setMessage(pattern.getName());
            } else if ("extended".equals(datePatternFormat) && pattern.getType() != 3) {
                event.setMessage(pattern.getName());
            } else if ("alternate".equals(datePatternFormat) && pattern.getType() == 1) {
                event.setMessage(pattern.getName());
            } else {
                Date last;
                Date first = pattern.getStartDate();
                event.setMessage(first.equals(last = pattern.getEndDate()) ? Formats.getDateFormat(Formats.Pattern.DATE_EVENT_LONG).format(first) : Formats.getDateFormat(Formats.Pattern.DATE_EVENT_SHORT).format(first) + " - " + Formats.getDateFormat(Formats.Pattern.DATE_EVENT_LONG).format(last));
            }
        }
        ArrayList<EventInterface.ResourceInterface> locations = new ArrayList<EventInterface.ResourceInterface>();
        for (RoomPref rp : clazz.effectivePreferences(RoomPref.class)) {
            if (!PreferenceLevel.sRequired.equals(rp.getPrefLevel().getPrefProlog())) continue;
            EventInterface.MeetingInterface meeting = new EventInterface.MeetingInterface();
            meeting.setPast(true);
            EventInterface.ResourceInterface location = new EventInterface.ResourceInterface();
            location.setType(EventInterface.ResourceType.ROOM);
            location.setId(rp.getRoom().getUniqueId());
            location.setName(rp.getRoom().getLabel());
            location.setSize(rp.getRoom().getCapacity());
            location.setRoomType(rp.getRoom().getRoomTypeLabel());
            location.setBreakTime(rp.getRoom().getEffectiveBreakTime());
            location.setMessage(rp.getRoom().getEventMessage());
            location.setIgnoreRoomCheck(rp.getRoom().isIgnoreRoomCheck());
            meeting.setLocation(location);
            event.addMeeting(meeting);
            locations.add(location);
        }
        if (!event.hasMeetings()) {
            EventInterface.MeetingInterface meeting = new EventInterface.MeetingInterface();
            meeting.setPast(true);
            event.addMeeting(meeting);
        }
        EventInterface.RelatedObjectInterface related = new EventInterface.RelatedObjectInterface();
        related.setType(EventInterface.RelatedObjectInterface.RelatedObjectType.Class);
        related.setUniqueId(clazz.getUniqueId());
        related.setName(clazz.getClassLabel(hibSession));
        String note = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering().getScheduleBookNote();
        if (clazz.getSchedulePrintNote() != null && !clazz.getSchedulePrintNote().isEmpty()) {
            note = (note == null || note.isEmpty() ? "" : note + "\n") + clazz.getSchedulePrintNote();
        }
        related.setNote(note);
        if (context != null && context.hasPermission(clazz, Right.ClassDetail)) {
            related.setDetailPage("classDetail.do?cid=" + clazz.getUniqueId());
        }
        CourseOffering courseOffering = clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getControllingCourseOffering();
        related.addCourseName(courseOffering.getCourseName());
        related.addCourseTitle(courseOffering.getTitle() == null ? "" : courseOffering.getTitle());
        related.setSectionNumber(clazz.getSectionNumberString(hibSession));
        if (clazz.getClassSuffix() != null) {
            related.addExternalId(clazz.getClassSuffix());
        }
        related.setInstruction(clazz.getSchedulingSubpart().getItype().getDesc());
        if (clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod() != null) {
            related.setInstruction(related.getInstruction() + " (" + clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalMethod().getLabel() + ")");
        }
        related.setInstructionType(clazz.getSchedulingSubpart().getItype().getItype());
        for (CourseOffering co : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
            if (co.isIsControl().booleanValue()) continue;
            related.addCourseName(co.getCourseName());
            related.addCourseTitle(co.getTitle() == null ? "" : co.getTitle());
            if (clazz.getClassSuffix(co) == null) continue;
            related.addExternalId(clazz.getClassSuffix(co));
        }
        if (clazz.getDisplayInstructor().booleanValue()) {
            for (ClassInstructor i : clazz.getClassInstructors()) {
                EventInterface.ContactInterface instructor = new EventInterface.ContactInterface();
                instructor.setFirstName(i.getInstructor().getFirstName());
                instructor.setMiddleName(i.getInstructor().getMiddleName());
                instructor.setLastName(i.getInstructor().getLastName());
                instructor.setAcademicTitle(i.getInstructor().getAcademicTitle());
                instructor.setExternalId(i.getInstructor().getExternalUniqueId());
                instructor.setEmail(i.getInstructor().getEmail());
                instructor.setFormattedName(i.getInstructor().getName(nameFormat));
                related.addInstructor(instructor);
            }
        }
        for (EventInterface.ResourceInterface location : locations) {
            related.addLocation(location);
        }
        if (pattern != null) {
            related.setDate(pattern.getName());
        }
        related.setTime(CONSTANTS.arrangeHours());
        event.addRelatedObject(related);
        return event;
    }
}

