/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.SavedHQL;

public class HQLImport
extends BaseImport {
    public void loadXml(Element root) throws Exception {
        try {
            this.beginTransaction();
            if (root.getName().equalsIgnoreCase("report")) {
                this.importReport(root);
            } else if (root.getName().equalsIgnoreCase("reports")) {
                Iterator i = root.elementIterator("report");
                while (i.hasNext()) {
                    this.importReport((Element)i.next());
                }
            } else {
                throw new Exception("Given XML file is not a HQL report file.");
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    protected void importReport(Element reportEl) {
        String name = reportEl.attributeValue("name");
        if (name == null) {
            this.error("Attribute name is not provided.");
            return;
        }
        SavedHQL report = (SavedHQL)this.getHibSession().createQuery("from SavedHQL where name = :name").setString("name", name).setMaxResults(1).uniqueResult();
        if (report == null) {
            report = new SavedHQL();
            report.setName(name);
        }
        report.setType(0);
        Element flags = reportEl.element("flags");
        Iterator i = (flags == null ? reportEl : flags).elementIterator("flag");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            SavedHQL.Flag flag = SavedHQL.Flag.valueOf(e.getTextTrim());
            if (flag == null) continue;
            report.set(flag);
        }
        Element queryEl = reportEl.element("query");
        if (queryEl != null) {
            report.setQuery(queryEl.getText());
        } else {
            report.setQuery(null);
        }
        Element descriptionEl = reportEl.element("description");
        if (descriptionEl != null) {
            report.setDescription(descriptionEl.getText());
        } else {
            report.setDescription(null);
        }
        this.getHibSession().saveOrUpdate((Object)report);
    }
}

