/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.Iterator;
import org.dom4j.Element;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;

public class DepartmentImport
extends BaseImport {
    public void loadXml(Element root) throws Exception {
        if (!root.getName().equalsIgnoreCase("departments")) {
            throw new Exception("Given XML file is not an Department load file.");
        }
        try {
            this.beginTransaction();
            String campus = root.attributeValue("campus");
            String year = root.attributeValue("year");
            String term = root.attributeValue("term");
            String created = root.attributeValue("created");
            Session session = Session.getSessionUsingInitiativeYearTerm(campus, year, term);
            if (session == null) {
                throw new Exception("No session found for the given campus, year, and term.");
            }
            if (created != null) {
                ChangeLog.addChange(this.getHibSession(), this.getManager(), session, session, created, ChangeLog.Source.DATA_IMPORT_DEPARTMENTS, ChangeLog.Operation.UPDATE, null, null);
            }
            Iterator it = root.elementIterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                String externalId = element.attributeValue("externalId");
                Department department = null;
                if (externalId != null && externalId.length() > 0) {
                    department = this.findByExternalId(externalId, session.getSessionId());
                    if (department == null && (department = Department.findByDeptCode(element.attributeValue("deptCode"), session.getSessionId())) != null) {
                        this.warn("Department:  " + element.attributeValue("deptCode") + " not loaded because a manually created department with the same department code already exists.");
                        continue;
                    }
                } else {
                    department = Department.findByDeptCode(element.attributeValue("deptCode"), session.getSessionId());
                }
                if (department == null) {
                    department = new Department();
                    department.setSession(session);
                    department.setAllowReqTime(false);
                    department.setAllowReqRoom(false);
                    department.setAllowReqDistribution(false);
                    department.setExternalManager(false);
                    department.setAllowEvents(false);
                    department.setAllowStudentScheduling(true);
                    department.setInheritInstructorPreferences(true);
                    department.setDistributionPrefPriority(new Integer(0));
                } else if ("T".equalsIgnoreCase(element.attributeValue("delete"))) {
                    this.getHibSession().delete((Object)department);
                    continue;
                }
                department.setAbbreviation(element.attributeValue("abbreviation"));
                department.setName(element.attributeValue("name"));
                department.setDeptCode(element.attributeValue("deptCode"));
                department.setExternalUniqueId(externalId);
                department.setAllowEvents("true".equals(element.attributeValue("allowEvents", department.isAllowEvents() != false ? "true" : "false")));
                department.setInheritInstructorPreferences("true".equals(element.attributeValue("instructorPrefs", department.isInheritInstructorPreferences() != false ? "true" : "false")));
                this.getHibSession().saveOrUpdate((Object)department);
                this.flushIfNeeded(false);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    private Department findByExternalId(String externalId, Long sessionId) {
        return (Department)this.getHibSession().createQuery("select distinct a from Department as a where a.externalUniqueId=:externalId and a.session.uniqueId=:sessionId").setLong("sessionId", sessionId.longValue()).setString("externalId", externalId).setCacheable(true).uniqueResult();
    }
}

