/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.model.AcademicAreaClassification;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentAccomodation;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.dao.StudentGroupDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;

@Service(value="/api/student-groups")
public class StudentGroupsConnector
extends ApiConnector {
    public void doGet(ApiHelper helper) throws IOException {
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        helper.getSessionContext().checkPermissionAnyAuthority(sessionId, "Session", Right.ApiRetrieveStudentGroups, new Qualifiable[0]);
        ArrayList<StudentGroupInfo> response = new ArrayList<StudentGroupInfo>();
        for (StudentGroup g : StudentGroupDAO.getInstance().getSession().createQuery("from StudentGroup g where g.session.uniqueId = :sessionId").setLong("sessionId", sessionId.longValue()).list()) {
            response.add(new StudentGroupInfo(g));
        }
        helper.setResponse(response);
    }

    protected String getName() {
        return "student-groups";
    }

    static class StudentInfo {
        Long iStudentId;
        String iExternalId;
        String iFirstName;
        String iMiddleName;
        String iLastName;
        String iTitle;
        String iEmail;
        String iSectioningStatus;
        List<String> iArea;
        List<String> iClassification;
        List<String> iMajor;
        List<String> iMinor;
        List<String> iGroup;
        List<String> iAccomodation;
        Long iCourseId;
        String iSubjectArea;
        String iCourseNumber;
        String iCourseTitle;
        Long iClassId;
        String iSubpart;
        String iSectionNumber;
        String iClassSuffix;
        String iClassExternalId;
        Date iRequestDate;
        Date iEnrollmentDate;

        StudentInfo(Student student) {
            this.iStudentId = student.getUniqueId();
            this.iExternalId = student.getExternalUniqueId();
            this.iFirstName = student.getFirstName();
            this.iMiddleName = student.getMiddleName();
            this.iLastName = student.getLastName();
            this.iTitle = student.getAcademicTitle();
            this.iEmail = student.getEmail();
            if (student.getSectioningStatus() != null) {
                this.iSectioningStatus = student.getSectioningStatus().getReference();
            }
            for (AcademicAreaClassification aac : student.getAcademicAreaClassifications()) {
                if (this.iArea == null) {
                    this.iArea = new ArrayList<String>();
                    this.iClassification = new ArrayList<String>();
                }
                this.iArea.add(aac.getAcademicArea().getAcademicAreaAbbreviation());
                this.iClassification.add(aac.getAcademicClassification().getCode());
            }
            for (PosMajor major : student.getPosMajors()) {
                if (this.iMajor == null) {
                    this.iMajor = new ArrayList<String>();
                }
                this.iMajor.add(major.getCode());
            }
            for (PosMinor minor : student.getPosMinors()) {
                if (this.iMinor == null) {
                    this.iMinor = new ArrayList<String>();
                }
                this.iMinor.add(minor.getCode());
            }
            for (StudentGroup group : student.getGroups()) {
                if (this.iGroup == null) {
                    this.iGroup = new ArrayList<String>();
                }
                this.iGroup.add(group.getGroupAbbreviation());
            }
            for (StudentAccomodation accomodation : student.getAccomodations()) {
                if (this.iAccomodation == null) {
                    this.iAccomodation = new ArrayList<String>();
                }
                this.iAccomodation.add(accomodation.getAbbreviation());
            }
        }
    }

    static class StudentGroupInfo {
        Long iId;
        String iExternalId;
        String iAbbreviation;
        String iName;
        List<StudentInfo> iStudents = new ArrayList<StudentInfo>();

        StudentGroupInfo(StudentGroup g) {
            this.iId = g.getUniqueId();
            this.iExternalId = g.getExternalUniqueId();
            this.iAbbreviation = g.getGroupAbbreviation();
            this.iName = g.getGroupName();
            for (Student s : g.getStudents()) {
                this.iStudents.add(new StudentInfo(s));
            }
        }
    }
}

