/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.cpsolver.coursett.model.TimeLocation;
import org.springframework.stereotype.Service;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;

@Service(value="/api/instructor-schedule")
public class InstructorScheduleConnector
extends ApiConnector {
    public void doGet(ApiHelper helper) throws IOException {
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        helper.getSessionContext().checkPermissionAnyAuthority(sessionId, "Session", Right.ApiRetrieveInstructorSchedule, new Qualifiable[0]);
        String externalId = helper.getParameter("id");
        if (externalId == null) {
            throw new IllegalArgumentException("Parameter ID not provided");
        }
        if (ApplicationProperty.ApiTrimLeadingZerosFromUserExternalIds.isTrue()) {
            while (externalId.startsWith("0")) {
                externalId = externalId.substring(1);
            }
        }
        boolean checkStatus = !helper.getSessionContext().hasPermission(Right.HasRole);
        InstructorScheduleInfo response = null;
        for (DepartmentalInstructor di : helper.getHibSession().createQuery("from DepartmentalInstructor d where d.externalUniqueId = :externalId and department.session.uniqueId = :sessionId").setString("externalId", externalId).setLong("sessionId", sessionId.longValue()).setCacheable(true).list()) {
            if (response == null) {
                response = new InstructorScheduleInfo(di);
            }
            response.add(di, checkStatus);
        }
        helper.setResponse(response);
    }

    protected static Date firstDate(DatePattern dp, int dayCode) {
        int idx;
        if (dp == null) {
            return null;
        }
        BitSet weekCode = dp.getPatternBitSet();
        if (weekCode.isEmpty()) {
            return null;
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        Date dpFirstDate = DateUtils.getDate(1, dp.getSession().getPatternStartMonth(), dp.getSession().getSessionStartYear());
        cal.setTime(dpFirstDate);
        cal.add(6, idx);
        for (idx = weekCode.nextSetBit(0); idx < weekCode.size(); ++idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((dayCode & DayCode.MON.getCode()) == 0) break;
                        return cal.getTime();
                    }
                    case 3: {
                        if ((dayCode & DayCode.TUE.getCode()) == 0) break;
                        return cal.getTime();
                    }
                    case 4: {
                        if ((dayCode & DayCode.WED.getCode()) == 0) break;
                        return cal.getTime();
                    }
                    case 5: {
                        if ((dayCode & DayCode.THU.getCode()) == 0) break;
                        return cal.getTime();
                    }
                    case 6: {
                        if ((dayCode & DayCode.FRI.getCode()) == 0) break;
                        return cal.getTime();
                    }
                    case 7: {
                        if ((dayCode & DayCode.SAT.getCode()) == 0) break;
                        return cal.getTime();
                    }
                    case 1: {
                        if ((dayCode & DayCode.SUN.getCode()) == 0) break;
                        return cal.getTime();
                    }
                }
            }
            cal.add(6, 1);
        }
        return null;
    }

    protected static Date lastDate(DatePattern dp, int dayCode) {
        int idx;
        if (dp == null) {
            return null;
        }
        BitSet weekCode = dp.getPatternBitSet();
        if (weekCode.isEmpty()) {
            return null;
        }
        Calendar cal = Calendar.getInstance(Locale.US);
        cal.setLenient(true);
        Date dpFirstDate = DateUtils.getDate(1, dp.getSession().getPatternStartMonth(), dp.getSession().getSessionStartYear());
        cal.setTime(dpFirstDate);
        cal.add(6, idx);
        Object last = null;
        for (idx = weekCode.length() - 1; idx >= 0 && last == null; --idx) {
            if (weekCode.get(idx)) {
                int dow = cal.get(7);
                switch (dow) {
                    case 2: {
                        if ((dayCode & DayCode.MON.getCode()) == 0) break;
                        return cal.getTime();
                    }
                    case 3: {
                        if ((dayCode & DayCode.TUE.getCode()) == 0) break;
                        return cal.getTime();
                    }
                    case 4: {
                        if ((dayCode & DayCode.WED.getCode()) == 0) break;
                        return cal.getTime();
                    }
                    case 5: {
                        if ((dayCode & DayCode.THU.getCode()) == 0) break;
                        return cal.getTime();
                    }
                    case 6: {
                        if ((dayCode & DayCode.FRI.getCode()) == 0) break;
                        return cal.getTime();
                    }
                    case 7: {
                        if ((dayCode & DayCode.SAT.getCode()) == 0) break;
                        return cal.getTime();
                    }
                    case 1: {
                        if ((dayCode & DayCode.SUN.getCode()) == 0) break;
                        return cal.getTime();
                    }
                }
            }
            cal.add(6, -1);
        }
        return null;
    }

    protected String getName() {
        return "instructor-schedule";
    }

    protected class RoomInfo {
        String iBuilding;
        String iRoomNumber;
        String iLocation;
        String iRoomType;
        Integer iRoomCapacity;

        RoomInfo(Location room) {
            if (room instanceof Room) {
                this.iBuilding = ((Room)room).getBuildingAbbv();
                this.iRoomNumber = ((Room)room).getRoomNumber();
            } else {
                this.iLocation = room.getLabel();
            }
            this.iRoomType = room.getRoomTypeLabel();
            this.iRoomCapacity = room.getCapacity();
        }
    }

    protected class PeriodInfo {
        String iDate;
        String iStartTime;
        String iEndTime;

        PeriodInfo(ExamPeriod period) {
            this.iDate = new SimpleDateFormat("yyyy-MM-dd").format(period.getStartDate());
            int start = period.getStartSlot() * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
            int sh = start / 60;
            int sm = start % 60;
            this.iStartTime = sh + ":" + (sm < 10 ? "0" : "") + sm;
            int end = start + Constants.SLOT_LENGTH_MIN * period.getLength();
            int eh = end / 60;
            int em = end % 60;
            this.iEndTime = eh + ":" + (em < 10 ? "0" : "") + em;
        }
    }

    protected class ExamOwnerInfo {
        String iType;
        Long iCourseId;
        Long iOfferingId;
        Long iConfigurationId;
        Long iClassId;
        String iSubjectArea;
        String iCourseNumber;
        String iCourseTitle;
        String iClassSuffix;
        String iClassExternalId;
        String iSubpart;
        String iSectionNumber;
        String iConfiguration;

        public ExamOwnerInfo(ExamOwner owner) {
            switch (owner.getOwnerType()) {
                case 3: {
                    this.iType = "Class";
                    this.iClassId = owner.getOwnerId();
                    break;
                }
                case 2: {
                    this.iType = "Config";
                    this.iConfigurationId = owner.getOwnerId();
                    break;
                }
                case 1: {
                    this.iType = "Course";
                    this.iCourseId = owner.getOwnerId();
                    break;
                }
                case 0: {
                    this.iType = "Offering";
                    this.iOfferingId = owner.getOwnerId();
                }
            }
            this.iSubjectArea = owner.getCourse().getSubjectAreaAbbv();
            this.iCourseNumber = owner.getCourse().getCourseNbr();
            this.iCourseTitle = owner.getCourse().getTitle();
            if (owner.getOwnerObject() instanceof Class_) {
                Class_ clazz = (Class_)owner.getOwnerObject();
                this.iClassId = clazz.getUniqueId();
                this.iClassSuffix = clazz.getClassSuffix(owner.getCourse());
                this.iClassExternalId = clazz.getExternalId(owner.getCourse());
                this.iSubpart = clazz.getSchedulingSubpart().getItypeDesc().trim();
                this.iSectionNumber = clazz.getSectionNumberString();
            } else if (owner.getOwnerObject() instanceof InstrOfferingConfig) {
                this.iConfiguration = ((InstrOfferingConfig)owner.getOwnerObject()).getName();
                this.iConfigurationId = owner.getOwnerId();
            }
        }
    }

    protected class ExamInfo {
        Long iExamId;
        String iName;
        String iType;
        Integer iSize;
        Integer iLength;
        Integer iPrintOffset;
        List<ExamOwnerInfo> iOwners = new ArrayList<ExamOwnerInfo>();
        PeriodInfo iPeriod;
        List<RoomInfo> iRoom;

        ExamInfo(Exam exam) {
            this.iExamId = exam.getUniqueId();
            this.iName = exam.getName();
            this.iType = exam.getExamType().getReference();
            for (ExamOwner owner : exam.getOwners()) {
                this.iOwners.add(new ExamOwnerInfo(owner));
            }
            this.iSize = exam.getSize();
            this.iLength = exam.getLength();
            this.iPrintOffset = exam.getPrintOffset();
            if (exam.getAssignedPeriod() != null) {
                this.iPeriod = new PeriodInfo(exam.getAssignedPeriod());
            }
            for (Location room : exam.getAssignedRooms()) {
                if (this.iRoom == null) {
                    this.iRoom = new ArrayList<RoomInfo>();
                }
                this.iRoom.add(new RoomInfo(room));
            }
        }
    }

    protected class AssignmentInfo {
        String iDayOfWeek;
        String iStartTime;
        String iEndTime;
        String iDatePattern;
        String iFirstDate;
        String iLastDate;
        String iBuilding;
        String iRoomNumber;
        String iLocation;
        String iRoomType;
        Integer iRoomCapacity;

        AssignmentInfo(TimeLocation time, DatePattern dp, int day, Location room) {
            if (time != null) {
                Date lastDate;
                this.iStartTime = time.getStartTimeHeader(false);
                this.iEndTime = time.getEndTimeHeader(false);
                this.iDayOfWeek = Constants.DAY_NAMES_FULL[day];
                this.iDatePattern = time.getDatePatternName();
                Date firstDate = InstructorScheduleConnector.firstDate(dp, Constants.DAY_CODES[day]);
                if (firstDate != null) {
                    this.iFirstDate = new SimpleDateFormat("yyyy-MM-dd").format(firstDate);
                }
                if ((lastDate = InstructorScheduleConnector.lastDate(dp, Constants.DAY_CODES[day])) != null) {
                    this.iLastDate = new SimpleDateFormat("yyyy-MM-dd").format(lastDate);
                }
            }
            if (room != null) {
                if (room instanceof Room) {
                    this.iBuilding = ((Room)room).getBuildingAbbv();
                    this.iRoomNumber = ((Room)room).getRoomNumber();
                } else {
                    this.iLocation = room.getLabel();
                }
                this.iRoomType = room.getRoomTypeLabel();
                this.iRoomCapacity = room.getCapacity();
            }
        }
    }

    class ClassInfo {
        List<CourseInfo> iCourse = new ArrayList<CourseInfo>();
        Long iClassId;
        String iSubpart;
        String iSectionNumber;
        String iNote;
        Integer iLimit;
        List<AssignmentInfo> iMeetings;

        ClassInfo(Class_ clazz) {
            int maxLimit;
            this.iClassId = clazz.getUniqueId();
            this.iSectionNumber = clazz.getSectionNumberString();
            this.iSubpart = clazz.getSchedulingSubpart().getItypeDesc().trim();
            this.iNote = clazz.getSchedulePrintNote();
            for (CourseOffering course : clazz.getSchedulingSubpart().getInstrOfferingConfig().getInstructionalOffering().getCourseOfferings()) {
                this.iCourse.add(new CourseInfo(course, clazz));
            }
            Assignment assignment = clazz.getCommittedAssignment();
            int minLimit = clazz.getExpectedCapacity();
            int limit = maxLimit = clazz.getMaxExpectedCapacity().intValue();
            if (assignment != null) {
                this.iMeetings = new ArrayList<AssignmentInfo>();
                for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                    if ((assignment.getDays() & Constants.DAY_CODES[i]) == 0) continue;
                    if (assignment.getRooms().isEmpty()) {
                        this.iMeetings.add(new AssignmentInfo(assignment.getTimeLocation(), assignment.getDatePattern(), i, null));
                        continue;
                    }
                    for (Location location : assignment.getRooms()) {
                        this.iMeetings.add(new AssignmentInfo(assignment.getTimeLocation(), assignment.getDatePattern(), i, location));
                    }
                }
                if (minLimit < maxLimit) {
                    int roomLimit = (int)Math.floor((float)assignment.getPlacement().getRoomSize() / (clazz.getRoomRatio() == null ? 1.0f : clazz.getRoomRatio().floatValue()));
                    limit = Math.min(Math.max(minLimit, roomLimit), maxLimit);
                }
            }
            if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue() || limit >= 9999) {
                limit = -1;
            }
            if (limit >= 0) {
                this.iLimit = limit;
            }
        }
    }

    class CourseInfo {
        Long iCourseId;
        String iSubjectArea;
        String iCourseNumber;
        String iCourseTitle;
        boolean iControl;
        String iType;
        String iClassSuffix;
        String iClassExternalId;
        String iCredit;
        String iNote;

        CourseInfo(CourseOffering co, Class_ clazz) {
            this.iCourseId = co.getUniqueId();
            this.iSubjectArea = co.getSubjectAreaAbbv();
            this.iCourseNumber = co.getCourseNbr();
            this.iCourseTitle = co.getTitle();
            this.iControl = co.isIsControl();
            if (co.getCourseType() != null) {
                this.iType = co.getCourseType().getReference();
            }
            if (clazz != null) {
                this.iClassSuffix = clazz.getClassSuffix(co);
                this.iClassExternalId = clazz.getExternalId(co);
            }
            if (co.getCredit() != null) {
                this.iCredit = co.getCredit().creditAbbv();
            }
            this.iNote = co.getScheduleBookNote();
        }
    }

    class ClassAssignmentInfo
    extends ClassInfo {
        Boolean iLead;
        Integer iPercentShare;

        ClassAssignmentInfo(ClassInstructor ci) {
            super(ci.getClassInstructing());
            this.iLead = ci.getLead();
            this.iPercentShare = ci.getPercentShare();
        }
    }

    class PositionInfo {
        String iReference;
        String iLabel;

        PositionInfo(PositionType type) {
            this.iReference = type.getReference();
            this.iLabel = type.getLabel();
        }
    }

    class DepartmentInfo {
        String iCode;
        String iName;

        DepartmentInfo(Department department) {
            this.iCode = department.getDeptCode();
            this.iName = department.getName();
        }
    }

    class InstructorInfo {
        Long iInstructorId;
        String iExternalId;
        String iFirstName;
        String iMiddleName;
        String iLastName;
        String iTitle;
        PositionInfo iPosition;
        String iEmail;
        DepartmentInfo iDepartment;
        String iAcademicTitle;

        InstructorInfo(DepartmentalInstructor instructor) {
            this.iInstructorId = instructor.getUniqueId();
            this.iExternalId = instructor.getExternalUniqueId();
            this.iFirstName = instructor.getFirstName();
            this.iMiddleName = instructor.getMiddleName();
            this.iLastName = instructor.getLastName();
            this.iTitle = instructor.getAcademicTitle();
            if (instructor.getPositionType() != null) {
                this.iPosition = new PositionInfo(instructor.getPositionType());
            }
            this.iEmail = instructor.getEmail();
            this.iDepartment = new DepartmentInfo(instructor.getDepartment());
            this.iAcademicTitle = instructor.getAcademicTitle();
        }
    }

    class SessionInfo {
        Long iSessionId;
        String iReference;

        SessionInfo(Session session) {
            this.iSessionId = session.getUniqueId();
            this.iReference = session.getReference();
        }
    }

    class InstructorScheduleInfo {
        String iExternalId;
        SessionInfo iSession;
        List<InstructorInfo> iInstructors = new ArrayList<InstructorInfo>();
        List<ClassInfo> iClasses = new ArrayList<ClassInfo>();
        List<CourseInfo> iCourses = new ArrayList<CourseInfo>();
        List<ExamInfo> iExams = new ArrayList<ExamInfo>();

        InstructorScheduleInfo(DepartmentalInstructor instructor) {
            this.iExternalId = instructor.getExternalUniqueId();
            this.iSession = new SessionInfo(instructor.getDepartment().getSession());
        }

        void add(DepartmentalInstructor instructor, boolean statusCheck) {
            this.iInstructors.add(new InstructorInfo(instructor));
            if (!statusCheck || instructor.getDepartment().getSession().canNoRoleReportClass()) {
                for (ClassInstructor ci : instructor.getClasses()) {
                    if (ci.getClassInstructing().isCancelled().booleanValue()) continue;
                    this.iClasses.add(new ClassAssignmentInfo(ci));
                }
                for (InstructionalOffering io : instructor.getOfferings()) {
                    for (CourseOffering co : io.getCourseOfferings()) {
                        if (co.getInstructionalOffering().isNotOffered().booleanValue()) continue;
                        this.iCourses.add(new CourseInfo(co, null));
                    }
                }
            }
            for (Exam exam : instructor.getExams()) {
                if (statusCheck && !exam.canView()) continue;
                this.iExams.add(new ExamInfo(exam));
            }
        }
    }
}

