/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.springframework.stereotype.Service;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.api.XmlApiHelper;
import org.unitime.timetable.dataexchange.DataExchangeHelper;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;

@Service(value="/api/exchange")
public class DataExchangeConnector
extends ApiConnector {
    protected ApiHelper createHelper(HttpServletRequest request, HttpServletResponse response) {
        return new XmlApiHelper(request, response, this.sessionContext, this.getCacheMode());
    }

    public void doGet(ApiHelper helper) throws IOException {
        helper.getSessionContext().checkPermissionAnyAuthority(Right.ApiDataExchangeConnector, new Qualifiable[0]);
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId, helper.getHibSession());
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        String type = helper.getParameter("type");
        if (type == null) {
            throw new IllegalArgumentException("Export TYPE parameter not provided.");
        }
        ApplicationProperties.setSessionId(sessionId);
        try {
            helper.setResponse(DataExchangeHelper.exportDocument(type, session, ApplicationProperties.getProperties(), new DataExchangeHelper.LogWriter(){

                public void println(String message) {
                }
            }));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void doPost(ApiHelper helper) throws IOException {
        helper.getSessionContext().checkPermissionAnyAuthority(Right.ApiDataExchangeConnector, new Qualifiable[0]);
        Document document = (Document)helper.getRequest((Type)((Object)Document.class));
        Document output = DocumentHelper.createDocument();
        final Element messages = output.addElement("html");
        try {
            DataExchangeHelper.importDocument(document, helper.getSessionContext().isAuthenticated() ? helper.getSessionContext().getUser().getExternalUserId() : null, new DataExchangeHelper.LogWriter(){

                public void println(String message) {
                    messages.addElement("p").setText(message);
                }
            });
            helper.setResponse(output);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected String getName() {
        return "exchange";
    }
}

