/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.ExamReportForm;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.PdfWebTable;
import org.unitime.timetable.webutil.RequiredTimeTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="/unassignedExams")
public class UnassignedExamsAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String op;
        ExamReportForm myForm = (ExamReportForm)form;
        this.sessionContext.checkPermission(Right.NotAssignedExaminations);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if ("Export CSV".equals(op) || "Export PDF".equals(op) || "Apply".equals(op)) {
            myForm.save(this.sessionContext);
        } else if ("Refresh".equals(op)) {
            myForm.reset(mapping, request);
        }
        myForm.load(this.sessionContext);
        Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
        RoomAvailability.setAvailabilityWarning(request, session, myForm.getExamType(), true, false);
        ExamSolverProxy solver = WebSolver.getExamSolver(request.getSession());
        Collection<ExamInfo> unassignedExams = null;
        if (myForm.getSubjectArea() != null && myForm.getSubjectArea() != 0L && myForm.getExamType() != null) {
            unassignedExams = solver != null && solver.getExamTypeId().equals(myForm.getExamType()) ? solver.getUnassignedExams(myForm.getSubjectArea()) : Exam.findUnassignedExams(this.sessionContext.getUser().getCurrentAcademicSessionId(), myForm.getSubjectArea(), myForm.getExamType());
        }
        WebTable.setOrder(this.sessionContext, "unassignedExams.ord", request.getParameter("ord"), 1);
        PdfWebTable table = this.getTable(true, false, myForm, unassignedExams);
        if ("Export PDF".equals(op) && table != null) {
            ExportUtils.exportPDF(this.getTable(false, true, myForm, unassignedExams), WebTable.getOrder(this.sessionContext, "unassignedExams.ord"), response, "unassigned");
            return null;
        }
        if ("Export CSV".equals(op) && table != null) {
            ExportUtils.exportCSV(this.getTable(false, false, myForm, unassignedExams), WebTable.getOrder(this.sessionContext, "unassignedExams.ord"), response, "unassigned");
            return null;
        }
        if (table != null) {
            myForm.setTable(table.printTable(WebTable.getOrder(this.sessionContext, "unassignedExams.ord")), 9, unassignedExams.size());
        }
        if (request.getParameter("backId") != null) {
            request.setAttribute("hash", (Object)request.getParameter("backId"));
        }
        LookupTables.setupExamTypes(request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable);
        return mapping.findForward("showReport");
    }

    public PdfWebTable getTable(boolean html, boolean color, ExamReportForm form, Collection<ExamInfo> exams) {
        if (exams == null || exams.isEmpty()) {
            return null;
        }
        boolean timeVertical = RequiredTimeTable.getTimeGridVertical(this.sessionContext.getUser());
        boolean timeText = RequiredTimeTable.getTimeGridAsText(this.sessionContext.getUser());
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(9, "Not-assigned Examinations", "unassignedExams.do?ord=%%", new String[]{form.getShowSections() ? "Classes / Courses" : "Examination", "Length", "Seating" + nl + "Type", "Size", "Max" + nl + "Rooms", "Instructor", "Period" + nl + "Preferences", "Room" + nl + "Preferences", "Distribution" + nl + "Preferences"}, new String[]{"left", "right", "center", "right", "right", "left", "left", "left", "left"}, new boolean[]{true, true, true, false, false, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        try {
            for (ExamInfo exam : exams) {
                PeriodPreferenceModel px;
                MidtermPeriodPreferenceModel epx;
                String perPref = "";
                String roomPref = "";
                String distPref = "";
                if (html) {
                    if ((roomPref = roomPref + exam.getExam().getEffectivePrefHtmlForPrefType(RoomPref.class)).length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    if ((roomPref = roomPref + exam.getExam().getEffectivePrefHtmlForPrefType(BuildingPref.class)).length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    if ((roomPref = roomPref + exam.getExam().getEffectivePrefHtmlForPrefType(RoomFeaturePref.class)).length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    if ((roomPref = roomPref + exam.getExam().getEffectivePrefHtmlForPrefType(RoomGroupPref.class)).endsWith(nl)) {
                        roomPref = roomPref.substring(0, roomPref.length() - nl.length());
                    }
                    if (timeText) {
                        perPref = perPref + exam.getExam().getEffectivePrefHtmlForPrefType(ExamPeriodPref.class);
                    } else if (exam.getExam().getExamType().getType() == 1) {
                        epx = new MidtermPeriodPreferenceModel(exam.getExam().getSession(), exam.getExam().getExamType());
                        epx.load(exam.getExam());
                        perPref = perPref + epx.toString(true);
                    } else {
                        px = new PeriodPreferenceModel(exam.getExam().getSession(), exam.getExamTypeId());
                        px.load(exam.getExam());
                        perPref = "<img border='0' src='pattern?v=" + (timeVertical ? 1 : 0) + "&x=" + exam.getExamId() + "' title='" + px.toString() + "'>";
                    }
                    distPref = distPref + exam.getExam().getEffectivePrefHtmlForPrefType(DistributionPref.class);
                } else {
                    for (Preference pref : exam.getExam().effectivePreferences(RoomPref.class)) {
                        if (roomPref.length() > 0) {
                            roomPref = roomPref + nl;
                        }
                        roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                    }
                    for (Preference pref : exam.getExam().effectivePreferences(BuildingPref.class)) {
                        if (roomPref.length() > 0) {
                            roomPref = roomPref + nl;
                        }
                        roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                    }
                    for (Preference pref : exam.getExam().effectivePreferences(RoomFeaturePref.class)) {
                        if (roomPref.length() > 0) {
                            roomPref = roomPref + nl;
                        }
                        roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                    }
                    for (Preference pref : exam.getExam().effectivePreferences(RoomGroupPref.class)) {
                        if (roomPref.length() > 0) {
                            roomPref = roomPref + nl;
                        }
                        roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                    }
                    if (1 == exam.getExamType().getType()) {
                        epx = new MidtermPeriodPreferenceModel(exam.getExam().getSession(), exam.getExamType());
                        epx.load(exam.getExam());
                        perPref = perPref + epx.toString(false, true);
                    } else if (timeText || !color) {
                        for (Preference pref : exam.getExam().effectivePreferences(ExamPeriodPref.class)) {
                            if (perPref.length() > 0) {
                                perPref = perPref + nl;
                            }
                            perPref = perPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                        }
                    } else {
                        px = new PeriodPreferenceModel(exam.getExam().getSession(), exam.getExamType().getUniqueId());
                        px.load(exam.getExam());
                        RequiredTimeTable rtt = new RequiredTimeTable(px);
                        BufferedImage image = rtt.createBufferedImage(timeVertical);
                        if (image != null) {
                            table.addImage(exam.getExamId().toString(), image);
                            perPref = perPref + "@@IMAGE " + exam.getExamId().toString() + " ";
                        } else {
                            for (Preference pref : exam.getExam().effectivePreferences(ExamPeriodPref.class)) {
                                if (perPref.length() > 0) {
                                    perPref = perPref + nl;
                                }
                                perPref = perPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                            }
                        }
                    }
                    for (Preference pref : exam.getExam().effectivePreferences(DistributionPref.class)) {
                        if (distPref.length() > 0) {
                            distPref = distPref + nl;
                        }
                        distPref = distPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + ((DistributionPref)pref).preferenceText(true, true, " (", ", ", ")").replaceAll("&lt;", "<").replaceAll("&gt;", ">");
                    }
                }
                String instructors = exam.getInstructorName(", ");
                table.addLine("onClick=\"showGwtDialog('Examination Assignment', 'examInfo.do?examId=" + exam.getExamId() + "','900','90%');\"", new String[]{(html ? "<a name='" + exam.getExamId() + "'>" : "") + (form.getShowSections() ? exam.getSectionName(nl) : exam.getExamName()) + (html ? "</a>" : ""), String.valueOf(exam.getLength()), 0 == exam.getSeatingType() ? "Normal" : "Exam", String.valueOf(exam.getNrStudents()), String.valueOf(exam.getMaxRooms()), instructors, perPref, roomPref, distPref}, new Comparable[]{exam, Integer.valueOf(exam.getLength()), Integer.valueOf(exam.getSeatingType()), Integer.valueOf(exam.getNrStudents()), Integer.valueOf(exam.getMaxRooms()), instructors, perPref, roomPref, distPref}, exam.getExamId().toString());
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.addLine(new String[]{"<font color='red'>ERROR:" + e.getMessage() + "</font>"}, null);
        }
        return table;
    }
}

