/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.TimetableManagerForm;
import org.unitime.timetable.interfaces.ExternalUidLookup;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.ManagerRole;
import org.unitime.timetable.model.Roles;
import org.unitime.timetable.model.SolverGroup;
import org.unitime.timetable.model.TimetableManager;
import org.unitime.timetable.model.comparators.RolesComparator;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.model.dao.RolesDAO;
import org.unitime.timetable.model.dao.SolverGroupDAO;
import org.unitime.timetable.model.dao.TimetableManagerDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;

@Service(value="/timetableManagerEdit")
public class TimetableManagerEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionErrors errors;
        String mapPath;
        String op;
        this.sessionContext.checkPermission(Right.TimetableManagers);
        MessageResources rsc = this.getResources(request);
        TimetableManagerForm frm = (TimetableManagerForm)form;
        Object object = request.getParameter("op") == null ? (frm.getOp() == null || frm.getOp().length() == 0 ? (request.getAttribute("op") == null ? null : request.getAttribute("op").toString()) : frm.getOp()) : (op = request.getParameter("op"));
        if (op == null || op.trim().length() == 0) {
            throw new Exception("Operation could not be interpreted: " + op);
        }
        LookupTables.setupDepts(request, this.sessionContext.getUser().getCurrentAcademicSessionId());
        request.setAttribute("solverGroupList", SolverGroup.findBySessionId(this.sessionContext.getUser().getCurrentAcademicSessionId()));
        frm.setOp(op);
        if (op.equalsIgnoreCase(rsc.getMessage("button.backToManagerList"))) {
            if (frm.getUniqueId() != null && frm.getUniqueId().trim().length() > 0) {
                request.setAttribute(Constants.JUMP_TO_ATTR_NAME, (Object)frm.getUniqueId());
            }
            return mapping.findForward("displayManagerList");
        }
        if (op.equalsIgnoreCase(rsc.getMessage("op.edit"))) {
            frm.setOp1("2");
            this.loadForm(request, frm);
        }
        if (op.equalsIgnoreCase(rsc.getMessage("button.addTimetableManager"))) {
            this.sessionContext.checkPermission(Right.TimetableManagerAdd);
            frm.setOp1("1");
            frm.setLookupEnabled(ApplicationProperty.ManagerExternalIdLookup.isTrue() && ApplicationProperty.ManagerExternalIdLookupClass.value() != null);
        }
        if (op.equalsIgnoreCase(rsc.getMessage("button.lookupManager"))) {
            // empty if block
        }
        String string = mapPath = frm.getOp1().equals("1") ? "addManagerInfo" : "editManagerInfo";
        if (op.equalsIgnoreCase(rsc.getMessage("button.addRole"))) {
            errors = frm.validate(mapping, request);
            if (!errors.isEmpty()) {
                this.saveErrors(request, (ActionMessages)errors);
                this.setupRoles(request, frm);
                this.lookupManager(frm);
                return mapping.findForward(mapPath);
            }
            Roles role = (Roles)new RolesDAO().get(new Long(frm.getRole()));
            frm.addToRoles(role);
            if (frm.getRoles().size() == 1) {
                frm.setPrimaryRole(role.getRoleId().toString());
            }
            frm.getRoleReceiveEmailFlags().add(new Boolean(true));
        }
        if (op.equalsIgnoreCase(rsc.getMessage("button.addDepartment"))) {
            errors = frm.validate(mapping, request);
            if (!errors.isEmpty()) {
                this.saveErrors(request, (ActionMessages)errors);
                this.setupRoles(request, frm);
                this.lookupManager(frm);
                return mapping.findForward(mapPath);
            }
            Department dept = (Department)new DepartmentDAO().get(new Long(frm.getDept()));
            frm.addToDepts(dept);
        }
        if (op.equalsIgnoreCase(rsc.getMessage("button.addSolverGroup"))) {
            errors = frm.validate(mapping, request);
            if (!errors.isEmpty()) {
                this.saveErrors(request, (ActionMessages)errors);
                this.setupRoles(request, frm);
                this.lookupManager(frm);
                return mapping.findForward(mapPath);
            }
            SolverGroup sg = (SolverGroup)new SolverGroupDAO().get(new Long(frm.getSolverGr()));
            frm.addToSolverGrs(sg);
        }
        if (op.equalsIgnoreCase(rsc.getMessage("button.insertTimetableManager"))) {
            frm.setOp1("1");
            errors = frm.validate(mapping, request);
            if (!errors.isEmpty()) {
                this.saveErrors(request, (ActionMessages)errors);
                this.setupRoles(request, frm);
                try {
                    this.lookupManager(frm);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return mapping.findForward(mapPath);
            }
            this.addManager(request, frm);
            return mapping.findForward("displayManagerList");
        }
        if (op.equalsIgnoreCase(rsc.getMessage("button.updateTimetableManager"))) {
            frm.setOp1("2");
            errors = frm.validate(mapping, request);
            if (!errors.isEmpty()) {
                this.saveErrors(request, (ActionMessages)errors);
                this.setupRoles(request, frm);
                try {
                    this.lookupManager(frm);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return mapping.findForward(mapPath);
            }
            this.updateManager(request, frm);
            return mapping.findForward("displayManagerList");
        }
        if (op.equalsIgnoreCase(rsc.getMessage("button.delete")) || op.equalsIgnoreCase(rsc.getMessage("button.deleteTimetableManager"))) {
            String deleteType = request.getParameter("deleteType");
            String deleteId = request.getParameter("deleteId");
            if (deleteType.equalsIgnoreCase("dept")) {
                frm.removeFromDepts(Integer.parseInt(deleteId));
            }
            if (deleteType.equalsIgnoreCase("solverGr")) {
                frm.removeFromSolverGrs(Integer.parseInt(deleteId));
            }
            if (deleteType.equalsIgnoreCase("role")) {
                frm.removeFromRoles(Integer.parseInt(deleteId));
                if (frm.getRoles().size() == 1) {
                    frm.setPrimaryRole(frm.getRoles(0));
                }
            }
            if (deleteType.equalsIgnoreCase("manager")) {
                frm.setOp1("2");
                this.deleteManager(request, frm);
                return mapping.findForward("displayManagerList");
            }
        }
        try {
            this.lookupManager(frm);
        }
        catch (Exception e) {
            ActionMessages errors2 = new ActionMessages();
            errors2.add("puid", new ActionMessage("errors.generic", (Object)e.getMessage()));
            this.saveErrors(request, errors2);
            this.setupRoles(request, frm);
            return mapping.findForward(mapPath);
        }
        this.setupRoles(request, frm);
        return mapping.findForward(mapPath);
    }

    private void lookupManager(TimetableManagerForm frm) throws Exception {
        String id = frm.getExternalId();
        if (id != null && id.trim().length() > 0 && frm.getLookupEnabled().booleanValue()) {
            String className = ApplicationProperty.ManagerExternalIdLookupClass.value();
            ExternalUidLookup lookup = (ExternalUidLookup)Class.forName(className).newInstance();
            ExternalUidLookup.UserInfo results = lookup.doLookup(id);
            if (results == null) {
                return;
            }
            frm.setExternalId(results.getExternalId());
            frm.setLookupResult(results.getUserName());
            if (frm.getFirstName() == null || frm.getFirstName().trim().length() == 0) {
                frm.setFirstName(results.getFirstName());
            }
            if (frm.getMiddleName() == null || frm.getMiddleName().trim().length() == 0) {
                frm.setMiddleName(results.getMiddleName());
            }
            if (frm.getLastName() == null || frm.getLastName().trim().length() == 0) {
                frm.setLastName(results.getLastName());
            }
            if (frm.getTitle() == null || frm.getTitle().trim().length() == 0) {
                frm.setTitle(results.getAcademicTitle());
            }
            frm.setEmail(results.getEmail());
        }
    }

    private void setupRoles(HttpServletRequest request, TimetableManagerForm frm) {
        Iterator<Roles> i;
        Set<Roles> roles = Roles.findAll(true);
        if (!this.sessionContext.hasPermission(Right.SessionIndependent)) {
            i = roles.iterator();
            while (i.hasNext()) {
                if (!i.next().hasRight(Right.SessionIndependent)) continue;
                i.remove();
            }
        }
        if (frm.getRoleRefs() != null && !frm.getRoleRefs().isEmpty()) {
            i = roles.iterator();
            while (i.hasNext()) {
                if (!frm.getRoleRefs().contains(i.next().getReference())) continue;
                i.remove();
            }
        }
        request.setAttribute(Roles.ROLES_ATTR_NAME, roles);
    }

    private void loadForm(HttpServletRequest request, TimetableManagerForm frm) throws Exception {
        Long mgrId = null;
        String uniqueId = request.getParameter("id");
        if (uniqueId == null || uniqueId.trim().length() == 0) {
            throw new Exception("Manager Id could not be read.");
        }
        try {
            mgrId = new Long(uniqueId);
        }
        catch (Exception e) {
            throw new Exception("Invalid Manager Id : " + uniqueId);
        }
        this.sessionContext.checkPermission(mgrId, "TimetableManager", Right.TimetableManagerEdit);
        frm.setUniqueId(uniqueId);
        TimetableManagerDAO mgrDao = new TimetableManagerDAO();
        TimetableManager mgr = (TimetableManager)mgrDao.get(mgrId);
        frm.setEmail(mgr.getEmailAddress());
        frm.setExternalId(mgr.getExternalUniqueId());
        Set<ManagerRole> rolesSet = mgr.getManagerRoles();
        ArrayList<ManagerRole> roles = new ArrayList<ManagerRole>(rolesSet);
        Collections.sort(roles, new RolesComparator());
        for (ManagerRole mgrRole : roles) {
            Roles role = mgrRole.getRole();
            frm.addToRoles(role);
            if (mgrRole.isPrimary().booleanValue()) {
                frm.setPrimaryRole(role.getRoleId().toString());
            }
            frm.getRoleReceiveEmailFlags().add(mgrRole.isReceiveEmails() == null ? new Boolean(false) : mgrRole.isReceiveEmails());
        }
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        Set<Department> depts = mgr.getDepartments();
        for (Department dept : depts) {
            if (!dept.getSessionId().equals(sessionId)) continue;
            frm.addToDepts(dept);
        }
        for (SolverGroup sg : mgr.getSolverGroups()) {
            if (!sg.getSession().getUniqueId().equals(sessionId)) continue;
            frm.addToSolverGrs(sg);
        }
        if (ApplicationProperty.ManagerExternalIdLookup.isTrue() && ApplicationProperty.ManagerExternalIdLookupClass.value() != null) {
            frm.setLookupEnabled(Boolean.TRUE);
            frm.setFirstName(mgr.getFirstName());
            frm.setMiddleName(mgr.getMiddleName());
            frm.setLastName(mgr.getLastName());
            frm.setTitle(mgr.getAcademicTitle());
        } else {
            frm.setLookupEnabled(Boolean.FALSE);
            frm.setFirstName(mgr.getFirstName());
            frm.setMiddleName(mgr.getMiddleName());
            frm.setLastName(mgr.getLastName());
            frm.setTitle(mgr.getAcademicTitle());
        }
    }

    private void addManager(HttpServletRequest request, TimetableManagerForm frm) throws Exception {
        this.sessionContext.checkPermission(Right.TimetableManagerAdd);
        this.lookupManager(frm);
        TimetableManagerDAO mgrDao = new TimetableManagerDAO();
        RolesDAO rDao = new RolesDAO();
        DepartmentDAO dDao = new DepartmentDAO();
        SolverGroupDAO sgDao = new SolverGroupDAO();
        Session hibSession = mgrDao.getSession();
        Transaction tx = hibSession.beginTransaction();
        TimetableManager mgr = new TimetableManager();
        mgr.setFirstName(frm.getFirstName());
        mgr.setMiddleName(frm.getMiddleName());
        mgr.setLastName(frm.getLastName());
        mgr.setAcademicTitle(frm.getTitle());
        mgr.setExternalUniqueId(frm.getExternalId());
        mgr.setEmailAddress(frm.getEmail());
        List roles = frm.getRoles();
        List roleReceiveEmails = frm.getRoleReceiveEmailFlags();
        Iterator receiveEmailIt = roleReceiveEmails.iterator();
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            Roles role = (Roles)rDao.get(new Long(i.next().toString()));
            ManagerRole mgrRole = new ManagerRole();
            mgrRole.setRole(role);
            mgrRole.setTimetableManager(mgr);
            if (frm.getPrimaryRole().equals(role.getRoleId().toString())) {
                mgrRole.setPrimary(new Boolean(true));
            } else {
                mgrRole.setPrimary(new Boolean(false));
            }
            if (receiveEmailIt.hasNext()) {
                String receiveEmailsStr = (String)receiveEmailIt.next();
                Boolean receiveEmails = new Boolean("on".equalsIgnoreCase(receiveEmailsStr));
                mgrRole.setReceiveEmails(receiveEmails);
            } else {
                mgrRole.setReceiveEmails(new Boolean(false));
            }
            mgr.addTomanagerRoles(mgrRole);
        }
        hibSession.saveOrUpdate((Object)mgr);
        mgr.setDepartments(new HashSet<Department>());
        i = frm.getDepts().iterator();
        while (i.hasNext()) {
            Department dept = (Department)dDao.get(new Long(i.next().toString()));
            mgr.getDepartments().add(dept);
            dept.getTimetableManagers().add(mgr);
            hibSession.saveOrUpdate((Object)dept);
        }
        mgr.setSolverGroups(new HashSet<SolverGroup>());
        i = frm.getSolverGrs().iterator();
        while (i.hasNext()) {
            SolverGroup sg = (SolverGroup)sgDao.get(new Long(i.next().toString()));
            mgr.getSolverGroups().add(sg);
            sg.getTimetableManagers().add(mgr);
            hibSession.saveOrUpdate((Object)sg);
        }
        ChangeLog.addChange(hibSession, this.sessionContext, mgr, ChangeLog.Source.MANAGER_EDIT, ChangeLog.Operation.CREATE, null, null);
        tx.commit();
        if (mgr.getUniqueId() != null) {
            request.setAttribute(Constants.JUMP_TO_ATTR_NAME, (Object)mgr.getUniqueId().toString());
        }
    }

    private void updateManager(HttpServletRequest request, TimetableManagerForm frm) throws Exception {
        boolean found;
        this.sessionContext.checkPermission((Serializable)((Object)frm.getUniqueId()), "TimetableManager", Right.TimetableManagerEdit);
        this.lookupManager(frm);
        TimetableManagerDAO mgrDao = new TimetableManagerDAO();
        RolesDAO rDao = new RolesDAO();
        DepartmentDAO dDao = new DepartmentDAO();
        SolverGroupDAO sgDao = new SolverGroupDAO();
        Long sessionId = this.sessionContext.getUser().getCurrentAcademicSessionId();
        Session hibSession = mgrDao.getSession();
        Transaction tx = hibSession.beginTransaction();
        TimetableManager mgr = (TimetableManager)mgrDao.get(new Long(frm.getUniqueId()));
        mgr.setFirstName(frm.getFirstName());
        mgr.setMiddleName(frm.getMiddleName());
        mgr.setLastName(frm.getLastName());
        mgr.setAcademicTitle(frm.getTitle());
        mgr.setExternalUniqueId(frm.getExternalId());
        mgr.setEmailAddress(frm.getEmail());
        List roles = frm.getRoles();
        List roleReceiveEmails = frm.getRoleReceiveEmailFlags();
        Set<ManagerRole> mgrRoles = mgr.getManagerRoles();
        if (mgrRoles == null) {
            mgrRoles = new HashSet<ManagerRole>();
        }
        Iterator receiveEmailIt = roleReceiveEmails.iterator();
        Iterator i = roles.iterator();
        while (i.hasNext()) {
            Roles role = (Roles)rDao.get(new Long(i.next().toString()));
            Boolean receiveEmail = new Boolean(false);
            if (receiveEmailIt.hasNext()) {
                String str = (String)receiveEmailIt.next();
                str = str == null ? "false" : (str.equalsIgnoreCase("on") ? "true" : str);
                receiveEmail = new Boolean(str);
            }
            found = false;
            for (ManagerRole eMgrRole : mgrRoles) {
                Roles eRole = eMgrRole.getRole();
                if (!eRole.equals(role)) continue;
                if (frm.getPrimaryRole().equals(role.getRoleId().toString())) {
                    eMgrRole.setPrimary(new Boolean(true));
                } else {
                    eMgrRole.setPrimary(new Boolean(false));
                }
                found = true;
                eMgrRole.setReceiveEmails(receiveEmail);
                break;
            }
            if (found) continue;
            ManagerRole mgrRole = new ManagerRole();
            mgrRole.setRole(role);
            mgrRole.setTimetableManager(mgr);
            if (frm.getPrimaryRole().equals(role.getRoleId().toString())) {
                mgrRole.setPrimary(new Boolean(true));
            } else {
                mgrRole.setPrimary(new Boolean(false));
            }
            mgrRole.setReceiveEmails(receiveEmail);
            mgr.addTomanagerRoles(mgrRole);
        }
        Iterator<ManagerRole> j = mgrRoles.iterator();
        while (j.hasNext()) {
            ManagerRole eMgrRole = j.next();
            Roles eRole = eMgrRole.getRole();
            found = false;
            Iterator i2 = roles.iterator();
            while (i2.hasNext()) {
                Roles role = (Roles)rDao.get(new Long(i2.next().toString()));
                if (!eRole.equals(role)) continue;
                found = true;
                break;
            }
            if (found) continue;
            j.remove();
        }
        List depts = frm.getDepts();
        Set<Department> mgrDepts = mgr.getDepartments();
        if (mgrDepts == null) {
            mgrDepts = new HashSet<Department>();
            mgr.setDepartments(mgrDepts);
        }
        Iterator i3 = depts.iterator();
        while (i3.hasNext()) {
            Department dept = (Department)dDao.get(new Long(i3.next().toString()));
            boolean found2 = false;
            for (Department eDept : mgrDepts) {
                if (!eDept.equals(dept)) continue;
                found2 = true;
                break;
            }
            if (found2) continue;
            mgrDepts.add(dept);
            dept.getTimetableManagers().add(mgr);
            hibSession.saveOrUpdate((Object)dept);
        }
        Iterator<Department> j2 = mgrDepts.iterator();
        while (j2.hasNext()) {
            Department eDept = j2.next();
            if (!eDept.getSessionId().equals(sessionId)) continue;
            boolean found3 = false;
            Iterator i4 = depts.iterator();
            while (i4.hasNext()) {
                Department dept = (Department)dDao.get(new Long(i4.next().toString()));
                if (!eDept.equals(dept)) continue;
                found3 = true;
                break;
            }
            if (found3) continue;
            j2.remove();
            eDept.getTimetableManagers().remove(mgr);
            hibSession.saveOrUpdate((Object)eDept);
        }
        List solverGrs = frm.getSolverGrs();
        Set<SolverGroup> mgrSolverGrs = mgr.getSolverGroups();
        if (mgrSolverGrs == null) {
            mgrSolverGrs = new HashSet<SolverGroup>();
            mgr.setSolverGroups(mgrSolverGrs);
        }
        Iterator i5 = solverGrs.iterator();
        while (i5.hasNext()) {
            SolverGroup sg = (SolverGroup)sgDao.get(new Long(i5.next().toString()));
            boolean found4 = false;
            for (SolverGroup eSg : mgrSolverGrs) {
                if (!eSg.equals(sg)) continue;
                found4 = true;
                break;
            }
            if (found4) continue;
            mgrSolverGrs.add(sg);
            sg.getTimetableManagers().add(mgr);
            hibSession.saveOrUpdate((Object)sg);
        }
        Iterator<SolverGroup> j3 = mgrSolverGrs.iterator();
        while (j3.hasNext()) {
            SolverGroup eSg = j3.next();
            if (!eSg.getSession().getUniqueId().equals(sessionId)) continue;
            boolean found5 = false;
            Iterator i6 = solverGrs.iterator();
            while (i6.hasNext()) {
                SolverGroup sg = (SolverGroup)sgDao.get(new Long(i6.next().toString()));
                if (!eSg.equals(sg)) continue;
                found5 = true;
                break;
            }
            if (found5) continue;
            j3.remove();
            eSg.getTimetableManagers().remove(mgr);
            hibSession.saveOrUpdate((Object)eSg);
        }
        hibSession.saveOrUpdate((Object)mgr);
        ChangeLog.addChange(hibSession, this.sessionContext, mgr, ChangeLog.Source.MANAGER_EDIT, ChangeLog.Operation.UPDATE, null, null);
        tx.commit();
        if (mgr.getUniqueId() != null) {
            request.setAttribute(Constants.JUMP_TO_ATTR_NAME, (Object)mgr.getUniqueId().toString());
        }
    }

    private void deleteManager(HttpServletRequest request, TimetableManagerForm frm) {
        this.sessionContext.checkPermission((Serializable)((Object)frm.getUniqueId()), "TimetableManager", Right.TimetableManagerEdit);
        TimetableManagerDAO mgrDao = new TimetableManagerDAO();
        Session hibSession = mgrDao.getSession();
        TimetableManager mgr = (TimetableManager)mgrDao.get(new Long(frm.getUniqueId()));
        Transaction tx = hibSession.beginTransaction();
        ChangeLog.addChange(hibSession, this.sessionContext, mgr, ChangeLog.Source.MANAGER_EDIT, ChangeLog.Operation.DELETE, null, null);
        Set<ManagerRole> mgrRoles = mgr.getManagerRoles();
        for (ManagerRole mgrRole : mgrRoles) {
            hibSession.delete((Object)mgrRole);
        }
        for (Department d : mgr.getDepartments()) {
            d.getTimetableManagers().remove(mgr);
            hibSession.saveOrUpdate((Object)d);
        }
        for (SolverGroup sg : mgr.getSolverGroups()) {
            sg.getTimetableManagers().remove(mgr);
            hibSession.saveOrUpdate((Object)sg);
        }
        hibSession.delete((Object)mgr);
        tx.commit();
    }
}

