/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.form.RollForwardSessionForm;
import org.unitime.timetable.gwt.command.server.GwtRpcServlet;
import org.unitime.timetable.gwt.shared.ReservationInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.SessionRollForward;
import org.unitime.timetable.util.queue.QueueItem;
import org.unitime.timetable.util.queue.QueueProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="/rollForwardSession")
public class RollForwardSessionAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    ApplicationContext applicationContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebTable table;
        MessageResources rsc = this.getResources(request);
        RollForwardSessionForm rollForwardSessionForm = (RollForwardSessionForm)form;
        String op = request.getParameter("op");
        if (op != null && op.equals(rsc.getMessage("button.rollForward"))) {
            this.sessionContext.checkPermission(Right.SessionRollForward);
            ActionErrors errors = rollForwardSessionForm.validate(mapping, request);
            if (errors.isEmpty()) {
                QueueProcessor.getInstance().add(new RollForwardQueueItem((Session)SessionDAO.getInstance().get(rollForwardSessionForm.getSessionToRollForwardTo()), this.sessionContext.getUser(), (RollForwardSessionForm)((Object)rollForwardSessionForm.clone())));
            } else {
                this.saveErrors(request, (ActionMessages)errors);
            }
        }
        if (request.getParameter("remove") != null) {
            QueueProcessor.getInstance().remove(Long.valueOf(request.getParameter("remove")));
        }
        if ((table = this.getQueueTable(request, rollForwardSessionForm)) != null) {
            request.setAttribute("table", (Object)table.printTable(WebTable.getOrder(this.sessionContext, "rollForwardSession.ord")));
        }
        this.setToFromSessionsInForm(rollForwardSessionForm);
        rollForwardSessionForm.setSubjectAreas(this.getSubjectAreas(rollForwardSessionForm.getSessionToRollForwardTo()));
        rollForwardSessionForm.setDepartments(this.getDepartments(rollForwardSessionForm.getSessionToRollForwardTo()));
        if (op == null) {
            this.setExpirationDates(rollForwardSessionForm);
        }
        if (rollForwardSessionForm.getSubpartLocationPrefsAction() == null) {
            rollForwardSessionForm.setSubpartLocationPrefsAction(SessionRollForward.ROLL_PREFS_ACTION);
        }
        if (rollForwardSessionForm.getSubpartTimePrefsAction() == null) {
            rollForwardSessionForm.setSubpartTimePrefsAction(SessionRollForward.ROLL_PREFS_ACTION);
        }
        if (rollForwardSessionForm.getClassPrefsAction() == null) {
            rollForwardSessionForm.setClassPrefsAction(SessionRollForward.DO_NOT_ROLL_ACTION);
        }
        if (rollForwardSessionForm.getCancelledClassAction() == null) {
            rollForwardSessionForm.setCancelledClassAction(SessionRollForward.CancelledClassAction.REOPEN.name());
        }
        if (rollForwardSessionForm.getMidtermExamsPrefsAction() == null) {
            rollForwardSessionForm.setMidtermExamsPrefsAction(SessionRollForward.EXAMS_ROOM_PREFS);
        }
        if (rollForwardSessionForm.getFinalExamsPrefsAction() == null) {
            rollForwardSessionForm.setFinalExamsPrefsAction(SessionRollForward.EXAMS_ROOM_PREFS);
        }
        return mapping.findForward("displayRollForwardSessionForm");
    }

    private WebTable getQueueTable(HttpServletRequest request, RollForwardSessionForm form) {
        WebTable.setOrder(this.sessionContext, "rollForwardSession.ord", request.getParameter("ord"), 1);
        String log = request.getParameter("log");
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        List<QueueItem> queue = QueueProcessor.getInstance().getItems(null, null, "Roll Forward");
        if (queue.isEmpty()) {
            return null;
        }
        WebTable table = new WebTable(9, null, "rollForwardSession.do?ord=%%", new String[]{"Name", "Status", "Progress", "Owner", "Session", "Created", "Started", "Finished", "Output"}, new String[]{"left", "left", "right", "left", "left", "left", "left", "left", "center"}, new boolean[]{true, true, true, true, true, true, true, true, true});
        Date now = new Date();
        long timeToShow = 86400000L;
        for (QueueItem item : queue) {
            if (item.finished() != null && now.getTime() - item.finished().getTime() > timeToShow || item.getSession() == null) continue;
            String name = item.name();
            if (name.length() > 60) {
                name = name.substring(0, 57) + "...";
            }
            String delete = null;
            if (this.sessionContext.getUser().getExternalUserId().equals(item.getOwnerId()) && (item.started() == null || item.finished() != null)) {
                delete = "<img src='images/action_delete.png' border='0' onClick=\"if (confirm('Do you really want to remove this roll forward?')) document.location='rollForwardSession.do?remove=" + item.getId() + "'; event.cancelBubble=true;\">";
            }
            WebTable.WebTableLine line = table.addLine("onClick=\"document.location='rollForwardSession.do?log=" + item.getId() + "';\"", new String[]{name + (delete == null ? "" : " " + delete), item.status(), item.progress() <= 0.0 || item.progress() >= 1.0 ? "" : String.valueOf(Math.round(100.0 * item.progress())) + "%", item.getOwnerName(), item.getSession().getLabel(), df.format(item.created()), item.started() == null ? "" : df.format(item.started()), item.finished() == null ? "" : df.format(item.finished()), item.output() == null ? "" : "<A href='temp/" + item.output().getName() + "'>" + item.output().getName().substring(item.output().getName().lastIndexOf(46) + 1).toUpperCase() + "</A>"}, new Comparable[]{item.getId(), item.status(), Double.valueOf(item.progress()), item.getOwnerName(), item.getSession(), Long.valueOf(item.created().getTime()), Long.valueOf(item.started() == null ? Long.MAX_VALUE : item.started().getTime()), Long.valueOf(item.finished() == null ? Long.MAX_VALUE : item.finished().getTime()), null});
            if (log == null || !log.equals(item.getId().toString())) continue;
            request.setAttribute("logname", (Object)name);
            request.setAttribute("logid", (Object)item.getId().toString());
            request.setAttribute("log", (Object)item.log());
            ((RollForwardQueueItem)item).getForm().copyTo(form);
            this.saveErrors(request, ((RollForwardQueueItem)item).getErrors());
            line.setBgColor("rgb(168,187,225)");
        }
        return table;
    }

    protected void setToFromSessionsInForm(RollForwardSessionForm rollForwardSessionForm) {
        ArrayList<Session> sessionList = new ArrayList<Session>();
        sessionList.addAll(Session.getAllSessions());
        rollForwardSessionForm.setFromSessions(new ArrayList<Session>());
        rollForwardSessionForm.setToSessions(new ArrayList<Session>());
        Session session = null;
        for (int i = sessionList.size() - 1; i >= 0; --i) {
            session = (Session)sessionList.get(i);
            if (session.getStatusType().isAllowRollForward()) {
                rollForwardSessionForm.getToSessions().add(session);
                if (rollForwardSessionForm.getSessionToRollForwardTo() != null) continue;
                rollForwardSessionForm.setSessionToRollForwardTo(session.getUniqueId());
                continue;
            }
            rollForwardSessionForm.getFromSessions().add(session);
        }
    }

    protected Set<SubjectArea> getSubjectAreas(Long selectedSessionId) {
        Set<SubjectArea> subjects = new TreeSet<SubjectArea>();
        Session session = null;
        if (selectedSessionId == null) {
            boolean found = false;
            TreeSet<Session> allSessions = Session.getAllSessions();
            ArrayList<Session> sessionList = new ArrayList<Session>();
            sessionList.addAll(Session.getAllSessions());
            for (int i = sessionList.size() - 1; i >= 0; --i) {
                session = (Session)sessionList.get(i);
                if (!session.getStatusType().isAllowRollForward()) continue;
                found = true;
            }
            if (!found) {
                session = null;
                if (allSessions.size() > 0) {
                    session = allSessions.last();
                }
            }
        } else {
            session = Session.getSessionById(selectedSessionId);
        }
        if (session != null) {
            subjects = session.getSubjectAreas();
        }
        return subjects;
    }

    protected Set<Department> getDepartments(Long selectedSessionId) {
        Set<Department> departments = new TreeSet<Department>();
        Session session = null;
        if (selectedSessionId == null) {
            boolean found = false;
            TreeSet<Session> allSessions = Session.getAllSessions();
            ArrayList<Session> sessionList = new ArrayList<Session>();
            sessionList.addAll(Session.getAllSessions());
            for (int i = sessionList.size() - 1; i >= 0; --i) {
                session = (Session)sessionList.get(i);
                if (!session.getStatusType().isAllowRollForward()) continue;
                found = true;
            }
            if (!found) {
                session = null;
                if (allSessions.size() > 0) {
                    session = allSessions.last();
                }
            }
        } else {
            session = Session.getSessionById(selectedSessionId);
        }
        if (session != null) {
            departments = session.getDepartments();
        }
        return departments;
    }

    protected void setExpirationDates(RollForwardSessionForm form) {
        if (form.getSessionToRollForwardTo() != null) {
            ReservationInterface.DefaultExpirationDates dates = GwtRpcServlet.execute(new ReservationInterface.ReservationDefaultExpirationDatesRpcRequest(form.getSessionToRollForwardTo()), this.applicationContext, this.sessionContext);
            if (dates != null) {
                Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_ENTRY_FORMAT);
                form.setExpirationCourseReservations(dates.hasExpirationDate("course") ? df.format(dates.getExpirationDate("course")) : null);
                form.setExpirationCurriculumReservations(dates.hasExpirationDate("curriculum") ? df.format(dates.getExpirationDate("curriculum")) : null);
                form.setExpirationGroupReservations(dates.hasExpirationDate("group") ? df.format(dates.getExpirationDate("group")) : null);
            }
        } else {
            form.setExpirationCourseReservations(null);
            form.setExpirationCurriculumReservations(null);
            form.setExpirationGroupReservations(null);
        }
    }

    private class RollForwardQueueItem
    extends QueueItem {
        private RollForwardSessionForm iForm;
        private int iProgress;
        private ActionErrors iErrors;

        public RollForwardQueueItem(Session session, UserContext owner, RollForwardSessionForm form) {
            super(session, owner);
            this.iProgress = 0;
            this.iErrors = new ActionErrors();
            this.iForm = form;
        }

        public ActionMessages getErrors() {
            return this.iErrors;
        }

        public RollForwardSessionForm getForm() {
            return this.iForm;
        }

        protected void execute() throws Exception {
            SessionRollForward sessionRollForward = new SessionRollForward(this);
            Session toAcadSession = Session.getSessionById(this.iForm.getSessionToRollForwardTo());
            if (toAcadSession == null) {
                this.iErrors.add("mustSelectSession", new ActionMessage("errors.rollForward.missingToSession"));
            }
            if (this.iErrors.isEmpty()) {
                this.iForm.validateDepartmentRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardDepartments().booleanValue()) {
                this.setStatus("Departments ...");
                sessionRollForward.rollDepartmentsForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateCurriculaRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardSessionConfig().booleanValue()) {
                this.setStatus("Session Configuration ...");
                sessionRollForward.rollSessionConfigurationForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateManagerRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardManagers().booleanValue()) {
                this.setStatus("Managers ...");
                sessionRollForward.rollManagersForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateBuildingAndRoomRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardRoomData().booleanValue()) {
                this.setStatus("Rooms ...");
                sessionRollForward.rollBuildingAndRoomDataForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateDatePatternRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardDatePatterns().booleanValue()) {
                this.setStatus("Date patterns ...");
                sessionRollForward.rollDatePatternsForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateTimePatternRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardTimePatterns().booleanValue()) {
                this.setStatus("Time patterns ...");
                sessionRollForward.rollTimePatternsForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateSubjectAreaRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardSubjectAreas().booleanValue()) {
                this.setStatus("Subjects ...");
                sessionRollForward.rollSubjectAreasForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardInstructorData().booleanValue()) {
                this.setStatus("Instructors ...");
                sessionRollForward.rollInstructorDataForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateCourseOfferingRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardCourseOfferings().booleanValue()) {
                this.setStatus("Courses ...");
                sessionRollForward.rollCourseOfferingsForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateClassInstructorRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardClassInstructors().booleanValue()) {
                this.setStatus("Class instructors ...");
                sessionRollForward.rollClassInstructorsForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getAddNewCourseOfferings().booleanValue()) {
                this.setStatus("New courses ...");
                sessionRollForward.addNewCourseOfferings((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateExamConfigurationRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardExamConfiguration().booleanValue()) {
                this.setStatus("Exam config ...");
                sessionRollForward.rollExamConfigurationDataForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateMidtermExamRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardMidtermExams().booleanValue()) {
                this.setStatus("Midterm exams ...");
                sessionRollForward.rollMidtermExamsForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateFinalExamRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardFinalExams().booleanValue()) {
                this.setStatus("Final exams ...");
                sessionRollForward.rollFinalExamsForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateLastLikeDemandRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardStudents().booleanValue()) {
                this.setStatus("Students ...");
                sessionRollForward.rollStudentsForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty()) {
                this.iForm.validateCurriculaRollForward(toAcadSession, this.iErrors);
            }
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardCurricula().booleanValue()) {
                this.setStatus("Curricula ...");
                sessionRollForward.rollCurriculaForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (this.iErrors.isEmpty() && this.iForm.getRollForwardReservations()) {
                this.setStatus("Reservations ...");
                sessionRollForward.rollReservationsForward((ActionMessages)this.iErrors, this.iForm);
            }
            ++this.iProgress;
            if (!this.iErrors.isEmpty()) {
                this.setError(new Exception(((ActionMessage)this.iErrors.get().next()).getValues()[0].toString()));
            } else {
                this.log("All done.");
            }
        }

        public String name() {
            String name;
            ArrayList<String> names = new ArrayList<String>();
            if (this.iForm.getRollForwardDepartments().booleanValue()) {
                names.add("departments");
            }
            if (this.iForm.getRollForwardSessionConfig().booleanValue()) {
                names.add("configuration");
            }
            if (this.iForm.getRollForwardManagers().booleanValue()) {
                names.add("managers");
            }
            if (this.iForm.getRollForwardRoomData().booleanValue()) {
                names.add("rooms");
            }
            if (this.iForm.getRollForwardDatePatterns().booleanValue()) {
                names.add("date patterns");
            }
            if (this.iForm.getRollForwardTimePatterns().booleanValue()) {
                names.add("time patterns");
            }
            if (this.iForm.getRollForwardSubjectAreas().booleanValue()) {
                names.add("subjects");
            }
            if (this.iForm.getRollForwardInstructorData().booleanValue()) {
                names.add("instructors");
            }
            if (this.iForm.getRollForwardCourseOfferings().booleanValue()) {
                names.add("courses");
            }
            if (this.iForm.getRollForwardClassInstructors().booleanValue()) {
                names.add("class instructors");
            }
            if (this.iForm.getAddNewCourseOfferings().booleanValue()) {
                names.add("new courses");
            }
            if (this.iForm.getRollForwardExamConfiguration().booleanValue()) {
                names.add("exam config");
            }
            if (this.iForm.getRollForwardMidtermExams().booleanValue()) {
                names.add("midterm exams");
            }
            if (this.iForm.getRollForwardFinalExams().booleanValue()) {
                names.add("final exams");
            }
            if (this.iForm.getRollForwardStudents().booleanValue()) {
                names.add("students");
            }
            if (this.iForm.getRollForwardCurricula().booleanValue()) {
                names.add("curricula");
            }
            if (this.iForm.getRollForwardReservations()) {
                names.add("reservations");
            }
            if ((name = ((Object)names).toString().replace("[", "").replace("]", "")).length() > 50) {
                name = name.substring(0, 47) + "...";
            }
            return name;
        }

        public double progress() {
            return 100 * this.iProgress / 14;
        }

        public String type() {
            return "Roll Forward";
        }
    }
}

