/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.SuggestionsAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ExamEditForm;
import org.unitime.timetable.form.InstructionalOfferingListForm;
import org.unitime.timetable.form.PreferencesForm;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DatePatternPref;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.DistributionType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeature;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.base.BaseExamPeriodPref;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.DatePatternDAO;
import org.unitime.timetable.model.dao.DistributionTypeDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.model.dao.RoomFeatureDAO;
import org.unitime.timetable.model.dao.RoomGroupDAO;
import org.unitime.timetable.model.dao.SchedulingSubpartDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.TimePatternDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.rooms.PeriodPreferencesBackend;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.interactive.ClassAssignmentDetails;
import org.unitime.timetable.solver.service.AssignmentService;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.duration.DurationModel;
import org.unitime.timetable.webutil.RequiredTimeTable;

public class PreferencesAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<SolverProxy> courseTimetablingSolverService;
    @Autowired
    AssignmentService<ClassAssignmentProxy> classAssignmentService;
    public static final String TIME_PATTERN_GRID_ATTR = "timePatternGrid";
    public static final String HASH_ATTR = "hash";
    public final String HASH_TIME_PREF = "TimePref";
    public final String HASH_RM_GROUP = "RoomGroupPref";
    public final String HASH_RM_PREF = "RoomPref";
    public final String HASH_RM_FEAT_PREF = "RoomFeatPref";
    public final String HASH_BLDG_PREF = "BldgPref";
    public final String HASH_DIST_PREF = "DistPref";
    public final String HASH_PERIOD_PREF = "PeriodPref";
    public final String HASH_DATE_PATTERN_PREF = "DatePatternPref";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        LookupTables.setupItypes(request, true);
        LookupTables.setupPrefLevels(request);
        return mapping.findForward(mapping.getInput());
    }

    protected void processPrefAction(HttpServletRequest request, PreferencesForm frm, ActionMessages errors) {
        String op = frm.getOp();
        if (op == null) {
            return;
        }
        if (op.equals(MSG.actionAddRoomGroupPreference())) {
            this.addRoomGroup(request, frm, errors);
        }
        if (op.equals(MSG.actionAddRoomPreference())) {
            this.addRoomPref(request, frm, errors);
        }
        if (op.equals(MSG.actionAddBuildingPreference())) {
            this.addBldgPref(request, frm, errors);
        }
        if (op.equals(MSG.actionAddDistributionPreference())) {
            this.addDistPref(request, frm, errors);
        }
        if (op.equals(MSG.actionAddRoomFeaturePreference())) {
            this.addRoomFeatPref(request, frm, errors);
        }
        if (op.equals(MSG.actionAddTimePreference())) {
            this.addTimePattern(request, frm, errors);
        }
        if (op.equals(MSG.actionRemoveBuildingPreference()) || op.equals(MSG.actionRemoveDistributionPreference()) || op.equals(MSG.actionRemoveRoomFeaturePreference()) || op.equals(MSG.actionRemoveRoomGroupPreference()) || op.equals(MSG.actionRemoveRoomPreference()) || op.equals(MSG.actionRemoveTimePattern()) || op.equals(MSG.actionRemoveInstructor())) {
            this.doDelete(request, frm);
        }
    }

    private void addRoomGroup(HttpServletRequest request, PreferencesForm frm, ActionMessages errors) {
        List lst = frm.getRoomGroups();
        if (frm.checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                frm.addToRoomGroups("-", "-");
            }
            request.setAttribute(HASH_ATTR, (Object)"RoomGroupPref");
        } else {
            errors.add("roomGroup", new ActionMessage("errors.generic", (Object)MSG.errorInvalidRoomGroup()));
            this.saveErrors(request, errors);
        }
    }

    protected void addBldgPref(HttpServletRequest request, PreferencesForm frm, ActionMessages errors) {
        List lst = frm.getBldgPrefs();
        if (frm.checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                frm.addToBldgPrefs("-", "-");
            }
            request.setAttribute(HASH_ATTR, (Object)"BldgPref");
        } else {
            errors.add("bldgPrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidBuildingPreference()));
            this.saveErrors(request, errors);
        }
    }

    protected void addDistPref(HttpServletRequest request, PreferencesForm frm, ActionMessages errors) {
        List lst = frm.getDistPrefs();
        if (frm.checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                frm.addToDistPrefs("-", "-");
            }
            request.setAttribute(HASH_ATTR, (Object)"DistPref");
        } else {
            errors.add("distPrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidDistributionPreference()));
            this.saveErrors(request, errors);
        }
    }

    protected void addRoomFeatPref(HttpServletRequest request, PreferencesForm frm, ActionMessages errors) {
        List lst = frm.getRoomFeaturePrefs();
        if (frm.checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                frm.addToRoomFeatPrefs("-", "-");
            }
            request.setAttribute(HASH_ATTR, (Object)"RoomFeatPref");
        } else {
            errors.add("roomFeaturePrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidRoomFeaturePreference()));
            this.saveErrors(request, errors);
        }
    }

    protected void addTimePattern(HttpServletRequest request, PreferencesForm frm, ActionMessages errors) {
        if ("-".equals(frm.getTimePattern())) {
            errors.add("timePrefs", new ActionMessage("errors.generic", (Object)MSG.errorTimePatternNotSelected()));
            this.saveErrors(request, errors);
        } else {
            if (frm.getTimePatterns() == null) {
                frm.setTimePatterns(new Vector());
            }
            frm.getTimePatterns().add(frm.getTimePattern());
            TimePattern tp = (TimePattern)new TimePatternDAO().get(Long.valueOf(frm.getTimePattern()));
            if (tp.getTimePatternModel().isExactTime()) {
                Iterator i = frm.getTimePatterns().iterator();
                while (i.hasNext()) {
                    String patternId = (String)i.next();
                    TimePattern tpx = (TimePattern)new TimePatternDAO().get(Long.valueOf(patternId));
                    if (tpx.getTimePatternModel().isExactTime()) continue;
                    i.remove();
                }
            } else {
                Iterator i = frm.getTimePatterns().iterator();
                while (i.hasNext()) {
                    String patternId = (String)i.next();
                    TimePattern tpx = (TimePattern)new TimePatternDAO().get(Long.valueOf(patternId));
                    if (!tpx.getTimePatternModel().isExactTime()) continue;
                    i.remove();
                }
            }
            request.setAttribute(HASH_ATTR, (Object)"TimePref");
        }
    }

    protected void addRoomPref(HttpServletRequest request, PreferencesForm frm, ActionMessages errors) {
        List lst = frm.getRoomPrefs();
        if (frm.checkPrefs(lst)) {
            for (int i = 0; i < 2; ++i) {
                frm.addToRoomPrefs("-", "-");
            }
            request.setAttribute(HASH_ATTR, (Object)"RoomPref");
        } else {
            errors.add("roomPrefs", new ActionMessage("errors.generic", (Object)MSG.errorInvalidRoomPreference()));
            this.saveErrors(request, errors);
        }
    }

    protected void doCancel(HttpServletRequest request, String subpartId) {
        SchedulingSubpartDAO sdao = new SchedulingSubpartDAO();
        SchedulingSubpart ss = (SchedulingSubpart)sdao.get(new Long(subpartId));
        InstructionalOffering io = ss.getInstrOfferingConfig().getInstructionalOffering();
        CourseOffering co = io.getControllingCourseOffering();
        InstructionalOfferingListForm frm2 = new InstructionalOfferingListForm();
        frm2.setSubjectAreaIds(new String[]{co.getSubjectArea().getUniqueId().toString()});
        frm2.setSubjectAreaAbbv(co.getSubjectAreaAbbv());
        frm2.setCourseNbr(co.getCourseNbr());
        frm2.setCtrlInstrOfferingId(io.getCtrlCourseId().toString());
        frm2.setIsControl(co.isIsControl());
        request.setAttribute("subjectAreaId", (Object)co.getSubjectArea().getUniqueId().toString());
        request.setAttribute("instructionalOfferingListForm", (Object)frm2);
    }

    protected void doDelete(HttpServletRequest request, PreferencesForm frm) {
        String deleteType = request.getParameter("deleteType");
        int deleteId = -1;
        try {
            deleteId = Integer.parseInt(request.getParameter("deleteId"));
        }
        catch (Exception e) {
            deleteId = -1;
        }
        if (deleteType != null && deleteId >= 0) {
            List lstL;
            List lst;
            if (deleteType.equals("roomPref")) {
                lst = frm.getRoomPrefs();
                lstL = frm.getRoomPrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                frm.setRoomPrefs(lst);
                frm.setRoomPrefLevels(lstL);
                request.setAttribute(HASH_ATTR, (Object)"RoomPref");
            }
            if (deleteType.equals("rgPref")) {
                lst = frm.getRoomGroups();
                lstL = frm.getRoomGroupLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                frm.setRoomGroups(lst);
                frm.setRoomGroupLevels(lstL);
                request.setAttribute(HASH_ATTR, (Object)"RoomGroupPref");
            }
            if (deleteType.equals("bldgPref")) {
                lst = frm.getBldgPrefs();
                lstL = frm.getBldgPrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                frm.setBldgPrefs(lst);
                frm.setBldgPrefLevels(lstL);
                request.setAttribute(HASH_ATTR, (Object)"BldgPref");
            }
            if (deleteType.equals("distPref")) {
                lst = frm.getDistPrefs();
                lstL = frm.getDistPrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                frm.setDistPrefs(lst);
                frm.setDistPrefLevels(lstL);
                request.setAttribute(HASH_ATTR, (Object)"DistPref");
            }
            if (deleteType.equals("roomFeaturePref")) {
                lst = frm.getRoomFeaturePrefs();
                lstL = frm.getRoomFeaturePrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                frm.setRoomFeaturePrefs(lst);
                frm.setRoomFeaturePrefLevels(lstL);
                request.setAttribute(HASH_ATTR, (Object)"RoomFeatPref");
            }
            if (deleteType.equals("timePattern")) {
                List tps = frm.getTimePatterns();
                tps.remove(deleteId);
                frm.setTimePatterns(tps);
                request.setAttribute(HASH_ATTR, (Object)"TimePref");
            }
            if (deleteType.equals("dpPref")) {
                lst = frm.getDatePatternPrefs();
                lstL = frm.getDatePatternPrefLevels();
                lst.remove(deleteId);
                lstL.remove(deleteId);
                frm.setDatePatternPrefs(lst);
                frm.setDatePatternPrefLevels(lstL);
                request.setAttribute(HASH_ATTR, (Object)"RoomGroupPref");
            }
        }
    }

    protected void doUpdate(HttpServletRequest request, PreferencesForm frm, PreferenceGroup pg, Set s, boolean timeVertical) throws Exception {
        Preference p;
        String pref;
        String id;
        pg.setPreferences(s);
        if (pg instanceof DepartmentalInstructor) {
            if (frm.getAvailability() != null && (frm.getAvailability().length() == 336 || frm.getAvailability().length() == 2016)) {
                TimePref tp = new TimePref();
                tp.setOwner(pg);
                tp.setPreference(frm.getAvailability());
                tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                tp.setTimePattern(null);
                s.add(tp);
            }
        } else {
            Set parentTimePrefs = pg.effectivePreferences(TimePref.class, false);
            List lst = frm.getTimePatterns();
            for (int i = 0; i < lst.size(); ++i) {
                String id2 = (String)lst.get(i);
                this.addToTimePref(request, pg, id2, s, i, timeVertical, parentTimePrefs);
            }
            if (parentTimePrefs != null && !parentTimePrefs.isEmpty()) {
                Iterator i = parentTimePrefs.iterator();
                while (i.hasNext()) {
                    TimePref tp = (TimePref)((TimePref)i.next()).clone();
                    tp.setOwner(pg);
                    tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                    s.add(tp);
                }
            }
        }
        List lst = frm.getRoomPrefs();
        List lstL = frm.getRoomPrefLevels();
        Set parentRoomPrefs = pg.effectivePreferences(RoomPref.class);
        for (int i = 0; i < lst.size(); ++i) {
            String id3 = (String)lst.get(i);
            if (id3 == null || id3.equals("-")) continue;
            String pref2 = (String)lstL.get(i);
            Debug.debug("Room: " + id3 + ": " + pref2);
            LocationDAO rdao = new LocationDAO();
            Location room = (Location)rdao.get(new Long(id3));
            RoomPref rp = new RoomPref();
            rp.setOwner(pg);
            rp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref2)));
            rp.setRoom(room);
            RoomPref sameParentRp = null;
            Iterator j = parentRoomPrefs.iterator();
            while (j.hasNext()) {
                RoomPref p2 = (RoomPref)j.next();
                if (!p2.isSame(rp)) continue;
                if (p2.getPrefLevel().equals(rp.getPrefLevel())) {
                    sameParentRp = rp;
                }
                j.remove();
                break;
            }
            if (sameParentRp != null) continue;
            s.add(rp);
        }
        if (parentRoomPrefs != null && !parentRoomPrefs.isEmpty()) {
            Iterator i = parentRoomPrefs.iterator();
            while (i.hasNext()) {
                RoomPref rp = (RoomPref)((RoomPref)i.next()).clone();
                rp.setOwner(pg);
                rp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                s.add(rp);
            }
        }
        lst = frm.getBldgPrefs();
        lstL = frm.getBldgPrefLevels();
        Set parentBuildingPrefs = pg.effectivePreferences(BuildingPref.class);
        for (int i = 0; i < lst.size(); ++i) {
            id = (String)lst.get(i);
            if (id == null || id.equals("-")) continue;
            pref = (String)lstL.get(i);
            Debug.debug("Bldg: " + id + ": " + pref);
            BuildingDAO bdao = new BuildingDAO();
            Building bldg = (Building)bdao.get(new Long(id));
            BuildingPref bp = new BuildingPref();
            bp.setOwner(pg);
            bp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref)));
            bp.setBuilding(bldg);
            BuildingPref sameParentBp = null;
            Iterator j = parentBuildingPrefs.iterator();
            while (j.hasNext()) {
                p = (BuildingPref)j.next();
                if (!((BuildingPref)p).isSame(bp)) continue;
                if (p.getPrefLevel().equals(bp.getPrefLevel())) {
                    sameParentBp = bp;
                }
                j.remove();
                break;
            }
            if (sameParentBp != null) continue;
            s.add(bp);
        }
        if (parentBuildingPrefs != null && !parentBuildingPrefs.isEmpty()) {
            Iterator i = parentBuildingPrefs.iterator();
            while (i.hasNext()) {
                BuildingPref bp = (BuildingPref)((BuildingPref)i.next()).clone();
                bp.setOwner(pg);
                bp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                s.add(bp);
            }
        }
        lst = frm.getDistPrefs();
        lstL = frm.getDistPrefLevels();
        for (int i = 0; i < lst.size(); ++i) {
            id = (String)lst.get(i);
            if (id == null || id.equals("-")) continue;
            pref = (String)lstL.get(i);
            Debug.debug("Dist: " + id + ": " + pref);
            DistributionTypeDAO ddao = new DistributionTypeDAO();
            DistributionType dist = (DistributionType)ddao.get(new Long(id));
            DistributionPref dp = new DistributionPref();
            dp.setOwner(pg);
            dp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref)));
            dp.setDistributionType(dist);
            dp.setStructure(DistributionPref.Structure.AllClasses);
            s.add(dp);
        }
        if (pg instanceof Exam) {
            Exam exam = (Exam)pg;
            if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
                ExamSolverProxy solver = WebSolver.getExamSolver(request.getSession());
                ExamAssignment assignment = null;
                if (solver != null && exam != null && exam.getUniqueId() != null) {
                    assignment = solver.getAssignment(exam.getUniqueId());
                } else if (exam.getAssignedPeriod() != null) {
                    assignment = new ExamAssignment(exam);
                }
                if (1 == exam.getExamType().getType()) {
                    MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(exam.getSession(), exam.getExamType(), assignment);
                    epx.load(exam);
                    epx.load(request);
                    epx.save(s, exam);
                } else {
                    PeriodPreferenceModel px = new PeriodPreferenceModel(exam.getSession(), assignment, exam.getExamType().getUniqueId());
                    px.load(exam);
                    RequiredTimeTable rtt = new RequiredTimeTable(px);
                    rtt.setName("PeriodPref");
                    rtt.update((ServletRequest)request);
                    px.save(s, exam);
                }
            } else {
                String pattern = request.getParameter("periodPrefs");
                if (pattern.indexOf(58) >= 0) {
                    pattern = pattern.substring(pattern.lastIndexOf(58) + 1);
                }
                int idx = 0;
                String defaultPref = exam.getExamType().getType() == 1 ? PreferenceLevel.sProhibited : PreferenceLevel.sNeutral;
                for (ExamPeriod period : ExamPeriod.findAll(exam.getSession().getUniqueId(), exam.getExamType().getUniqueId())) {
                    String pref3;
                    char ch = exam.getExamType().getType() == 1 ? (char)'P' : '2';
                    try {
                        ch = pattern.charAt(idx++);
                    }
                    catch (IndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    if (defaultPref.equals(pref3 = PreferenceLevel.char2prolog(ch))) continue;
                    p = new ExamPeriodPref();
                    p.setOwner(pg);
                    ((BaseExamPeriodPref)p).setExamPeriod(period);
                    p.setPrefLevel(PreferenceLevel.getPreferenceLevel(pref3));
                    s.add(p);
                }
            }
        }
        lst = frm.getRoomFeaturePrefs();
        lstL = frm.getRoomFeaturePrefLevels();
        Set parentRoomFeaturePrefs = pg.effectivePreferences(RoomFeaturePref.class);
        for (int i = 0; i < lst.size(); ++i) {
            String id4 = (String)lst.get(i);
            if (id4 == null || id4.equals("-")) continue;
            String pref4 = (String)lstL.get(i);
            Debug.debug("Room Feat: " + id4 + ": " + pref4);
            RoomFeatureDAO rfdao = new RoomFeatureDAO();
            RoomFeature rf = (RoomFeature)rfdao.get(new Long(id4));
            RoomFeaturePref rfp = new RoomFeaturePref();
            rfp.setOwner(pg);
            rfp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref4)));
            rfp.setRoomFeature(rf);
            RoomFeaturePref sameParentRfp = null;
            Iterator j = parentRoomFeaturePrefs.iterator();
            while (j.hasNext()) {
                RoomFeaturePref p3 = (RoomFeaturePref)j.next();
                if (!p3.isSame(rfp)) continue;
                if (p3.getPrefLevel().equals(rfp.getPrefLevel())) {
                    sameParentRfp = rfp;
                }
                j.remove();
                break;
            }
            if (sameParentRfp != null) continue;
            s.add(rfp);
        }
        if (parentRoomFeaturePrefs != null && !parentRoomFeaturePrefs.isEmpty()) {
            Iterator i = parentRoomFeaturePrefs.iterator();
            while (i.hasNext()) {
                RoomFeaturePref rp = (RoomFeaturePref)((RoomFeaturePref)i.next()).clone();
                rp.setOwner(pg);
                rp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                s.add(rp);
            }
        }
        lst = frm.getRoomGroups();
        lstL = frm.getRoomGroupLevels();
        Set parentRoomGroupPrefs = pg.effectivePreferences(RoomGroupPref.class);
        for (int i = 0; i < lst.size(); ++i) {
            String id5 = (String)lst.get(i);
            if (id5 == null || id5.equals("-")) continue;
            String pref5 = (String)lstL.get(i);
            Debug.debug("Roomgr: " + id5 + ": " + pref5);
            RoomGroupDAO gdao = new RoomGroupDAO();
            RoomGroup gr = (RoomGroup)gdao.get(new Long(id5));
            RoomGroupPref gp = new RoomGroupPref();
            gp.setOwner(pg);
            gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref5)));
            gp.setRoomGroup(gr);
            RoomGroupPref sameParentGp = null;
            Iterator j = parentRoomGroupPrefs.iterator();
            while (j.hasNext()) {
                RoomGroupPref p4 = (RoomGroupPref)j.next();
                if (!p4.isSame(gp)) continue;
                if (p4.getPrefLevel().equals(gp.getPrefLevel())) {
                    sameParentGp = gp;
                }
                j.remove();
                break;
            }
            if (sameParentGp != null) continue;
            s.add(gp);
        }
        if (parentRoomGroupPrefs != null && !parentRoomGroupPrefs.isEmpty()) {
            Iterator i = parentRoomGroupPrefs.iterator();
            while (i.hasNext()) {
                RoomGroupPref gp = (RoomGroupPref)((RoomGroupPref)i.next()).clone();
                gp.setOwner(pg);
                gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                s.add(gp);
            }
        }
        lst = frm.getDatePatternPrefs();
        lstL = frm.getDatePatternPrefLevels();
        Set parentDatePatternPrefs = pg.effectivePreferences(DatePatternPref.class);
        for (int i = 0; i < lst.size(); ++i) {
            String id6 = (String)lst.get(i);
            if (id6 == null || id6.equals("-") || lstL.get(i).equals(PreferenceLevel.PREF_LEVEL_NEUTRAL)) continue;
            String pref6 = (String)lstL.get(i);
            Debug.debug("Datepattern: " + id6 + ": " + pref6);
            DatePatternDAO dpdao = new DatePatternDAO();
            DatePattern dp = (DatePattern)dpdao.get(new Long(id6));
            DatePatternPref dpp = new DatePatternPref();
            dpp.setOwner(pg);
            dpp.setPrefLevel(PreferenceLevel.getPreferenceLevel(Integer.parseInt(pref6)));
            dpp.setDatePattern(dp);
            DatePatternPref sameParentDp = null;
            Iterator j = parentDatePatternPrefs.iterator();
            while (j.hasNext()) {
                DatePatternPref p5 = (DatePatternPref)j.next();
                if (!p5.isSame(dpp)) continue;
                if (p5.getPrefLevel().equals(dpp.getPrefLevel())) {
                    sameParentDp = dpp;
                }
                j.remove();
                break;
            }
            if (sameParentDp != null) continue;
            s.add(dpp);
        }
        if (parentDatePatternPrefs != null && !parentDatePatternPrefs.isEmpty()) {
            Iterator i = parentDatePatternPrefs.iterator();
            while (i.hasNext()) {
                DatePatternPref gp = (DatePatternPref)((DatePatternPref)i.next()).clone();
                if (!pg.effectiveDatePattern().findChildren().contains(gp.getDatePattern())) continue;
                gp.setOwner(pg);
                gp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sNeutral));
                s.add(gp);
            }
        }
        pg.setPreferences(s);
    }

    protected void addToTimePref(HttpServletRequest request, PreferenceGroup owner, String tpat, Set prefs, int idx, boolean timeVertical, Set parentTimePrefs) throws Exception {
        TimePatternDAO timePatternDao = new TimePatternDAO();
        TimePattern timePattern = tpat.equals("-1") ? null : (TimePattern)timePatternDao.get(new Long(tpat));
        boolean canUseHardTimePrefs = this.sessionContext.hasPermission(owner, Right.CanUseHardTimePrefs);
        RequiredTimeTable rtt = timePattern == null ? TimePattern.getDefaultRequiredTimeTable() : timePattern.getRequiredTimeTable(canUseHardTimePrefs);
        rtt.getModel().setDefaultSelection(RequiredTimeTable.getTimeGridSize(this.sessionContext.getUser()));
        rtt.setName("p" + idx);
        rtt.update((ServletRequest)request);
        TimePref tp = new TimePref();
        tp.setOwner(owner);
        tp.setPreference(rtt.getModel().getPreferences());
        tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
        tp.setTimePattern(timePattern);
        TimePref sameParentTimePref = null;
        if (parentTimePrefs != null && !parentTimePrefs.isEmpty()) {
            Iterator i = parentTimePrefs.iterator();
            while (i.hasNext()) {
                TimePref parentTimePref = (TimePref)i.next();
                if (!parentTimePref.isSame(tp)) continue;
                if (parentTimePref.getPreference().equals(tp.getPreference()) && parentTimePref.getPrefLevel().equals(tp.getPrefLevel())) {
                    sameParentTimePref = parentTimePref;
                }
                i.remove();
                break;
            }
        }
        if (sameParentTimePref == null) {
            prefs.add(tp);
        }
    }

    protected void generateExamPeriodGrid(HttpServletRequest request, PreferencesForm frm, Exam exam, String op, boolean timeVertical, boolean editable) throws Exception {
        if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
            ExamType type;
            ExamSolverProxy solver = WebSolver.getExamSolver(request.getSession());
            ExamAssignment assignment = null;
            if (solver != null && exam != null) {
                assignment = solver.getAssignment(exam.getUniqueId());
            } else if (exam != null && exam.getAssignedPeriod() != null) {
                assignment = new ExamAssignment(exam);
            }
            ExamType examType = type = exam == null ? (ExamType)ExamTypeDAO.getInstance().get(((ExamEditForm)frm).getExamType()) : exam.getExamType();
            if (1 == type.getType()) {
                MidtermPeriodPreferenceModel epx = new MidtermPeriodPreferenceModel(exam == null ? (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()) : exam.getSession(), type, assignment);
                if (exam != null) {
                    epx.load(exam);
                }
                frm.setHasNotAvailable(true);
                if (!op.equals("init")) {
                    epx.load(request);
                }
                request.setAttribute("ExamPeriodGrid", (Object)epx.print(editable, editable ? 0 : exam.getLength()));
            } else {
                PeriodPreferenceModel px = new PeriodPreferenceModel(exam == null ? (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId()) : exam.getSession(), assignment, type.getUniqueId());
                if (exam != null) {
                    px.load(exam);
                }
                px.setAllowHard(this.sessionContext.hasPermission(exam, Right.CanUseHardTimePrefs));
                frm.setHasNotAvailable(px.hasNotAvailable());
                RequiredTimeTable rtt = new RequiredTimeTable(px);
                rtt.setName("PeriodPref");
                if (!op.equals("init")) {
                    rtt.update((ServletRequest)request);
                }
                request.setAttribute("ExamPeriodGrid", (Object)rtt.print(editable, timeVertical, editable, false));
            }
        } else {
            RoomInterface.PeriodPreferenceModel model = new PeriodPreferencesBackend().loadExamPeriodPreferences(WebSolver.getExamSolver(request.getSession()), exam, exam == null ? (ExamType)ExamTypeDAO.getInstance().get(((ExamEditForm)frm).getExamType()) : exam.getExamType(), this.sessionContext);
            if (!op.equals("init") && request.getParameter("periodPrefs") != null) {
                model.setPattern(request.getParameter("periodPrefs"));
            }
            if (editable) {
                request.setAttribute("ExamPeriodGrid", (Object)("<div id='UniTimeGWT:PeriodPreferences'><input type=\"hidden\" name=\"periodPrefs\" value=\"" + model.getPattern() + "\"></div>"));
            } else {
                request.setAttribute("ExamPeriodGrid", (Object)("<div id='UniTimeGWT:PeriodPreferences' style='display: none;'>" + model.getPattern() + "</div>"));
            }
        }
    }

    protected void generateTimePatternGrids(HttpServletRequest request, PreferencesForm frm, PreferenceGroup pg, int minutes, DurationModel dmod, DatePattern dpat, Set tpat, String op, boolean timeVertical, boolean editable, Vector leadInstructors) throws Exception {
        Vector timePrefs = null;
        Vector<String> tps = null;
        if (op.equals("init")) {
            Set tp = pg.effectivePreferences(TimePref.class, leadInstructors, !editable);
            if (tp.size() > 0) {
                timePrefs = new Vector(tp);
                Collections.sort(timePrefs);
                tps = new Vector<String>();
                Enumeration e = timePrefs.elements();
                while (e.hasMoreElements()) {
                    TimePref timePref = (TimePref)e.nextElement();
                    if (timePref.getTimePatternModel().hasNotAvailablePreference()) {
                        frm.setHasNotAvailable(true);
                    }
                    tps.add(timePref.getTimePattern() == null ? "-1" : timePref.getTimePattern().getUniqueId().toString());
                }
            } else if (tpat.size() > 0 && editable) {
                Vector x = new Vector(tpat);
                Collections.sort(x);
                tps = new Vector();
                Enumeration e = x.elements();
                while (e.hasMoreElements()) {
                    TimePattern pat = (TimePattern)e.nextElement();
                    tps.add(pat.getUniqueId().toString());
                }
            }
            frm.setTimePatterns(tps);
        } else {
            tps = frm.getTimePatterns();
        }
        Assignment assignment = null;
        if (pg instanceof Class_ && this.sessionContext.hasPermission(Right.ClassAssignments)) {
            ClassAssignmentDetails ca = ClassAssignmentDetails.createClassAssignmentDetails(this.sessionContext, this.courseTimetablingSolverService.getSolver(), pg.getUniqueId(), true);
            if (ca != null) {
                String assignmentTable = SuggestionsAction.getAssignmentTable(this.sessionContext, this.courseTimetablingSolverService.getSolver(), ca, false, null, true);
                if (assignmentTable != null) {
                    request.setAttribute("Suggestions.assignmentInfo", (Object)assignmentTable);
                }
            } else {
                String assignmentTable;
                ClassAssignmentProxy cap = this.classAssignmentService.getAssignment();
                if (cap != null && (assignment = cap.getAssignment((Class_)pg)) != null && assignment.getUniqueId() != null && (ca = ClassAssignmentDetails.createClassAssignmentDetailsFromAssignment(this.sessionContext, assignment.getUniqueId(), true)) != null && (assignmentTable = SuggestionsAction.getAssignmentTable(this.sessionContext, this.courseTimetablingSolverService.getSolver(), ca, false, null, true)) != null) {
                    request.setAttribute("Suggestions.assignmentInfo", (Object)assignmentTable);
                }
            }
        }
        if (tps == null || tps.isEmpty()) {
            request.setAttribute(TIME_PATTERN_GRID_ATTR, (Object)MSG.errorTimePatternNotSelected());
        } else {
            int idx = 0;
            int deletedTimePatternIdx = -1;
            if ("timePattern".equals(request.getParameter("deleteType"))) {
                try {
                    deletedTimePatternIdx = Integer.parseInt(request.getParameter("deleteId"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            for (String tp : tps) {
                TimePattern timePattern;
                TimePatternDAO timePatternDao = new TimePatternDAO();
                TimePattern timePattern2 = timePattern = tp.equals("-1") ? null : (TimePattern)timePatternDao.get(new Long(tp));
                RequiredTimeTable rtt = timePattern == null ? TimePattern.getDefaultRequiredTimeTable() : timePattern.getRequiredTimeTable(assignment == null ? null : assignment.getTimeLocation(), this.sessionContext.hasPermission(pg, Right.CanUseHardTimePrefs));
                rtt.getModel().setDefaultSelection(this.sessionContext.getUser().getProperty(UserProperty.GridSize));
                rtt.setName("p" + idx);
                String reloadCause = request.getParameter("reloadCause");
                if (reloadCause != null && reloadCause.equals("timePattern")) {
                    request.setAttribute(HASH_ATTR, (Object)"TimePref");
                }
                if (!(reloadCause != null && reloadCause.equals("timePattern") || op.equals("init"))) {
                    if (deletedTimePatternIdx >= 0 && idx >= deletedTimePatternIdx) {
                        rtt.setName("p" + (idx + 1));
                        rtt.update((ServletRequest)request);
                        rtt.setName("p" + idx);
                    } else {
                        rtt.update((ServletRequest)request);
                    }
                }
                if (timePrefs != null && timePrefs.size() > 0 && op.equals("init")) {
                    rtt.getModel().setPreferences(((TimePref)timePrefs.elementAt(idx)).getPreference());
                }
                String name = null;
                if (timePattern != null && !rtt.getModel().isExactTime()) {
                    if (dpat.getType() != null && dpat.getType() == 4) {
                        boolean allPatterns = true;
                        String matching = "";
                        for (DatePattern dch : dpat.findChildren()) {
                            if (dmod.isValidCombination(minutes, dch, timePattern)) {
                                matching = matching + (matching.isEmpty() ? "" : ", ") + dch.getName();
                                continue;
                            }
                            allPatterns = false;
                        }
                        if (matching.isEmpty()) {
                            name = timePattern.getName() + " <font color=\\'red\\'>" + MSG.warnNoMatchingDatePattern() + "</font>";
                        } else if (!allPatterns) {
                            name = timePattern.getName() + " (" + matching + ")";
                        }
                    } else if (!dmod.isValidCombination(minutes, dpat, timePattern)) {
                        name = timePattern.getName() + " <font color=\\'red\\'>" + MSG.warnNoMatchingDatePattern() + "</font>";
                    }
                }
                request.setAttribute("timePatternGrid_" + idx, (Object)rtt.print(editable, timeVertical, editable, false, name));
                ++idx;
            }
        }
    }

    protected void initPrefs(PreferencesForm frm, PreferenceGroup pg, Vector leadInstructors, boolean addBlankRows) {
        if (pg == null) {
            if (addBlankRows) {
                frm.addBlankPrefRows();
            }
            return;
        }
        frm.getRoomPrefs().clear();
        frm.getRoomPrefLevels().clear();
        Set roomPrefs = pg.effectivePreferences(RoomPref.class, leadInstructors);
        for (RoomPref rp : roomPrefs) {
            Debug.debug("Adding room pref ... " + rp.getRoom().getUniqueId().toString());
            frm.addToRoomPrefs(rp.getRoom().getUniqueId().toString(), rp.getPrefLevel().getUniqueId().toString());
        }
        frm.getRoomFeaturePrefs().clear();
        frm.getRoomFeaturePrefLevels().clear();
        Set roomFeatPrefs = pg.effectivePreferences(RoomFeaturePref.class, leadInstructors);
        for (RoomFeaturePref rfp : roomFeatPrefs) {
            Debug.debug("Adding room feature pref ... " + rfp.getRoomFeature().getUniqueId().toString());
            frm.addToRoomFeatPrefs(rfp.getRoomFeature().getUniqueId().toString(), rfp.getPrefLevel().getUniqueId().toString());
        }
        frm.getBldgPrefs().clear();
        frm.getBldgPrefLevels().clear();
        Set bldgPrefs = pg.effectivePreferences(BuildingPref.class, leadInstructors);
        for (BuildingPref bp : bldgPrefs) {
            Debug.debug("Adding building pref ... " + bp.getBuilding().getUniqueId().toString());
            frm.addToBldgPrefs(bp.getBuilding().getUniqueId().toString(), bp.getPrefLevel().getUniqueId().toString());
        }
        frm.getDistPrefs().clear();
        frm.getDistPrefLevels().clear();
        Set distPrefs = pg.effectivePreferences(DistributionPref.class, leadInstructors);
        for (DistributionPref dp : distPrefs) {
            Debug.debug("Adding distribution pref ... " + dp.getDistributionType().getUniqueId().toString());
            frm.addToDistPrefs(dp.getDistributionType().getUniqueId().toString(), dp.getPrefLevel().getUniqueId().toString());
        }
        frm.getRoomGroups().clear();
        frm.getRoomGroupLevels().clear();
        Set rgPrefs = pg.effectivePreferences(RoomGroupPref.class, leadInstructors);
        for (RoomGroupPref bp : rgPrefs) {
            Debug.debug("Adding room group pref ... " + bp.getRoomGroup().getUniqueId().toString());
            frm.addToRoomGroups(bp.getRoomGroup().getUniqueId().toString(), bp.getPrefLevel().getUniqueId().toString());
        }
        Set datePatternPrefs = pg.effectivePreferences(DatePatternPref.class);
        frm.getDatePatternPrefs().clear();
        frm.getDatePatternPrefLevels().clear();
        for (DatePatternPref dp : datePatternPrefs) {
            if (!dp.appliesTo(pg)) continue;
            Debug.debug("Adding date pattern pref ... " + dp.getDatePattern().getUniqueId().toString());
            frm.addToDatePatternPrefs(dp.getDatePattern().getUniqueId().toString(), dp.getPrefLevel().getUniqueId().toString());
        }
        if (addBlankRows) {
            frm.addBlankPrefRows();
        }
    }

    protected void clearPrefs(HttpServletRequest request, PreferencesForm frm) {
        frm.clearPrefs();
    }
}

