/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.timetable.form.ItypeDescEditForm;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.dao.ItypeDescDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;

@Service(value="/itypeDescEdit")
public class ItypeDescEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String op;
            ItypeDescEditForm myForm = (ItypeDescEditForm)form;
            this.sessionContext.checkPermission(Right.InstructionalTypes);
            String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
            if (op == null) {
                myForm.reset(mapping, request);
                myForm.setOp("Save");
            }
            if ("Back".equals(op)) {
                return mapping.findForward("back");
            }
            if ("Add IType".equals(op)) {
                this.sessionContext.checkPermission(Right.InstructionalTypeAdd);
                myForm.setOp("Save");
            }
            LookupTables.setupItypes(request, true);
            if ("Update".equals(op) || "Save".equals(op)) {
                ActionErrors errors = myForm.validate(mapping, request);
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                    return mapping.findForward("Save".equals(op) ? "add" : "edit");
                }
                Transaction tx = null;
                if (myForm.getUniqueId() == null || myForm.getUniqueId() < 0) {
                    this.sessionContext.checkPermission(Right.InstructionalTypeAdd);
                } else {
                    this.sessionContext.checkPermission(myForm.getUniqueId(), "ItypeDesc", Right.InstructionalTypeEdit);
                }
                try {
                    Session hibSession = new ItypeDescDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    myForm.saveOrUpdate(hibSession);
                    if (tx != null) {
                        tx.commit();
                    }
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                return mapping.findForward("back");
            }
            if ("Edit".equals(op)) {
                String id = request.getParameter("id");
                this.sessionContext.checkPermission(Integer.valueOf(id), "ItypeDesc", Right.InstructionalTypeEdit);
                ActionMessages errors = new ActionMessages();
                if (id == null || id.trim().length() == 0) {
                    errors.add("externalId", new ActionMessage("errors.invalid", (Object)id));
                    this.saveErrors(request, errors);
                    return mapping.findForward("edit");
                }
                ItypeDesc itype = (ItypeDesc)new ItypeDescDAO().get(Integer.valueOf(id));
                if (itype == null) {
                    return mapping.findForward("back");
                }
                myForm.load(itype);
            }
            if ("Delete".equals(op)) {
                Transaction tx = null;
                this.sessionContext.checkPermission(myForm.getUniqueId(), "ItypeDesc", Right.InstructionalTypeDelete);
                try {
                    Session hibSession = new ItypeDescDAO().getSession();
                    if (hibSession.getTransaction() == null || !hibSession.getTransaction().isActive()) {
                        tx = hibSession.beginTransaction();
                    }
                    myForm.delete(hibSession);
                    tx.commit();
                }
                catch (Exception e) {
                    if (tx != null) {
                        tx.rollback();
                    }
                    throw e;
                }
                return mapping.findForward("back");
            }
            return mapping.findForward("Save".equals(myForm.getOp()) ? "add" : "edit");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }
}

