/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.Email;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.InquiryForm;
import org.unitime.timetable.model.EventContact;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LookupTables;

@Service(value="/inquiry")
public class InquiryAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            InquiryForm myForm = (InquiryForm)form;
            MessageResources rsc = this.getResources(request);
            this.sessionContext.checkPermission(Right.Inquiry);
            String op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
            myForm.setNoRole(!this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.HasRole));
            if ("Cancel".equals(op) || "Back".equals(op)) {
                return mapping.findForward("submit");
            }
            ActionMessages errors = null;
            if (op != null && op.equals(rsc.getMessage("button.insertAddress"))) {
                if (myForm.getPuid() != null && myForm.getPuid().length() > 0) {
                    myForm.addToCarbonCopy(myForm.getPuid());
                    myForm.setPuid(null);
                } else {
                    errors = new ActionMessages();
                    errors.add("puid", new ActionMessage("errors.generic", (Object)"Recipient has an invalid email address."));
                    this.saveErrors(request, errors);
                }
            }
            if (request.getParameter("deleteId") != null && request.getParameter("deleteId").length() > 0) {
                try {
                    int deleteId = Integer.parseInt(request.getParameter("deleteId"));
                    myForm.removeCarbonCopy(deleteId);
                    myForm.setPuid(null);
                }
                catch (Exception e) {
                    errors = new ActionMessages();
                    errors.add("puid", new ActionMessage("errors.generic", (Object)"Invalid email address."));
                    this.saveErrors(request, errors);
                }
            }
            if ("Submit".equals(op)) {
                errors = myForm.validate(mapping, request);
                if (errors.size() > 0) {
                    this.saveErrors(request, errors);
                } else {
                    List<? extends UserQualifier> sg;
                    List<? extends UserQualifier> depts;
                    String mail = myForm.getMessage();
                    mail = mail + "\r\n";
                    mail = mail + "\r\n";
                    mail = mail + "User info -------------- \r\n";
                    mail = mail + "User: " + this.sessionContext.getUser().getName() + "\r\n";
                    mail = mail + "Login: " + this.sessionContext.getUser().getUsername() + "\r\n";
                    mail = mail + "Email: " + this.sessionContext.getUser().getEmail() + "\r\n";
                    mail = mail + "Role: " + this.sessionContext.getUser().getCurrentAuthority() + "\r\n";
                    List<? extends UserQualifier> sessions = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Session");
                    if (!sessions.isEmpty()) {
                        mail = mail + "Academic Session: " + ((Qualifiable)sessions.get(0)).getQualifierLabel() + "\r\n";
                    }
                    if (!(depts = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Department")).isEmpty()) {
                        mail = mail + "Departments: " + depts + "\r\n";
                    }
                    if (!(sg = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("SolverGroup")).isEmpty()) {
                        mail = mail + "Solver Groups: " + sg + "\r\n";
                    }
                    mail = mail + "\r\n";
                    mail = mail + "\r\n";
                    mail = mail + "Application info -------------- \r\n";
                    mail = mail + "Version: " + Constants.getVersion() + " (" + Constants.getReleaseDate() + ")\r\n";
                    mail = mail + "TimeStamp: " + new Date();
                    EventContact c = EventContact.findByExternalUniqueId(this.sessionContext.getUser().getExternalUserId());
                    Email email = Email.createEmail();
                    email.setSubject("UniTime (" + myForm.getTypeMsg(myForm.getType()) + "): " + myForm.getSubject());
                    email.setText(mail);
                    if (!myForm.getCarbonCopy().isEmpty()) {
                        Iterator i = myForm.getCarbonCopy().iterator();
                        while (i.hasNext()) {
                            email.addRecipientCC((String)i.next(), null);
                        }
                    }
                    if (ApplicationProperty.EmailInquiryAddress.value() != null) {
                        email.addRecipient(ApplicationProperty.EmailInquiryAddress.value(), ApplicationProperty.EmailInquiryAddressName.value());
                    } else {
                        email.addNotify();
                    }
                    boolean autoreply = ApplicationProperty.EmailInquiryAutoreply.isTrue();
                    if (!autoreply) {
                        if (this.sessionContext.getUser().getEmail() != null && !this.sessionContext.getUser().getEmail().isEmpty()) {
                            email.addRecipientCC(this.sessionContext.getUser().getEmail(), this.sessionContext.getUser().getName());
                        } else if (c != null && c.getEmailAddress() != null && !c.getEmailAddress().isEmpty()) {
                            email.addRecipientCC(c.getEmailAddress(), c.getName());
                        } else {
                            email.addRecipientCC(this.sessionContext.getUser().getUsername() + ApplicationProperty.EmailInquiryAddressSuffix.value(), this.sessionContext.getUser().getName());
                        }
                    }
                    email.send();
                    if (autoreply) {
                        try {
                            mail = "The following inquiry was submitted on your behalf. We will contact you soon. This email was automatically generated, please do not reply.\n\n";
                            if (ApplicationProperty.EmailSenderName.value() != null) {
                                mail = mail + "Thank you, \n\n" + ApplicationProperty.EmailSenderName.value() + "\n\n";
                            }
                            mail = mail + "-- INQUIRY (" + myForm.getTypeMsg(myForm.getType()) + "): " + myForm.getSubject() + " ---------- \n\n" + myForm.getMessage() + "\n" + "-- END INQUIRY -------------------------------------------";
                            email = Email.createEmail();
                            email.setSubject("RE: UniTime (" + myForm.getTypeMsg(myForm.getType()) + "): " + myForm.getSubject());
                            email.setText(mail);
                            if (this.sessionContext.getUser().getEmail() != null && !this.sessionContext.getUser().getEmail().isEmpty()) {
                                email.addRecipient(this.sessionContext.getUser().getEmail(), this.sessionContext.getUser().getName());
                            } else if (c != null && c.getEmailAddress() != null && !c.getEmailAddress().isEmpty()) {
                                email.addRecipient(c.getEmailAddress(), c.getName());
                            } else {
                                email.addRecipient(this.sessionContext.getUser().getUsername() + ApplicationProperty.EmailInquiryAddressSuffix.value(), this.sessionContext.getUser().getName());
                            }
                            email.send();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    myForm.setOp("Sent");
                    return mapping.findForward("display");
                }
            }
            LookupTables.setupTimetableManagers(request);
            myForm.updateMessage();
            return mapping.findForward("display");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }
}

