/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.unitime.commons.MultiComparable;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ExamsForm;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamStatus;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.LoginManager;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.PdfWebTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="/exams")
public class ExamsAction
extends Action {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    @Autowired
    AuthenticationManager authenticationManager;
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Session session;
        String op;
        ExamsForm myForm = (ExamsForm)form;
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if (request.getParameter("select") != null) {
            myForm.load(request.getSession());
            if (request.getParameter("subject") != null) {
                myForm.setSubjectArea(request.getParameter("subject"));
            } else if (myForm.canDisplayAllSubjectsAtOnce().booleanValue()) {
                myForm.setSubjectArea(Constants.ALL_OPTION_VALUE);
            }
            if (request.getParameter("year") != null && request.getParameter("term") != null && request.getParameter("campus") != null && (session = Session.getSessionUsingInitiativeYearTerm(request.getParameter("campus"), request.getParameter("year"), request.getParameter("term"))) != null) {
                myForm.setSession(session.getUniqueId());
            }
            if (request.getParameter("type") != null) {
                try {
                    myForm.setExamType(Long.valueOf(request.getParameter("type")));
                }
                catch (NumberFormatException e) {
                    ExamType type = ExamType.findByReference(request.getParameter("type"));
                    if (type != null) {
                        myForm.setExamType(type.getUniqueId());
                    }
                }
            } else {
                myForm.setExamType(null);
            }
            op = "Apply";
        }
        if ("Apply".equals(op)) {
            myForm.save(request.getSession());
            if (myForm.getUsername() != null && myForm.getUsername().length() > 0 && myForm.getPassword() != null && myForm.getPassword().length() > 0) {
                try {
                    UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)myForm.getUsername(), (Object)myForm.getPassword());
                    Authentication authResult = this.authenticationManager.authenticate((Authentication)authRequest);
                    SecurityContextHolder.getContext().setAuthentication(authResult);
                    UserContext user = (UserContext)authResult.getPrincipal();
                    if (user.getCurrentAuthority() == null || !user.getCurrentAuthority().hasRight(Right.PersonalSchedule)) {
                        for (UserAuthority userAuthority : user.getAuthorities()) {
                            if (userAuthority.getAcademicSession() == null || !userAuthority.getAcademicSession().getQualifierId().equals(myForm.getSession()) || !userAuthority.hasRight(Right.PersonalSchedule)) continue;
                            user.setCurrentAuthority(userAuthority);
                            break;
                        }
                    }
                    request.getSession().setAttribute("loginPage", (Object)"exams");
                    LoginManager.loginSuceeded(authResult.getName());
                    if (user.getCurrentAuthority() == null) {
                        response.sendRedirect("selectPrimaryRole.do");
                        return null;
                    }
                    return mapping.findForward("personal");
                }
                catch (Exception e) {
                    myForm.setMessage("Authentication failed: " + e.getMessage());
                    LoginManager.addFailedLoginAttempt(myForm.getUsername(), new Date());
                }
            }
        }
        myForm.load(request.getSession());
        WebTable.setOrder(this.sessionContext, "exams.order", request.getParameter("ord"), 1);
        if (myForm.getSession() != null && myForm.getSubjectArea() != null && myForm.getSubjectArea().length() > 0 && myForm.getExamType() != null) {
            DepartmentStatusType type;
            session = (Session)new SessionDAO().get(myForm.getSession());
            ExamStatus status = ExamStatus.findStatus(myForm.getSession(), myForm.getExamType());
            DepartmentStatusType departmentStatusType = type = status == null || status.getStatus() == null ? session.getStatusType() : status.getStatus();
            if (type != null && type.can(myForm.isFinals() ? DepartmentStatusType.Status.ReportExamsFinal : DepartmentStatusType.Status.ReportExamsMidterm)) {
                List exams = null;
                if ("--ALL--".equals(myForm.getSubjectArea())) {
                    exams = Exam.findAll(myForm.getSession(), myForm.getExamType());
                } else {
                    SubjectArea subjectArea = SubjectArea.findByAbbv(myForm.getSession(), myForm.getSubjectArea());
                    if (subjectArea != null) {
                        exams = Exam.findExamsOfSubjectAreaIncludeCrossLists(subjectArea.getUniqueId(), myForm.getExamType());
                    }
                }
                if (exams != null && !exams.isEmpty()) {
                    PdfWebTable table;
                    Vector<ExamAssignment> vector = new Vector<ExamAssignment>();
                    for (Exam exam : exams) {
                        if (exam.getAssignedPeriod() == null) continue;
                        vector.add(new ExamAssignment(exam));
                    }
                    if (!vector.isEmpty() && (table = this.getTable(true, myForm, vector)) != null) {
                        myForm.setTable(table.printTable(WebTable.getOrder(this.sessionContext, "exams.order")), table.getNrColumns(), table.getLines().size());
                    }
                }
            }
        }
        LookupTables.setupExamTypes(request, null);
        return mapping.findForward("show");
    }

    private PdfWebTable getTable(boolean html, ExamsForm form, Vector<ExamAssignment> exams) {
        String itype = MSG.columnExamInstructionalType();
        if (ApplicationProperty.ExaminationReportsExternalId.isTrue() && (itype = ApplicationProperty.ExaminationReportsExternalIdName.value()) == null) {
            itype = MSG.columnExamExternalId();
        }
        PdfWebTable table = new PdfWebTable(7, form.getSessionLabel() + " " + form.getExamTypeLabel().toLowerCase() + " " + MSG.examinations() + ("--ALL--".equals(form.getSubjectArea()) ? "" : " (" + form.getSubjectArea() + ")"), "exams.do?ord=%%", new String[]{MSG.columnExamSubject(), MSG.columnExamCourse(), itype, MSG.columnExamSection(), MSG.columnExamDate(), MSG.columnExamTime(), MSG.columnExamRoom()}, new String[]{"left", "left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        String noRoom = ApplicationProperty.ExaminationsNoRoomText.value();
        for (ExamAssignment exam : exams) {
            for (ExamInfo.ExamSectionInfo section : exam.getSectionsIncludeCrosslistedDummies()) {
                if (!"--ALL--".equals(form.getSubjectArea()) && !section.getSubject().equals(form.getSubjectArea())) continue;
                table.addLine(new String[]{section.getSubject(), section.getCourseNbr(), section.getItype(), section.getSection(), exam.getDate(false), exam.getTime(false), exam.getNrRooms() == 0 ? noRoom : (html ? exam.getRoomsNameWithHint(false, ", ") : exam.getRoomsName(", "))}, new Comparable[]{new MultiComparable((Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getItype()), (Comparable)((Object)section.getSection()), exam.getPeriodOrd()), new MultiComparable((Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getItype()), (Comparable)((Object)section.getSection()), exam.getPeriodOrd()), new MultiComparable((Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getItype()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getSection()), exam.getPeriodOrd()), new MultiComparable((Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getSection()), (Comparable)((Object)section.getItype()), exam.getPeriodOrd()), new MultiComparable(exam.getPeriodOrd(), (Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getSection()), (Comparable)((Object)section.getItype())), new MultiComparable(exam.getPeriod().getStartSlot(), (Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getSection()), (Comparable)((Object)section.getItype()), exam.getPeriodOrd()), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), (Comparable)((Object)section.getSubject()), (Comparable)((Object)section.getCourseNbr()), (Comparable)((Object)section.getItype()), (Comparable)((Object)section.getSection()), exam.getPeriodOrd())});
            }
        }
        return table;
    }
}

