/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.awt.image.BufferedImage;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.web.WebTable;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ExamListForm;
import org.unitime.timetable.model.BuildingPref;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.DistributionPref;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriodPref;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.MidtermPeriodPreferenceModel;
import org.unitime.timetable.model.PeriodPreferenceModel;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomFeaturePref;
import org.unitime.timetable.model.RoomGroupPref;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.solver.service.SolverService;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;
import org.unitime.timetable.webutil.PdfWebTable;
import org.unitime.timetable.webutil.RequiredTimeTable;

@Service(value="/examList")
public class ExamListAction
extends Action {
    @Autowired
    SessionContext sessionContext;
    @Autowired
    SolverService<ExamSolverProxy> examinationSolverService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<ExamType> types;
        String op;
        ExamListForm myForm = (ExamListForm)form;
        this.sessionContext.checkPermission(Right.Examinations);
        String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
        if (op == null && this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea) != null) {
            String subject = (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsSubjectArea);
            if (subject.indexOf(44) >= 0) {
                subject = subject.substring(0, subject.indexOf(44));
            }
            myForm.setSubjectAreaId(subject);
            myForm.setCourseNbr((String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber));
        }
        if (op == null && this.sessionContext.getAttribute(SessionAttribute.ExamType) != null) {
            myForm.setExamType((Long)this.sessionContext.getAttribute(SessionAttribute.ExamType));
        }
        if (myForm.getExamType() == null && !(types = ExamType.findAllUsedApplicable(this.sessionContext.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable)).isEmpty()) {
            myForm.setExamType(types.get(0).getUniqueId());
        }
        WebTable.setOrder(this.sessionContext, "ExamList.ord", request.getParameter("ord"), 1);
        if ("Search".equals(op) || "Export PDF".equals(op) || "Export CSV".equals(op)) {
            if (myForm.getSubjectAreaId() != null) {
                this.sessionContext.setAttribute(SessionAttribute.OfferingsSubjectArea, (Object)myForm.getSubjectAreaId());
                this.sessionContext.setAttribute(SessionAttribute.OfferingsCourseNumber, (Object)myForm.getCourseNbr());
                this.sessionContext.setAttribute(SessionAttribute.ExamType, (Object)myForm.getExamType());
            }
            if ("Export PDF".equals(op)) {
                ExportUtils.exportPDF(this.getExamTable(myForm, false, true), WebTable.getOrder(this.sessionContext, "ExamList.ord"), response, "exams");
                return null;
            }
            if ("Export CSV".equals(op)) {
                ExportUtils.exportCSV(this.getExamTable(myForm, false, false), WebTable.getOrder(this.sessionContext, "ExamList.ord"), response, "exams");
                return null;
            }
        }
        if ("Add Examination".equals(op)) {
            return mapping.findForward("addExam");
        }
        myForm.setSubjectAreas(SubjectArea.getUserSubjectAreas(this.sessionContext.getUser(), false));
        if (myForm.getSubjectAreas().size() == 1) {
            SubjectArea firstSubjectArea = (SubjectArea)myForm.getSubjectAreas().iterator().next();
            myForm.setSubjectAreaId(firstSubjectArea.getUniqueId().toString());
        }
        if (myForm.getSubjectAreaId() != null && myForm.getSubjectAreaId().length() != 0) {
            PdfWebTable table = this.getExamTable(myForm, true, false);
            if (table != null) {
                request.setAttribute("ExamList.table", (Object)table.printTable(WebTable.getOrder(this.sessionContext, "ExamList.ord")));
                Vector<Long> ids = new Vector<Long>();
                Enumeration e = table.getLines().elements();
                while (e.hasMoreElements()) {
                    WebTable.WebTableLine line = (WebTable.WebTableLine)e.nextElement();
                    ids.add(Long.parseLong(line.getUniqueId()));
                }
                Navigation.set(this.sessionContext, Navigation.sInstructionalOfferingLevel, ids);
            } else {
                ActionMessages errors = new ActionMessages();
                errors.add("exams", new ActionMessage("errors.generic", (Object)"No examination matching the above criteria was found."));
                this.saveErrors(request, errors);
            }
        }
        String subjectAreaName = "";
        try {
            subjectAreaName = ((SubjectArea)new SubjectAreaDAO().get(new Long(myForm.getSubjectAreaId()))).getSubjectAreaAbbreviation();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (request.getParameter("backId") != null) {
            request.setAttribute("hash", (Object)request.getParameter("backId"));
        }
        if (myForm.getExamType() != null && myForm.getSubjectAreaId() != null && myForm.getCourseNbr() != null) {
            BackTracker.markForBack(request, "examList.do?op=Search&examType=" + myForm.getExamType() + "&subjectAreaId=" + myForm.getSubjectAreaId() + "&courseNbr=" + URLEncoder.encode(myForm.getCourseNbr(), "utf-8"), ((ExamType)ExamTypeDAO.getInstance().get(myForm.getExamType())).getLabel() + " Exams (" + (Constants.ALL_OPTION_VALUE.equals(myForm.getSubjectAreaId()) ? "All" : subjectAreaName + (myForm.getCourseNbr() == null || myForm.getCourseNbr().length() == 0 ? "" : " " + myForm.getCourseNbr())) + ")", true, true);
        }
        LookupTables.setupExamTypes(request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
        return mapping.findForward("list");
    }

    public PdfWebTable getExamTable(ExamListForm form, boolean html, boolean color) {
        Collection exams;
        ExamAssignmentProxy examAssignment = this.examinationSolverService.getSolver();
        Collection collection = form.getSubjectAreaId() == null || form.getSubjectAreaId().trim().length() == 0 || "null".equals(form.getSubjectAreaId()) ? null : (exams = Constants.ALL_OPTION_VALUE.equals(form.getSubjectAreaId()) ? Exam.findAll(this.sessionContext.getUser().getCurrentAcademicSessionId(), form.getExamType()) : Exam.findExamsOfCourse(Long.valueOf(form.getSubjectAreaId()), form.getCourseNbr(), form.getExamType()));
        if (exams == null || exams.isEmpty()) {
            return null;
        }
        if (examAssignment != null && !examAssignment.getExamTypeId().equals(form.getExamType())) {
            examAssignment = null;
        }
        String nl = html ? "<br>" : "\n";
        boolean timeVertical = RequiredTimeTable.getTimeGridVertical(this.sessionContext.getUser());
        boolean timeText = RequiredTimeTable.getTimeGridAsText(this.sessionContext.getUser());
        String instructorNameFormat = UserProperty.NameFormat.get(this.sessionContext.getUser());
        ExamType type = (ExamType)ExamTypeDAO.getInstance().get(form.getExamType());
        PdfWebTable table = new PdfWebTable(11, type.getLabel() + " Examinations", "examList.do?ord=%%", new String[]{"Classes / Courses", "Length", "Seating" + nl + "Type", "Size", "Max" + nl + "Rooms", "Instructor", "Period" + nl + "Preferences", "Room" + nl + "Preferences", "Distribution" + nl + "Preferences", "Assigned" + nl + "Period", "Assigned" + nl + "Room"}, new String[]{"left", "right", "center", "right", "right", "left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true, true});
        for (Exam exam : exams) {
            RequiredTimeTable rtt;
            ExamAssignment ea;
            String objects = "";
            String perPref = "";
            String roomPref = "";
            String distPref = "";
            String per = "";
            String rooms = "";
            Comparable perCmp = null;
            for (ExamOwner examOwner : new TreeSet<ExamOwner>(exam.getOwners())) {
                if (objects.length() > 0) {
                    objects = objects + nl;
                }
                objects = objects + examOwner.getLabel();
            }
            ExamAssignment examAssignment2 = examAssignment != null ? examAssignment.getAssignment(exam.getUniqueId()) : (ea = exam.getAssignedPeriod() != null ? new ExamAssignment(exam) : null);
            if (ea != null) {
                per = html ? ea.getPeriodAbbreviationWithPref() : (ea.getPeriodPref() == null || !color ? "" : "@@COLOR " + PreferenceLevel.prolog2color(ea.getPeriodPref()) + " ") + ea.getPeriodAbbreviation();
                perCmp = ea.getPeriodOrd();
                rooms = "";
                for (ExamRoomInfo room : ea.getRooms()) {
                    if (rooms.length() > 0) {
                        rooms = rooms + nl;
                    }
                    rooms = rooms + (html ? room.toString() : (color ? "@@COLOR " + PreferenceLevel.prolog2color(PreferenceLevel.int2prolog(room.getPreference())) + " " : "") + room.getName());
                }
            }
            if (html) {
                if ((roomPref = roomPref + exam.getEffectivePrefHtmlForPrefType(RoomPref.class)).length() > 0 && !roomPref.endsWith(nl)) {
                    roomPref = roomPref + nl;
                }
                if ((roomPref = roomPref + exam.getEffectivePrefHtmlForPrefType(BuildingPref.class)).length() > 0 && !roomPref.endsWith(nl)) {
                    roomPref = roomPref + nl;
                }
                if ((roomPref = roomPref + exam.getEffectivePrefHtmlForPrefType(RoomFeaturePref.class)).length() > 0 && !roomPref.endsWith(nl)) {
                    roomPref = roomPref + nl;
                }
                if ((roomPref = roomPref + exam.getEffectivePrefHtmlForPrefType(RoomGroupPref.class)).endsWith(nl)) {
                    roomPref = roomPref.substring(0, roomPref.length() - nl.length());
                }
                if (ApplicationProperty.LegacyPeriodPreferences.isTrue()) {
                    if (timeText || 1 == exam.getExamType().getType()) {
                        if (1 == exam.getExamType().getType()) {
                            MidtermPeriodPreferenceModel midtermPeriodPreferenceModel = new MidtermPeriodPreferenceModel(exam.getSession(), exam.getExamType());
                            midtermPeriodPreferenceModel.load(exam);
                            perPref = perPref + midtermPeriodPreferenceModel.toString(true);
                        } else {
                            perPref = perPref + exam.getEffectivePrefHtmlForPrefType(ExamPeriodPref.class);
                        }
                    } else {
                        PeriodPreferenceModel periodPreferenceModel = new PeriodPreferenceModel(exam.getSession(), ea, exam.getExamType().getUniqueId());
                        rtt = new RequiredTimeTable(periodPreferenceModel);
                        periodPreferenceModel.load(exam);
                        String hint = rtt.print(false, timeVertical).replace(");\n</script>", "").replace("<script language=\"javascript\">\ndocument.write(", "").replace("\n", " ");
                        perPref = "<img border='0' src='pattern?v=" + (timeVertical ? 1 : 0) + "&x=" + exam.getUniqueId() + (ea == null ? "" : "&ap=" + ea.getPeriodId()) + "' onmouseover=\"showGwtHint(this, " + hint + ");\" onmouseout=\"hideGwtHint();\">";
                    }
                } else if (timeText || 1 == exam.getExamType().getType()) {
                    if (1 == exam.getExamType().getType()) {
                        MidtermPeriodPreferenceModel midtermPeriodPreferenceModel = new MidtermPeriodPreferenceModel(exam.getSession(), exam.getExamType());
                        midtermPeriodPreferenceModel.load(exam);
                        perPref = perPref + "<span onmouseover=\"showGwtExamPeriodPreferencesHint(this, '" + exam.getUniqueId() + "', null);\" onmouseout=\"hideGwtPeriodPreferencesHint();\">" + midtermPeriodPreferenceModel.toString(true) + "</span>";
                    } else {
                        perPref = perPref + "<span onmouseover=\"showGwtExamPeriodPreferencesHint(this, '" + exam.getUniqueId() + "', null);\" onmouseout=\"hideGwtPeriodPreferencesHint();\">" + exam.getEffectivePrefHtmlForPrefType(ExamPeriodPref.class) + "</span>";
                    }
                } else {
                    perPref = "<img border='0' src='pattern?v=" + (timeVertical ? 1 : 0) + "&x=" + exam.getUniqueId() + (ea == null ? "" : "&ap=" + ea.getPeriodId()) + "' onmouseover=\"showGwtExamPeriodPreferencesHint(this, '" + exam.getUniqueId() + "', null);\" onmouseout=\"hideGwtPeriodPreferencesHint();\">";
                }
                distPref = distPref + exam.getEffectivePrefHtmlForPrefType(DistributionPref.class);
            } else {
                for (Preference pref : exam.effectivePreferences(RoomPref.class)) {
                    if (roomPref.length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                }
                for (Preference pref : exam.effectivePreferences(BuildingPref.class)) {
                    if (roomPref.length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                }
                for (Preference pref : exam.effectivePreferences(RoomFeaturePref.class)) {
                    if (roomPref.length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                }
                for (Preference pref : exam.effectivePreferences(RoomGroupPref.class)) {
                    if (roomPref.length() > 0) {
                        roomPref = roomPref + nl;
                    }
                    roomPref = roomPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                }
                if (1 == exam.getExamType().getType()) {
                    MidtermPeriodPreferenceModel midtermPeriodPreferenceModel = new MidtermPeriodPreferenceModel(exam.getSession(), exam.getExamType());
                    midtermPeriodPreferenceModel.load(exam);
                    perPref = perPref + midtermPeriodPreferenceModel.toString(false, color);
                } else if (timeText || !color) {
                    for (Preference pref : exam.effectivePreferences(ExamPeriodPref.class)) {
                        if (perPref.length() > 0) {
                            perPref = perPref + nl;
                        }
                        perPref = perPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                    }
                } else {
                    PeriodPreferenceModel periodPreferenceModel = new PeriodPreferenceModel(exam.getSession(), ea, exam.getExamType().getUniqueId());
                    periodPreferenceModel.load(exam);
                    rtt = new RequiredTimeTable(periodPreferenceModel);
                    BufferedImage image = rtt.createBufferedImage(timeVertical);
                    if (image != null) {
                        table.addImage(exam.getUniqueId().toString(), image);
                        perPref = perPref + "@@IMAGE " + exam.getUniqueId().toString() + " ";
                    } else {
                        for (Preference pref : exam.effectivePreferences(ExamPeriodPref.class)) {
                            if (perPref.length() > 0) {
                                perPref = perPref + nl;
                            }
                            perPref = perPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + pref.preferenceText();
                        }
                    }
                }
                for (Preference pref : exam.effectivePreferences(DistributionPref.class)) {
                    if (distPref.length() > 0) {
                        distPref = distPref + nl;
                    }
                    distPref = distPref + (color ? "@@COLOR " + PreferenceLevel.prolog2color(pref.getPrefLevel().getPrefProlog()) + " " : "") + pref.getPrefLevel().getAbbreviation() + " " + ((DistributionPref)pref).preferenceText(true, true, " (", ", ", ")").replaceAll("&lt;", "<").replaceAll("&gt;", ">");
                }
            }
            int n = exam.getSize();
            String instructors = "";
            for (DepartmentalInstructor instructor : new TreeSet<DepartmentalInstructor>(exam.getInstructors())) {
                if (instructors.length() > 0) {
                    instructors = instructors + nl;
                }
                instructors = instructors + instructor.getName(instructorNameFormat);
            }
            table.addLine("onClick=\"document.location='examDetail.do?examId=" + exam.getUniqueId() + "';\"", new String[]{(html ? "<a name='" + exam.getUniqueId() + "'>" : "") + objects + (html ? "</a>" : ""), exam.getLength().toString(), 0 == exam.getSeatingType() ? "Normal" : "Exam", String.valueOf(n), exam.getMaxNbrRooms().toString(), instructors, perPref, roomPref, distPref, per, rooms}, new Comparable[]{exam.firstOwner(), exam.getLength(), exam.getSeatingType(), Integer.valueOf(n), exam.getMaxNbrRooms(), instructors, perPref, roomPref, distPref, perCmp, rooms}, exam.getUniqueId().toString());
        }
        return table;
    }
}

