/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.form.DepartmentEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;

@Service(value="/departmentEdit")
public class DepartmentEditAction
extends Action {
    @Autowired
    SessionContext sessionContext;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String id;
            Department department;
            String op;
            DepartmentEditForm myForm = (DepartmentEditForm)form;
            MessageResources rsc = this.getResources(request);
            this.sessionContext.checkPermission(Right.Departments);
            String string = op = myForm.getOp() != null ? myForm.getOp() : request.getParameter("op");
            if (rsc.getMessage("op.edit").equalsIgnoreCase(op) && (department = (Department)new DepartmentDAO().get(Long.valueOf(id = request.getParameter("id")))) != null) {
                this.sessionContext.checkPermission(department, Right.DepartmentEdit);
                myForm.load(department);
                return mapping.findForward("edit");
            }
            if (rsc.getMessage("button.addDepartment").equalsIgnoreCase(op)) {
                myForm.reset(mapping, request);
                myForm.setSessionId(this.sessionContext.getUser().getCurrentAcademicSessionId());
                myForm.setInheritInstructorPreferences(true);
                myForm.setAllowStudentScheduling(true);
                this.sessionContext.checkPermission(Right.DepartmentAdd);
                return mapping.findForward("add");
            }
            if (rsc.getMessage("button.updateDepartment").equalsIgnoreCase(op) || rsc.getMessage("button.saveDepartment").equalsIgnoreCase(op)) {
                ActionErrors errors = myForm.validate(mapping, request);
                if (errors.size() > 0) {
                    this.saveErrors(request, (ActionMessages)errors);
                    if (myForm.getId() != null) {
                        return mapping.findForward("edit");
                    }
                    return mapping.findForward("add");
                }
                if (myForm.getId() == null || myForm.getId().equals(0L)) {
                    this.sessionContext.checkPermission(Right.DepartmentAdd);
                } else {
                    this.sessionContext.checkPermission(myForm.getId(), "Department", Right.DepartmentEdit);
                }
                myForm.save(this.sessionContext);
            }
            if (rsc.getMessage("button.deleteDepartment").equalsIgnoreCase(op)) {
                this.doDelete(myForm);
            }
            if (myForm.getId() != null) {
                request.setAttribute(Constants.JUMP_TO_ATTR_NAME, (Object)myForm.getId().toString());
            }
            return mapping.findForward("back");
        }
        catch (Exception e) {
            Debug.error(e);
            throw e;
        }
    }

    private void doDelete(DepartmentEditForm frm) throws Exception {
        this.sessionContext.checkPermission(frm.getId(), "Department", Right.DepartmentDelete);
        Session hibSession = new DepartmentDAO().getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            Department department = (Department)new DepartmentDAO().get(frm.getId(), hibSession);
            if (department.isExternalManager().booleanValue()) {
                Iterator i = hibSession.createQuery("select c from Class_ c where c.managingDept.uniqueId=:deptId").setLong("deptId", department.getUniqueId().longValue()).iterate();
                while (i.hasNext()) {
                    Preference pref;
                    Iterator<Preference> j;
                    Class_ clazz = (Class_)i.next();
                    if (clazz.getSchedulingSubpart().getManagingDept().equals(department)) {
                        j = clazz.getSchedulingSubpart().getPreferences().iterator();
                        while (j.hasNext()) {
                            pref = j.next();
                            if (pref instanceof TimePref) continue;
                            j.remove();
                        }
                        clazz.getSchedulingSubpart().deleteAllDistributionPreferences(hibSession);
                        hibSession.saveOrUpdate((Object)clazz.getSchedulingSubpart());
                    }
                    clazz.setManagingDept(clazz.getControllingDept(), this.sessionContext.getUser(), hibSession);
                    j = clazz.getPreferences().iterator();
                    while (j.hasNext()) {
                        pref = j.next();
                        if (pref instanceof TimePref) continue;
                        j.remove();
                    }
                    clazz.deleteAllDistributionPreferences(hibSession);
                    hibSession.saveOrUpdate((Object)clazz);
                }
            } else {
                hibSession.createQuery("delete StudentClassEnrollment e where e.clazz.uniqueId in (select c.uniqueId from Class_ c, CourseOffering co where co.isControl=1 and c.schedulingSubpart.instrOfferingConfig.instructionalOffering=co.instructionalOffering and co.subjectArea.department.uniqueId=:deptId)").setLong("deptId", department.getUniqueId().longValue()).executeUpdate();
            }
            ChangeLog.addChange(hibSession, this.sessionContext, department, ChangeLog.Source.DEPARTMENT_EDIT, ChangeLog.Operation.DELETE, null, null);
            hibSession.delete((Object)department);
            tx.commit();
            HibernateUtil.clearCache();
        }
        catch (HibernateException e) {
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
            throw e;
        }
    }
}

