/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.unitime.commons.Debug;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ApplicationConfig;
import org.unitime.timetable.model.SessionConfig;
import org.unitime.timetable.model.dao._RootDAO;
import org.unitime.timetable.util.Constants;

public class ApplicationProperties {
    private static DateFormat sTempFileDateFormat = new SimpleDateFormat("yy-MM-dd_HHmmssSSS", Locale.US);
    private static Properties props = new Properties();
    private static long appPropertiesLastModified = -1L;
    private static long custPropertiesLastModified = -1L;
    private static PropertyFileChangeListener pfc = null;
    private static Properties configProps = null;
    private static Map<Long, Properties> sSessionProperties = new HashMap<Long, Properties>();
    private static final ThreadLocal<Long> sAcademicSession = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return null;
        }
    };

    public static Long getSessionId() {
        return sAcademicSession.get();
    }

    public static void setSessionId(Long sessionId) {
        if (sessionId == null) {
            sAcademicSession.remove();
        } else {
            sAcademicSession.set(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        try {
            URL custPropertiesUrl;
            URL appPropertiesUrl = ApplicationProperties.class.getClassLoader().getResource("application.properties");
            if (appPropertiesUrl != null) {
                Debug.info("Reading " + URLDecoder.decode(appPropertiesUrl.getPath(), "UTF-8") + " ...");
                props.load(appPropertiesUrl.openStream());
            }
            try {
                try {
                    appPropertiesLastModified = new File(appPropertiesUrl.toURI()).lastModified();
                }
                catch (URISyntaxException e) {
                    appPropertiesLastModified = new File(appPropertiesUrl.getPath()).lastModified();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            String customProperties = System.getProperty("tmtbl.custom.properties");
            if (customProperties == null) {
                customProperties = props.getProperty("tmtbl.custom.properties", "custom.properties");
            }
            if ((custPropertiesUrl = ApplicationProperties.class.getClassLoader().getResource(customProperties)) != null) {
                Debug.info("Reading " + URLDecoder.decode(custPropertiesUrl.getPath(), "UTF-8") + " ...");
                props.load(custPropertiesUrl.openStream());
                try {
                    try {
                        custPropertiesLastModified = new File(custPropertiesUrl.toURI()).lastModified();
                    }
                    catch (URISyntaxException e) {
                        custPropertiesLastModified = new File(custPropertiesUrl.getPath()).lastModified();
                    }
                }
                catch (Exception e) {}
            } else if (new File(customProperties).exists()) {
                Debug.info("Reading " + customProperties + " ...");
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(customProperties);
                    props.load(fis);
                    custPropertiesLastModified = new File(customProperties).lastModified();
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            props.putAll((Map<?, ?>)System.getProperties());
        }
        catch (Exception e) {
            Debug.error(e);
        }
    }

    public static void reloadIfNeeded() {
        if (appPropertiesLastModified >= 0L) {
            URL appPropertiesUrl = ApplicationProperties.class.getClassLoader().getResource("application.properties");
            long appPropTS = -1L;
            try {
                try {
                    appPropTS = new File(appPropertiesUrl.toURI()).lastModified();
                }
                catch (URISyntaxException e) {
                    appPropTS = new File(appPropertiesUrl.getPath()).lastModified();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            String customProperties = System.getProperty("tmtbl.custom.properties");
            if (customProperties == null) {
                customProperties = props.getProperty("tmtbl.custom.properties", "custom.properties");
            }
            URL custPropertiesUrl = ApplicationProperties.class.getClassLoader().getResource(customProperties);
            long custPropTS = -1L;
            try {
                if (custPropertiesUrl != null) {
                    try {
                        custPropTS = new File(custPropertiesUrl.toURI()).lastModified();
                    }
                    catch (URISyntaxException e) {
                        custPropTS = new File(custPropertiesUrl.getPath()).lastModified();
                    }
                } else if (new File(customProperties).exists()) {
                    custPropTS = new File(customProperties).lastModified();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (appPropTS > appPropertiesLastModified || custPropTS > custPropertiesLastModified) {
                ApplicationProperties.load();
            }
        }
    }

    public static Properties getConfigProperties() {
        if (configProps == null && _RootDAO.isConfigured()) {
            configProps = ApplicationConfig.toProperties();
        }
        return configProps == null ? new Properties() : configProps;
    }

    public static void clearConfigProperties() {
        configProps = null;
    }

    public static Properties getSessionProperties(Long sessionId) {
        if (!_RootDAO.isConfigured() || sessionId == null) {
            return new Properties();
        }
        Properties properties = sSessionProperties.get(sessionId);
        if (properties == null) {
            properties = SessionConfig.toProperties(sessionId);
            sSessionProperties.put(sessionId, properties);
        }
        return properties;
    }

    public static void clearSessionProperties(Long sessionId) {
        if (sessionId == null) {
            sSessionProperties.clear();
        } else {
            sSessionProperties.remove(sessionId);
        }
    }

    public static String getProperty(String key) {
        return ApplicationProperties.getProperty(key, null);
    }

    public static String getProperty(ApplicationProperty property) {
        return property.value();
    }

    public static String getProperty(String key, String defaultValue) {
        String value;
        if (key == null || key.trim().length() == 0) {
            return defaultValue;
        }
        Long sessionId = ApplicationProperties.getSessionId();
        if (sessionId != null && (value = ApplicationProperties.getSessionProperties(sessionId).getProperty(key)) != null) {
            return value;
        }
        value = ApplicationProperties.getConfigProperties().getProperty(key);
        if (value != null) {
            return value;
        }
        return props.getProperty(key, defaultValue);
    }

    public static Properties getDefaultProperties() {
        return props;
    }

    public static Properties getProperties() {
        Properties ret = (Properties)props.clone();
        ret.putAll((Map<?, ?>)ApplicationProperties.getConfigProperties());
        Long sessionId = ApplicationProperties.getSessionId();
        if (sessionId != null) {
            ret.putAll((Map<?, ?>)ApplicationProperties.getSessionProperties(sessionId));
        }
        return ret;
    }

    public static String getBasePath() {
        File parent;
        String base = ApplicationProperties.getProperty("unitime.base.dir");
        if (base != null) {
            return base;
        }
        URL url = ApplicationProperties.class.getProtectionDomain().getCodeSource().getLocation();
        if (url == null) {
            return null;
        }
        try {
            if ("jar".equals(url.getProtocol())) {
                url = ((JarURLConnection)url.openConnection()).getJarFileURL();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        File file = null;
        try {
            file = new File(url.toURI());
        }
        catch (Exception e) {
            file = new File(url.getFile());
            try {
                file = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
            }
            catch (UnsupportedEncodingException x) {
                file = new File(url.getFile());
            }
        }
        for (parent = file.getParentFile(); parent != null && !parent.getName().equals("WEB-INF"); parent = parent.getParentFile()) {
        }
        return parent == null ? null : parent.getAbsolutePath();
    }

    public static File getDataFolder() {
        if (ApplicationProperties.getProperty("unitime.data.dir") != null) {
            File dir = new File(ApplicationProperties.getProperty("unitime.data.dir"));
            dir.mkdirs();
            return dir;
        }
        if (ApplicationProperties.getProperty("catalina.base") != null) {
            File dir = new File(new File(ApplicationProperties.getProperty("catalina.base"), "data"), "unitime");
            dir.mkdirs();
            return dir;
        }
        File dir = new File(ApplicationProperties.getBasePath());
        if (!dir.getName().equals("webapps")) {
            dir = dir.getParentFile();
        }
        dir = dir.getParentFile().getParentFile();
        dir = new File(dir, "data");
        dir = new File(dir, "unitime");
        dir.mkdirs();
        return dir;
    }

    public static File getBlobFolder() {
        File dir = new File(ApplicationProperties.getDataFolder(), "blob");
        dir.mkdir();
        return dir;
    }

    public static File getRestoreFolder() {
        File dir = new File(ApplicationProperties.getDataFolder(), "restore");
        dir.mkdir();
        return dir;
    }

    public static File getPassivationFolder() {
        File dir = new File(ApplicationProperties.getDataFolder(), "passivate");
        dir.mkdir();
        return dir;
    }

    public static File getTempFolder() {
        File dir = new File(new File(ApplicationProperties.getBasePath()).getParentFile(), "temp");
        dir.mkdir();
        return dir;
    }

    public static synchronized File getTempFile(String prefix, String ext) {
        File file = null;
        String ts = sTempFileDateFormat.format(new Date());
        try {
            file = File.createTempFile(prefix + "_" + ts, "." + ext, ApplicationProperties.getTempFolder());
        }
        catch (IOException e) {
            Debug.error(e);
            file = new File(ApplicationProperties.getTempFolder(), prefix + "_" + ts + "." + ext);
        }
        file.deleteOnExit();
        return file;
    }

    public static void stopListener() {
        if (pfc != null && pfc.isAlive() && !pfc.isInterrupted()) {
            Debug.info("Stopping Property File Change Listener Thread ...");
            pfc.interrupt();
        }
    }

    static {
        ApplicationProperties.load();
        String dynamicReload = props.getProperty("tmtbl.properties.dynamic_reload", null);
        if ((appPropertiesLastModified > 0L || custPropertiesLastModified > 0L) && dynamicReload != null && dynamicReload.equalsIgnoreCase("true")) {
            pfc = new PropertyFileChangeListener();
            pfc.start();
        }
    }

    static class PropertyFileChangeListener
    extends Thread {
        public PropertyFileChangeListener() {
            this.setName("Property File Change Listener Thread");
            this.setDaemon(true);
        }

        public void run() {
            try {
                Debug.info("Starting Property File Change Listener Thread ...");
                long threadInterval = Constants.getPositiveInteger(ApplicationProperties.getProperty("tmtbl.properties.dynamic_reload_interval"), 15000);
                try {
                    while (true) {
                        PropertyFileChangeListener.sleep(threadInterval);
                        ApplicationProperties.reloadIfNeeded();
                    }
                }
                catch (InterruptedException e) {
                    Debug.info("Property File Change Listener Thread interrupted ...");
                }
            }
            catch (Exception e) {
                Debug.warning("Property File Change Listener Thread failed, reason: " + e.getMessage());
            }
        }
    }
}

