/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.cpsolver.coursett.constraint.InstructorConstraint;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.model.Configuration;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimetableModel;

public class Student
implements Comparable<Student> {
    private static Logger sLogger = Logger.getLogger(Student.class);
    public static boolean USE_DISTANCE_CACHE = false;
    Long iStudentId = null;
    HashMap<Long, Double> iOfferings = new HashMap();
    Set<Lecture> iLectures = new HashSet<Lecture>();
    Set<Configuration> iConfigurations = new HashSet<Configuration>();
    HashMap<Long, Set<Lecture>> iCanNotEnrollSections = null;
    HashMap<Student, Double> iDistanceCache = null;
    HashSet<Placement> iCommitedPlacements = null;
    private String iAcademicArea = null;
    private String iAcademicClassification = null;
    private String iMajor = null;
    private String iCurriculum = null;
    HashMap<Long, Double> iOfferingPriority = new HashMap();
    private InstructorConstraint iInstructor = null;

    public Student(Long studentId) {
        this.iStudentId = studentId;
    }

    public void addOffering(Long offeringId, double weight, Double priority) {
        this.iOfferings.put(offeringId, weight);
        if (priority != null) {
            this.iOfferingPriority.put(offeringId, priority);
        }
    }

    public void addOffering(Long offeringId, double weight) {
        this.addOffering(offeringId, weight, null);
    }

    public Map<Long, Double> getOfferingsMap() {
        return this.iOfferings;
    }

    public Set<Long> getOfferings() {
        return this.iOfferings.keySet();
    }

    public boolean hasOffering(Long offeringId) {
        return this.iOfferings.containsKey(offeringId);
    }

    public InstructorConstraint getInstructor() {
        return this.iInstructor;
    }

    public void setInstructor(InstructorConstraint instructor) {
        this.iInstructor = instructor;
    }

    public Double getPriority(Long offeringId) {
        return offeringId == null ? null : this.iOfferingPriority.get(offeringId);
    }

    public Double getPriority(Configuration configuration) {
        return configuration == null ? null : this.getPriority(configuration.getOfferingId());
    }

    public Double getPriority(Lecture lecture) {
        return lecture == null ? null : this.getPriority(lecture.getConfiguration());
    }

    public Double getConflictingPriorty(Lecture l1, Lecture l2) {
        Double p1 = this.getPriority(l1);
        Double p2 = this.getPriority(l2);
        return p1 == null ? null : (p2 == null ? null : Double.valueOf(Math.min(p1, p2)));
    }

    public double getOfferingWeight(Configuration configuration) {
        if (configuration == null) {
            return 1.0;
        }
        return this.getOfferingWeight(configuration.getOfferingId());
    }

    public double getOfferingWeight(Long offeringId) {
        Double weight = this.iOfferings.get(offeringId);
        return weight == null ? 0.0 : weight;
    }

    public boolean canUnenroll(Lecture lecture) {
        if (this.getInstructor() != null) {
            return !this.getInstructor().variables().contains(lecture);
        }
        return true;
    }

    public boolean canEnroll(Lecture lecture) {
        if (this.iCanNotEnrollSections != null) {
            Set<Lecture> canNotEnrollLectures = this.iCanNotEnrollSections.get(lecture.getConfiguration().getOfferingId());
            return this.canEnroll(canNotEnrollLectures, lecture, true);
        }
        return true;
    }

    private boolean canEnroll(Set<Lecture> canNotEnrollLectures, Lecture lecture, boolean checkParents) {
        if (canNotEnrollLectures == null) {
            return true;
        }
        if (canNotEnrollLectures.contains(lecture)) {
            return false;
        }
        if (checkParents) {
            for (Lecture parent = lecture.getParent(); parent != null; parent = parent.getParent()) {
                if (!canNotEnrollLectures.contains(parent)) continue;
                return false;
            }
        }
        if (lecture.hasAnyChildren()) {
            for (Long subpartId : lecture.getChildrenSubpartIds()) {
                boolean canEnrollChild = false;
                for (Lecture childLecture : lecture.getChildren(subpartId)) {
                    if (!this.canEnroll(canNotEnrollLectures, childLecture, false)) continue;
                    canEnrollChild = true;
                    break;
                }
                if (canEnrollChild) continue;
                return false;
            }
        }
        return true;
    }

    public void addCanNotEnroll(Lecture lecture) {
        if (this.iCanNotEnrollSections == null) {
            this.iCanNotEnrollSections = new HashMap();
        }
        if (lecture.getConfiguration() == null) {
            sLogger.warn("Student.addCanNotEnroll(" + lecture + ") -- given lecture has no configuration associated with.");
            return;
        }
        Set<Lecture> canNotEnrollLectures = this.iCanNotEnrollSections.get(lecture.getConfiguration().getOfferingId());
        if (canNotEnrollLectures == null) {
            canNotEnrollLectures = new HashSet<Lecture>();
            this.iCanNotEnrollSections.put(lecture.getConfiguration().getOfferingId(), canNotEnrollLectures);
        }
        canNotEnrollLectures.add(lecture);
    }

    public void addCanNotEnroll(Long offeringId, Collection<Lecture> lectures) {
        Set<Lecture> canNotEnrollLectures;
        if (lectures == null || lectures.isEmpty()) {
            return;
        }
        if (this.iCanNotEnrollSections == null) {
            this.iCanNotEnrollSections = new HashMap();
        }
        if ((canNotEnrollLectures = this.iCanNotEnrollSections.get(offeringId)) == null) {
            canNotEnrollLectures = new HashSet<Lecture>();
            this.iCanNotEnrollSections.put(offeringId, canNotEnrollLectures);
        }
        canNotEnrollLectures.addAll(lectures);
    }

    public Map<Long, Set<Lecture>> canNotEnrollSections() {
        return this.iCanNotEnrollSections;
    }

    public void addLecture(Lecture lecture) {
        this.iLectures.add(lecture);
    }

    public void removeLecture(Lecture lecture) {
        this.iLectures.remove(lecture);
    }

    public Set<Lecture> getLectures() {
        return this.iLectures;
    }

    public void addConfiguration(Configuration config) {
        this.iConfigurations.add(config);
    }

    public void removeConfiguration(Configuration config) {
        this.iConfigurations.remove(config);
    }

    public Set<Configuration> getConfigurations() {
        return this.iConfigurations;
    }

    public Long getId() {
        return this.iStudentId;
    }

    public double getDistance(Student student) {
        Double dist;
        Double d = dist = USE_DISTANCE_CACHE && this.iDistanceCache != null ? this.iDistanceCache.get(student) : null;
        if (dist == null) {
            int same = 0;
            for (Long o : this.getOfferings()) {
                if (!student.getOfferings().contains(o)) continue;
                ++same;
            }
            double all = student.getOfferings().size() + this.getOfferings().size();
            double dif = all - 2.0 * (double)same;
            dist = new Double(dif / all);
            if (USE_DISTANCE_CACHE) {
                if (this.iDistanceCache == null) {
                    this.iDistanceCache = new HashMap();
                }
                this.iDistanceCache.put(student, dist);
            }
        }
        return dist;
    }

    public void clearDistanceCache() {
        if (USE_DISTANCE_CACHE && this.iDistanceCache != null) {
            this.iDistanceCache.clear();
        }
    }

    public String toString() {
        return String.valueOf(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    @Override
    public int compareTo(Student s) {
        return this.getId().compareTo(s.getId());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Student)) {
            return false;
        }
        return this.getId().equals(((Student)o).getId());
    }

    public void addCommitedPlacement(Placement placement) {
        if (this.iCommitedPlacements == null) {
            this.iCommitedPlacements = new HashSet();
        }
        this.iCommitedPlacements.add(placement);
    }

    public Set<Placement> getCommitedPlacements() {
        return this.iCommitedPlacements;
    }

    public Set<Placement> conflictPlacements(Placement placement) {
        if (this.iCommitedPlacements == null) {
            return null;
        }
        HashSet<Placement> ret = new HashSet<Placement>();
        Lecture lecture = (Lecture)placement.variable();
        for (Placement commitedPlacement : this.iCommitedPlacements) {
            Lecture commitedLecture = (Lecture)commitedPlacement.variable();
            if (lecture.getSchedulingSubpartId() != null && lecture.getSchedulingSubpartId().equals(commitedLecture.getSchedulingSubpartId()) || lecture.isToIgnoreStudentConflictsWith(commitedLecture) || !JenrlConstraint.isInConflict(commitedPlacement, placement, ((TimetableModel)((Lecture)placement.variable()).getModel()).getDistanceMetric())) continue;
            ret.add(commitedPlacement);
        }
        return ret;
    }

    public int countConflictPlacements(Placement placement) {
        Set<Placement> conflicts = this.conflictPlacements(placement);
        double w = this.getOfferingWeight(((Lecture)placement.variable()).getConfiguration());
        return (int)Math.round(conflicts == null ? 0.0 : this.avg(w, 1.0) * (double)conflicts.size());
    }

    public double getJenrlWeight(Lecture l1, Lecture l2) {
        if (this.getInstructor() != null && (this.getInstructor().variables().contains(l1) || this.getInstructor().variables().contains(l2))) {
            return 1.0;
        }
        return this.avg(this.getOfferingWeight(l1.getConfiguration()), this.getOfferingWeight(l2.getConfiguration()));
    }

    public double avg(double w1, double w2) {
        return Math.sqrt(w1 * w2);
    }

    public String getAcademicArea() {
        return this.iAcademicArea;
    }

    public void setAcademicArea(String acadArea) {
        this.iAcademicArea = acadArea;
    }

    public String getAcademicClassification() {
        return this.iAcademicClassification;
    }

    public void setAcademicClassification(String acadClasf) {
        this.iAcademicClassification = acadClasf;
    }

    public String getMajor() {
        return this.iMajor;
    }

    public void setMajor(String major) {
        this.iMajor = major;
    }

    public String getCurriculum() {
        return this.iCurriculum;
    }

    public void setCurriculum(String curriculum) {
        this.iCurriculum = curriculum;
    }
}

