/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.ifs.assignment.Assignment;

public class Configuration {
    private Long iConfigId = null;
    private Long iOfferingId = null;
    private HashMap<Long, Set<Lecture>> iTopLectures = new HashMap();
    private List<Configuration> iAltConfigurations = null;
    private int iLimit = -1;

    public Configuration(Long offeringId, Long configId, int limit) {
        this.iOfferingId = offeringId;
        this.iConfigId = configId;
        this.iLimit = limit;
    }

    public Long getOfferingId() {
        return this.iOfferingId;
    }

    public Long getConfigId() {
        return this.iConfigId;
    }

    public void addTopLecture(Lecture lecture) {
        Set<Lecture> lectures = this.iTopLectures.get(lecture.getSchedulingSubpartId());
        if (lectures == null) {
            lectures = new HashSet<Lecture>();
            this.iTopLectures.put(lecture.getSchedulingSubpartId(), lectures);
        }
        lectures.add(lecture);
    }

    public Map<Long, Set<Lecture>> getTopLectures() {
        return this.iTopLectures;
    }

    public Set<Long> getTopSubpartIds() {
        return this.iTopLectures.keySet();
    }

    public Set<Lecture> getTopLectures(Long subpartId) {
        return this.iTopLectures.get(subpartId);
    }

    public void setAltConfigurations(List<Configuration> altConfigurations) {
        this.iAltConfigurations = altConfigurations;
    }

    public void addAltConfiguration(Configuration configuration) {
        if (this.iAltConfigurations == null) {
            this.iAltConfigurations = new ArrayList<Configuration>();
        }
        this.iAltConfigurations.add(configuration);
    }

    public List<Configuration> getAltConfigurations() {
        return this.iAltConfigurations;
    }

    public Set<Student> students() {
        HashSet<Student> students = new HashSet<Student>();
        for (Set<Lecture> lectures : this.iTopLectures.values()) {
            for (Lecture l : lectures) {
                students.addAll(l.students());
            }
        }
        return students;
    }

    public boolean hasConflict(Assignment<Lecture, Placement> assignment, Student student) {
        for (Lecture lecture : student.getLectures()) {
            Placement placement = assignment.getValue(lecture);
            if (placement == null || !this.equals(lecture.getConfiguration())) continue;
            if (student.countConflictPlacements(placement) > 0) {
                return true;
            }
            for (Lecture x : student.getLectures()) {
                JenrlConstraint jenrl;
                if (assignment.getValue(x) == null || x.equals(lecture) || (jenrl = lecture.jenrlConstraint(x)) == null || !jenrl.isInConflict(assignment)) continue;
                return true;
            }
        }
        return false;
    }

    public int getLimit() {
        if (this.iLimit < 0) {
            double totalWeight = 0.0;
            for (Student s : this.students()) {
                totalWeight += s.getOfferingWeight(this.getOfferingId());
            }
            this.iLimit = (int)Math.round(totalWeight);
        }
        return this.iLimit;
    }

    public int hashCode() {
        return this.getConfigId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Configuration)) {
            return false;
        }
        return this.getConfigId().equals(((Configuration)o).getConfigId());
    }
}

