/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.constraint.GroupConstraint;
import org.cpsolver.coursett.criteria.SameSubpartBalancingPenalty;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class SpreadConstraint
extends ConstraintWithContext<Lecture, Placement, SpreadConstraintContext>
implements WeakeningConstraint<Lecture, Placement> {
    private boolean iInteractive = false;
    private double iSpreadFactor = 1.2;
    private int iUnassignmentsToWeaken = 250;
    private String iName = null;
    private int iFirstDaySlot;
    private int iLastDaySlot;
    private int iFirstWorkDay;
    private int iLastWorkDay;
    public static boolean USE_MOST_IMPROVEMENT_ADEPTS = false;

    public SpreadConstraint(String name, double spreadFactor, int unassignmentsToWeaken, boolean interactiveMode, int firstDaySlot, int lastDaySlot, int firstWorkDay, int lastWorkDay) {
        this.iName = name;
        this.iSpreadFactor = spreadFactor;
        this.iUnassignmentsToWeaken = unassignmentsToWeaken;
        this.iInteractive = interactiveMode;
        this.iFirstDaySlot = firstDaySlot;
        this.iLastDaySlot = lastDaySlot;
        this.iFirstWorkDay = firstWorkDay;
        this.iLastWorkDay = lastWorkDay;
    }

    public SpreadConstraint(DataProperties config, String name) {
        this(name, config.getPropertyDouble("Spread.SpreadFactor", 1.2), config.getPropertyInt("Spread.Unassignments2Weaken", 250), config.getPropertyBoolean("General.InteractiveMode", false), config.getPropertyInt("General.FirstDaySlot", Constants.DAY_SLOTS_FIRST), config.getPropertyInt("General.LastDaySlot", Constants.DAY_SLOTS_LAST), config.getPropertyInt("General.FirstWorkDay", 0), config.getPropertyInt("General.LastWorkDay", Constants.NR_DAYS_WEEK - 1));
    }

    protected Criterion<Lecture, Placement> getCriterion() {
        return this.getModel().getCriterion(SameSubpartBalancingPenalty.class);
    }

    public Placement getAdept(Assignment<Lecture, Placement> assignment, Placement placement, int[][] nrCourses, Set<Placement> conflicts) {
        int imp;
        Placement plac;
        Placement adept = null;
        int improvement = 0;
        for (Lecture lect : this.variables()) {
            if (lect.isCommitted() || (plac = assignment.getValue(lect)) == null || plac.equals(placement) || ((Lecture)placement.variable()).equals(plac.variable()) || conflicts.contains(plac) || (imp = this.getPenaltyIfUnassigned(assignment, plac, nrCourses)) == 0 || adept != null && imp <= improvement) continue;
            adept = plac;
            improvement = imp;
        }
        if (adept != null) {
            return adept;
        }
        for (Lecture lect : this.variables()) {
            if (!lect.isCommitted() || (plac = assignment.getValue(lect)) == null || plac.equals(placement) || conflicts.contains(plac) || (imp = this.getPenaltyIfUnassigned(assignment, plac, nrCourses)) == 0 || adept != null && imp <= improvement) continue;
            adept = plac;
            improvement = imp;
        }
        return adept;
    }

    private Set<Placement>[] getAdepts(Assignment<Lecture, Placement> assignment, Placement placement, int[][] nrCourses, Set<Placement> conflicts) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > this.iLastDaySlot) {
            return null;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < this.iFirstDaySlot) {
            return null;
        }
        HashSet[] adepts = new HashSet[]{new HashSet(), new HashSet()};
        for (int i = Math.max(firstSlot, this.iFirstDaySlot); i <= Math.min(endSlot, this.iLastDaySlot); ++i) {
            for (int j = this.iFirstWorkDay; j <= this.iLastWorkDay; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0 || nrCourses[i - this.iFirstDaySlot][j - this.iFirstWorkDay] < context.getMaxCourses(i, j)) continue;
                for (Placement p : context.getCourses(i, j)) {
                    if (conflicts.contains(p) || p.equals(placement) || ((Lecture)p.variable()).equals(placement.variable())) continue;
                    adepts[((Lecture)p.variable()).isCommitted() ? 1 : 0].add(p);
                }
            }
        }
        return adepts;
    }

    private int getPenaltyIfUnassigned(Assignment<Lecture, Placement> assignment, Placement placement, int[][] nrCourses) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > this.iLastDaySlot) {
            return 0;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < this.iFirstDaySlot) {
            return 0;
        }
        int penalty = 0;
        for (int i = Math.max(firstSlot, this.iFirstDaySlot); i <= Math.min(endSlot, this.iLastDaySlot); ++i) {
            for (int j = this.iFirstWorkDay; j <= this.iLastWorkDay; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0 || nrCourses[i - this.iFirstDaySlot][j - this.iFirstWorkDay] <= context.getMaxCourses(i, j)) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    private int tryUnassign(Assignment<Lecture, Placement> assignment, Placement placement, int[][] nrCourses) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > this.iLastDaySlot) {
            return 0;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < this.iFirstDaySlot) {
            return 0;
        }
        int improvement = 0;
        for (int i = Math.max(firstSlot, this.iFirstDaySlot); i <= Math.min(endSlot, this.iLastDaySlot); ++i) {
            for (int j = this.iFirstWorkDay; j <= this.iLastWorkDay; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                if (nrCourses[i - this.iFirstDaySlot][j - this.iFirstWorkDay] > context.getMaxCourses(i, j)) {
                    ++improvement;
                }
                int[] nArray = nrCourses[i - this.iFirstDaySlot];
                int n = j - this.iFirstWorkDay;
                nArray[n] = nArray[n] - 1;
            }
        }
        return improvement;
    }

    private int tryAssign(Assignment<Lecture, Placement> assignment, Placement placement, int[][] nrCourses) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > this.iLastDaySlot) {
            return 0;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < this.iFirstDaySlot) {
            return 0;
        }
        int penalty = 0;
        for (int i = Math.max(firstSlot, this.iFirstDaySlot); i <= Math.min(endSlot, this.iLastDaySlot); ++i) {
            for (int j = this.iFirstWorkDay; j <= this.iLastWorkDay; ++j) {
                int dayCode = Constants.DAY_CODES[j];
                if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                int[] nArray = nrCourses[i - this.iFirstDaySlot];
                int n = j - this.iFirstWorkDay;
                nArray[n] = nArray[n] + 1;
                if (nrCourses[i - this.iFirstDaySlot][j - this.iFirstWorkDay] <= context.getMaxCourses(i, j)) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement placement, Set<Placement> conflicts) {
        block12: {
            int[][] nrCourses;
            int penalty;
            SpreadConstraintContext context;
            block11: {
                Placement plac;
                context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
                if (context.getUnassignmentsToWeaken() == 0) {
                    return;
                }
                penalty = context.getCurrentPenalty() + this.getPenalty(assignment, placement);
                if (penalty <= context.getMaxAllowedPenalty()) {
                    return;
                }
                int firstSlot = placement.getTimeLocation().getStartSlot();
                if (firstSlot > this.iLastDaySlot) {
                    return;
                }
                int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
                if (endSlot < this.iFirstDaySlot) {
                    return;
                }
                nrCourses = new int[this.iLastDaySlot - this.iFirstDaySlot + 1][this.iLastWorkDay - this.iFirstWorkDay + 1];
                for (int i = 0; i < this.iLastDaySlot - this.iFirstDaySlot + 1; ++i) {
                    for (int j = 0; j < this.iLastWorkDay - this.iFirstWorkDay + 1; ++j) {
                        nrCourses[i][j] = context.getNrCourses(i + this.iFirstDaySlot, j + this.iFirstWorkDay, placement);
                    }
                }
                this.tryAssign(assignment, placement, nrCourses);
                for (Lecture lect : this.variables()) {
                    if (lect.equals(placement.variable())) continue;
                    if (conflicts.contains(lect)) {
                        penalty -= this.tryUnassign(assignment, assignment.getValue(lect), nrCourses);
                    }
                    if (penalty > context.getMaxAllowedPenalty()) continue;
                    return;
                }
                if (!USE_MOST_IMPROVEMENT_ADEPTS) break block11;
                while (penalty > context.getMaxAllowedPenalty() && (plac = this.getAdept(assignment, placement, nrCourses, conflicts)) != null) {
                    conflicts.add(plac);
                    penalty -= this.tryUnassign(assignment, plac, nrCourses);
                }
                break block12;
            }
            if (penalty <= context.getMaxAllowedPenalty()) break block12;
            Set<Placement>[] adepts = this.getAdepts(assignment, placement, nrCourses, conflicts);
            for (int i = 0; penalty > context.getMaxAllowedPenalty() && i < adepts.length; ++i) {
                while (!adepts[i].isEmpty() && penalty > context.getMaxAllowedPenalty()) {
                    Placement plac = ToolBox.random(adepts[i]);
                    adepts[i].remove(plac);
                    conflicts.add(plac);
                    penalty -= this.tryUnassign(assignment, plac, nrCourses);
                }
            }
        }
    }

    @Override
    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement placement) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        if (context.getUnassignmentsToWeaken() == 0) {
            return false;
        }
        return this.getPenalty(assignment, placement) + context.getCurrentPenalty() > context.getMaxAllowedPenalty();
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment) {
        ((SpreadConstraintContext)this.getContext((Assignment)assignment)).weaken();
    }

    @Override
    public String getName() {
        return this.iName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Time Spread between ");
        Iterator e = this.variables().iterator();
        while (e.hasNext()) {
            Lecture v = (Lecture)e.next();
            sb.append(v.getName());
            if (!e.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public int getPenalty(Assignment<Lecture, Placement> assignment) {
        return ((SpreadConstraintContext)this.getContext((Assignment)assignment)).getCurrentPenalty();
    }

    public int getPenaltyEstimate(Assignment<Lecture, Placement> assignment) {
        int i;
        int endSlot;
        int firstSlot;
        double[][] histogramPerDay = new double[this.iLastDaySlot - this.iFirstDaySlot + 1][this.iLastWorkDay - this.iFirstWorkDay + 1];
        int[][] maxCourses = new int[this.iLastDaySlot - this.iFirstDaySlot + 1][this.iLastWorkDay - this.iFirstWorkDay + 1];
        int[][] nrCourses = new int[this.iLastDaySlot - this.iFirstDaySlot + 1][this.iLastWorkDay - this.iFirstWorkDay + 1];
        for (int i2 = 0; i2 < this.iLastDaySlot - this.iFirstDaySlot + 1; ++i2) {
            for (int j = 0; j < this.iLastWorkDay - this.iFirstWorkDay + 1; ++j) {
                histogramPerDay[i2][j] = 0.0;
            }
        }
        int totalUsedSlots = 0;
        for (Lecture lecture : this.variables()) {
            Placement firstPlacement;
            List<Placement> values = lecture.values(assignment);
            Placement placement = firstPlacement = values.isEmpty() ? null : values.get(0);
            if (firstPlacement != null) {
                totalUsedSlots += firstPlacement.getTimeLocation().getNrSlotsPerMeeting() * firstPlacement.getTimeLocation().getNrMeetings();
            }
            for (Placement p : values) {
                firstSlot = p.getTimeLocation().getStartSlot();
                if (firstSlot > this.iLastDaySlot || (endSlot = firstSlot + p.getTimeLocation().getNrSlotsPerMeeting() - 1) < this.iFirstDaySlot) continue;
                for (i = Math.max(firstSlot, this.iFirstDaySlot); i <= Math.min(endSlot, this.iLastDaySlot); ++i) {
                    int dayCode = p.getTimeLocation().getDayCode();
                    for (int j = this.iFirstWorkDay; j <= this.iLastWorkDay; ++j) {
                        if ((dayCode & Constants.DAY_CODES[j]) == 0) continue;
                        double[] dArray = histogramPerDay[i - this.iFirstDaySlot];
                        int n = j - this.iFirstWorkDay;
                        dArray[n] = dArray[n] + 1.0 / (double)values.size();
                    }
                }
            }
        }
        double threshold = this.iSpreadFactor * ((double)totalUsedSlots / (double)((this.iLastWorkDay - this.iFirstWorkDay + 1) * (this.iLastDaySlot - this.iFirstDaySlot + 1)));
        for (int i3 = 0; i3 < this.iLastDaySlot - this.iFirstDaySlot + 1; ++i3) {
            for (int j = 0; j < this.iLastWorkDay - this.iFirstWorkDay + 1; ++j) {
                nrCourses[i3][j] = 0;
                maxCourses[i3][j] = (int)(0.999 + (histogramPerDay[i3][j] <= threshold ? this.iSpreadFactor * histogramPerDay[i3][j] : histogramPerDay[i3][j]));
            }
        }
        int currentPenalty = 0;
        for (Lecture lecture : this.variables()) {
            Placement placement = assignment.getValue(lecture);
            if (placement == null || (firstSlot = placement.getTimeLocation().getStartSlot()) > this.iLastDaySlot || (endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1) < this.iFirstDaySlot) continue;
            for (i = Math.max(firstSlot, this.iFirstDaySlot); i <= Math.min(endSlot, this.iLastDaySlot); ++i) {
                for (int j = this.iFirstWorkDay; j <= this.iLastWorkDay; ++j) {
                    int dayCode = Constants.DAY_CODES[j];
                    if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                    int[] nArray = nrCourses[i - this.iFirstDaySlot];
                    int n = j - this.iFirstWorkDay;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        for (int i4 = 0; i4 < this.iLastDaySlot - this.iFirstDaySlot + 1; ++i4) {
            for (int j = 0; j < this.iLastWorkDay - this.iFirstWorkDay + 1; ++j) {
                currentPenalty += Math.max(0, nrCourses[i4][j] - maxCourses[i4][j]);
            }
        }
        return currentPenalty;
    }

    public int getMaxPenalty(Assignment<Lecture, Placement> assignment, Placement placement) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        int penalty = 0;
        TimeLocation.IntEnumeration e = placement.getTimeLocation().getSlots();
        while (e.hasMoreElements()) {
            int dif;
            int slot = (Integer)e.nextElement();
            int day = slot / 288;
            int time = slot % 288;
            if (time < this.iFirstDaySlot || time > this.iLastDaySlot || day < this.iFirstWorkDay || day > this.iLastWorkDay || (dif = 1 + context.getNrCourses(time, day, placement) - context.getMaxCourses(time, day)) <= penalty) continue;
            penalty = dif;
        }
        return penalty;
    }

    public int getPenalty(Assignment<Lecture, Placement> assignment, Placement placement) {
        SpreadConstraintContext context = (SpreadConstraintContext)this.getContext((Assignment)assignment);
        int firstSlot = placement.getTimeLocation().getStartSlot();
        if (firstSlot > this.iLastDaySlot) {
            return 0;
        }
        int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
        if (endSlot < this.iFirstDaySlot) {
            return 0;
        }
        int penalty = 0;
        int min = Math.max(firstSlot, this.iFirstDaySlot);
        int max = Math.min(endSlot, this.iLastDaySlot);
        for (int j = this.iFirstWorkDay; j <= this.iLastWorkDay; ++j) {
            int dayCode = Constants.DAY_CODES[j];
            if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
            for (int i = min; i <= max; ++i) {
                if (context.getNrCourses(i, j, placement) < context.getMaxCourses(i, j)) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    @Override
    public void addVariable(Lecture lecture) {
        if (lecture.canShareRoom()) {
            for (GroupConstraint gc : lecture.groupConstraints()) {
                if (gc.getType() != GroupConstraint.ConstraintType.MEET_WITH || gc.variables().indexOf(lecture) <= 0) continue;
                return;
            }
        }
        super.addVariable(lecture);
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment, Placement value) {
        while (this.inConflict(assignment, value)) {
            ((SpreadConstraintContext)this.getContext((Assignment)assignment)).weaken(((SpreadConstraintContext)this.getContext((Assignment)assignment)).getCurrentPenalty() + this.getPenalty(assignment, value));
        }
    }

    @Override
    public SpreadConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new SpreadConstraintContext(assignment);
    }

    public class SpreadConstraintContext
    implements AssignmentConstraintContext<Lecture, Placement> {
        private int iMaxAllowedPenalty = 0;
        private long iUnassignment = 0L;
        private Set<Placement>[][] iCourses = null;
        private int[][] iMaxCourses = null;
        private int iCurrentPenalty = 0;

        public SpreadConstraintContext(Assignment<Lecture, Placement> assignment) {
            int dayCode;
            this.iCourses = new Set[SpreadConstraint.this.iLastDaySlot - SpreadConstraint.this.iFirstDaySlot + 1][SpreadConstraint.this.iLastWorkDay - SpreadConstraint.this.iFirstWorkDay + 1];
            if (SpreadConstraint.this.iInteractive) {
                SpreadConstraint.this.iUnassignmentsToWeaken = 0;
            }
            for (int i = 0; i < this.iCourses.length; ++i) {
                for (int j = 0; j < SpreadConstraint.this.iLastWorkDay - SpreadConstraint.this.iFirstWorkDay + 1; ++j) {
                    this.iCourses[i][j] = new HashSet<Placement>(10);
                }
            }
            double[][] histogramPerDay = new double[SpreadConstraint.this.iLastDaySlot - SpreadConstraint.this.iFirstDaySlot + 1][SpreadConstraint.this.iLastWorkDay - SpreadConstraint.this.iFirstWorkDay + 1];
            this.iMaxCourses = new int[SpreadConstraint.this.iLastDaySlot - SpreadConstraint.this.iFirstDaySlot + 1][SpreadConstraint.this.iLastWorkDay - SpreadConstraint.this.iFirstWorkDay + 1];
            for (int i = 0; i < SpreadConstraint.this.iLastDaySlot - SpreadConstraint.this.iFirstDaySlot + 1; ++i) {
                for (int j = 0; j < SpreadConstraint.this.iLastWorkDay - SpreadConstraint.this.iFirstWorkDay + 1; ++j) {
                    histogramPerDay[i][j] = 0.0;
                }
            }
            int totalUsedSlots = 0;
            for (Lecture lecture : SpreadConstraint.this.variables()) {
                Placement firstPlacement;
                List<Placement> values = lecture.values(assignment);
                Placement placement = firstPlacement = values.isEmpty() ? null : values.get(0);
                if (firstPlacement != null) {
                    totalUsedSlots += firstPlacement.getTimeLocation().getNrSlotsPerMeeting() * firstPlacement.getTimeLocation().getNrMeetings();
                }
                for (Placement p : values) {
                    int endSlot;
                    int firstSlot = p.getTimeLocation().getStartSlot();
                    if (firstSlot > SpreadConstraint.this.iLastDaySlot || (endSlot = firstSlot + p.getTimeLocation().getNrSlotsPerMeeting() - 1) < SpreadConstraint.this.iFirstDaySlot) continue;
                    for (int i = Math.max(firstSlot, SpreadConstraint.this.iFirstDaySlot); i <= Math.min(endSlot, SpreadConstraint.this.iLastDaySlot); ++i) {
                        dayCode = p.getTimeLocation().getDayCode();
                        for (int j = SpreadConstraint.this.iFirstWorkDay; j <= SpreadConstraint.this.iLastWorkDay; ++j) {
                            if ((dayCode & Constants.DAY_CODES[j]) == 0) continue;
                            double[] dArray = histogramPerDay[i - SpreadConstraint.this.iFirstDaySlot];
                            int n = j - SpreadConstraint.this.iFirstWorkDay;
                            dArray[n] = dArray[n] + 1.0 / (double)values.size();
                        }
                    }
                }
            }
            double threshold = SpreadConstraint.this.iSpreadFactor * ((double)totalUsedSlots / (double)((SpreadConstraint.this.iLastWorkDay - SpreadConstraint.this.iFirstWorkDay + 1) * (SpreadConstraint.this.iLastDaySlot - SpreadConstraint.this.iFirstDaySlot + 1)));
            for (int i = 0; i < SpreadConstraint.this.iLastDaySlot - SpreadConstraint.this.iFirstDaySlot + 1; ++i) {
                for (int j = 0; j < SpreadConstraint.this.iLastWorkDay - SpreadConstraint.this.iFirstWorkDay + 1; ++j) {
                    this.iMaxCourses[i][j] = (int)(0.999 + (histogramPerDay[i][j] <= threshold ? SpreadConstraint.this.iSpreadFactor * histogramPerDay[i][j] : histogramPerDay[i][j]));
                }
            }
            for (Lecture lecture : SpreadConstraint.this.variables()) {
                int endSlot;
                int firstSlot;
                Placement placement = assignment.getValue(lecture);
                if (placement == null || (firstSlot = placement.getTimeLocation().getStartSlot()) > SpreadConstraint.this.iLastDaySlot || (endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1) < SpreadConstraint.this.iFirstDaySlot) continue;
                for (int i = Math.max(firstSlot, SpreadConstraint.this.iFirstDaySlot); i <= Math.min(endSlot, SpreadConstraint.this.iLastDaySlot); ++i) {
                    for (int j = SpreadConstraint.this.iFirstWorkDay; j <= SpreadConstraint.this.iLastWorkDay; ++j) {
                        dayCode = Constants.DAY_CODES[j];
                        if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                        this.iCourses[i - SpreadConstraint.this.iFirstDaySlot][j - SpreadConstraint.this.iFirstWorkDay].add(placement);
                    }
                }
            }
            this.iCurrentPenalty = 0;
            for (int i = 0; i < SpreadConstraint.this.iLastDaySlot - SpreadConstraint.this.iFirstDaySlot + 1; ++i) {
                for (int j = 0; j < SpreadConstraint.this.iLastWorkDay - SpreadConstraint.this.iFirstWorkDay + 1; ++j) {
                    this.iCurrentPenalty += Math.max(0, this.iCourses[i][j].size() - this.iMaxCourses[i][j]);
                }
            }
            this.iMaxAllowedPenalty = this.iCurrentPenalty;
            SpreadConstraint.this.getCriterion().inc(assignment, this.iCurrentPenalty);
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            int firstSlot = placement.getTimeLocation().getStartSlot();
            if (firstSlot > SpreadConstraint.this.iLastDaySlot) {
                return;
            }
            int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
            if (endSlot < SpreadConstraint.this.iFirstDaySlot) {
                return;
            }
            SpreadConstraint.this.getCriterion().inc(assignment, -this.iCurrentPenalty);
            for (int i = Math.max(firstSlot, SpreadConstraint.this.iFirstDaySlot); i <= Math.min(endSlot, SpreadConstraint.this.iLastDaySlot); ++i) {
                for (int j = SpreadConstraint.this.iFirstWorkDay; j <= SpreadConstraint.this.iLastWorkDay; ++j) {
                    int dayCode = Constants.DAY_CODES[j];
                    if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                    this.iCourses[i - SpreadConstraint.this.iFirstDaySlot][j - SpreadConstraint.this.iFirstWorkDay].add(placement);
                    if (this.iCourses[i - SpreadConstraint.this.iFirstDaySlot][j - SpreadConstraint.this.iFirstWorkDay].size() <= this.iMaxCourses[i - SpreadConstraint.this.iFirstDaySlot][j - SpreadConstraint.this.iFirstWorkDay]) continue;
                    ++this.iCurrentPenalty;
                }
            }
            SpreadConstraint.this.getCriterion().inc(assignment, this.iCurrentPenalty);
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            int firstSlot = placement.getTimeLocation().getStartSlot();
            if (firstSlot > SpreadConstraint.this.iLastDaySlot) {
                return;
            }
            int endSlot = firstSlot + placement.getTimeLocation().getNrSlotsPerMeeting() - 1;
            if (endSlot < SpreadConstraint.this.iFirstDaySlot) {
                return;
            }
            SpreadConstraint.this.getCriterion().inc(assignment, -this.iCurrentPenalty);
            for (int i = Math.max(firstSlot, SpreadConstraint.this.iFirstDaySlot); i <= Math.min(endSlot, SpreadConstraint.this.iLastDaySlot); ++i) {
                for (int j = SpreadConstraint.this.iFirstWorkDay; j <= SpreadConstraint.this.iLastWorkDay; ++j) {
                    int dayCode = Constants.DAY_CODES[j];
                    if ((dayCode & placement.getTimeLocation().getDayCode()) == 0) continue;
                    if (this.iCourses[i - SpreadConstraint.this.iFirstDaySlot][j - SpreadConstraint.this.iFirstWorkDay].size() > this.iMaxCourses[i - SpreadConstraint.this.iFirstDaySlot][j - SpreadConstraint.this.iFirstWorkDay]) {
                        --this.iCurrentPenalty;
                    }
                    this.iCourses[i - SpreadConstraint.this.iFirstDaySlot][j - SpreadConstraint.this.iFirstWorkDay].remove(placement);
                }
            }
            SpreadConstraint.this.getCriterion().inc(assignment, this.iCurrentPenalty);
        }

        public int[][] getMaxCourses() {
            return this.iMaxCourses;
        }

        public int getMaxCourses(int time, int day) {
            return this.iMaxCourses[time - SpreadConstraint.this.iFirstDaySlot][day - SpreadConstraint.this.iFirstWorkDay];
        }

        public int getNrCourses(int time, int day, Placement placement) {
            if (placement == null) {
                return this.getCourses(time, day).size();
            }
            int nrCourses = 0;
            for (Placement p : this.getCourses(time, day)) {
                if (((Lecture)p.variable()).equals(placement.variable())) continue;
                ++nrCourses;
            }
            return nrCourses;
        }

        public Set<Placement> getCourses(int time, int day) {
            return this.iCourses[time - SpreadConstraint.this.iFirstDaySlot][day - SpreadConstraint.this.iFirstWorkDay];
        }

        public int getUnassignmentsToWeaken() {
            return SpreadConstraint.this.iUnassignmentsToWeaken;
        }

        public int getCurrentPenalty() {
            return this.iCurrentPenalty;
        }

        public int getMaxAllowedPenalty() {
            return this.iMaxAllowedPenalty;
        }

        public void weaken() {
            if (SpreadConstraint.this.iUnassignmentsToWeaken == 0) {
                return;
            }
            ++this.iUnassignment;
            if (this.iUnassignment % (long)SpreadConstraint.this.iUnassignmentsToWeaken == 0L) {
                ++this.iMaxAllowedPenalty;
            }
        }

        public void weaken(int penalty) {
            if (penalty > this.iMaxAllowedPenalty) {
                this.iMaxAllowedPenalty = penalty;
            }
        }
    }
}

