/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util;

import biweekly.util.StringUtils;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionNumber
implements Comparable<VersionNumber> {
    private final Integer[] parts;

    public VersionNumber(String version) {
        if (!version.matches("[0-9]+(\\.[0-9]+)*")) {
            throw new IllegalArgumentException("Invalid version format.");
        }
        String[] parts = version.split("\\.");
        this.parts = new Integer[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            this.parts[i] = Integer.valueOf(parts[i]);
        }
    }

    @Override
    public int compareTo(VersionNumber that) {
        int length = Math.max(this.parts.length, that.parts.length);
        for (int i = 0; i < length; ++i) {
            int thatPart;
            int thisPart = i < this.parts.length ? this.parts[i] : 0;
            int n = thatPart = i < that.parts.length ? that.parts[i] : 0;
            if (thisPart < thatPart) {
                return -1;
            }
            if (thisPart <= thatPart) continue;
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.parts);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionNumber other = (VersionNumber)obj;
        return Arrays.equals((Object[])this.parts, (Object[])other.parts);
    }

    public String toString() {
        return StringUtils.join(Arrays.asList(this.parts), ".");
    }
}

