/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.text;

import biweekly.parameter.ICalParameters;
import java.util.Arrays;

public class ICalRawLine {
    private final String name;
    private final String value;
    private final ICalParameters parameters;

    public ICalRawLine(String name, ICalParameters parameters, String value) {
        this.name = name;
        this.value = value;
        this.parameters = parameters;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public ICalParameters getParameters() {
        return this.parameters;
    }

    public String toString() {
        return this.name + this.parameters + ":" + this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ICalRawLine other = (ICalRawLine)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public static class Builder {
        private String name;
        private String value;
        private ICalParameters parameters = new ICalParameters();

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder param(String name, String ... values) {
            this.parameters.putAll(name, Arrays.asList(values));
            return this;
        }

        public ICalRawLine build() {
            if (this.name == null) {
                throw new IllegalArgumentException("Property name required.");
            }
            return new ICalRawLine(this.name, this.parameters, this.value);
        }
    }
}

