/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.parameter.ICalParameters;
import biweekly.property.VCalAlarmProperty;
import biweekly.util.Duration;
import biweekly.util.ICalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VCalAlarmPropertyScribe<T extends VCalAlarmProperty>
extends ICalPropertyScribe<T> {
    public VCalAlarmPropertyScribe(Class<T> clazz, String propertyName) {
        super(clazz, propertyName);
    }

    public VCalAlarmPropertyScribe(Class<T> clazz, String propertyName, ICalDataType defaultDataType) {
        super(clazz, propertyName, defaultDataType);
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        ArrayList<String> values = new ArrayList<String>(4);
        Date start = ((VCalAlarmProperty)property).getStart();
        String value = VCalAlarmPropertyScribe.date(start, property, context).extended(false).write();
        values.add(value);
        Duration snooze = ((VCalAlarmProperty)property).getSnooze();
        value = snooze == null ? "" : snooze.toString();
        values.add(value);
        Integer repeat = ((VCalAlarmProperty)property).getRepeat();
        value = repeat == null ? "" : repeat.toString();
        values.add(value);
        List<String> dataValues = this.writeData(property);
        values.addAll(dataValues);
        return VCalAlarmPropertyScribe.structured(values.toArray());
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        Integer repeat;
        Duration snooze;
        ICalDate start;
        ICalPropertyScribe.SemiStructuredIterator it = VCalAlarmPropertyScribe.semistructured(value);
        String next = this.next(it);
        try {
            start = next == null ? null : VCalAlarmPropertyScribe.date(next).parse();
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException("");
        }
        next = this.next(it);
        try {
            snooze = next == null ? null : Duration.parse(next);
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException("");
        }
        next = this.next(it);
        try {
            repeat = next == null ? null : Integer.valueOf(next);
        }
        catch (IllegalArgumentException e) {
            throw new CannotParseException("");
        }
        T property = this.create(dataType, it);
        ((VCalAlarmProperty)property).setStart(start);
        ((VCalAlarmProperty)property).setSnooze(snooze);
        ((VCalAlarmProperty)property).setRepeat(repeat);
        return property;
    }

    private String next(ICalPropertyScribe.SemiStructuredIterator it) {
        String next = it.next();
        if (next == null) {
            return null;
        }
        return (next = next.trim()).length() == 0 ? null : next;
    }

    protected abstract List<String> writeData(T var1);

    protected abstract T create(ICalDataType var1, ICalPropertyScribe.SemiStructuredIterator var2);

    @Override
    public Set<ICalVersion> getSupportedVersions() {
        return EnumSet.of(ICalVersion.V1_0);
    }
}

