/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.xml;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.ICalendar;
import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.io.CannotParseException;
import biweekly.io.SkipMeException;
import biweekly.io.StreamReader;
import biweekly.io.StreamWriter;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.component.ICalendarScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalNamespaceContext;
import biweekly.io.xml.XCalQNames;
import biweekly.parameter.ICalParameters;
import biweekly.property.ICalProperty;
import biweekly.property.Version;
import biweekly.property.Xml;
import biweekly.util.IOUtils;
import biweekly.util.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XCalDocument {
    private static final ICalendarScribe icalMarshaller = ScribeIndex.getICalendarScribe();
    private static final XCalNamespaceContext nsContext = new XCalNamespaceContext("xcal");
    private final Document document;
    private final ICalVersion targetVersion = ICalVersion.V2_0;
    private Element root;

    public XCalDocument(String xml) throws SAXException {
        this(XmlUtils.toDocument(xml));
    }

    public XCalDocument(InputStream in) throws SAXException, IOException {
        this(XmlUtils.toDocument(in));
    }

    public XCalDocument(File file) throws SAXException, IOException {
        this(XCalDocument.readFile(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document readFile(File file) throws SAXException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            Document document = XmlUtils.toDocument(in);
            return document;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    public XCalDocument(Reader reader) throws SAXException, IOException {
        this(XmlUtils.toDocument(reader));
    }

    public XCalDocument(Document document) {
        this.document = document;
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsContext);
        try {
            String prefix = nsContext.getPrefix();
            this.root = (Element)xpath.evaluate("//" + prefix + ":" + XCalQNames.ICALENDAR.getLocalPart(), document, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
    }

    public XCalDocument() {
        this(XCalDocument.createRoot());
    }

    private static Document createRoot() {
        Document document = XmlUtils.createDocument();
        Element root = document.createElementNS(XCalQNames.ICALENDAR.getNamespaceURI(), XCalQNames.ICALENDAR.getLocalPart());
        document.appendChild(root);
        return document;
    }

    public Document getDocument() {
        return this.document;
    }

    public List<ICalendar> getICalendars() {
        try {
            return this.reader().readAll();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void add(ICalendar ical) {
        this.writer().write(ical);
    }

    public StreamReader reader() {
        return new XCalDocumentStreamReader();
    }

    public XCalDocumentStreamWriter writer() {
        return new XCalDocumentStreamWriter();
    }

    public String write() {
        return this.write(-1);
    }

    public String write(int indent) {
        StringWriter sw = new StringWriter();
        try {
            this.write(sw, indent);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        return sw.toString();
    }

    public void write(OutputStream out) throws TransformerException {
        this.write(out, -1);
    }

    public void write(OutputStream out, int indent) throws TransformerException {
        this.write(IOUtils.utf8Writer(out), indent);
    }

    public void write(File file) throws TransformerException, IOException {
        this.write(file, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, int indent) throws TransformerException, IOException {
        Writer writer = IOUtils.utf8Writer(file);
        try {
            this.write(writer, indent);
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
    }

    public void write(Writer writer) throws TransformerException {
        this.write(writer, -1);
    }

    public void write(Writer writer, int indent) throws TransformerException {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (indent >= 0) {
            properties.put("indent", "yes");
            properties.put("{http://xml.apache.org/xslt}indent-amount", indent + "");
        }
        XmlUtils.toWriter(this.document, writer, properties);
    }

    public String toString() {
        return this.write(2);
    }

    public class XCalDocumentStreamWriter
    extends StreamWriter {
        private final Map<String, ICalDataType> parameterDataTypes = new HashMap<String, ICalDataType>();

        public XCalDocumentStreamWriter() {
            this.registerParameterDataType("CN", ICalDataType.TEXT);
            this.registerParameterDataType("ALTREP", ICalDataType.URI);
            this.registerParameterDataType("CUTYPE", ICalDataType.TEXT);
            this.registerParameterDataType("DELEGATED-FROM", ICalDataType.CAL_ADDRESS);
            this.registerParameterDataType("DELEGATED-TO", ICalDataType.CAL_ADDRESS);
            this.registerParameterDataType("DIR", ICalDataType.URI);
            this.registerParameterDataType("ENCODING", ICalDataType.TEXT);
            this.registerParameterDataType("FMTTYPE", ICalDataType.TEXT);
            this.registerParameterDataType("FBTYPE", ICalDataType.TEXT);
            this.registerParameterDataType("LANGUAGE", ICalDataType.TEXT);
            this.registerParameterDataType("MEMBER", ICalDataType.CAL_ADDRESS);
            this.registerParameterDataType("PARTSTAT", ICalDataType.TEXT);
            this.registerParameterDataType("RANGE", ICalDataType.TEXT);
            this.registerParameterDataType("RELATED", ICalDataType.TEXT);
            this.registerParameterDataType("RELTYPE", ICalDataType.TEXT);
            this.registerParameterDataType("ROLE", ICalDataType.TEXT);
            this.registerParameterDataType("RSVP", ICalDataType.BOOLEAN);
            this.registerParameterDataType("SENT-BY", ICalDataType.CAL_ADDRESS);
            this.registerParameterDataType("TZID", ICalDataType.TEXT);
        }

        public void write(ICalendar ical) {
            try {
                super.write(ical);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected void _write(ICalendar ical) {
            Element element = this.buildComponentElement(ical);
            if (XCalDocument.this.root == null) {
                XCalDocument.this.root = this.buildElement(XCalQNames.ICALENDAR);
                Element documentRoot = XmlUtils.getRootElement(XCalDocument.this.document);
                if (documentRoot == null) {
                    XCalDocument.this.document.appendChild(XCalDocument.this.root);
                } else {
                    documentRoot.appendChild(XCalDocument.this.root);
                }
            }
            XCalDocument.this.root.appendChild(element);
        }

        public void registerParameterDataType(String parameterName, ICalDataType dataType) {
            parameterName = parameterName.toLowerCase();
            if (dataType == null) {
                this.parameterDataTypes.remove(parameterName);
            } else {
                this.parameterDataTypes.put(parameterName, dataType);
            }
        }

        private Element buildComponentElement(ICalComponent component) {
            ICalComponentScribe<? extends ICalComponent> componentScribe = this.index.getComponentScribe(component);
            Element componentElement = this.buildElement(componentScribe.getComponentName().toLowerCase());
            Element propertiesWrapperElement = this.buildElement(XCalQNames.PROPERTIES);
            List<ICalProperty> propertyObjs = componentScribe.getProperties(component);
            if (component instanceof ICalendar && component.getProperty(Version.class) == null) {
                propertyObjs.add(0, new Version(XCalDocument.this.targetVersion));
            }
            for (ICalProperty propertyObj : propertyObjs) {
                this.context.setParent(component);
                ICalProperty property = propertyObj;
                Element propertyElement = this.buildPropertyElement(property);
                if (propertyElement == null) continue;
                propertiesWrapperElement.appendChild(propertyElement);
            }
            if (propertiesWrapperElement.hasChildNodes()) {
                componentElement.appendChild(propertiesWrapperElement);
            }
            Collection<ICalComponent> subComponents = componentScribe.getComponents(component);
            if (component instanceof ICalendar) {
                Collection<VTimezone> tzs = this.tzinfo.getComponents();
                for (VTimezone tz : tzs) {
                    if (subComponents.contains(tz)) continue;
                    subComponents.add(tz);
                }
            }
            Element componentsWrapperElement = this.buildElement(XCalQNames.COMPONENTS);
            for (ICalComponent subComponentObj : subComponents) {
                ICalComponent subComponent = subComponentObj;
                Element subComponentElement = this.buildComponentElement(subComponent);
                if (subComponentElement == null) continue;
                componentsWrapperElement.appendChild(subComponentElement);
            }
            if (componentsWrapperElement.hasChildNodes()) {
                componentElement.appendChild(componentsWrapperElement);
            }
            return componentElement;
        }

        private Element buildPropertyElement(ICalProperty property) {
            ICalParameters parameters;
            Element propertyElement;
            if (property instanceof Xml) {
                Xml xml = (Xml)property;
                Document value = (Document)xml.getValue();
                if (value == null) {
                    return null;
                }
                propertyElement = XmlUtils.getRootElement(value);
                propertyElement = (Element)XCalDocument.this.document.importNode(propertyElement, true);
                parameters = property.getParameters();
            } else {
                ICalPropertyScribe<? extends ICalProperty> propertyScribe = this.index.getPropertyScribe(property);
                propertyElement = this.buildElement(propertyScribe.getQName());
                try {
                    propertyScribe.writeXml(property, propertyElement, this.context);
                }
                catch (SkipMeException e) {
                    return null;
                }
                parameters = propertyScribe.prepareParameters(property, this.context);
            }
            Element parametersWrapperElement = this.buildParametersElement(parameters);
            if (parametersWrapperElement.hasChildNodes()) {
                propertyElement.insertBefore(parametersWrapperElement, propertyElement.getFirstChild());
            }
            return propertyElement;
        }

        private Element buildParametersElement(ICalParameters parameters) {
            Element parametersWrapperElement = this.buildElement(XCalQNames.PARAMETERS);
            for (Map.Entry parameter : parameters) {
                String name = ((String)parameter.getKey()).toLowerCase();
                ICalDataType dataType = this.parameterDataTypes.get(name);
                String dataTypeStr = dataType == null ? "unknown" : dataType.getName().toLowerCase();
                Element parameterElement = this.buildAndAppendElement(name, parametersWrapperElement);
                for (String parameterValue : parameter.getValue()) {
                    Element parameterValueElement = this.buildAndAppendElement(dataTypeStr, parameterElement);
                    parameterValueElement.setTextContent(parameterValue);
                }
            }
            return parametersWrapperElement;
        }

        private Element buildElement(String localName) {
            return this.buildElement(new QName("urn:ietf:params:xml:ns:icalendar-2.0", localName));
        }

        private Element buildElement(QName qname) {
            return XCalDocument.this.document.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
        }

        private Element buildAndAppendElement(String localName, Element parent) {
            return this.buildAndAppendElement(new QName("urn:ietf:params:xml:ns:icalendar-2.0", localName), parent);
        }

        private Element buildAndAppendElement(QName qname, Element parent) {
            Element child = XCalDocument.this.document.createElementNS(qname.getNamespaceURI(), qname.getLocalPart());
            parent.appendChild(child);
            return child;
        }

        protected ICalVersion getTargetVersion() {
            return ICalVersion.V2_0;
        }

        public void close() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XCalDocumentStreamReader
    extends StreamReader {
        private final Iterator<Element> vcalendarElements = this.getVCalendarElements().iterator();

        private XCalDocumentStreamReader() {
        }

        @Override
        protected ICalendar _readNext() throws IOException {
            if (!this.vcalendarElements.hasNext()) {
                return null;
            }
            this.context.setVersion(ICalVersion.V2_0);
            Element vcalendarElement = this.vcalendarElements.next();
            return this.parseICal(vcalendarElement);
        }

        private ICalendar parseICal(Element icalElement) {
            ICalComponent root = this.parseComponent(icalElement);
            if (root instanceof ICalendar) {
                return (ICalendar)root;
            }
            ICalendar ical = (ICalendar)icalMarshaller.emptyInstance();
            ical.addComponent(root);
            return ical;
        }

        private ICalComponent parseComponent(Element componentElement) {
            ICalComponentScribe<? extends ICalComponent> scribe = this.index.getComponentScribe(componentElement.getLocalName(), ICalVersion.V2_0);
            ICalComponent component = scribe.emptyInstance();
            boolean isICalendar = component instanceof ICalendar;
            for (Element propertyWrapperElement : this.getChildElements(componentElement, XCalQNames.PROPERTIES)) {
                for (Element propertyElement : XmlUtils.toElementList(propertyWrapperElement.getChildNodes())) {
                    Version version;
                    ICalVersion icalVersion;
                    ICalProperty property = this.parseProperty(propertyElement);
                    if (property == null) continue;
                    if (isICalendar && property instanceof Version && (icalVersion = (version = (Version)property).toICalVersion()) != null) {
                        this.context.setVersion(icalVersion);
                        continue;
                    }
                    component.addProperty(property);
                }
            }
            for (Element componentWrapperElement : this.getChildElements(componentElement, XCalQNames.COMPONENTS)) {
                for (Element subComponentElement : XmlUtils.toElementList(componentWrapperElement.getChildNodes())) {
                    if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(subComponentElement.getNamespaceURI())) continue;
                    ICalComponent subComponent = this.parseComponent(subComponentElement);
                    component.addComponent(subComponent);
                }
            }
            return component;
        }

        private ICalProperty parseProperty(Element propertyElement) {
            ICalParameters parameters = this.parseParameters(propertyElement);
            String propertyName = propertyElement.getLocalName();
            QName qname = new QName(propertyElement.getNamespaceURI(), propertyName);
            this.context.getWarnings().clear();
            ICalPropertyScribe<? extends ICalProperty> scribe = this.index.getPropertyScribe(qname);
            try {
                ICalProperty property = scribe.parseXml(propertyElement, parameters, this.context);
                for (Warning warning : this.context.getWarnings()) {
                    this.warnings.add(null, propertyName, warning);
                }
                return property;
            }
            catch (SkipMeException e) {
                this.warnings.add(null, propertyName, 0, e.getMessage());
                return null;
            }
            catch (CannotParseException e) {
                this.warnings.add(null, propertyName, 16, e.getMessage());
                scribe = this.index.getPropertyScribe(Xml.class);
                return scribe.parseXml(propertyElement, parameters, this.context);
            }
        }

        private ICalParameters parseParameters(Element propertyElement) {
            ICalParameters parameters = new ICalParameters();
            for (Element parametersElement : this.getChildElements(propertyElement, XCalQNames.PARAMETERS)) {
                List<Element> paramElements = XmlUtils.toElementList(parametersElement.getChildNodes());
                for (Element paramElement : paramElements) {
                    if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(paramElement.getNamespaceURI())) continue;
                    String name = paramElement.getLocalName().toUpperCase();
                    List<Element> valueElements = XmlUtils.toElementList(paramElement.getChildNodes());
                    if (valueElements.isEmpty()) {
                        String value = paramElement.getTextContent();
                        parameters.put(name, value);
                        continue;
                    }
                    for (Element valueElement : valueElements) {
                        if (!"urn:ietf:params:xml:ns:icalendar-2.0".equals(valueElement.getNamespaceURI())) continue;
                        String value = valueElement.getTextContent();
                        parameters.put(name, value);
                    }
                }
            }
            return parameters;
        }

        private List<Element> getVCalendarElements() {
            return XCalDocument.this.root == null ? Collections.emptyList() : this.getChildElements(XCalDocument.this.root, XCalQNames.VCALENDAR);
        }

        private List<Element> getChildElements(Element parent, QName qname) {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element child : XmlUtils.toElementList(parent.getChildNodes())) {
                QName childQName = new QName(child.getNamespaceURI(), child.getLocalName());
                if (!qname.equals(childQName)) continue;
                elements.add(child);
            }
            return elements;
        }

        @Override
        public void close() {
        }
    }
}

