/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.component.DaylightSavingsTime;
import biweekly.component.ICalComponent;
import biweekly.component.Observance;
import biweekly.component.StandardTime;
import biweekly.component.VAlarm;
import biweekly.component.VTimezone;
import biweekly.io.ICalTimeZone;
import biweekly.parameter.Related;
import biweekly.parameter.Role;
import biweekly.property.Action;
import biweekly.property.Attachment;
import biweekly.property.Attendee;
import biweekly.property.AudioAlarm;
import biweekly.property.DateEnd;
import biweekly.property.DateStart;
import biweekly.property.Daylight;
import biweekly.property.Description;
import biweekly.property.DisplayAlarm;
import biweekly.property.DurationProperty;
import biweekly.property.EmailAlarm;
import biweekly.property.Organizer;
import biweekly.property.ProcedureAlarm;
import biweekly.property.Repeat;
import biweekly.property.Timezone;
import biweekly.property.Trigger;
import biweekly.property.UtcOffsetProperty;
import biweekly.property.VCalAlarmProperty;
import biweekly.util.DateTimeComponents;
import biweekly.util.Duration;
import biweekly.util.ICalDate;
import biweekly.util.UtcOffset;
import com.google.ical.values.DateTimeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataModelConverter {
    public static VTimezone convert(List<Daylight> daylights, Timezone tz) {
        UtcOffset tzOffset;
        UtcOffset utcOffset = tzOffset = tz == null ? null : (UtcOffset)tz.getValue();
        if (daylights.isEmpty() && tzOffset == null) {
            return null;
        }
        VTimezone timezone = new VTimezone("TZ");
        if (daylights.isEmpty() && tzOffset != null) {
            StandardTime st = new StandardTime();
            st.setTimezoneOffsetFrom(tzOffset);
            st.setTimezoneOffsetTo(tzOffset);
            timezone.addStandardTime(st);
            return timezone;
        }
        for (Daylight daylight : daylights) {
            if (!daylight.isDaylight()) continue;
            UtcOffset daylightOffset = daylight.getOffset();
            UtcOffset standardOffset = new UtcOffset(daylightOffset.getMillis() - 3600000L);
            DaylightSavingsTime dst = new DaylightSavingsTime();
            dst.setDateStart(daylight.getStart());
            dst.setTimezoneOffsetFrom(standardOffset);
            dst.setTimezoneOffsetTo(daylightOffset);
            dst.addTimezoneName(daylight.getDaylightName());
            timezone.addDaylightSavingsTime(dst);
            StandardTime st = new StandardTime();
            st.setDateStart(daylight.getEnd());
            st.setTimezoneOffsetFrom(daylightOffset);
            st.setTimezoneOffsetTo(standardOffset);
            st.addTimezoneName(daylight.getStandardName());
            timezone.addStandardTime(st);
        }
        return timezone.getComponents().isEmpty() ? null : timezone;
    }

    public static VCalTimezoneProperties convert(VTimezone timezone, List<Date> dates) {
        ArrayList<Daylight> daylights = new ArrayList<Daylight>();
        Timezone tz = null;
        if (dates.isEmpty()) {
            return new VCalTimezoneProperties(daylights, tz);
        }
        ICalTimeZone icalTz = new ICalTimeZone(timezone);
        Collections.sort(dates);
        HashSet<DateTimeValue> daylightStartDates = new HashSet<DateTimeValue>();
        boolean zeroObservanceUsed = false;
        for (Date date : dates) {
            Daylight daylight;
            String daylightName;
            String standardName;
            DateTimeValue end;
            DateTimeValue start;
            UtcOffset offset;
            ICalTimeZone.Boundary boundary = icalTz.getObservanceBoundary(date);
            Observance observance = boundary.getObservanceIn();
            Observance observanceAfter = boundary.getObservanceAfter();
            if (observance == null && observanceAfter == null) continue;
            if (observance == null) {
                if (observanceAfter instanceof StandardTime && !zeroObservanceUsed) {
                    offset = DataModelConverter.getOffset(observanceAfter.getTimezoneOffsetFrom());
                    start = null;
                    end = boundary.getObservanceAfterStart();
                    standardName = icalTz.getDisplayName(false, 0);
                    daylightName = icalTz.getDisplayName(true, 0);
                    daylight = new Daylight(true, offset, DataModelConverter.convert(start), DataModelConverter.convert(end), standardName, daylightName);
                    daylights.add(daylight);
                    zeroObservanceUsed = true;
                }
                if (!(observanceAfter instanceof DaylightSavingsTime) || (offset = DataModelConverter.getOffset(observanceAfter.getTimezoneOffsetFrom())) == null) continue;
                tz = new Timezone(offset);
                continue;
            }
            if (observance instanceof StandardTime) {
                offset = DataModelConverter.getOffset(observance.getTimezoneOffsetTo());
                if (offset == null) continue;
                tz = new Timezone(offset);
                continue;
            }
            if (!(observance instanceof DaylightSavingsTime) || daylightStartDates.contains(boundary.getObservanceInStart())) continue;
            offset = DataModelConverter.getOffset(observance.getTimezoneOffsetTo());
            start = boundary.getObservanceInStart();
            end = null;
            if (observanceAfter != null) {
                end = boundary.getObservanceAfterStart();
            }
            standardName = icalTz.getDisplayName(false, 0);
            daylightName = icalTz.getDisplayName(true, 0);
            daylight = new Daylight(true, offset, DataModelConverter.convert(start), DataModelConverter.convert(end), standardName, daylightName);
            daylights.add(daylight);
            daylightStartDates.add(start);
        }
        if (tz == null) {
            int rawOffset = icalTz.getRawOffset();
            UtcOffset offset = new UtcOffset(rawOffset);
            tz = new Timezone(offset);
        }
        if (daylights.isEmpty()) {
            Daylight daylight = new Daylight();
            daylight.setDaylight(false);
            daylights.add(daylight);
        }
        return new VCalTimezoneProperties(daylights, tz);
    }

    private static UtcOffset getOffset(UtcOffsetProperty property) {
        return property == null ? null : (UtcOffset)property.getValue();
    }

    private static ICalDate convert(DateTimeValue value) {
        if (value == null) {
            return null;
        }
        DateTimeComponents components = new DateTimeComponents(value.year(), value.month(), value.day(), value.hour(), value.minute(), value.second(), false);
        return new ICalDate(components, true);
    }

    public static Organizer convert(Attendee attendee) {
        Organizer organizer = new Organizer(attendee.getCommonName(), attendee.getEmail());
        organizer.setUri(attendee.getUri());
        organizer.setParameters(attendee.getParameters());
        return organizer;
    }

    public static Attendee convert(Organizer organizer) {
        Attendee attendee = new Attendee(organizer.getCommonName(), organizer.getEmail());
        attendee.setRole(Role.ORGANIZER);
        attendee.setUri(organizer.getUri());
        attendee.setParameters(organizer.getParameters());
        return attendee;
    }

    public static VAlarm convert(AudioAlarm aalarm) {
        Trigger trigger = new Trigger(aalarm.getStart());
        VAlarm valarm = new VAlarm(Action.audio(), trigger);
        valarm.addAttachment(DataModelConverter.buildAttachment(aalarm));
        valarm.setDuration(aalarm.getSnooze());
        valarm.setRepeat(aalarm.getRepeat());
        return valarm;
    }

    public static VAlarm convert(DisplayAlarm dalarm) {
        Trigger trigger = new Trigger(dalarm.getStart());
        VAlarm valarm = new VAlarm(Action.display(), trigger);
        valarm.setDescription(dalarm.getText());
        valarm.setDuration(dalarm.getSnooze());
        valarm.setRepeat(dalarm.getRepeat());
        return valarm;
    }

    public static VAlarm convert(EmailAlarm malarm) {
        Trigger trigger = new Trigger(malarm.getStart());
        VAlarm valarm = new VAlarm(Action.email(), trigger);
        String email = malarm.getEmail();
        if (email != null) {
            valarm.addAttendee(new Attendee(null, email));
        }
        valarm.setDescription(malarm.getNote());
        valarm.setDuration(malarm.getSnooze());
        valarm.setRepeat(malarm.getRepeat());
        return valarm;
    }

    public static VAlarm convert(ProcedureAlarm dalarm) {
        Trigger trigger = new Trigger(dalarm.getStart());
        VAlarm valarm = new VAlarm(Action.procedure(), trigger);
        valarm.setDescription(dalarm.getPath());
        valarm.setDuration(dalarm.getSnooze());
        valarm.setRepeat(dalarm.getRepeat());
        return valarm;
    }

    private static Attachment buildAttachment(AudioAlarm aalarm) {
        String type = aalarm.getParameter("TYPE");
        String contentType = type == null ? null : "audio/" + type.toLowerCase();
        byte[] data = aalarm.getData();
        if (data != null) {
            return new Attachment(contentType, data);
        }
        String contentId = aalarm.getContentId();
        String uri = contentId == null ? aalarm.getUri() : "CID:" + contentId;
        return new Attachment(contentType, uri);
    }

    public static VCalAlarmProperty convert(VAlarm valarm, ICalComponent parent) {
        Action action = valarm.getAction();
        if (action == null) {
            return null;
        }
        if (action.isAudio()) {
            Repeat repeat;
            DurationProperty duration;
            AudioAlarm aalarm = new AudioAlarm();
            aalarm.setStart(DataModelConverter.determineStartDate(valarm, parent));
            List<Attachment> attaches = valarm.getAttachments();
            if (!attaches.isEmpty()) {
                String uri;
                Attachment attach = attaches.get(0);
                String formatType = attach.getFormatType();
                aalarm.setParameter("TYPE", formatType);
                byte[] data = attach.getData();
                if (data != null) {
                    aalarm.setData(data);
                }
                if ((uri = attach.getUri()) != null) {
                    if (uri.toUpperCase().startsWith("CID:")) {
                        String contentId = uri.substring(4);
                        aalarm.setContentId(contentId);
                    } else {
                        aalarm.setUri(uri);
                    }
                }
            }
            if ((duration = valarm.getDuration()) != null) {
                aalarm.setSnooze((Duration)duration.getValue());
            }
            if ((repeat = valarm.getRepeat()) != null) {
                aalarm.setRepeat((Integer)repeat.getValue());
            }
            return aalarm;
        }
        if (action.isDisplay()) {
            Description description = valarm.getDescription();
            String text = description == null ? null : (String)description.getValue();
            return new DisplayAlarm(text);
        }
        if (action.isEmail()) {
            List<Attendee> attendees = valarm.getAttendees();
            String email = attendees.isEmpty() ? null : attendees.get(0).getEmail();
            EmailAlarm malarm = new EmailAlarm(email);
            Description description = valarm.getDescription();
            String note = description == null ? null : (String)description.getValue();
            malarm.setNote(note);
            return malarm;
        }
        if (action.isProcedure()) {
            Description description = valarm.getDescription();
            String path = description == null ? null : (String)description.getValue();
            return new ProcedureAlarm(path);
        }
        return null;
    }

    private static Date determineStartDate(VAlarm valarm, ICalComponent parent) {
        Trigger trigger = valarm.getTrigger();
        if (trigger == null) {
            return null;
        }
        Date start = trigger.getDate();
        if (start != null) {
            return start;
        }
        Duration triggerDuration = trigger.getDuration();
        if (triggerDuration == null) {
            return null;
        }
        Related related = trigger.getRelated();
        if (related == Related.START) {
            DateStart parentDateStart = parent.getProperty(DateStart.class);
            if (parentDateStart == null) {
                return null;
            }
            Date date = (Date)parentDateStart.getValue();
            return date == null ? null : triggerDuration.add(date);
        }
        if (related == Related.END) {
            DateEnd parentDateEnd = parent.getProperty(DateEnd.class);
            if (parentDateEnd != null) {
                Date date = (Date)parentDateEnd.getValue();
                return date == null ? null : triggerDuration.add(date);
            }
            DateStart parentDateStart = parent.getProperty(DateStart.class);
            DurationProperty parentDuration = parent.getProperty(DurationProperty.class);
            if (parentDuration == null || parentDateStart == null) {
                return null;
            }
            Duration duration = (Duration)parentDuration.getValue();
            Date date = (Date)parentDateStart.getValue();
            return duration == null || date == null ? null : duration.add(date);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VCalTimezoneProperties {
        private final List<Daylight> daylights;
        private final Timezone tz;

        public VCalTimezoneProperties(List<Daylight> daylights, Timezone tz) {
            this.daylights = daylights;
            this.tz = tz;
        }

        public List<Daylight> getDaylights() {
            return this.daylights;
        }

        public Timezone getTz() {
            return this.tz;
        }
    }
}

