/*
 * Decompiled with CFR 0.152.
 */
package biweekly;

import biweekly.Biweekly;
import biweekly.ICalVersion;
import biweekly.ValidationWarnings;
import biweekly.Warning;
import biweekly.component.ICalComponent;
import biweekly.component.VEvent;
import biweekly.component.VFreeBusy;
import biweekly.component.VJournal;
import biweekly.component.VTodo;
import biweekly.property.CalendarScale;
import biweekly.property.Geo;
import biweekly.property.Method;
import biweekly.property.ProductId;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICalendar
extends ICalComponent {
    private ICalVersion version;

    public ICalendar() {
        this.setProductId(ProductId.biweekly());
    }

    public ICalVersion getVersion() {
        return this.version;
    }

    public void setVersion(ICalVersion version) {
        this.version = version;
    }

    public ProductId getProductId() {
        return this.getProperty(ProductId.class);
    }

    public void setProductId(ProductId prodId) {
        this.setProperty(ProductId.class, prodId);
    }

    public ProductId setProductId(String prodId) {
        ProductId prop = prodId == null ? null : new ProductId(prodId);
        this.setProductId(prop);
        return prop;
    }

    public CalendarScale getCalendarScale() {
        return this.getProperty(CalendarScale.class);
    }

    public void setCalendarScale(CalendarScale calendarScale) {
        this.setProperty(CalendarScale.class, calendarScale);
    }

    public Method getMethod() {
        return this.getProperty(Method.class);
    }

    public void setMethod(Method method) {
        this.setProperty(Method.class, method);
    }

    public Method setMethod(String method) {
        Method prop = method == null ? null : new Method(method);
        this.setMethod(prop);
        return prop;
    }

    public List<VEvent> getEvents() {
        return this.getComponents(VEvent.class);
    }

    public void addEvent(VEvent event) {
        this.addComponent(event);
    }

    public List<VTodo> getTodos() {
        return this.getComponents(VTodo.class);
    }

    public void addTodo(VTodo todo) {
        this.addComponent(todo);
    }

    public List<VJournal> getJournals() {
        return this.getComponents(VJournal.class);
    }

    public void addJournal(VJournal journal) {
        this.addComponent(journal);
    }

    public List<VFreeBusy> getFreeBusies() {
        return this.getComponents(VFreeBusy.class);
    }

    public void addFreeBusy(VFreeBusy freeBusy) {
        this.addComponent(freeBusy);
    }

    public ValidationWarnings validate(ICalVersion version) {
        List<ValidationWarnings.WarningsGroup> warnings = this.validate(new ArrayList<ICalComponent>(0), version);
        return new ValidationWarnings(warnings);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<Warning> warnings) {
        if (version != ICalVersion.V1_0) {
            this.checkRequiredCardinality(warnings, ProductId.class);
            if (this.components.isEmpty()) {
                warnings.add(Warning.validate(4, new Object[0]));
            }
            if (this.getProperty(Geo.class) != null) {
                warnings.add(Warning.validate(44, new Object[0]));
            }
        }
    }

    public String write() {
        ICalVersion version = this.version == null ? ICalVersion.V2_0 : this.version;
        return Biweekly.write(this).version(version).go();
    }

    public void write(File file) throws IOException {
        ICalVersion version = this.version == null ? ICalVersion.V2_0 : this.version;
        Biweekly.write(this).version(version).go(file);
    }

    public void write(OutputStream out) throws IOException {
        ICalVersion version = this.version == null ? ICalVersion.V2_0 : this.version;
        Biweekly.write(this).version(version).go(out);
    }

    public void write(Writer writer) throws IOException {
        ICalVersion version = this.version == null ? ICalVersion.V2_0 : this.version;
        Biweekly.write(this).version(version).go(writer);
    }

    public String writeXml() {
        return Biweekly.writeXml(this).indent(2).go();
    }

    public void writeXml(File file) throws TransformerException, IOException {
        Biweekly.writeXml(this).indent(2).go(file);
    }

    public void writeXml(OutputStream out) throws TransformerException {
        Biweekly.writeXml(this).indent(2).go(out);
    }

    public void writeXml(Writer writer) throws TransformerException {
        Biweekly.writeXml(this).indent(2).go(writer);
    }

    public String writeJson() {
        return Biweekly.writeJson(this).go();
    }

    public void writeJson(File file) throws IOException {
        Biweekly.writeJson(this).go(file);
    }

    public void writeJson(OutputStream out) throws IOException {
        Biweekly.writeJson(this).go(out);
    }

    public void writeJson(Writer writer) throws IOException {
        Biweekly.writeJson(this).go(writer);
    }
}

