/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.read.AbstractDataCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.base.BaseRpcInterceptor;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.concurrent.locks.LockManager;

public abstract class ClusteringInterceptor
extends BaseRpcInterceptor {
    protected CommandsFactory cf;
    protected EntryFactory entryFactory;
    protected LockManager lockManager;
    protected DataContainer dataContainer;
    protected StateTransferManager stateTransferManager;
    protected boolean needReliableReturnValues;
    protected boolean isL1Enabled;

    @Inject
    public void injectDependencies(CommandsFactory cf, EntryFactory entryFactory, LockManager lockManager, DataContainer dataContainer, StateTransferManager stateTransferManager) {
        this.cf = cf;
        this.entryFactory = entryFactory;
        this.lockManager = lockManager;
        this.dataContainer = dataContainer;
        this.stateTransferManager = stateTransferManager;
    }

    @Start
    public void configure() {
        this.needReliableReturnValues = !this.cacheConfiguration.unsafe().unreliableReturnValues();
        this.isL1Enabled = this.cacheConfiguration.clustering().l1().enabled();
    }

    protected boolean isNeedReliableReturnValues(FlagAffectedCommand command) {
        return !command.hasFlag(Flag.SKIP_REMOTE_LOOKUP) && !command.hasFlag(Flag.IGNORE_RETURN_VALUES) && this.needReliableReturnValues;
    }

    protected boolean needsRemoteGet(InvocationContext ctx, AbstractDataCommand command) {
        if (command.hasFlag(Flag.CACHE_MODE_LOCAL) || command.hasFlag(Flag.SKIP_REMOTE_LOOKUP) || command.hasFlag(Flag.IGNORE_RETURN_VALUES)) {
            return false;
        }
        boolean shouldFetchFromRemote = false;
        CacheEntry entry = ctx.lookupEntry(command.getKey());
        if (entry == null || entry.isNull()) {
            Object key = command.getKey();
            ConsistentHash ch = this.stateTransferManager.getCacheTopology().getReadConsistentHash();
            boolean bl = shouldFetchFromRemote = ctx.isOriginLocal() && !this.isValueAvailableLocally(ch, key);
            if (!shouldFetchFromRemote && this.getLog().isTraceEnabled()) {
                this.getLog().tracef("Not doing a remote get for key %s since entry is mapped to current node (%s) or is in L1. Owners are %s", Util.toStr((Object)key), this.rpcManager.getAddress(), ch.locateOwners(key));
            }
        }
        return shouldFetchFromRemote;
    }

    protected boolean isValueAvailableLocally(ConsistentHash consistentHash, Object key) {
        InternalCacheEntry ice;
        boolean isLocal = consistentHash.isKeyLocalToNode(this.rpcManager.getAddress(), key);
        return isLocal || this.isL1Enabled && (ice = this.dataContainer.get(key)) != null && ice.isL1Entry();
    }

    protected InternalCacheEntry fetchValueLocallyIfAvailable(ConsistentHash consistentHash, Object key) {
        if (consistentHash.isKeyLocalToNode(this.rpcManager.getAddress(), key)) {
            return this.dataContainer.get(key);
        }
        if (this.isL1Enabled) {
            InternalCacheEntry entry = this.dataContainer.get(key);
            return entry != null && entry.isL1Entry() ? entry : null;
        }
        return null;
    }

    protected boolean ignorePreviousValueOnBackup(WriteCommand command, InvocationContext ctx) {
        return ctx.isOriginLocal() && command.isSuccessful();
    }

    protected abstract InternalCacheEntry retrieveFromRemoteSource(Object var1, InvocationContext var2, boolean var3, FlagAffectedCommand var4, boolean var5) throws Exception;
}

