/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.heuristics.RoundRobinNeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.solver.SolverListener;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.heuristics.RouletteWheelRequestSelection;
import org.cpsolver.studentsct.heuristics.selection.AssignInitialSelection;
import org.cpsolver.studentsct.heuristics.selection.BacktrackSelection;
import org.cpsolver.studentsct.heuristics.selection.BranchBoundSelection;
import org.cpsolver.studentsct.heuristics.selection.PriorityConstructionSelection;
import org.cpsolver.studentsct.heuristics.selection.RandomUnassignmentSelection;
import org.cpsolver.studentsct.heuristics.selection.ResectionIncompleteStudentsSelection;
import org.cpsolver.studentsct.heuristics.selection.ResectionUnassignedStudentsSelection;
import org.cpsolver.studentsct.heuristics.selection.RndUnProblStudSelection;
import org.cpsolver.studentsct.heuristics.selection.ShuffleStudentsSelection;
import org.cpsolver.studentsct.heuristics.selection.StandardSelection;
import org.cpsolver.studentsct.heuristics.selection.SwapStudentSelection;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class StudentSctNeighbourSelection
extends RoundRobinNeighbourSelection<Request, Enrollment>
implements SolverListener<Request, Enrollment> {
    private boolean iUseConstruction = false;
    private boolean iMPP = false;
    private boolean iShuffleStudentsSelection = false;

    public StudentSctNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
        this.iUseConstruction = properties.getPropertyBoolean("Sectioning.UsePriorityConstruction", this.iUseConstruction);
        this.iMPP = properties.getPropertyBoolean("General.MPP", false);
        this.iShuffleStudentsSelection = properties.getPropertyBoolean("Shuffle.Enabled", true) && properties.getPropertyBoolean("Load.RequestGroups", false);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        super.init(solver);
        this.setup(solver);
        solver.setUpdateProgress(false);
        solver.addSolverListener(this);
    }

    public void setup(Solver<Request, Enrollment> solver) {
        if (this.iMPP) {
            this.registerSelection(new AssignInitialSelection(solver.getProperties()));
        }
        this.registerSelection(this.iUseConstruction ? new PriorityConstructionSelection(solver.getProperties()) : new BranchBoundSelection(solver.getProperties()));
        this.registerSelection(new SwapStudentSelection(solver.getProperties()));
        this.registerSelection(new StandardSelection(solver.getProperties(), this.getVariableSelection(), this.getValueSelection()));
        this.registerSelection(new BacktrackSelection(solver.getProperties()));
        SwapStudentSelection swapStudentSelection = new SwapStudentSelection(solver.getProperties());
        this.registerSelection(swapStudentSelection);
        this.registerSelection(new RndUnProblStudSelection(solver.getProperties(), swapStudentSelection));
        this.registerSelection(new ResectionIncompleteStudentsSelection(solver.getProperties()));
        this.registerSelection(new ResectionUnassignedStudentsSelection(solver.getProperties()));
        this.registerSelection(new SwapStudentSelection(solver.getProperties()));
        this.registerSelection(new StandardSelection(solver.getProperties(), new RouletteWheelRequestSelection(solver.getProperties()), this.getValueSelection()));
        this.registerSelection(new SwapStudentSelection(solver.getProperties()));
        this.registerSelection(new BacktrackSelection(solver.getProperties()));
        if (this.iShuffleStudentsSelection) {
            this.registerSelection(new ShuffleStudentsSelection(solver.getProperties()));
            this.registerSelection(new BacktrackSelection(solver.getProperties()));
        }
        this.registerSelection(new RandomUnassignmentSelection(solver.getProperties()));
    }

    @Override
    public void changeSelection(int selectionIndex) {
        super.changeSelection(selectionIndex);
    }

    @Override
    public boolean variableSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable) {
        return true;
    }

    @Override
    public boolean valueSelected(Assignment<Request, Enrollment> assignment, long iteration, Request variable, Enrollment value) {
        return true;
    }

    @Override
    public boolean neighbourSelected(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
        return true;
    }

    @Override
    public void neighbourFailed(Assignment<Request, Enrollment> assignment, long iteration, Neighbour<Request, Enrollment> neighbour) {
        NeighbourSelection selection = this.getSelection();
        if (neighbour instanceof BranchBoundSelection.BranchBoundNeighbour && selection instanceof BranchBoundSelection) {
            ((BranchBoundSelection)selection).addStudent(((BranchBoundSelection.BranchBoundNeighbour)neighbour).getStudent());
        }
    }
}

