/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class CSVFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    HashMap<String, Integer> iHeaderMap = null;
    CSVLine iHeader = null;
    List<CSVLine> iLines = null;
    String iSeparator = ",";
    String iQuotationMark = "\"";

    public CSVFile() {
    }

    public CSVFile(File file) throws IOException {
        this.load(file);
    }

    public CSVFile(File file, String separator) throws IOException {
        this.setSeparator(separator);
        this.load(file);
    }

    public CSVFile(File file, String separator, String quotationMark) throws IOException {
        this.setSeparator(separator);
        this.setQuotationMark(quotationMark);
        this.load(file);
    }

    public void setSeparator(String separator) {
        this.iSeparator = separator;
    }

    public String getSeparator() {
        return this.iSeparator;
    }

    public void setQuotationMark(String quotationMark) {
        this.iQuotationMark = quotationMark;
    }

    public String getQuotationMark() {
        return this.iQuotationMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(File file) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            this.iHeader = new CSVLine(reader.readLine());
            this.iHeaderMap = new HashMap();
            this.iLines = new ArrayList<CSVLine>();
            int idx = 0;
            Iterator<CSVField> i = this.iHeader.fields();
            while (i.hasNext()) {
                CSVField field = i.next();
                this.iHeaderMap.put(field.toString(), idx);
                ++idx;
            }
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                this.iLines.add(new CSVLine(line));
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
            if (this.iHeader != null) {
                writer.println(this.iHeader.toString());
            }
            if (this.iLines != null) {
                for (CSVLine line : this.iLines) {
                    writer.println(line.toString());
                }
            }
            writer.flush();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    public CSVLine getHeader() {
        return this.iHeader;
    }

    public void setHeader(CSVLine header) {
        this.iHeader = header;
    }

    public List<CSVLine> getLines() {
        return this.iLines;
    }

    public int size() {
        return this.iLines.size();
    }

    public boolean isEmpty() {
        return this.iLines.isEmpty();
    }

    public CSVLine getLine(int idx) {
        return this.iLines.get(idx);
    }

    public Iterator<CSVLine> lines() {
        return this.iLines.iterator();
    }

    public void addLine(CSVLine line) {
        if (this.iLines == null) {
            this.iLines = new ArrayList<CSVLine>();
        }
        this.iLines.add(line);
    }

    public void addLine(String line) {
        if (this.iLines == null) {
            this.iLines = new ArrayList<CSVLine>();
        }
        this.iLines.add(new CSVLine(line));
    }

    public List<CSVLine> filter(CSVFilter filter) {
        ArrayList<CSVLine> ret = new ArrayList<CSVLine>();
        for (CSVLine line : this.iLines) {
            if (!filter.match(line)) continue;
            ret.add(line);
        }
        return ret;
    }

    public CSVLine addLine() {
        CSVLine line = new CSVLine();
        this.addLine(line);
        return line;
    }

    public CSVLine addLine(CSVField[] fields) {
        CSVLine line = new CSVLine(fields);
        this.addLine(line);
        return line;
    }

    public CSVLine addLine(Collection<CSVField> fields) {
        CSVLine line = new CSVLine(fields);
        this.addLine(line);
        return line;
    }

    public CSVLine setHeader(CSVField[] fields) {
        CSVLine header = new CSVLine(fields);
        this.setHeader(header);
        return header;
    }

    public CSVLine setHeader(Collection<CSVField> fields) {
        CSVLine header = new CSVLine(fields);
        this.setHeader(header);
        return header;
    }

    public static CSVFilter eq(String name, String value) {
        return (new CSVFilter(){
            String n;
            String v;

            @Override
            public boolean match(CSVLine line) {
                return line.getField(this.n).equals(this.v);
            }

            private CSVFilter set(String n, String v) {
                this.n = n;
                this.v = v;
                return this;
            }
        }).set(name, value);
    }

    public static CSVFilter and(CSVFilter first, CSVFilter second) {
        return (new CSVFilter(){
            CSVFilter a;
            CSVFilter b;

            @Override
            public boolean match(CSVLine line) {
                return this.a.match(line) && this.b.match(line);
            }

            private CSVFilter set(CSVFilter a, CSVFilter b) {
                this.a = a;
                this.b = b;
                return this;
            }
        }).set(first, second);
    }

    public static CSVFilter or(CSVFilter first, CSVFilter second) {
        return (new CSVFilter(){
            CSVFilter a;
            CSVFilter b;

            @Override
            public boolean match(CSVLine line) {
                return this.a.match(line) || this.b.match(line);
            }

            private CSVFilter set(CSVFilter a, CSVFilter b) {
                this.a = a;
                this.b = b;
                return this;
            }
        }).set(first, second);
    }

    public static CSVFilter not(CSVFilter filter) {
        return (new CSVFilter(){
            CSVFilter f;

            @Override
            public boolean match(CSVLine line) {
                return !this.f.match(line);
            }

            private CSVFilter set(CSVFilter f) {
                this.f = f;
                return this;
            }
        }).set(filter);
    }

    public static interface CSVFilter {
        public boolean match(CSVLine var1);
    }

    public static class CSVField
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String iField = null;

        public CSVField(String field, String quotationMark) {
            field = field.trim();
            if (quotationMark != null && field.startsWith(quotationMark) && field.endsWith(quotationMark)) {
                field = field.substring(1, field.length() - 1);
            }
            this.iField = field;
        }

        public CSVField(Object field) {
            this.set(field == null ? "" : field.toString());
        }

        public CSVField(int field) {
            this.set(field);
        }

        public CSVField(boolean field) {
            this.set(field);
        }

        public CSVField(double field) {
            this.set(field);
        }

        public CSVField(long field) {
            this.set(field);
        }

        public CSVField(float field) {
            this.set(field);
        }

        public void set(Object value) {
            this.iField = value == null ? "" : value.toString();
        }

        public void set(int value) {
            this.iField = String.valueOf(value);
        }

        public void set(boolean value) {
            this.iField = value ? "1" : "0";
        }

        public void set(double value) {
            this.iField = String.valueOf(value);
        }

        public void set(long value) {
            this.iField = String.valueOf(value);
        }

        public void set(float value) {
            this.iField = String.valueOf(value);
        }

        public String toString() {
            return this.iField == null ? "" : this.iField;
        }

        public boolean isEmpty() {
            return this.iField.length() == 0;
        }

        public int toInt() {
            return this.toInt(0);
        }

        public int toInt(int defaultValue) {
            try {
                return Integer.parseInt(this.iField);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }

        public long toLong() {
            return this.toLong(0L);
        }

        public long toLong(long defaultValue) {
            try {
                return Long.parseLong(this.iField);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }

        public double toDouble() {
            return this.toDouble(0.0);
        }

        public double toDouble(double defaultValue) {
            try {
                return Double.parseDouble(this.iField);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }

        public Date toDate() {
            int month = Integer.parseInt(this.iField.substring(0, 2));
            int day = Integer.parseInt(this.iField.substring(3, 5));
            int year = Integer.parseInt(this.iField.substring(6, 8));
            Calendar c = Calendar.getInstance(Locale.US);
            c.set(year, month - 1, day, 0, 0, 0);
            return c.getTime();
        }

        public boolean toBoolean() {
            return "Y".equalsIgnoreCase(this.iField) || "on".equalsIgnoreCase(this.iField) || "true".equalsIgnoreCase(this.iField) || "1".equalsIgnoreCase(this.iField);
        }
    }

    public class CSVLine
    implements Serializable {
        private static final long serialVersionUID = 1L;
        List<CSVField> iFields;

        public CSVLine(String line) {
            this.iFields = new ArrayList<CSVField>(CSVFile.this.iHeader == null ? 10 : CSVFile.this.iHeader.size());
            int idx = 0;
            int newIdx = 0;
            int fromIdx = 0;
            while ((newIdx = line.indexOf(CSVFile.this.iSeparator, fromIdx)) >= 0) {
                String field = line.substring(idx, newIdx);
                if (CSVFile.this.iQuotationMark != null && field.startsWith(CSVFile.this.iQuotationMark) && (!field.endsWith(CSVFile.this.iQuotationMark) || field.length() == 1)) {
                    fromIdx = newIdx + CSVFile.this.iSeparator.length();
                    continue;
                }
                this.iFields.add(new CSVField(field, CSVFile.this.iQuotationMark));
                fromIdx = idx = newIdx + CSVFile.this.iSeparator.length();
            }
            this.iFields.add(new CSVField(line.substring(idx), CSVFile.this.iQuotationMark));
        }

        public CSVLine() {
            this.iFields = new ArrayList<CSVField>(CSVFile.this.iHeader == null ? 10 : CSVFile.this.iHeader.size());
        }

        public CSVLine(CSVField[] fields) {
            this.iFields = new ArrayList<CSVField>(CSVFile.this.iHeader == null ? 10 : CSVFile.this.iHeader.size());
            for (int i = 0; i < fields.length; ++i) {
                this.iFields.add(fields[i]);
            }
        }

        public CSVLine(Collection<CSVField> fields) {
            this.iFields = new ArrayList<CSVField>(CSVFile.this.iHeader == null ? 10 : CSVFile.this.iHeader.size());
            this.iFields.addAll(fields);
        }

        public List<CSVField> getFields() {
            return this.iFields;
        }

        public int size() {
            return this.iFields.size();
        }

        public boolean isEmpty() {
            return this.iFields.isEmpty();
        }

        public CSVField getField(int idx) {
            try {
                return this.iFields.get(idx);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public void setField(int idx, CSVField field) {
            this.iFields.set(idx, field);
        }

        public Iterator<CSVField> fields() {
            return this.iFields.iterator();
        }

        public CSVField getField(String name) {
            Integer idx = CSVFile.this.iHeaderMap.get(name);
            return idx == null ? null : this.getField(idx);
        }

        public void setField(String name, CSVField field) {
            Integer idx = CSVFile.this.iHeaderMap.get(name);
            if (idx != null) {
                this.setField(idx, field);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Iterator<CSVField> i = this.iFields.iterator();
            while (i.hasNext()) {
                CSVField field = i.next();
                if (field != null) {
                    sb.append((CSVFile.this.iQuotationMark == null ? "" : CSVFile.this.iQuotationMark) + field.toString() + (CSVFile.this.iQuotationMark == null ? "" : CSVFile.this.iQuotationMark));
                }
                if (!i.hasNext()) continue;
                sb.append(CSVFile.this.iSeparator);
            }
            return sb.toString();
        }

        public void debug(int offset, PrintWriter out) {
            int idx = 0;
            for (CSVField field : this.iFields) {
                if (field == null || field.toString().length() == 0) continue;
                for (int j = 0; j < offset; ++j) {
                    out.print(" ");
                }
                out.println(CSVFile.this.iHeader.getField(idx) + "=" + (CSVFile.this.iQuotationMark == null ? "" : CSVFile.this.iQuotationMark) + field + (CSVFile.this.iQuotationMark == null ? "" : CSVFile.this.iQuotationMark));
            }
        }
    }
}

