/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.solver;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.locks.Lock;
import org.apache.log4j.Logger;
import org.cpsolver.ifs.assignment.DefaultSingleAssignment;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.perturbations.PerturbationsCounter;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solution.SolutionComparator;
import org.cpsolver.ifs.solver.SolverListener;
import org.cpsolver.ifs.termination.TerminationCondition;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.ifs.util.ToolBox;

public class Solver<V extends Variable<V, T>, T extends Value<V, T>> {
    public static int THREAD_PRIORITY = 3;
    protected static Logger sLogger = Logger.getLogger(Solver.class);
    protected Solution<V, T> iCurrentSolution = null;
    protected Solution<V, T> iLastSolution = null;
    protected boolean iStop = false;
    protected SolverThread iSolverThread = null;
    private DataProperties iProperties = null;
    private TerminationCondition<V, T> iTerminationCondition = null;
    private SolutionComparator<V, T> iSolutionComparator = null;
    private PerturbationsCounter<V, T> iPerturbationsCounter = null;
    private NeighbourSelection<V, T> iNeighbourSelection = null;
    private List<Extension<V, T>> iExtensions = new ArrayList<Extension<V, T>>();
    protected List<SolverListener<V, T>> iSolverListeners = new ArrayList<SolverListener<V, T>>();
    protected int iSaveBestUnassigned = 0;
    private boolean iUpdateProgress = true;
    protected Progress iProgress;

    public Solver(DataProperties properties) {
        this.iProperties = properties;
    }

    public void dispose() {
        this.iExtensions.clear();
        this.iSolverListeners.clear();
        this.iTerminationCondition = null;
        this.iSolutionComparator = null;
        this.iPerturbationsCounter = null;
        this.iNeighbourSelection = null;
    }

    public void setTerminalCondition(TerminationCondition<V, T> terminationCondition) {
        this.iTerminationCondition = terminationCondition;
    }

    public void setSolutionComparator(SolutionComparator<V, T> solutionComparator) {
        this.iSolutionComparator = solutionComparator;
    }

    public void setNeighbourSelection(NeighbourSelection<V, T> neighbourSelection) {
        this.iNeighbourSelection = neighbourSelection;
    }

    public void setPerturbationsCounter(PerturbationsCounter<V, T> perturbationsCounter) {
        this.iPerturbationsCounter = perturbationsCounter;
    }

    public void addExtension(Extension<V, T> extension) {
        this.iExtensions.add(extension);
    }

    public TerminationCondition<V, T> getTerminationCondition() {
        return this.iTerminationCondition;
    }

    public SolutionComparator<V, T> getSolutionComparator() {
        return this.iSolutionComparator;
    }

    public NeighbourSelection<V, T> getNeighbourSelection() {
        return this.iNeighbourSelection;
    }

    public PerturbationsCounter<V, T> getPerturbationsCounter() {
        return this.iPerturbationsCounter;
    }

    public List<Extension<V, T>> getExtensions() {
        return this.iExtensions;
    }

    public void addSolverListener(SolverListener<V, T> listener) {
        this.iSolverListeners.add(listener);
    }

    public void removeSolverListener(SolverListener<V, T> listener) {
        this.iSolverListeners.remove(listener);
    }

    public List<SolverListener<V, T>> getSolverListeners() {
        return this.iSolverListeners;
    }

    public DataProperties getProperties() {
        return this.iProperties;
    }

    protected void autoConfigure() {
        try {
            boolean mpp = this.getProperties().getPropertyBoolean("General.MPP", false);
            String terminationConditionClassName = this.getProperties().getProperty("Termination.Class", mpp ? "org.cpsolver.ifs.termination.MPPTerminationCondition" : "org.cpsolver.ifs.termination.GeneralTerminationCondition");
            sLogger.info("Using " + terminationConditionClassName);
            Class<?> terminationConditionClass = Class.forName(terminationConditionClassName);
            Constructor<?> terminationConditionConstructor = terminationConditionClass.getConstructor(DataProperties.class);
            this.setTerminalCondition((TerminationCondition)terminationConditionConstructor.newInstance(this.getProperties()));
            String solutionComparatorClassName = this.getProperties().getProperty("Comparator.Class", mpp ? "org.cpsolver.ifs.solution.MPPSolutionComparator" : "org.cpsolver.ifs.solution.GeneralSolutionComparator");
            sLogger.info("Using " + solutionComparatorClassName);
            Class<?> solutionComparatorClass = Class.forName(solutionComparatorClassName);
            Constructor<?> solutionComparatorConstructor = solutionComparatorClass.getConstructor(DataProperties.class);
            this.setSolutionComparator((SolutionComparator)solutionComparatorConstructor.newInstance(this.getProperties()));
            String neighbourSelectionClassName = this.getProperties().getProperty("Neighbour.Class", "org.cpsolver.ifs.heuristics.StandardNeighbourSelection");
            sLogger.info("Using " + neighbourSelectionClassName);
            Class<?> neighbourSelectionClass = Class.forName(neighbourSelectionClassName);
            Constructor<?> neighbourSelectionConstructor = neighbourSelectionClass.getConstructor(DataProperties.class);
            this.setNeighbourSelection((NeighbourSelection)neighbourSelectionConstructor.newInstance(this.getProperties()));
            String perturbationCounterClassName = this.getProperties().getProperty("PerturbationCounter.Class", "org.cpsolver.ifs.perturbations.DefaultPerturbationsCounter");
            sLogger.info("Using " + perturbationCounterClassName);
            Class<?> perturbationCounterClass = Class.forName(perturbationCounterClassName);
            Constructor<?> perturbationCounterConstructor = perturbationCounterClass.getConstructor(DataProperties.class);
            this.setPerturbationsCounter((PerturbationsCounter)perturbationCounterConstructor.newInstance(this.getProperties()));
            for (Extension<V, T> extension : this.iExtensions) {
                extension.unregister(this.iCurrentSolution.getModel());
            }
            this.iExtensions.clear();
            String extensionClassNames = this.getProperties().getProperty("Extensions.Classes", null);
            if (extensionClassNames != null) {
                StringTokenizer extensionClassNameTokenizer = new StringTokenizer(extensionClassNames, ";");
                while (extensionClassNameTokenizer.hasMoreTokens()) {
                    String extensionClassName = extensionClassNameTokenizer.nextToken().trim();
                    if (extensionClassName.isEmpty()) continue;
                    sLogger.info("Using " + extensionClassName);
                    Class<?> extensionClass = Class.forName(extensionClassName);
                    Constructor<?> extensionConstructor = extensionClass.getConstructor(Solver.class, DataProperties.class);
                    this.addExtension((Extension)extensionConstructor.newInstance(this, this.getProperties()));
                }
            }
        }
        catch (Exception e) {
            sLogger.error("Unable to autoconfigure solver.", e);
        }
    }

    public void clearBest() {
        if (this.iCurrentSolution != null) {
            this.iCurrentSolution.clearBest();
        }
    }

    public void setInitalSolution(Solution<V, T> solution) {
        this.iCurrentSolution = solution;
        this.iLastSolution = null;
    }

    public void setInitalSolution(Model<V, T> model) {
        this.setInitalSolution(new Solution<V, T>(model, new DefaultSingleAssignment(), 0L, 0.0));
    }

    public void start() {
        this.iSolverThread = new SolverThread();
        this.iSolverThread.setPriority(THREAD_PRIORITY);
        this.iSolverThread.start();
    }

    public Thread getSolverThread() {
        return this.iSolverThread;
    }

    public void init() {
    }

    protected boolean isUpdateProgress() {
        return this.iUpdateProgress;
    }

    public void setUpdateProgress(boolean updateProgress) {
        this.iUpdateProgress = updateProgress;
    }

    public Solution<V, T> lastSolution() {
        return this.iLastSolution == null ? this.iCurrentSolution : this.iLastSolution;
    }

    public Solution<V, T> currentSolution() {
        return this.iCurrentSolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSolver() {
        long seed = this.getProperties().getPropertyLong("General.Seed", System.currentTimeMillis());
        ToolBox.setSeed(seed);
        this.iSaveBestUnassigned = this.getProperties().getPropertyInt("General.SaveBestUnassigned", 0);
        this.clearBest();
        if (this.iProperties.getPropertyBoolean("Solver.AutoConfigure", true)) {
            this.autoConfigure();
        }
        for (Extension<V, T> extension : this.iExtensions) {
            extension.register(this.iCurrentSolution.getModel());
        }
        this.iCurrentSolution.init(this);
        this.getNeighbourSelection().init(this);
        if (this.getPerturbationsCounter() != null) {
            this.getPerturbationsCounter().init(this);
        }
        if (this.iProperties.getPropertyBoolean("General.SaveConfiguration", false)) {
            FileOutputStream f = null;
            try {
                f = new FileOutputStream(this.iProperties.getProperty("General.Output") + File.separator + this.iProperties.getProperty("General.ProblemName", "ifs") + ".properties");
                this.iProperties.store(f, this.iProperties.getProperty("General.ProblemNameLong", "Iterative Forward Search") + "  -- configuration file");
                f.flush();
                f.close();
                f = null;
            }
            catch (Exception e) {
                sLogger.error("Unable to store configuration file :-(", e);
            }
            finally {
                try {
                    if (f != null) {
                        f.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void stopSolver() {
        this.stopSolver(true);
    }

    public void stopSolver(boolean join) {
        if (this.getSolverThread() != null) {
            this.iStop = true;
            if (join) {
                try {
                    this.getSolverThread().join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isRunning() {
        return this.getSolverThread() != null;
    }

    protected void onStop() {
    }

    protected void onStart() {
    }

    protected void onFinish() {
    }

    protected void onFailure() {
    }

    protected void onAssigned(double startTime, Solution<V, T> solution) {
    }

    public boolean hasSingleSolution() {
        return this.currentSolution().getAssignment() instanceof DefaultSingleAssignment;
    }

    public boolean isStop() {
        return this.iStop;
    }

    protected class SolverThread
    extends Thread {
        protected SolverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Solver.this.iStop = false;
                this.setName("Solver");
                Solver.this.iProgress = Progress.getInstance(Solver.this.iCurrentSolution.getModel());
                Solver.this.iProgress.setStatus("Solving problem ...");
                Solver.this.iProgress.setPhase("Initializing solver");
                Solver.this.initSolver();
                Solver.this.onStart();
                double startTime = JProf.currentTimeSec();
                int timeout = Solver.this.getProperties().getPropertyInt("Termination.TimeOut", 1800);
                if (Solver.this.isUpdateProgress()) {
                    if (Solver.this.iCurrentSolution.getBestInfo() == null) {
                        Solver.this.iProgress.setPhase("Searching for initial solution ...", Solver.this.iCurrentSolution.getModel().variables().size());
                    } else {
                        Solver.this.iProgress.setPhase("Improving found solution ...");
                    }
                }
                sLogger.info("Initial solution:" + ToolBox.dict2string(Solver.this.iCurrentSolution.getExtendedInfo(), 1));
                if (!(Solver.this.iSaveBestUnassigned >= 0 && Solver.this.iSaveBestUnassigned < Solver.this.iCurrentSolution.getAssignment().nrUnassignedVariables(Solver.this.iCurrentSolution.getModel()) || Solver.this.iCurrentSolution.getBestInfo() != null && !Solver.this.getSolutionComparator().isBetterThanBestSolution(Solver.this.iCurrentSolution))) {
                    if (Solver.this.iCurrentSolution.getModel().variables().size() == Solver.this.iCurrentSolution.getAssignment().nrAssignedVariables()) {
                        sLogger.info("Complete solution " + ToolBox.dict2string(Solver.this.iCurrentSolution.getExtendedInfo(), 1) + " was found.");
                    }
                    Solver.this.iCurrentSolution.saveBest();
                }
                if (Solver.this.iCurrentSolution.getModel().variables().isEmpty()) {
                    Solver.this.iProgress.error("Nothing to solve.");
                    Solver.this.iStop = true;
                }
                while (!Solver.this.iStop && Solver.this.getTerminationCondition().canContinue(Solver.this.iCurrentSolution)) {
                    Neighbour neighbour = Solver.this.getNeighbourSelection().selectNeighbour(Solver.this.iCurrentSolution);
                    for (SolverListener listener : Solver.this.iSolverListeners) {
                        if (listener.neighbourSelected(Solver.this.iCurrentSolution.getAssignment(), Solver.this.iCurrentSolution.getIteration(), neighbour)) continue;
                        neighbour = null;
                    }
                    if (neighbour == null) {
                        sLogger.debug("No neighbour selected.");
                        Solver.this.iCurrentSolution.update(JProf.currentTimeSec() - startTime, false);
                        continue;
                    }
                    Lock lock = Solver.this.iCurrentSolution.getLock().writeLock();
                    lock.lock();
                    try {
                        neighbour.assign(Solver.this.iCurrentSolution.getAssignment(), Solver.this.iCurrentSolution.getIteration());
                    }
                    finally {
                        lock.unlock();
                    }
                    double time = JProf.currentTimeSec() - startTime;
                    Solver.this.iCurrentSolution.update(time);
                    Solver.this.onAssigned(startTime, Solver.this.iCurrentSolution);
                    if (!(Solver.this.iSaveBestUnassigned >= 0 && Solver.this.iSaveBestUnassigned < Solver.this.iCurrentSolution.getAssignment().nrUnassignedVariables(Solver.this.iCurrentSolution.getModel()) || Solver.this.iCurrentSolution.getBestInfo() != null && !Solver.this.getSolutionComparator().isBetterThanBestSolution(Solver.this.iCurrentSolution))) {
                        if (Solver.this.iCurrentSolution.getModel().variables().size() == Solver.this.iCurrentSolution.getAssignment().nrAssignedVariables()) {
                            Solver.this.iProgress.debug("Complete solution of value " + Solver.this.iCurrentSolution.getModel().getTotalValue(Solver.this.iCurrentSolution.getAssignment()) + " was found.");
                        }
                        Solver.this.iCurrentSolution.saveBest();
                    }
                    if (!Solver.this.isUpdateProgress()) continue;
                    if (Solver.this.iCurrentSolution.getBestInfo() != null && Solver.this.iCurrentSolution.getModel().getBestUnassignedVariables() == 0) {
                        if (!"Improving found solution ...".equals(Solver.this.iProgress.getPhase())) {
                            Solver.this.iProgress.setPhase("Improving found solution ...");
                        }
                        Solver.this.iProgress.setProgress(Math.min(100, (int)Math.round(100.0 * time / (double)timeout)));
                        continue;
                    }
                    if (Solver.this.iCurrentSolution.getBestInfo() != null && Solver.this.iCurrentSolution.getModel().getBestUnassignedVariables() <= 0 || (long)Solver.this.iCurrentSolution.getAssignment().nrAssignedVariables() <= Solver.this.iProgress.getProgress()) continue;
                    Solver.this.iProgress.setProgress(Solver.this.iCurrentSolution.getAssignment().nrAssignedVariables());
                }
                Solver.this.iLastSolution = Solver.this.iCurrentSolution;
                Solver.this.iProgress.setPhase("Done", 1L);
                Solver.this.iProgress.incProgress();
                Solver.this.iSolverThread = null;
                if (Solver.this.iStop) {
                    sLogger.debug("Solver stopped.");
                    Solver.this.iProgress.setStatus("Solver stopped.");
                    Solver.this.onStop();
                } else {
                    sLogger.debug("Solver done.");
                    Solver.this.iProgress.setStatus("Solver done.");
                    Solver.this.onFinish();
                }
            }
            catch (Exception ex) {
                sLogger.error(ex.getMessage(), ex);
                Solver.this.iProgress.fatal("Solver failed, reason:" + ex.getMessage(), ex);
                Solver.this.iProgress.setStatus("Solver failed.");
                Solver.this.onFailure();
            }
            Solver.this.iSolverThread = null;
        }
    }
}

