/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class StudentBackToBackConflicts
extends ExamCriterion {
    private boolean iDayBreakBackToBack = false;

    @Override
    public boolean init(Solver<Exam, ExamPlacement> solver) {
        boolean ret = super.init(solver);
        this.iDayBreakBackToBack = solver.getProperties().getPropertyBoolean("Exams.IsDayBreakBackToBack", this.iDayBreakBackToBack);
        return ret;
    }

    @Override
    public String getWeightName() {
        return "Exams.BackToBackConflictWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "backToBackConflictWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 10.0;
    }

    public boolean isDayBreakBackToBack() {
        return this.iDayBreakBackToBack;
    }

    public void setDayBreakBackToBack(boolean dayBreakBackToBack) {
        this.iDayBreakBackToBack = dayBreakBackToBack;
    }

    @Override
    public void getXmlParameters(Map<String, String> params) {
        params.put(this.getXmlWeightName(), String.valueOf(this.getWeight()));
        params.put("isDayBreakBackToBack", this.isDayBreakBackToBack() ? "true" : "false");
    }

    @Override
    public void setXmlParameters(Map<String, String> params) {
        try {
            this.setWeight(Double.valueOf(params.get(this.getXmlWeightName())));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.setDayBreakBackToBack("true".equals(params.get("isDayBreakBackToBack")));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        ExamPeriod period = value.getPeriod();
        Map<ExamStudent, Set<Exam>> prev = period.prev() != null && (this.isDayBreakBackToBack() || period.prev().getDay() == period.getDay()) ? ((ExamModel)this.getModel()).getStudentsOfPeriod(assignment, period.prev()) : null;
        Map<ExamStudent, Set<Exam>> next = period.next() != null && (this.isDayBreakBackToBack() || period.next().getDay() == period.getDay()) ? ((ExamModel)this.getModel()).getStudentsOfPeriod(assignment, period.next()) : null;
        for (ExamStudent s : exam.getStudents()) {
            int nrExams;
            Set<Exam> exams;
            if (prev != null && (exams = prev.get(s)) != null) {
                nrExams = exams.size() + (exams.contains(exam) ? -1 : 0);
                penalty += nrExams;
            }
            if (next == null || (exams = next.get(s)) == null) continue;
            nrExams = exams.size() + (exams.contains(exam) ? -1 : 0);
            penalty += nrExams;
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Back-To-Back Conflicts";
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        if (this.getValue(assignment) != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue(assignment)));
        }
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "BTB:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

