/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.model.WeakeningConstraint;
import org.cpsolver.ifs.util.DataProperties;

public class MinimizeNumberOfUsedRoomsConstraint
extends ConstraintWithContext<Lecture, Placement, MinimizeNumberOfUsedRoomsConstraintContext>
implements WeakeningConstraint<Lecture, Placement> {
    private int iUnassignmentsToWeaken = 250;
    private int iFirstDaySlot;
    private int iLastDaySlot;
    private int iFirstWorkDay;
    private int iLastWorkDay;

    public MinimizeNumberOfUsedRoomsConstraint(DataProperties config) {
        this.iUnassignmentsToWeaken = config.getPropertyInt("MinimizeNumberOfUsedRooms.Unassignments2Weaken", this.iUnassignmentsToWeaken);
        this.iFirstDaySlot = config.getPropertyInt("General.FirstDaySlot", Constants.DAY_SLOTS_FIRST);
        this.iLastDaySlot = config.getPropertyInt("General.LastDaySlot", Constants.DAY_SLOTS_LAST);
        this.iFirstWorkDay = config.getPropertyInt("General.FirstWorkDay", 0);
        this.iLastWorkDay = config.getPropertyInt("General.LastWorkDay", Constants.NR_DAYS_WEEK - 1);
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement placement, Set<Placement> conflicts) {
        MinimizeNumberOfUsedRoomsConstraintContext context = (MinimizeNumberOfUsedRoomsConstraintContext)this.getContext((Assignment)assignment);
        int overLimit = context.getOverLimit(assignment, placement);
        if (overLimit > 0) {
            ArrayList adepts = new ArrayList();
            for (Set<Lecture> lects : context.getUsedRooms().values()) {
                ArrayList<Placement> placementsToUnassign = new ArrayList<Placement>();
                boolean canUnassign = true;
                for (Lecture l : lects) {
                    if (l.isCommitted()) {
                        canUnassign = false;
                        break;
                    }
                    Placement p = assignment.getValue(l);
                    if (conflicts.contains(p)) continue;
                    placementsToUnassign.add(p);
                }
                if (!canUnassign) continue;
                adepts.add(placementsToUnassign);
            }
            if (adepts.size() < overLimit) {
                conflicts.add(placement);
            } else {
                Collections.sort(adepts, new Comparator<List<Placement>>(){

                    @Override
                    public int compare(List<Placement> c1, List<Placement> c2) {
                        return Double.compare(c1.size(), c2.size());
                    }
                });
                for (int i = 0; i < overLimit; ++i) {
                    conflicts.addAll((Collection)adepts.get(i));
                }
            }
        }
    }

    @Override
    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement placement) {
        return ((MinimizeNumberOfUsedRoomsConstraintContext)this.getContext((Assignment)assignment)).isOverLimit(assignment, placement);
    }

    @Override
    public String getName() {
        return "Minimize number of used rooms";
    }

    public int estimateLimit() {
        HashSet<RoomLocation> mandatoryRooms = new HashSet<RoomLocation>();
        for (Lecture lecture : this.variables()) {
            if (lecture.getNrRooms() == 0 || !lecture.isCommitted() && lecture.roomLocations().size() != 1) continue;
            mandatoryRooms.addAll(lecture.roomLocations());
        }
        double[][] histogram = new double[this.iLastDaySlot - this.iFirstDaySlot + 1][this.iLastWorkDay - this.iFirstWorkDay + 1];
        for (int i = 0; i < this.iLastDaySlot - this.iFirstDaySlot + 1; ++i) {
            for (int j = 0; j < this.iLastWorkDay - this.iFirstWorkDay + 1; ++j) {
                histogram[i][j] = 0.0;
            }
        }
        for (Lecture lecture : this.variables()) {
            if (lecture.getNrRooms() == 0) continue;
            List<Placement> values = lecture.values((Assignment<Lecture, Placement>)null);
            for (Placement p : lecture.values((Assignment<Lecture, Placement>)null)) {
                int endSlot;
                int firstSlot = p.getTimeLocation().getStartSlot();
                if (firstSlot > this.iLastDaySlot || (endSlot = firstSlot + p.getTimeLocation().getNrSlotsPerMeeting() - 1) < this.iFirstDaySlot) continue;
                for (int i = Math.max(firstSlot, this.iFirstDaySlot); i <= Math.min(endSlot, this.iLastDaySlot); ++i) {
                    int dayCode = p.getTimeLocation().getDayCode();
                    for (int j = this.iFirstWorkDay; j <= this.iLastWorkDay; ++j) {
                        if ((dayCode & Constants.DAY_CODES[j]) == 0) continue;
                        double[] dArray = histogram[i - this.iFirstDaySlot];
                        int n = j - this.iFirstWorkDay;
                        dArray[n] = dArray[n] + (double)lecture.getNrRooms() / (double)values.size();
                    }
                }
            }
        }
        int maxAverageRooms = 0;
        for (int i = 0; i < this.iLastDaySlot - this.iFirstDaySlot + 1; ++i) {
            for (int j = 0; j < this.iLastWorkDay - this.iFirstWorkDay + 1; ++j) {
                maxAverageRooms = Math.max(maxAverageRooms, (int)Math.ceil(histogram[i][j]));
            }
        }
        return Math.max(1, Math.max(mandatoryRooms.size(), maxAverageRooms));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Minimize Number Of Rooms Used between ");
        Iterator e = this.variables().iterator();
        while (e.hasNext()) {
            Lecture v = (Lecture)e.next();
            sb.append(v.getName());
            if (!e.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment) {
        if (this.iUnassignmentsToWeaken > 0) {
            ((MinimizeNumberOfUsedRoomsConstraintContext)this.getContext((Assignment)assignment)).weaken();
        }
    }

    @Override
    public void weaken(Assignment<Lecture, Placement> assignment, Placement value) {
        ((MinimizeNumberOfUsedRoomsConstraintContext)this.getContext((Assignment)assignment)).weaken(assignment, value);
    }

    @Override
    public MinimizeNumberOfUsedRoomsConstraintContext createAssignmentContext(Assignment<Lecture, Placement> assignment) {
        return new MinimizeNumberOfUsedRoomsConstraintContext(assignment);
    }

    public class MinimizeNumberOfUsedRoomsConstraintContext
    implements AssignmentConstraintContext<Lecture, Placement> {
        private long iUnassignment = 0L;
        private int iLimit = 1;
        private Map<RoomLocation, Set<Lecture>> iUsedRooms = new HashMap<RoomLocation, Set<Lecture>>();

        public MinimizeNumberOfUsedRoomsConstraintContext(Assignment<Lecture, Placement> assignment) {
            for (Lecture lecture : MinimizeNumberOfUsedRoomsConstraint.this.variables()) {
                Placement placement = assignment.getValue(lecture);
                if (placement == null) continue;
                this.assigned(assignment, placement);
            }
            this.iLimit = Math.max(this.iUsedRooms.size(), MinimizeNumberOfUsedRoomsConstraint.this.estimateLimit());
        }

        @Override
        public void assigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            Lecture lecture = (Lecture)placement.variable();
            if (lecture.getNrRooms() <= 0) {
                return;
            }
            if (placement.isMultiRoom()) {
                for (RoomLocation r : placement.getRoomLocations()) {
                    Set<Lecture> lects = this.iUsedRooms.get(r);
                    if (lects == null) {
                        lects = new HashSet<Lecture>();
                        this.iUsedRooms.put(r, lects);
                    }
                    lects.add(lecture);
                }
            } else {
                RoomLocation r = placement.getRoomLocation();
                Set<Lecture> lects = this.iUsedRooms.get(r);
                if (lects == null) {
                    lects = new HashSet<Lecture>();
                    this.iUsedRooms.put(r, lects);
                }
                lects.add(lecture);
            }
        }

        @Override
        public void unassigned(Assignment<Lecture, Placement> assignment, Placement placement) {
            Lecture lecture = (Lecture)placement.variable();
            if (lecture.getNrRooms() <= 0) {
                return;
            }
            if (placement.isMultiRoom()) {
                for (RoomLocation r : placement.getRoomLocations()) {
                    Set<Lecture> lects = this.iUsedRooms.get(r);
                    if (lects == null) continue;
                    lects.remove(lecture);
                    if (!lects.isEmpty()) continue;
                    this.iUsedRooms.remove(r);
                }
            } else {
                RoomLocation r = placement.getRoomLocation();
                Set<Lecture> lects = this.iUsedRooms.get(r);
                if (lects != null) {
                    lects.remove(lecture);
                    if (lects.isEmpty()) {
                        this.iUsedRooms.remove(r);
                    }
                }
            }
        }

        public boolean isOverLimit(Assignment<Lecture, Placement> assignment, Placement placement) {
            return this.getOverLimit(assignment, placement) > 0;
        }

        public int getOverLimit(Assignment<Lecture, Placement> assignment, Placement placement) {
            if (MinimizeNumberOfUsedRoomsConstraint.this.iUnassignmentsToWeaken == 0) {
                return 0;
            }
            Lecture lecture = (Lecture)placement.variable();
            if (lecture.getNrRooms() <= 0) {
                return 0;
            }
            if (lecture.roomLocations().size() == lecture.getNrRooms()) {
                return 0;
            }
            if (lecture.isCommitted()) {
                return 0;
            }
            Placement current = assignment.getValue(lecture);
            int usage = this.iUsedRooms.size();
            if (usage + lecture.getNrRooms() <= this.iLimit) {
                return 0;
            }
            if (placement.isMultiRoom()) {
                HashSet<RoomLocation> assignedRooms = new HashSet<RoomLocation>();
                if (current != null) {
                    assignedRooms.addAll(current.getRoomLocations());
                }
                for (RoomLocation r : placement.getRoomLocations()) {
                    if (assignedRooms.remove(r) || this.iUsedRooms.containsKey(r)) continue;
                    ++usage;
                }
                for (RoomLocation r : assignedRooms) {
                    Set<Lecture> lects = this.iUsedRooms.get(r);
                    if (lects == null || lects.size() != 1) continue;
                    --usage;
                }
            } else {
                RoomLocation assignedRoom = current != null && !current.equals(placement) ? current.getRoomLocation() : null;
                RoomLocation room = placement.getRoomLocation();
                if (!room.equals(assignedRoom)) {
                    Set<Lecture> lects;
                    if (!this.iUsedRooms.containsKey(room)) {
                        ++usage;
                    }
                    if (assignedRoom != null && (lects = this.iUsedRooms.get(assignedRoom)) != null && lects.size() == 1) {
                        --usage;
                    }
                }
            }
            if (usage <= this.iUsedRooms.size()) {
                return 0;
            }
            if (usage <= this.iLimit) {
                return 0;
            }
            return usage - this.iLimit;
        }

        public void weaken(Assignment<Lecture, Placement> assignment, Placement value) {
            if (this.isOverLimit(assignment, value)) {
                this.iLimit += this.getOverLimit(assignment, value);
            }
        }

        public void weaken() {
            ++this.iUnassignment;
            if (MinimizeNumberOfUsedRoomsConstraint.this.iUnassignmentsToWeaken > 0 && this.iUnassignment % (long)MinimizeNumberOfUsedRoomsConstraint.this.iUnassignmentsToWeaken == 0L) {
                ++this.iLimit;
            }
        }

        public Map<RoomLocation, Set<Lecture>> getUsedRooms() {
            return this.iUsedRooms;
        }
    }
}

