/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import java.net.URL;
import java.util.Locale;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.event.ConfigurationEvent;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.unitime.commons.Debug;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.listeners.SessionListener;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.MessageResourcesFactory;

public class MessageResources
extends org.apache.struts.util.MessageResources {
    private static final long serialVersionUID = -3234198544455822319L;
    private static PropertiesConfiguration resource;
    private static String resourceFile;

    public MessageResources(MessageResourcesFactory factory, String config, boolean returnNull) {
        super((org.apache.struts.util.MessageResourcesFactory)factory, config, returnNull);
    }

    public MessageResources(MessageResourcesFactory factory, String config) {
        super((org.apache.struts.util.MessageResourcesFactory)factory, config);
    }

    public String getMessage(Locale locale, String key) {
        if (resource == null) {
            resource = (PropertiesConfiguration)this.getConfiguration(this.config + "_" + locale.getLanguage() + ".properties");
            resourceFile = this.config + "_" + locale.getLanguage() + ".properties";
            if (resource == null || !resource.containsKey(key)) {
                resource = (PropertiesConfiguration)this.getConfiguration(this.config + ".properties");
                resourceFile = this.config + ".properties";
            }
            if (resource == null) {
                return null;
            }
        }
        System.out.println(key + " - " + resource.getString(key));
        return resource.getString(key);
    }

    private Configuration getConfiguration(String name) {
        PropertiesConfiguration configuration = null;
        URL url = Thread.currentThread().getContextClassLoader().getResource(name);
        if (url != null) {
            PropertiesConfiguration pc = new PropertiesConfiguration();
            pc.setURL(url);
            String dynamicReload = ApplicationProperties.getProperty("tmtbl.properties.dynamic_reload", null);
            if (dynamicReload != null && dynamicReload.equalsIgnoreCase("true")) {
                long refreshDelay = Constants.getPositiveInteger(ApplicationProperties.getProperty("tmtbl.properties.dynamic_reload_interval"), 15000);
                FileChangedReloadingStrategy strategy = new FileChangedReloadingStrategy();
                strategy.setRefreshDelay(refreshDelay);
                pc.setReloadingStrategy((ReloadingStrategy)strategy);
                pc.addConfigurationListener((ConfigurationListener)new MessageResourcesCfgListener(pc.getBasePath()));
            }
            try {
                pc.load();
                configuration = pc;
            }
            catch (ConfigurationException e) {
                Debug.error("Message Resources configuration exception: " + e.getMessage());
            }
        }
        return configuration;
    }

    public static PropertiesConfiguration getResource() {
        return resource;
    }

    public static void setResource(PropertiesConfiguration resource) {
        MessageResources.resource = resource;
    }

    public static String getResourceFile() {
        return resourceFile;
    }

    public static void setResourceFile(String resourceFile) {
        MessageResources.resourceFile = resourceFile;
    }

    class MessageResourcesCfgListener
    implements ConfigurationListener {
        private String basePath;

        public MessageResourcesCfgListener(String basePath) {
            this.basePath = basePath;
        }

        public void configurationChanged(ConfigurationEvent arg0) {
            SessionListener.reloadMessageResources(this.basePath);
        }
    }
}

