/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.tags;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.unitime.timetable.gwt.shared.PageAccessException;
import org.unitime.timetable.listeners.SessionListener;
import org.unitime.timetable.security.UserContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;

public class SessionsTag
extends TagSupport {
    private static final long serialVersionUID = 1332135385302161770L;

    private UserContext getUser(SecurityContext context) {
        if (context == null) {
            return null;
        }
        Authentication authentication = context.getAuthentication();
        if (authentication != null && authentication.isAuthenticated() && authentication.getPrincipal() instanceof UserContext) {
            return (UserContext)authentication.getPrincipal();
        }
        return null;
    }

    private UserContext getUser() {
        return this.getUser(SecurityContextHolder.getContext());
    }

    public int doStartTag() throws JspException {
        UserContext user = this.getUser();
        if (user == null || user.getCurrentAuthority() == null || !user.getCurrentAuthority().hasRight(Right.IsAdmin)) {
            throw new PageAccessException("Access Denied.");
        }
        StringBuffer html = new StringBuffer("");
        Formats.Format<Date> sdf = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);
        try {
            html.append("<TABLE border='0' cellspacing='1' cellpadding='2' width='100%'>");
            html.append("<TR>");
            html.append("<TD align='center'>User</TD>");
            html.append("<TD align='center'>Created</TD>");
            html.append("<TD align='center'>Last Access</TD>");
            html.append("</TR>");
            HashMap s = SessionListener.getSessions();
            Set keys = s.keySet();
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                String sessionId = i.next().toString();
                HttpSession session = (HttpSession)s.get(sessionId);
                if (session == null) continue;
                session.getAttribute("SPRING_SECURITY_CONTEXT");
                UserContext u = this.getUser((SecurityContext)session.getAttribute("SPRING_SECURITY_CONTEXT"));
                String userDetail = "Cannot be determined";
                if (u != null && u.getUsername() != null) {
                    userDetail = u.getUsername() + (u.getCurrentAuthority() == null ? "" : " (" + u.getCurrentAuthority() + ")");
                }
                html.append("<TR>");
                html.append("<TD align='left'>" + userDetail + "</TD>");
                html.append("<TD align='left'>" + sdf.format(new Date(session.getCreationTime())) + "</TD>");
                html.append("<TD align='left'>" + sdf.format(new Date(session.getLastAccessedTime())) + "</TD>");
                html.append("</TR>");
            }
            html.append("</TABLE>");
            this.pageContext.getOut().print(html.toString());
        }
        catch (Exception ex) {
            throw new JspTagException("SessionsTag: " + ex.getMessage());
        }
        return 0;
    }

    public int doEndTag() {
        return 6;
    }
}

