/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.service;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.blocks.RpcDispatcher;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;
import org.unitime.commons.jgroups.UniTimeChannelLookup;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.jgroups.LocalSolverServer;
import org.unitime.timetable.solver.jgroups.RemoteSolverContainer;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.solver.jgroups.SolverContainerWrapper;
import org.unitime.timetable.solver.jgroups.SolverServer;
import org.unitime.timetable.solver.jgroups.SolverServerImplementation;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="solverServerService")
@DependsOn(value={"startupService"})
public class SolverServerService
implements InitializingBean,
DisposableBean {
    private static Log sLog = LogFactory.getLog(SolverServerService.class);
    private JChannel iChannel = null;
    private SolverServer iServer = null;
    private SolverContainer<SolverProxy> iCourseSolverContainer;
    private SolverContainer<ExamSolverProxy> iExamSolverContainer;
    private SolverContainer<StudentSolverProxy> iStudentSolverContainer;
    private SolverContainer<OnlineSectioningServer> iOnlineStudentSchedulingContainer;

    public void afterPropertiesSet() throws Exception {
        try {
            if (ApplicationProperty.SolverClusterEnabled.isFalse()) {
                this.iServer = new LocalSolverServer();
                this.iServer.start();
                this.iCourseSolverContainer = this.iServer.getCourseSolverContainer();
                this.iExamSolverContainer = this.iServer.getExamSolverContainer();
                this.iStudentSolverContainer = this.iServer.getStudentSolverContainer();
                this.iOnlineStudentSchedulingContainer = this.iServer.getOnlineStudentSchedulingContainer();
            } else {
                this.iChannel = (JChannel)new UniTimeChannelLookup().getJGroupsChannel(null);
                this.iServer = new SolverServerImplementation(true, this.iChannel);
                this.iChannel.connect("UniTime:rpc");
                this.iServer.start();
                this.iCourseSolverContainer = new SolverContainerWrapper<SolverProxy>(((SolverServerImplementation)this.iServer).getDispatcher(), (RemoteSolverContainer)this.iServer.getCourseSolverContainer(), true);
                this.iExamSolverContainer = new SolverContainerWrapper<ExamSolverProxy>(((SolverServerImplementation)this.iServer).getDispatcher(), (RemoteSolverContainer)this.iServer.getExamSolverContainer(), true);
                this.iStudentSolverContainer = new SolverContainerWrapper<StudentSolverProxy>(((SolverServerImplementation)this.iServer).getDispatcher(), (RemoteSolverContainer)this.iServer.getStudentSolverContainer(), true);
                this.iOnlineStudentSchedulingContainer = new SolverContainerWrapper<OnlineSectioningServer>(((SolverServerImplementation)this.iServer).getDispatcher(), (RemoteSolverContainer)this.iServer.getOnlineStudentSchedulingContainer(), false);
            }
        }
        catch (Exception e) {
            sLog.fatal((Object)("Failed to start solver server: " + e.getMessage()), (Throwable)e);
        }
    }

    private RpcDispatcher getDispatcher() {
        if (this.iServer instanceof SolverServerImplementation) {
            return ((SolverServerImplementation)this.iServer).getDispatcher();
        }
        return null;
    }

    public void destroy() throws Exception {
        try {
            sLog.info((Object)"Server is going down...");
            this.iServer.stop();
            if (this.iChannel != null) {
                sLog.info((Object)"Disconnecting from the channel...");
                this.iChannel.disconnect();
                sLog.info((Object)"Closing the channel...");
                this.iChannel.close();
            }
            this.iServer = null;
        }
        catch (Exception e) {
            sLog.fatal((Object)("Failed to stop solver server: " + e.getMessage()), (Throwable)e);
        }
    }

    public List<SolverServer> getServers(boolean onlyAvailable) {
        return this.iServer.getServers(onlyAvailable);
    }

    public SolverServer getLocalServer() {
        return this.iServer;
    }

    public SolverContainer<SolverProxy> getCourseSolverContainer() {
        return this.iCourseSolverContainer;
    }

    public SolverProxy createCourseSolver(String host, String user, DataProperties properties) {
        if (host != null) {
            if ("local".equals(host)) {
                SolverProxy solver = this.iServer.getCourseSolverContainer().createSolver(user, properties);
                return solver;
            }
            for (SolverServer server : this.iServer.getServers(true)) {
                if (!server.getHost().equals(host)) continue;
                SolverProxy solver = server.getCourseSolverContainer().createSolver(user, properties);
                return solver;
            }
        }
        SolverProxy solver = this.iCourseSolverContainer.createSolver(user, properties);
        return solver;
    }

    public SolverContainer<ExamSolverProxy> getExamSolverContainer() {
        return this.iExamSolverContainer;
    }

    public ExamSolverProxy createExamSolver(String host, String user, DataProperties properties) {
        if (host != null) {
            if ("local".equals(host)) {
                ExamSolverProxy solver = this.iServer.getExamSolverContainer().createSolver(user, properties);
                return solver;
            }
            for (SolverServer server : this.iServer.getServers(true)) {
                if (!server.getHost().equals(host)) continue;
                ExamSolverProxy solver = server.getExamSolverContainer().createSolver(user, properties);
                return solver;
            }
        }
        ExamSolverProxy solver = this.iExamSolverContainer.createSolver(user, properties);
        return solver;
    }

    public SolverContainer<StudentSolverProxy> getStudentSolverContainer() {
        return this.iStudentSolverContainer;
    }

    public StudentSolverProxy createStudentSolver(String host, String user, DataProperties properties) {
        if (host != null) {
            if ("local".equals(host)) {
                StudentSolverProxy solver = this.iServer.getStudentSolverContainer().createSolver(user, properties);
                return solver;
            }
            for (SolverServer server : this.iServer.getServers(true)) {
                if (!server.getHost().equals(host)) continue;
                StudentSolverProxy solver = server.getStudentSolverContainer().createSolver(user, properties);
                return solver;
            }
        }
        StudentSolverProxy solver = this.iStudentSolverContainer.createSolver(user, properties);
        return solver;
    }

    public SolverContainer<OnlineSectioningServer> getOnlineStudentSchedulingContainer() {
        return this.iOnlineStudentSchedulingContainer;
    }

    public SolverServer getServer(String host) {
        if ("local".equals(host) || host == null) {
            return this.iServer;
        }
        if (this.iChannel != null) {
            for (Address address : this.iChannel.getView().getMembers()) {
                if (!host.equals(address.toString())) continue;
                return this.iServer.crateServerProxy(address);
            }
        }
        return null;
    }

    public boolean isOnlineStudentSchedulingEnabled() {
        return !this.getOnlineStudentSchedulingContainer().getSolvers().isEmpty();
    }

    public boolean isStudentRegistrationEnabled() {
        for (Session session : SessionDAO.getInstance().findAll()) {
            if (session.getStatusType().isTestSession() || session.getStatusType().canOnlineSectionStudents() || session.getStatusType().canSectionAssistStudents() || !session.getStatusType().canPreRegisterStudents()) continue;
            return true;
        }
        return false;
    }

    public void setApplicationProperty(Long sessionId, String key, String value) {
        try {
            RpcDispatcher dispatcher = this.getDispatcher();
            if (dispatcher != null) {
                dispatcher.callRemoteMethods(null, "setApplicationProperty", new Object[]{sessionId, key, value}, new Class[]{Long.class, String.class, String.class}, SolverServerImplementation.sAllResponses);
            } else {
                this.iServer.setApplicationProperty(sessionId, key, value);
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to update the application property " + key + " along the cluster: " + e.getMessage()), (Throwable)e);
        }
    }

    public void setLoggingLevel(String name, Integer level) {
        try {
            RpcDispatcher dispatcher = this.getDispatcher();
            if (dispatcher != null) {
                dispatcher.callRemoteMethods(null, "setLoggingLevel", new Object[]{name, level}, new Class[]{String.class, Integer.class}, SolverServerImplementation.sAllResponses);
            } else {
                this.iServer.setLoggingLevel(name, level);
            }
        }
        catch (Exception e) {
            sLog.error((Object)("Failed to update the logging level for " + name + " along the cluster: " + e.getMessage()), (Throwable)e);
        }
    }
}

