/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.jgroups;

import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cpsolver.ifs.util.DataProperties;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.TimetableSolver;
import org.unitime.timetable.solver.jgroups.SolverContainer;
import org.unitime.timetable.solver.remote.BackupFileFilter;
import org.unitime.timetable.solver.ui.TimetableInfoFileProxy;
import org.unitime.timetable.solver.ui.TimetableInfoUtil;
import org.unitime.timetable.util.MemoryCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CourseSolverContainer
implements SolverContainer<SolverProxy> {
    private static Log sLog = LogFactory.getLog(CourseSolverContainer.class);
    protected Map<String, TimetableSolver> iCourseSolvers = new Hashtable<String, TimetableSolver>();
    private PassivationThread iPassivation = null;

    @Override
    public Set<String> getSolvers() {
        return new HashSet<String>(this.iCourseSolvers.keySet());
    }

    @Override
    public SolverProxy getSolver(String user) {
        return this.iCourseSolvers.get(user);
    }

    @Override
    public long getMemUsage(String user) {
        SolverProxy solver = this.getSolver(user);
        return solver == null ? 0L : new MemoryCounter().estimate(solver);
    }

    @Override
    public SolverProxy createSolver(String user, DataProperties config) {
        TimetableSolver solver = new TimetableSolver(config, new SolverOnDispose(user));
        this.iCourseSolvers.put(user, solver);
        return solver;
    }

    @Override
    public void unloadSolver(String user) {
        TimetableSolver solver = this.iCourseSolvers.get(user);
        if (solver != null) {
            solver.dispose();
        }
    }

    @Override
    public boolean hasSolver(String user) {
        return this.iCourseSolvers.containsKey(user);
    }

    @Override
    public int getUsage() {
        int ret = 0;
        for (SolverProxy solverProxy : this.iCourseSolvers.values()) {
            ++ret;
            if (!solverProxy.isPassivated()) {
                ++ret;
            }
            try {
                if (!solverProxy.isWorking()) continue;
                ++ret;
            }
            catch (Exception e) {}
        }
        return ret;
    }

    @Override
    public void start() {
        this.iPassivation = new PassivationThread(ApplicationProperties.getPassivationFolder());
        this.iPassivation.start();
        File folder = ApplicationProperties.getRestoreFolder();
        sLog.info((Object)("Restore folder: " + folder));
        if (!folder.exists() || !folder.isDirectory()) {
            return;
        }
        BackupFileFilter filter = new BackupFileFilter(true, false, 0);
        File[] files = folder.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String user = filter.getUser(file);
            TimetableSolver solver = new TimetableSolver(new DataProperties(), new SolverOnDispose(user));
            if (!solver.restore(folder, user)) continue;
            if (ApplicationProperties.getPassivationFolder() != null) {
                solver.passivate(ApplicationProperties.getPassivationFolder(), user);
            }
            this.iCourseSolvers.put(user, solver);
        }
    }

    @Override
    public void stop() {
        File folder = ApplicationProperties.getRestoreFolder();
        if (folder.exists() && !folder.isDirectory()) {
            return;
        }
        folder.mkdirs();
        File[] old = folder.listFiles(new BackupFileFilter(true, true, 0));
        for (int i = 0; i < old.length; ++i) {
            old[i].delete();
        }
        for (Map.Entry<String, TimetableSolver> entry : this.iCourseSolvers.entrySet()) {
            entry.getValue().backup(folder, entry.getKey());
        }
        this.iPassivation.destroy();
    }

    public TimetableInfoFileProxy getFileProxy() {
        return TimetableInfoUtil.getLocalInstance();
    }

    private class PassivationThread
    extends Thread {
        private File iFolder = null;
        public long iDelay = 30000L;
        public boolean iContinue = true;

        public PassivationThread(File folder) {
            this.iFolder = folder;
            this.setName("Passivation[CourseTimetabling]");
            this.setDaemon(true);
            this.setPriority(1);
        }

        public void run() {
            try {
                sLog.info((Object)"Solver passivation thread started.");
                while (this.iContinue) {
                    for (Map.Entry<String, TimetableSolver> entry : CourseSolverContainer.this.iCourseSolvers.entrySet()) {
                        entry.getValue().passivateIfNeeded(this.iFolder, entry.getKey());
                    }
                    try {
                        PassivationThread.sleep(this.iDelay);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                sLog.info((Object)"Solver passivation thread finished.");
            }
            catch (Exception e) {
                sLog.warn((Object)("Solver passivation thread failed, reason: " + e.getMessage()), (Throwable)e);
            }
        }

        public void destroy() {
            this.iContinue = false;
            if (this.isAlive()) {
                this.interrupt();
            }
        }
    }

    protected class SolverOnDispose
    implements TimetableSolver.SolverDisposeListener {
        String iUser = null;

        public SolverOnDispose(String user) {
            this.iUser = user;
        }

        public void onDispose() {
            CourseSolverContainer.this.iCourseSolvers.remove(this.iUser);
        }
    }
}

