/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.solver.curricula;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.solver.curricula.StudentCourseDemands;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StudentCourseRequests
implements StudentCourseDemands {
    protected Hashtable<Long, Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>>> iDemands = new Hashtable();
    protected org.hibernate.Session iHibSession = null;
    protected Hashtable<Long, Set<StudentCourseDemands.WeightedCourseOffering>> iStudentRequests = null;
    protected Long iSessionId = null;
    protected double iBasePriorityWeight = 0.9;
    private Hashtable<Long, Hashtable<Long, Double>> iEnrollmentPriorities = new Hashtable();

    public StudentCourseRequests(DataProperties conf) {
        this.iBasePriorityWeight = conf.getPropertyDouble("StudentCourseRequests.BasePriorityWeight", this.iBasePriorityWeight);
    }

    @Override
    public void init(org.hibernate.Session hibSession, Progress progress, Session session, Collection<InstructionalOffering> offerings) {
        this.iHibSession = hibSession;
        this.iSessionId = session.getUniqueId();
    }

    protected Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>> loadDemandsForSubjectArea(SubjectArea subjectArea) {
        Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>> demands = new Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>>();
        for (Object[] o : this.iHibSession.createQuery("select distinct s, r.courseOffering.uniqueId, r.courseDemand.priority, r.courseDemand.alternative, r.order from CourseRequest r inner join r.courseDemand.student s left join fetch s.academicAreaClassifications left join fetch s.posMajors where r.courseOffering.subjectArea.uniqueId = :subjectId").setLong("subjectId", subjectArea.getUniqueId().longValue()).setCacheable(true).list()) {
            Hashtable<Long, Double> priorities;
            Student s = (Student)o[0];
            Long courseId = (Long)o[1];
            Integer priority = (Integer)o[2];
            Boolean alternative = (Boolean)o[3];
            Integer order = (Integer)o[4];
            Set<StudentCourseDemands.WeightedStudentId> students = demands.get(courseId);
            if (students == null) {
                students = new HashSet<StudentCourseDemands.WeightedStudentId>();
                demands.put(courseId, students);
            }
            StudentCourseDemands.WeightedStudentId student = new StudentCourseDemands.WeightedStudentId(s);
            students.add(student);
            if (priority == null || !Boolean.FALSE.equals(alternative)) continue;
            if (order != null) {
                priority = priority + order;
            }
            if ((priorities = this.iEnrollmentPriorities.get(s.getUniqueId())) == null) {
                priorities = new Hashtable();
                this.iEnrollmentPriorities.put(s.getUniqueId(), priorities);
            }
            priorities.put(courseId, Math.pow(this.iBasePriorityWeight, priority.intValue()));
        }
        return demands;
    }

    @Override
    public Set<StudentCourseDemands.WeightedCourseOffering> getCourses(Long studentId) {
        if (this.iStudentRequests == null) {
            this.iStudentRequests = new Hashtable();
            for (Object[] o : this.iHibSession.createQuery("select distinct d.student.uniqueId, c, d.priority, d.alternative, r.order from CourseRequest r inner join r.courseOffering c inner join r.courseDemand d where d.student.session.uniqueId = :sessionId").setLong("sessionId", this.iSessionId.longValue()).setCacheable(true).list()) {
                Hashtable<Long, Double> priorities;
                Long sid = (Long)o[0];
                CourseOffering co = (CourseOffering)o[1];
                Integer priority = (Integer)o[2];
                Boolean alternative = (Boolean)o[3];
                Integer order = (Integer)o[4];
                Set<StudentCourseDemands.WeightedCourseOffering> courses = this.iStudentRequests.get(sid);
                if (courses == null) {
                    courses = new HashSet<StudentCourseDemands.WeightedCourseOffering>();
                    this.iStudentRequests.put(sid, courses);
                }
                courses.add(new StudentCourseDemands.WeightedCourseOffering(co));
                if (priority == null || !Boolean.FALSE.equals(alternative)) continue;
                if (order != null) {
                    priority = priority + order;
                }
                if ((priorities = this.iEnrollmentPriorities.get(studentId)) == null) {
                    priorities = new Hashtable();
                    this.iEnrollmentPriorities.put(studentId, priorities);
                }
                priorities.put(co.getUniqueId(), Math.pow(this.iBasePriorityWeight, priority.intValue()));
            }
        }
        return this.iStudentRequests.get(studentId);
    }

    @Override
    public Set<StudentCourseDemands.WeightedStudentId> getDemands(CourseOffering course) {
        Hashtable<Long, Set<StudentCourseDemands.WeightedStudentId>> demands = this.iDemands.get(course.getSubjectArea().getUniqueId());
        if (demands == null) {
            demands = this.loadDemandsForSubjectArea(course.getSubjectArea());
            this.iDemands.put(course.getSubjectArea().getUniqueId(), demands);
        }
        return demands.get(course.getUniqueId());
    }

    @Override
    public boolean isMakingUpStudents() {
        return false;
    }

    @Override
    public boolean isWeightStudentsToFillUpOffering() {
        return false;
    }

    @Override
    public boolean canUseStudentClassEnrollmentsAsSolution() {
        return true;
    }

    @Override
    public Double getEnrollmentPriority(Long studentId, Long courseId) {
        Hashtable<Long, Double> priorities = this.iEnrollmentPriorities.get(studentId);
        return priorities == null ? null : priorities.get(courseId);
    }
}

